static char vjmknodeCSid[]="@(#)vjmknode.c	30.1 3/13/91 AppEng/SCCS Interphase";

#include <stdio.h>
#include <strings.h>

/*-------------------------------------------------------------------*/
/*
	This program will will create a file called vjmknode.dev, 
	that can be used to create the dev entries in the /dev dir.

	usage:
		vjmknode configuration_file

	Author:  John Balanchuk
*/

/**** REVISION HISTORY
 **** DATE    ID   VER     COMMENT
 ** 03/13/91 rbrant 30.1   New development/distribution format.
 ** 08/30/90  JQO   21.3   bumped to new SBU/SCCS level.
 ** 06/06/90  jdb    1.3   This program will will create a file called 
 **                        vjmknode.dev, that can be used to create the 
 **                        dev entries in the /dev dir.
 ****/
/*-------------------------------------------------------------------*/

main(argc,argv)
int argc;
char *argv[];
{
	FILE *fpin, *fpout;
	char str[135], str1[20], str2[20];
	int i, x;
	int blkmajor, chrmajor, minor;

	printf("%s\n", vjmknodeCSid);
	if (argc != 2)
	{
		printf("\nusage: vjmknode configuration_file\n");
		printf("This program produces a file called jagmknode that\n"); 
		printf("will create the dev entries in /dev directory.\n");
		printf("\nexample:\n");
		printf("cd /usr/sys/sun3/conf\n");
		printf("cp /usr/sys/interphase/drivers/vjmknode.c .\n");
		printf("cc -o vjmknode vjmknode.c\n");
		printf("vjmknode GENERIC\n");
		printf("chmod 777 jagmknode\n");
		printf("cp jagmknode /dev\n");
		printf("cd /dev\n");
		printf("jagmknode\n\n");
		exit(1);
	}

	/* open file that contains the first blk and chr major numbers */
	if ((fpin=fopen("/usr/sys/sundev/vj_major.h","r"))==NULL)
	{
		printf("cannot open vj_major.h file\n");
		exit(1);
	}

	/* get block major string */
	fgets(str,134,fpin);
	if ((i = strsearch ("VJBLKMAJOR",str)) < 0)
	{
		printf("VJBLKMAJOR does not exist.\n");
		exit(1);
	}

	/* get first block major number */
	i += 11;
	x = 0;
	for ( x = 0; str[i + x] != ' '; x++)
		str2[x] = str[i + x];
	str2[x] = NULL;
	blkmajor = atoi(str2);

	/* get character major string */
	fgets(str,134,fpin);
	if ((i = strsearch ("VJCHRMAJOR",str)) < 0)
	{
		printf("VJCHRMAJOR does not exist.\n");
		exit(1);
	}

	/* get first character major number */
	i += 11;
	x = 0;
	for ( x = 0; str[i + x] != ' '; x++)
		str2[x] = str[i + x];
	str2[x] = NULL;
	chrmajor = atoi(str2);

	/* close file that contains the first blk and chr major numbers */
	fclose(fpin);

	/* open the configuration file defined by the user */
	if ((fpin=fopen(argv[1],"r"))==NULL)
	{
		printf("cannot open configuration file\n");
		exit(1);
	}

	/* open output file called jagmknode */
	fpout=fopen("jagmknode","w");
  
	/* add to jagmknode file */
	fprintf(fpout,"echo \"Removing all vj disk entries\"\n");
	fprintf(fpout,"rm /dev/*vj*\n");
	fprintf(fpout,"echo \"Removing all vt tape entries\"\n");
	fprintf(fpout,"rm /dev/*vt*\n");

	/* get line from configuration file */
	fgets(str,134,fpin);

	while (!feof(fpin))
	{
		/* find next vj controller */
		while ((strsearch("controller",str) < 0) || (strsearch ("vjc",str) < 0))
			/* get line from configuration file */
			if (!fgets(str,134,fpin)) break;
		
		/* set minor number to zero */
		minor = 0;
	
		/* get line from configuration file */
		if (!fgets(str,134,fpin)) break;

		/* search for the next jaguar controller in the configuration file */
		while ((strsearch("controller",str) < 0) || (strsearch ("vjc",str) < 0))
		{
			/* check if device is a disk */
			if (strsearch ("disk",str) >= 0)
			{
				/* build the dev entries for jaguar disk and store in */
				/* jagmknode file */
				i = strsearch ("vj",str);
				i += 2;
				x = 0;
				for ( x = 0; (str[i + x] != ' ') && (str[i + x] != '\t'); x++)
					str1[x] = str[i + x];
				str1[x] = NULL;
				i = minor;

				fprintf(fpout,"echo \"Creating blk device nodes for disk     ");
				fprintf(fpout,"  vj%sa-h, major = %d ",str1,blkmajor);
				fprintf(fpout,"minor = %d-%d\"\n",i * 8,(i*8)+7);
				fprintf(fpout,"mknod vj%sa b %d %d\n",str1,blkmajor,(i*8)+0);
				fprintf(fpout,"mknod vj%sb b %d %d\n",str1,blkmajor,(i*8)+1);
				fprintf(fpout,"mknod vj%sc b %d %d\n",str1,blkmajor,(i*8)+2);
				fprintf(fpout,"mknod vj%sd b %d %d\n",str1,blkmajor,(i*8)+3);
				fprintf(fpout,"mknod vj%se b %d %d\n",str1,blkmajor,(i*8)+4);
				fprintf(fpout,"mknod vj%sf b %d %d\n",str1,blkmajor,(i*8)+5);
				fprintf(fpout,"mknod vj%sg b %d %d\n",str1,blkmajor,(i*8)+6);
				fprintf(fpout,"mknod vj%sh b %d %d\n",str1,blkmajor,(i*8)+7);

				fprintf(fpout,"echo \"Creating chr device nodes for disk     ");
				fprintf(fpout," rvj%sa-h, major = %d ",str1,chrmajor);
				fprintf(fpout,"minor = %d-%d\"\n",i * 8,(i*8)+7);
				fprintf(fpout,"mknod rvj%sa c %d %d\n",str1,chrmajor,(i*8)+0);
				fprintf(fpout,"mknod rvj%sb c %d %d\n",str1,chrmajor,(i*8)+1);
				fprintf(fpout,"mknod rvj%sc c %d %d\n",str1,chrmajor,(i*8)+2);
				fprintf(fpout,"mknod rvj%sd c %d %d\n",str1,chrmajor,(i*8)+3);
				fprintf(fpout,"mknod rvj%se c %d %d\n",str1,chrmajor,(i*8)+4);
				fprintf(fpout,"mknod rvj%sf c %d %d\n",str1,chrmajor,(i*8)+5);
				fprintf(fpout,"mknod rvj%sg c %d %d\n",str1,chrmajor,(i*8)+6);
				fprintf(fpout,"mknod rvj%sh c %d %d\n",str1,chrmajor,(i*8)+7);

				fprintf(fpout,"echo \"Creating special device node for disk");
				fprintf(fpout,"     rsvj%s, major = %d ",str1,chrmajor);
				fprintf(fpout,"minor = %d\"\n",(i * 8) + 128);
				fprintf(fpout,"mknod rsvj%s c %d %d\n",str1,chrmajor,(i*8)+128);

				/* increment minor number for next device */
				minor++;
			}
			/* check if device is a tape */
			else if ((i = strsearch ("tape",str) >= 0))
			{
				/* build the dev entries for jaguar tape and store in */
				/* jagmknode file */
				i = strsearch ("vj",str);
				i += 2;
				x = 0;
				for ( x = 0; (str[i + x] != ' ') && (str[i + x] != '\t'); x++)
					str1[x] = str[i + x];
				str1[x] = NULL;
				i = minor;

				fprintf(fpout,"echo \"Creating chr device nodes for tape     ");
				fprintf(fpout," rvt%s0-3, major = %d ",str1,chrmajor);
				fprintf(fpout,"minor = %d-%d\"\n",i * 8,(i*8)+2);
				fprintf(fpout,"mknod nrvt%s c %d %d\n",str1,chrmajor,(i*8)+0);
				fprintf(fpout,"mknod rvt%s c %d %d\n",str1,chrmajor,(i*8)+1);
				fprintf(fpout,"mknod nrvth%s c %d %d\n",str1,chrmajor,(i*8)+2);
				fprintf(fpout,"mknod rvth%s c %d %d\n",str1,chrmajor,(i*8)+3);

				/* increment minor number for next device */
				minor++;
			}
			if (!fgets(str,134,fpin)) break;
		}

		/* increment blkmajor and chrmajor numbers for the next jaguar */
		/* controller */
		blkmajor++;
		chrmajor++;
	}

	/* close the configuration file */
	fclose(fpin);

	/* close the output file jagmknode */
	fclose(fpout);
}

/*-------------------------------------------------------------------*/
/*
	int strsearch ( str1, str2)
		char *str1, *str2
	
	The function strsearch() will search str2 for the
	first occurance of str1 and return an integer based 
	on its outcome shown here.
		Value		Meaning
		-1			no match found
		-2			str1 or str2 is null
		>=0			match found (offset in str2)

	example - after the execution of this command i = 2
		i = strsearch ("is","this is a test"); 
 	  
	Author:  John Balanchuk
*/
/*-------------------------------------------------------------------*/

int strsearch ( str1, str2)
char str1[], str2[];
{
	int str1cnt=0, str2cnt=0, found = 0; 

	if (strlen(str1)==0 || strlen(str2)==0)
		return(-2);

	while (str1cnt < strlen(str1))
	{
		while (str2cnt < strlen(str2) && !found)
		{
			if (str1[str1cnt] != str2[str2cnt])
			{
				str2cnt++;
				str1cnt = 0;
			}
			else found = 1; 
		}
		if (!found)
		return(-1);

		str2cnt++;
		str1cnt++;
		found = 0;
	}
	return (str2cnt - strlen(str1));
}

/*-------------------------------------------------------------------*/

