static char IPtypesHSid[]="@(#)IPtypes.h	30.1 3/13/91 AppEng/SCCS Interphase";

/****  REVISION HISTORY
 **** DATE     ID    VER     COMMENT
 ** 03/13/91 rbrant 30.1     New development/distribution format.
 ** 08/30/90  JQO   22.5     BUMPED TO NEW SBU/SCCS LEVEL.
 ** 08/15/90  jqo    2.5     BUMPED TO COINCIDE WITH RCS VERSION 2.5  
 **                          ADDED SCCS TO HEADER TO ID SCCS AT `what' COMMAND.
 ****/

/*
 *	The following types are to be used by most of the interphase drivers. 
 *
 *	WARNING:
 *		Since several drivers share this header be very careful
 *		when changing any of these.
 */

#ifndef IP_TYPES

typedef          char	BYTE;
typedef unsigned char	UBYTE;
typedef unsigned short	USHORT;
typedef			 short	SHORT;
typedef unsigned short	UWORD;
typedef			 short	WORD;
typedef unsigned int	UINT;
typedef          int	INT;
typedef unsigned long	ULONG;
typedef          long	LONG;
typedef unsigned short  Bit;
typedef int (FUNC)();				/* A function */

struct longv {
	union {
		struct {
			UWORD	msw;
			UWORD	lsw;
		} v;
		ULONG	l;
	} U;
};
typedef struct longv LONGV;

#define MSW(x)	((x).U.v.msw)
#define LSW(x)	((x).U.v.lsw)
#define L(x)	((x).U.l)

struct wordv {
	union {
		struct {
			UBYTE	msb;
			UBYTE	lsb;
		} v;
		UWORD	w;
	} U;
};
typedef struct wordv WORDV;

#define MSB(x)	((x).U.v.msb)
#define LSB(x)	((x).U.v.lsb)
#define W(x)	((x).U.w)

#define LLV( a, b)		{ MSW( a ) = MSW( b ); LSW( a ) = LSW( b ); }
#define WWV( a, b)		{ MSB( a ) = MSB( b ); LSB( a ) = LSB( b ); }

#define LV( a, b)		/* Long to LongV */ \
	{ \
		LONGV _x; \
		L( _x ) = (ULONG)b; \
		MSW( a ) = MSW( _x ); \
		LSW( a ) = LSW( _x ); \
	}
#define VL( a, b)		/* LongV to long */ \
	{ \
		LONGV _x; \
		MSW( _x ) = MSW( b ); \
		LSW( _x ) = LSW( b ); \
		(ULONG)a = L( _x ); \
	}
#define WV( a, b)		/* Word to WordV */	\
	{ \
		WORDV _x; \
		L( _x ) = (UWORD)b; \
		MSB( a ) = MSB( _x ); \
		LSB( a ) = LSB( _x ); \
	}
#define VW( a, b)		/* WordV to word */ \
	{ \
		WORDV _x; \
		MSB( _x ) = MSB( b ); \
		LSB( _x ) = LSB( b ); \
		(UWORD)a = W( _x ); \
	}

#define BIT(x)		(1 << (x))
#define CTL(x)          (x & 0x1f)

#define IP_TYPES
#endif
