;=========================================================================;
;  PCIRES - 3270PC High Level Language Application Program Interface      ;
;           V 1.0  08/30/84                                               ;
;                                                                         ;
;   1753180 (C) COPYRIGHT IBM CORP. 1984                                  ;
;   LICENSED MATERIAL - PROGRAM PROPERTY OF IBM                           ;
;=========================================================================;
;
;=========================================================================;
;       MACRO DEFINITIONS FOR UTILITY MACROS                              ;
;=========================================================================;
;
MSG     MACRO   TEXT            ;MACRO TO DISPLAY MSG TEXT INLINE
        LOCAL   CONT,TXT,LP1
        PUSHF
        PUSH    BP
        PUSH    AX
        PUSH    BX
        PUSH    DI
        MOV     DI,OFFSET TXT
LP1:
        MOV     AH,14           ;BIOS WRT TTY OP CODE
        MOV     AL,CS:[DI]      ;GET BYTE TO TTY OUT
        MOV     BX,0
        INT     10H             ;CALL BIOS VIDEO SVC
        MOV     AL,CS:[DI]      ;REGET THE BYTE
        CMP     AL,0DH          ;IS IT THE CR (LAST BYTE)?
        JE      CONT
        INC     DI              ;POINT TO NEXT BYTE
        JMP     SHORT LP1
;
TXT     DB      TEXT
        DB      0AH,0DH         ;LF+CR
CONT:   POP     DI
        POP     BX
        POP     AX
        POP     BP
        POPF
        ENDM
;
PUSHALL MACRO
        PUSH    AX
        PUSH    BX
        PUSH    CX
        PUSH    DX
        PUSH    BP
        PUSH    SI
        PUSH    DI
        PUSH    DS
        PUSH    ES
        PUSHF
        ENDM
;
POPALL  MACRO
        POPF
        POP     ES
        POP     DS
        POP     DI
        POP     SI
        POP     BP
        POP     DX
        POP     CX
        POP     BX
        POP     AX
        ENDM
;
PRINTDATA MACRO  LOC,LEN
        LOCAL    LP
;; DISPLAYS DATA AT LOC FOR LEN ON THE SCREEN VIA TTY OUT
;;
        PUSH    AX
        PUSH    BX
        PUSH    CX
        PUSH    DI
        MOV     BX,0
        MOV     DI,OFFSET LOC   ;GET ADDR
        MOV     CX,LEN          ;GET LENGTH
LP:     MOV     AH,14           ;WRT TTY OP CODE
        MOV     AL,[DI]         ;GET BYTE
        INT     10H             ;BIOS VIDEO SVC
        INC     DI
        LOOP    LP
        POP     DI
        POP     CX
        POP     BX
        POP     AX
        ENDM
;
CVHEX   MACRO   LOC
        LOCAL   JMP1,TAB
;;
;; CONVERTS DATA IN AX: TO PRINTABLE HEX IN 'LOC'
;;
        PUSH    BX
        PUSH    CX
        PUSH    DI
        PUSH    SI
;
        MOV     DI,OFFSET LOC
        MOV     SI,OFFSET TAB
        MOV     BX,AX           ;GET HEX DATA
        AND     BX,000FH        ;1ST NIBBLE
        MOV     CL,CS:[BX] [SI]
        MOV     [DI]+3,CL
        MOV     BX,AX
        AND     BX,00F0H        ;2ND 456789ABCDEF'
JMP1:
        POP     SI
        POP     DI
        POP     CX
        POP     BX
        ENDM
;
;===========================================================================
CSEG            SEGMENT PARA PUBLIC 'CODE'
                ASSUME  CS:CSEG,DS:CSEG,SS:STACK,ES:NOTHING
PCISTART:       JMP     REAL_START      ;PSEUDO START TO SKIP DSECTS
;
                DB      '1753180'
                DB      '(C) COPYRIGHT 1984 IBM CORP.'
                DB      'LICENSED MATERIAL - PROGRAM PROPERTY OF IBM'
;===================================================================
MYINTNUM        DB      044H            ;ZAPABLE CONSTANT FOR INTERRUPT #
FIRSTCK         DB      033H            ;CK VALUE FOR OVERLAY INTEGRITY CK
CP_PSCBOFF      DW      0               ;OFFSET TO CONFIG TABLE
CP_PSCBSIZ      DW      44              ;TABLE SIZE (44)
CP_CPOFFS       DW      4D9CH           ;1.2 INT VECTOR OFFS FOR 1.2
CP_OIAOFFS      DW      02CH            ;OIA PTR OFFSET
CP_CURSOFF      DW      18              ;OFFSET TO CURSOR LOC PTR
CAPSMODE        DB      0               ;SCANCODE FLAG TO OR IN BY TYPIST
;====================================================================
; Language Interface Module (LIM) PARAMETER CONTROL BLOCK (PCB)
;
                DB      'pcb'           ;SHADOW PCB HDR IN SMALL LETTERS
UFUNCODE        DB      0               ;USERS FUNCTION REQ CODE
UDSEG           DW      0               ;USERS DATA SEG
UDOFFS          DW      0               ;OFFSET TO USERS DATA
UDLEN           DW      0               ;DATA LENGTH
USESSID         DB      0               ;BYTE NAME OF REQUESTED SESSION
URETCODE        DW      0               ;RETURN CODE (1 BYTE EXCEPT FOR SRCH)
UPSBSEG         DW      0               ;ADDR OF USER PSB (DUPL OF THIS)
UPSBOFF         DW      0
;====================================================================
; PCIRES Control Variables
;
PS_SEG          DW      0               ;SEG ADDR OF CURRENT PRESENT SPACE
PS_OFF          DW      0               ;OFFSET TO CURRENT PRESENTATION SP
PS_ID           DB      0FFH            ;CURRENT PS ID (0FF = PC SESS=NOT CON)
PS_SIZE         DW      1920            ;SIZE OF CURRENT PS
PS_EAB          DB      'N'             ;E OR N (Eab or Normal)
PS_SESSID       DW      0               ;CURRENT SESSION API NAME (CODE)
PS_PSCBOFF      DW      0               ;OFFSET OF CURR PSCB ENTRY [SI] (OR 0)
PS_CURSOR       DW      0               ;POINTER TO ES:CURSOR DATA
PS_ROWSIZE      DB      0               ;PS ROW SIZE (SCREEN WIDTH)
PS_RESERV       DB      0               ;SESS RESERVED ('R') OR NOT (00)
CK_PSID         DB      0               ;LATEST PS ID FROM CHK_STATUS
                                        ;0FF = PC SESSION
CNP_PSID        DB      0               ;SAVE AREA FOR CONNECT PHYSICAL PS ID
PS_TYP          DB      0               ;2 = NOTEPAD , 3 = 3270, 1 = PC  0=UNK
PS_OIAPTR       DD      0      ; <- DD  ;SI+ES POINTER TO CURR OIA
PS_PCID         DB      0               ;PC PS ID (USED BY DISCONN PHYS)
SE_TYPE         DB      0               ;WORK VAR FOR SET_ENV
;
; PCIRES SESSION VARIABLES AS SET BY PCIOPTION CALL
;
PCI_PARMS       LABEL   BYTE
PCI_CODE        DB      'A'             ;A=ASCII S=SCAN CODES (INPUT TYPE)
PCI_ESC         DB      '@'             ;ESC CHAR FOR ASCII CODES STREAM
PCI_CONN        DB      'L'             ;CONNECT L ogical OR P hysical
PCI_SRCH        DB      'A'             ;SEARCH All OR From a starting offset
PCI_RESET       DB      'Y'             ;AUTORESET Yes OR No
PCI_TRACE       DB      'N'             ;TRACE Y es (ON) OR No (OFF)
PCI_STRLEN      DB      'L'             ;STRINGS BY L ength OR Eot CHARACTER
PCI_EOT         DB      00              ;EOT CHARACTER IF PCI_STRLEN=E
PCI_ATTRX       DB      'Y'             ;XLATE ATTR BYTE TO BLANK (Yes OR No)
PCI_ITSTRACE    DB      'N'             ;TRACE ITS CALLS & RETURN CODES
PCI_TIMEO       DB      'Y'             ;WAIT TIMES OUT (Yes / No, Z=ZERO WAIT)
;
; OPTION PARMNIBBLE
        MOV     CL,04
        SHR     BX,CL
        MOV     CL,CS:[BX] [SI]
        MOV     [DI]+2,CL
        MOV     BX,AX
        AND     BX,0F00H        ;3RD NIBBLE
        MOV     CL,08
        SHR     BX,CL
        MOV     CL,CS:[BX] [SI]
        MOV     [DI]+1,CL
        MOV     BX,AX
        AND     BX,0F000H       ;4TH NIBBLE
        MOV     CL,12
        SHR     BX,CL
        MOV     CL,CS:[BX] [SI]
        MOV     [DI],CL
        JMP     SHORT JMP1
;
TAB     DB      '0123 KEYWORD TABLE:
;        FORMAT:   LENGTH,SYMBOL,DISPL,KEYWORD STRING  (SYMBOL = SAYS USE VALUE
;
SP_TABLE        LABEL   BYTE
                DB      5,'A',0,'ASCII'
                DB      8,'S',0,'SCANCODE'
                DB      4,'=',1,'ESC='
                DB      7,'P',2,'CONPHYS'
                DB      6,'L',2,'CONLOG'
                DB      7,'A',3,'SRCHALL'
                DB      8,'F',3,'SRCHFROM'
                DB      9,'Y',4,'AUTORESET'
                DB      7,'N',4,'NORESET'
                DB      4,'Y',5,'TRON'
                DB      5,'N',5,'TROFF'
                DB      6,'E',6,'STREOT'
                DB      6,'L',6,'STRLEN'
                DB      4,'=',7,'EOT='
                DB      5,'N',8,'ATTRB'
                DB      7,'Y',8,'NOATTRB'        ;MUST OCCUR AFTER ATTRB
                DB      5,'Y',9,'ITSTR'
                DB      7,'N',9,'NOITSTR'        ;MUST OCCUR AFTER ITSTR
                DB      5,'Y',10,'TWAIT'
                DB      5,'N',10,'LWAIT'
                DB      5,'Z',10,'NWAIT'
                DB      0FFH,0FFH,0FFH  ;MUST END W/ HEX FF
SP_SYM          DB      0               ;SAVE AREA FOR SET_PARM
SP_OFFS         DW      0
SP_LEN          DW      0
SP_TABOFFS      DW      0
;====================================================================
CK_STATUS       DW      0               ;LAST STATUS FROM CHKSTATUS
CK_NOHOST       DB      0FFH            ;FF = NOT HOST CONN
PROG_CKSUM      DW      0               ;PROG OVERLAY CHECKSUM
SYS_ERR1        DW      0               ;EXTENDED ERROR STATUS
SYS_ERR2        DW      0               ;
TRACEMSG        DB      'PCI-009 Return Code= '
DISPRC          DB      4 DUP (0)       ;RETURN CODE FOR ABOVE MSG...
                DB      ' '
DISPRC2         DB      4 DUP (' ')     ;DISPLAY FIELD FOR XTENDED ERR STATUS
                DB      ' '
DISPRC3         DB      4 DUP (' ')
                DB      0DH,0AH,0DH,0AH ;CR LF CR LF (SKIP A LINE)
ITSMSG          DB      'PCI-008 ITS Return = '
ITSRC           DB      4 DUP (0)
                DB      0DH,0AH,0DH,0AH
;
;======================== ADDRESS LOOKUP VALUES ==========================
CP_TYPE         DB      2               ;CTRL PGM TYPE/REL 1=DFT 1.2, 2=CUT 1.2
EPSEG           DW      0000H           ;SEG ADDR (FIND THIS IN INT VECTORS)
;
SR_OFFS         DW      0               ;WORKAREA FOR SCANIT SUBRTN (SEARCH)
SR_LEN          DW      0               ;  "       "    "   "
SC_START        DW      0               ;SCANIT STARTING OFFSET
SC_END          DW      1920            ;SCANIT ENDING OFFSET
TY_COUNT        DW      0               ;LOOP COUNT FOR TYPIST
;
DBUFFSEG        DW      0A000H          ;DISPLAY BUFFER SEG
DLINEOFF        DW      1E00H           ;OFFSET TO STATUS LINE IN DISP BUFFR
;=========================================================================
PSCBHDR         DB      'PSCB'          ;EYECATCHER TO Pres Space Cntrl Blk
PSCB_COUNT      DW      0               ;NO OF ENTRIES
PSACB_PREFIX    DW      0               ;SIZE OF PREFIX BEFORE HIS REAL
                                        ;PS BUFFER (HIS PTR IS TO CTL BLK)
PSCB_NEXT       DW      0               ;POINTER TO NEXT FREE PSCB (OFFSET)
PSTABLE_PTR     DW      0               ;OFFSET IN PC CPGM OF HIS PS TABLE
PSCB_CBSIZE     DW      27              ;SIZE OF MY CTRL BLK STRUC
;
PSCB            STRUC
PSCB_NAM        DB      0               ;SHORT NAME OF PRESENTATION SPACE
PSCB_LNAME      DB      8 DUP (' ')
PSCB_TYP        DB      0               ; 1=PC  2=NOTEPAD  3=3270
PSCB_FEAT       DB      0               ;EAB & PROG SYMS FEATURE
PSCB_RESERV     DB      0               ;RESERVED ('R') OR NOT (00)
PSCB_ROWSIZE    DB      0               ;SCREEN WIDTH
PSCB_ID         DW      0               ;SESSION ID FOR THIS PS
PSCB_SEG        DW      0
PSCB_OFF        DW      0
PSCB_OIAOFF     DW      0               ;POINTER TO OIA BIT STRING
PSCB_OIASEG     DW      0               ;NEEDED FOR NOTEPAD & DFT MODE
PSCB_CURSOR     DW      0               ;OFFSET IN CP TO CURSOR
PSCB_SIZE       DW      0
PSCB            ENDS
;
PS1             PSCB    < >
PS2             PSCB    < >
PS3             PSCB    < >
PS4             PSCB    < >
PS5             PSCB    < >
PS6             PSCB    < >
PS7             PSCB    < >
;=========================================================================
INCOUNT         DW      0               ;ORIGINAL INPUT COUNT (INCL CMPND CHARS)
;
;==================================O)
API_LASTRC      DW      0               ;LAST RET CODE OUT OF APIREQST
API_LASTCX      DW      0               ;LAST CX RET REG FROM APIREQST
API_LASTAX      DW      0               ;LAST AX RET REG FROM APIREQST
;
;
API_PARM        LABEL   BYTE            ;****** API PARAMETER LIST ***********
API_RC          DB      0               ;RETURN CODE
                DB      0
API_SESS        DW      0               ;SESSION ID (CODE FOR PRES SP)
API_FLD1        DW      0
API_OPT         DB      0
API_KEYS        DB      0
API_SCAN        DB      0
API_SHFT        DB      0
                DW      0
                DW      5 DUP (0)       ;RESERVE EXTRA SPACE
;
API_SMGR_NAM    DW      0               ;NUMERIC CODE NAME FOR SESSMGR
API_KYBD_NAM    DW      0               ;DITTO FOR KEYBOARD
API_MFIC_NAM    DW      0               ;DITTO FOR MFI
API_SMGR_INIT   DB      'SESSMGR '      ;NAME FOR NAME_RESOLUTION
API_KYBD_INIT   DB      'KEYBOARD'
API_MFIC_INIT   DB      'MFIC    '
API_WSCID       DW      0               ;WSCTRL NUMERIC SESSION ID
API_WSCNAM      DB      0               ;WSCTRL SHORT NAME
;
;========================================================================
; SCANTABLE IS THE XLAT TABLE FOR ASCII TO KEY SCAN CODES.
;    (X'80' BIT SAYS UPSHIFT REQD)
;
SCANTABLE       DB      32 DUP (0)
                DB      029H,096H,0D2H,0A6H     ;BLANK ! " #
                DB      0A5H,0AEH,0BDH,052H     ; $ % & '
                DB      0C6H,0C5H,0BEH,0D5H     ; ( ) * +
                DB      041H,04EH,049H,04AH     ; , - . /
                DB      45H,16H,1EH,26H,25H     ;0-4
                DB      2EH,36H,3DH,3EH,46H     ;5-9
                DB      0CCH,4CH,013H,55H,093H  ; : ; < = >
                DB      0CAH,09EH               ; ? @
                DB      09CH,0B2H,0A1H,0A3H,0A4H  ;A-E CAP (w/ UPSHIFT CODE)
                DB      0ABH,0B4H,0B3H,0C3H,0BBH  ;F-J CAP (w / UPSHIFT BIT ON)
                DB      0C2H,0CBH,0BAH,0B1H,0C4H  ;K-O CAP (w/ UPSHIFT BITS ON)
                DB      0CDH,095H,0ADH,09BH,0ACH  ;P-T CAP (W/ SHIFT BITS)
                DB      0BCH,0AAH,09DH,0A2H,0B5H  ;U-Y CAP (w/ SHIFT BITS ON)
                DB      09AH                      ;Z CAP (w/ SHIFT BIT ON)
                DB      054H,05BH,096H,0B6H,0CEH  ;CNTS \ BAR NOT _
                DB      0EH                     ;SINGLE QUOTE
                DB      1CH,32H,21H,23H,24H     ;a-e
                DB      2BH,34H,33H,43H,3BH     ;f-j
                DB      42H,4BH,3AH,31H,44H     ;k-o
                DB      4DH,15H,2DH,1BH,2CH     ;p-t
                DB      3CH,2AH,1DH,22H,35H     ;u-y
                DB      1AH                     ;z
                DB      053H,0DBH,0D3H,08EH,00H ;{  | } ~
                DB      27 DUP (0)
                DB      054H                    ;CENTS SIGN (ALSO IS [)
                DB      27 DUP (0)
                DB      26 DUP (0)
                DB      27 DUP (0)
                DB      20 DUP (0)
;
;====================================================================
MFITOASC        DB      8 DUP (0)
                DB      '>','<','[',']',')','(','}','{'
                DB      ' ','=',27H,22H,'/','\',00H,'|'
                DB      '?','!','$'
                DB      5 DUP (0)
                DB      '0','1','2','3','4','5','6'
                DB      '7','8','9'
                DB      00H,00H,'#','@','%','-','&','-','.',',',':'  ;2/7/84
                DB      '+'                                          ;ch _ to -
                DB      21 DUP (0)
                DB      28 DUP (0)
                DB      25 DUP (0)
                DB      'a','b','c','d','e','f','g','h'
                DB      'i','j','k','l','m','n','o','p'
                DB      'q','r','s','t','u','v','w','x'
                DB      'y','z'
                DB      0
                DB      5 DUP (0)
                DB      'A','B','C','D','E','F','G','H'
                DB      'I','J','K','L','M','N','O','P'
         =======================================
; API REL 1.2 CONTROL BLOCKS & PARM AREAS
;
                DB      'APIP'          ;EYECATCHER
API_FUNC        DB      0               ;FUNCTION CODE TO REQUEST (SYS EXT NUM)
API_WAIT        DB      20H             ;WAIT ACTION MASK (DEFAULT/RESET=20H)
API_REPLY       DB      80H             ;REPLY TYPE (DEFAULT/RESET=80H)
API_AMTHDID     DW      0               ;REQUESTED ACC METHOD ID
API_ERR         DB      0               ;TRY ERP IN COMMON SUB? (0=Y FF=N       DB      'Q','R','S','T','U','V','W','X'
                DB      'Y','Z'
                DB      4 DUP (0)
                DB      ';','*'
                DB      17 DUP (0)
                DB      27 DUP (0)
                DB      19 DUP (0)
                DB      0FFH            ;FLAG HIGH VALUES FOR PC PS ID OIA
;=========================================================================
;         SPECIAL XLAT TABLE FOR COMPOUND CNTL CHARS (@x)
CMPNDTABLE      DB      24 DUP (0)
                DB      23 DUP (0)
                DB      0
                DB      62H,07H,0FH,17H,1FH,27H   ;0-9 = HM CURS, PF1-PF9
                DB      2FH,37H,3FH,47H
                DB      7 DUP (0)
                DB      19H,64H,06H,6DH,58H,0BH   ;A-F
                DB      00H,05H,65H,03H,0AH,61H   ;G-L
                DB      01H,5AH,00H,83H,0CH,11H   ;M-R
                DB      12H,0DH,63H,60H,00H,0FFH  ;S-X  (X=SPECIAL ESC CHAR)
                DB      00H,6AH                   ;Y-Z
                DB      6 DUP (0)
                DB      4FH,56H,5EH,08H,10H,18H   ;a-f PF10-PF24
                DB      20H,28H,30H,38H,40H,48H   ;g-l
                DB      50H,57H,5FH,00H,00H,00H   ;m-r
                DB      00H,00H,00H,00H,00H,67H   ;s-x
                DB      6EH,6FH                   ;y-z
;                                                 LET REST OF TABLE OVERLAP
;                                                 AS WE SHOULD NOT HAVE BAD DATA
;===========================================================================
HIS_SS          DW      0               ;SAVEAREA FOR CALLERS STACK DATA
HIS_SP          DW      0
STACK_TOP       DB      99H
MYSTACK         DB      50 DUP ('STACK   ')
STACK_END       DB      'STACKEND'
;===========================================================================
STACK           SEGMENT PARA STACK 'STACK'
                DB      20 DUP ('STACK   ')     ;STACK FOR INIT'S USE
STACK           ENDS
;
;=================================================================
;
;==============================================================================
;       MAIN PCI INTERRUPT HANDLER
;               - ENTRY & CALL ANALYSIS
;               - CONTROL BLOCK VALIDATION & BUILD
;               - BRANCH TO EXEC ROUTINES
;               - CALLED WITH DS:SI POINTING TO THE USER PCB
;
; NOTE: ALL CALLS ARE 'FAR' IN CASE MODULE MUST BE SPLIT UP
;
CODESTART       DB      0               ;TOP OF CODE
INT44   PROC    FAR
I44:
        JMP     I44_START       ;SKIP 8 BYTE EYECATCHER/VALIDATION STAMP
        DB      'PCIRES10'      ;EYECATCHER PCIRESvr (VERS/RELEASE)
I44_START:                      ;SO LIMS CAN VERIFY WE ARE LOADED AND OK
        STI                     ;REENABLE ALL INTERRUPTS
        PUSH    ES              ;SAVE ES ON CALLERS STACK
        MOV     AX,DS           ;GET HIS DS
        MOV     ES,AX           ;ES: NOW = USER DS:
        MOV     BX,CSEG         ;GET MY DATA SEG SET UP
        MOV     DS,BX           ;DS: NOW = MY DATA AREA (ACTUALLY CSEG)
        MOV     UPSBOFF,SI      ;SAVE PCB PTR
        MOV     UPSBSEG,AX
;
;  SWITCH OVER TO MY LARGER STACK AREA FOR REST OF THE SESSION....
;
        MOV     CX,CSEG         ;GET MY UNIVERSAL SEGREG ADDR
        MOV     BX,SS           ;GET HIS SS: ADDR
        MOV     HIS_SS,BX       ;SAVE HIS SS:
;
        CLI                     ;STOP ALL INTS FOR STACK POINTER FIDDLES
        MOV     HIS_SP,SP       ;SAVE THE SP
        LEA     AX,STACK_END    ;POINT TO MY STACK SEG
        MOV     SP,AX
        MOV     AX,CSEG         ;GET UNIVERSAL SEGREG
        MOV     SS,AX           ;NOW ON MY STACK
        STI                     ;RE-ENABLE INTERRUPTS FOR NEW STACK
;
        MOV     AX,0ABCDH       ;PUSH VALIDITY CHECK VALUE ON STACK
        PUSH    AX              ;AS MY FIRST STACK ACTION (RECHECK AT EXIT)
        CMP     BYTE PTR LASTCK,044H     ;DO VALIDITY CKS FOR OVERLAYS
        JNE     INTEG_ERR1
        CMP     FIRSTCK,33H     ;TOP OF COMMON
        JNE     INTEG_ERR1
        CMP     STACK_TOP,99H   ;STACK OVERFLO
        JNE     INTEG_ERR1
        JMP     INTEG_OK
INTEG_ERR1:
        POP     AX              ;POP STACK TEST VALU
        MOV     AX,9999H        ;SET NEW STACK TEST VALUE (WILL CAUSE ERR)
        PUSH    AX
        MOV     AX,09
        MOV     URETCODE,AX     ;SHOW INTERNAL ERROR
        MOV     SYS_ERR1,0099H
        MOV     SYS_ERR2,0
        JMP     FAR PTR EXIT    ;GO ABEND
INTEG_OK:
;
        MOV     AL,ES:3 [SI]   HER
        JNE     PSBERROR
        CMP     BYTE PTR ES:2 [SI],'B'
        JE      VALIDPSB
PSBERROR:
        MOV     URETCODE,02     ;BAD PARM ON CALL
        JMP     FAR PTR EXIT
;
VALIDPSB:
        MOV     SYS_ERR1,0      ;RESET EXTENDED ERR CODE
        MOV     SYS_ERR2,0
C01:    CMP     AL,01H          ;CONNECT
        JNE     C02
        JMP     FAR PTR CONNECT
C02:    CMP     AL,02H          ;DISCONNECT
        JNE     C03
        JMP     FAR PTR DISCON
C03:    CMP     AL,03H          ;SENDKEY
        JNE     C04
        JMP     FAR PTR SENDKEY
C04:    CMP     AL,04H          ;WAIT
        JNE     C05
        JMP     FAR PTR WAIT
C05:    CMP     AL,05H          ;COPYPS
        JNE     C06
        JMP     FAR PTR GETSCR
C06:    CMP     AL,06H          ;SEARCH
        JNE     C07
        JMP     FAR PTR SEARCH
C07:    CMP     AL,07H          ;Q CURSOR
        JNE     C08
        JMP     FAR PTR Q_CURSOR
C08:    CMP     AL,08H          ;COPY STRING
        JNE     C09
        JMP     FAR PTR GETSTR
C09:    CMP     AL,09H          ;SET SESS PARM
        JNE     C0A
        CALL    FAR PTR CK_INTEG2       ;LOW PERF CALL
        JMP     FAR PTR SET_PARM
C0A:
        CMP     AL,0AH          ;Q SESS
        JNE     C0B
        CALL    FAR PTR CK_INTEG2       ;LOW PERF CALL
        JMP     FAR PTR Q_SESS
C0B:
        CMP     AL,0BH          ;RESERVE
        JNE     C0C
        JMP     FAR PTR RESERVE
C0C:
        CMP     AL,0CH
        JNE     C0D
        JMP     FAR PTR RELEASE
C0D:
        NOP
;
        CALL    FAR PTR CK_INTEG2       ;LOW PERF CALL
        MOV     URETCODE,02     ;BAD PARM
        JMP     FAR PTR EXIT
INT44   ENDP
;=========================================================================
;       EXIT - COMMON EXIT PROCESSING MODULE
;
EXIT    PROC    FAR
;
;  SHOW ENDING STATUS IF REQUIRED
;
        CMP     PCI_TRACE,'Y'   ;IS TRACE ON ?
        JNE     EX_NOTR
        MOV     AX,URETCODE     ;GET THE RETURN CODE
        CALL    FAR PTR PRTSTATUS
EX_NOTR:
;
;  NOW NEED TO RETURN US TO THE USERS OLD STACK
;
        POP     AX              ;SHOULD BE OUR STACK VALIDATION VALUE
        CMP     AX,0ABCDH       ;IS IT?
        JE      EX_STACKOK
        CALL    FAR PTR DAMG_MSG         ;PRINT DAMAGE MSG
EX_STACKOK:                     ;EVEN IF DAMAGED TRY TO RETURN....
        MOV     AX,HIS_SS       ;GET HIS STACK SS:
        MOV     BX,HIS_SP       ;GET HIS SP:
        CLI                     ;MASK ALL INTS WHILE WE MESS W/ STACK
        MOV     SS,AX           ;NOW ON HIS SS:
        MOV     SP,BX           ;NOW BACK TO OUR ORIGINAL ENTRY STACK
        STI                     ;RE-ENABLE INTS
;
;  NOW PASS BACK RETURN CODES & RESET DS: TO CALLER
;
        MOV     BX,URETCODE     ;PICK UP MY RETCODE TO PASS BACK (IN SHADOW PCB)
        MOV     AX,UPSBSEG      ;GET LANG INTERF DS: TO POINT TO REAL PCB
        MOV     DI,UPSBOFF      ;PCB OFFSET
        MOV     DS,AX           ;NOW RESTORE CALLER'S DS:  - MY DS: ZAPPED HERE
        MOV     [DI]+0BH,BX     ;STORE RETURN CODE IN LIM PCB
        POP     ES              ;RESTORE ES FROM HIS STACK
;
        IRET                    ;STACK STILL SHOULD BE SET TO IRET
EXIT    ENDP
;
;
CK_INTEG2 PROC FAR
        CALL    FAR PTR CK_OVERLAY
        CMP     AX,PROG_CKSUM   ;HAS THERE BEEN CODE ALTERED ?
        JE      CI2_OK          ;CHECKSUMS AGREE
        CALL    FAR PTR DAMG_MSG ;PRINT DAMAGE MSG
        MOV     AX,09
        MOV     URETCODE,AX     ;INTERNAL ERR
        POP     AX              ;POP CS:IP OFF STACK (WON'T DO A RETURN)
        POP     AX
        JMP     FAR PTR EXIT
CI2_OK:
        RET
;
CK_INTEG2 ENDP
;
DAMG_MSG PROC    FAR
        MSG     'PCI-933 PROGRAM DAMAGE HAS BEEN DETECTED'
        RET
DAMG_MSG ENDP
;=========================================================================
;                                                                        ;
;           FUNCTION MODULES :                                           ;
;  ;GET FUNCODE & LEAVE IN AL
        MOV     UFUNCODE,AL
        MOV     BX,ES:4 [SI]    ;GET DS:
        MOV     UDSEG,BX
        MOV     BX,ES:6 [SI]    ;GET DATA OFFSET
        MOV     UDOFFS,BX
        MOV     BX,ES:8 [SI]    ;GET LENGTH
        MOV     UDLEN,BX
        MOV     BL,ES:0AH [SI]  ;GET SESSION ID
        MOV     USESSID,BL
        MOV     BX,ES:0BH [SI]  ;GET RET CODE (OFFSET FOR GETSTR)
        MOV     URETCODE,BX
        CMP     BYTE PTR ES:0 [SI],'P' ;IS IT A VALID PCB EYECATC                                                                       ;
;=========================================================================
;
;
SENDKEY PROC    FAR
;====================================================================
;         SENDKEY
;====================================================================
        CMP     PCI_TRACE,'N'   ;IN DIAG MODE ?
        JE      SK_NODIA
        MSG     'PCI-030 IN SENDKEY'
SK_NODIA:
        CALL    FAR PTR CHKSTAT
        CMP     CK_NOHOST,0FFH  ;ARE WE CONNECTED ?
        JNE     SK_CONN         ;YES, CONTINUE
        JMP     SK_NOTCONN      ;ELSE DON'T TRY TO SENDKEY
SK_CONN:
;
;  GET READY TO CONVERT ASCII TO KEY SCAN CODES
;
        CALL    FAR PTR LOCK    ;LOCK HIS SESSION
        CMP     AL,0            ;GOOD RC
        JE      SK_LOCKOK
        CMP     AL,10H          ;IS INPUT INHIBITED ?
        JE      SK_LOCKOK       ;IF SO TRY RESET ANYWAY ++
        MOV     SYS_ERR1,0301H  ;ELSE IS AN INTERNAL ERROR
        MOV     SYS_ERR2,AX
        MOV     AX,9
        JMP     SK_EXIT
SK_INHIBIT:
        JMP     SK_LOCKED
SK_LOCKOK:
        MOV     CAPSMODE,0      ;RESET ANY OLD CAPS STATE
;
        CMP     PCI_RESET,'Y'   ;AUTORESET PRIOR TO SEND ?
        JNE     SK_NORESET
        MOV     AL,PS_ID        ;GET SESS NAM
        CMP     AL,API_WSCNAM   ;IS THIS THE SESS  MGR?
        JE      SK_NORESET      ;IF SO HE WON'T LIKE OUR RESET
        MOV     AH,0            ;SHIFTCODE = 0
        MOV     AL,11H          ;RESET KEY
        CALL    FAR PTR TYPIST  ;GO TYPE IT
        CMP     AL,0            ;GOOD RC
        JE      SK_NORESET
        CMP     AL,10H          ;WAS IT INHIBITED
        JE      SK_BADRESET
        MOV     SYS_ERR1,0303H  ;ELSE IT'S AN INTERNAL ERR
;;;;;   MOV     SYS_ERR2,AX
        MOV     AX,09
        JMP     SK_EXIT
SK_BADRESET:
        JMP     SK_LOCKED
;
SK_NORESET:
;
        MOV     AX,UDSEG        ;GET USERS SEG REG FROM PCB
        MOV     ES,AX           ;ES IS DATA SEGREG
        MOV     SI,UDOFFS       ;USER MSG POINTER IN SI (OFFSET)
        MOV     DI,0            ;OUTPUT BUFFER PTR  (COUNTER TO INCREMENT)
        MOV     CX,UDLEN        ;GET LENGTH FROM PCB
        CMP     PCI_STRLEN,'L'  ;STRING LENGTH BY COUNT (L) OR EOT (E) ?
        JE      SK_SETCNT       ;IF BY COUNT USE HIS LENGTH PARM
        MOV     CX,300          ;ELSE SET A MAX COUNT IN CASE EOT IS MISSING
SK_SETCNT:
        MOV     INCOUNT,CX      ;START OUT OUTLEN = INLEN (CHANGE FOR CMPND CHR)
        XOR     CX,CX           ;KEEP CX AS A LOOP COUNTER
SK_LOOP:
        MOV     AL,ES:0 [SI]    ;MOVE A BYTE OF MSG
        CMP     AL,PCI_ESC      ;@X IS A COMPOUND CONTROL CHARACTER
        JE      COMPOUND        ;IF ESC CHAR (@) FOUND, GO HANDLE IT
        CMP     PCI_STRLEN,'L'  ;STRING LENGTH BY COUNT? (vs EOT BYTE)
        JE      SK_NO_EOT
        CMP     AL,PCI_EOT      ;IS THIS THE EOT BYTE?
        JNE     SK_NO_EOT
        JMP     SK_DONE         ;IF EOT BYTE, WE ARE DONE....
SK_NO_EOT:
        LEA     BX,SCANTABLE    ;XLAT TABLE ADDR IN BX
        XLAT                    ;CONVERT ASCII TO KEY SCAN CODES
        INC     SI              ;SOURCE + 1
        JMP     SK_SHIFT        ;GO SET SHIFT CODE FOR API
;
COMPOUND:                       ;=== COMES HERE FOR @x COMPOUND CHAR ===
        INC     SI              ;NEED TO SKIP @ CHAR TO GET REAL CHAR CODE.
        INC     CX              ;LOOP COUNT + 1 TO SKIP ESC CHAR ALSO
        MOV     AL,ES:0 [SI]    ;GET 2ND BYTE OF CHARACTER
        CMP     PCI_STRLEN,'L'  ;Eot OR Length MODE?
        JE      SK_CP1          ;JMP IF LENGTH
        CMP     AL,PCI_EOT      ;IS BYTE 2 THE EOT BYTE?
        JNE     SK_CP1          ;IF NOT GO ON....
        JMP     SK_DONE         ;ELSE QUIT (EOT IN CMPD IS A SEMI ERROR !!)
SK_CP1:                         ;HOWEVER WE WON'T ENFORCE IT
        CMP     AL,PCI_ESC      ;DOUBLE ESC CHAR? (@@ ?)
        JE      SK_NO_EOT
        INC     SI              ;BUMP TO NEXT SOURCE BYTE
        CMP     AL,'A'          ;ALT MODE REQD?
        JE      SK_ALT
        CMP     AL,'S'          ;UPSHIFT?
        JE      SK_UPSHFT
        CMP     AL,'X'          ;IS IT SCAN CODE PASSTHRU HEADER? @X+SHFT+SCAN
        JE      SK_NOXLATE      ;IF SO DON'T XLATE
        PUSH    BX              ;SAVE NORMAL XLAT TABLE ADDR
        LEA     BX,CMPNDTABLE   ;POINT TO SPECIAL SCAN CODE TABLE
        XLAT                    ;XLATE TO SCAN CODE IN AL:
        POP     BX              ;RESTORE OLD XLAT TAY
        JMP     SK_OK           ;(SETS SHIFT STATE MASK FOR TYPIST)
SK_UPSHFT:
        OR      CAPSMODE,01H    ;OR IN UPSHIFT CODE IN SHIFTSTATE
        JMP     SK_OK
SK_NOXLATE:                     ;PASSTHRU DATA FIELD @X+SCAN+SHFT
        MOV     AL,ES:0[SI]     ;GET SCAN CODE
        MOV     AH,ES:1[SI]     ;GET SHIFT STATE
        ADD     SI,2            ;BUMP POINTERS
        ADD     CX,2
        JMP     SK_CONVERTED
;
SK_CONVERTED:                   ;SCAN CODE IS IN AL: SHIFT STATE IN AH:
        CMP     AL,00           ;IS IT AN INVALID CHAR             ++
        JE      SK_OK           ;IF SO, IGNORE IT (PRETEND IT SENT)++
        PUSH    CX              ;SAVE LOOP COUNTER
        CALL    FAR PTR TYPIST  ;GO SEND KEYSTROKE (RC IN AL:)
        POP     CX              ;RESTORE LOOP COUNTER
        CMP     AX,0            ;0 RETURN CODE ?
        JE      SK_OK
        CMP     AX,12H          ;RC=12H SAYS WE GENERATED AN AID BYTE
        JE      SK_OK           ;CONSIDER THIS OK
        CMP     AX,10H          ;RC=10 SAYS INHIBITED IPT
        JE      SK_LOCKED
        MOV     SYS_ERR1,0305H  ;ELSE AN INTERNAL ERR (TYPIST SETS SYS_ERR2)
        MOV     AX,0009H
        JMP     SK_EXIT         ;GO EXIT W/ BAD RETURN CODE
SK_LOCKED:
        CALL    FAR PTR CHKSTAT ;GO CHECK THE OIA
        CMP     AX,04           ;WAS IT BUSY
        JE      SK_EXIT         ;IF SO PASS BACK THE BUSY RC
        MOV     AX,05           ;ELSE IT IS LOCKED
        JMP     SK_EXIT
SK_NOTCONN:
        MOV     AX,01           ;NOT CONNECTED
        MOV     URETCODE,AX     ;PASS BACK STATUS
        JMP     FAR PTR EXIT    ;SPECIAL CASE--- DIRECT EXIT TO AVOID UNLOCK
;
SK_OK:
        INC     CX              ;LOOP COUNT + 1
        CMP     CX,INCOUNT      ;HAVE WE DONE THEM ALL YET ?
        JNL     SK_DONE
        JMP     SK_LOOP         ;GO BACK AND KEEP ON SENDING.....
SK_DONE:
        CMP     CP_TYPE,2       ;IS IT CUT MODE (HAS UPSHIFT STICK PROB) ++
        JNE     SK_NOERSET      ;IF       MOV     AX,01           ;NOT CONNECTED
        MOV     URETCODE,AX     ;PASS BACK STATUS
        JMP     FAR PTR EXIT    ;SPECIAL CASE--- DIRECT EXIT TO AVOID UNLOCK
;
SK_OK:
        INC     CX              ;LOOP COUNT + 1
        CMP     CX,INCOUNT      ;HAVE WE DONE THEM ALL YET ?
        JNL     SK_DONE
        JMP     SK_LOOP         ;GO BACK AND KEEP ON SENDING.....
SK_DONE:
        CMP     CP_TYPE,2       ;IS IT CUT MODE (HAS UPSHIFT STICK PROB) ++
        JNE     SK_NOERSET      ;IF NOT, NO PROBLEM                      ++
        CMP     PCI_RESET,'Y'   ;SPECIAL ENDING RESET FOR 1.2 PROB
        JNE     SK_NOERSET      ;(IF LAST BYTE SENT IS CAPS HE CAPS LOCKS !!!)
        MOV     AL,PS_ID        ;ALSO DON'T E RESET WSCTRL
        CMP     AL,API_WSCNAM
        JE      SK_NOERSET
;
        CALL    FAR PTR CHKSTAT ;1.2 CUT DOESN'T REPORT ERRS !!!!
        CMP     AX,05           ;IS HE INHIBITED ?
        JNE     SK12_FIX1       ;NO GO DO ENDING RESET
        JMP     SK_EXIT         ;MAY LEAVE KYBD STUCK IN UPSHIFT
SK12_FIX1:
        MOV     AH,0            ;NO SHIFT/SCAN
        MOV     AL,11H          ;RESET KEY (DOESN'T HAVE A SHIFT BIT)
        CALL    FAR PTR TYPIST
                                ;DON'T PROCESS ERRS
SK_NOERSET:
        CALL    FAR PTR CHKSTAT ;GO GET THE ENDING STATUS
        CMP     AX,04           ;ARE WE BUSY (X CLOCK/X SYS) ?
        JE      SK_ZEROSTAT     ;IF SO SET BACK TO 0 (BUSY IS GOOD ENDING)
        JMP     SK_EXIT         ;ELSE GO PASS BACK THE STATUS
SK_ZEROSTAT:
        XOR     AX,AX           ;STATUS = 0     MUST FALL THROUGH
SK_EXIT:
        MOV     URETCODE,AX     ;PASS BACK STATUS
        CALL    FAR PTR UNLOCK  ;UNLOCK HIS SESSION
                                ;<<<<<<<<<<<------
        JMP     FAR PTR EXIT    ;COMMON EXIT
;
SENDKEY ENDP
;
;======================================================================
;       TYPIST - SENDS SCAN CODE IN AL: (SHIFT STATE IN AH:)
;              - RETURNS STATUS IN AL:  SETUP FOR API/ITS 1.2
;======================================================================
TYPIST  PROC    FAR
;
;================================================================
;    DRIVER FOR PC/3270 KEYBOARD INTERFACE
;================================================================
        PUSH    BX              ;SAVE BX AS WORK REG
        PUSH    CX
        PUSH    DX
        PUSH    DI
        OR      AH,CAPSMODE     ;OR IN ALT OR SHIFT STATE
        MOV     CAPSMODE,0      ;CAPSMODE IS A SINGLE SHOT MASK (NEXT KEYSTR)
        MOV     TY_COUNT,0      ;WAIT RETRY COUNT=0
;
        MOV     API_FUNC,04     ;WRITE KEY
        CALL    FAR PTR APICLR  ;CLEAR PARM LIST
        MOV     BX,PS_SESSID    ;GET SESSION ID
        MOV     API_SESS,BX     ;PUT IN PARM LIST
        MOV     API_OPT,20H     ;SCAN-SHIFT OPTION
        MOV     API_SCAN,AL
        MOV     API_SHFT,AH     ;SHIFT STATE
        MOV     API_REPLY,40H   ;SENDKEY REQS COMPL-Q REPLY FORMAT
        MOV     API_WAIT,00H    ;NO WAIT FOR DATA ON COMPL-Q
        MOV     API_ERR,0FFH    ;DO MY OWN EREP
        CALL    FAR PTR APIREQST
        MOV     CX,API_LASTCX   ;GET ORIGINAL RC
        CMP     CL,0            ;GOOD RETURN
        JE      TY_NOERR1
        JMP     TY_ERR          ;ELSE FALL OUT W/ ERROR
TY_NOERR1:
        MOV     AH,83H          ;DO A GET-COMP FOR STATUS OF SENDKEY
        MOV     AL,0
        MOV     BH,0
        MOV     BL,00H          ;WAIT ON COMPL-Q ENTRY ???
        XOR     CX,CX
        XOR     DX,DX
        XOR     DI,DI
        PUSH    ES
        MOV     ES,DX           ;ES=0
        INT     7AH             ;CALL THE API FOR A GET_COMP Q
;
        CMP     PCI_ITSTRACE,'Y'
        JNE     TY_NOCQTR
        PUSH    AX              ;SAVE REQ ID
        MOV     AH,83H          ;API_LASTAX HAS OLD AX
        MOV     AL,CL           ;GET COMP Q RC
        CALL    FAR PTR PRT_APITR
        POP     AX              ;REQ ID
TY_NOCQTR:
        CMP     AX,API_LASTAX   ;DOES THE REQ-ID MATCH THE WRT-KEY ?
        JE      TY_RIGHTREQ
        POP     ES              ;ELSE TREAT AS AN EMPTY COMPL-Q
        JMP     TY_QEMPTY
TY_RIGHTREQ:
        CMP     CL,0            ;ANY ERRORS ?
        JE      TY_NOERR2
        POP     ES              ;RESTORE ES BEFORE ERP
        CMP     CL,09           ;IS REQ EMPTY ?
        JE      TY_QEMPTY       ;GO TRA
        JMP     TY_ERR
TY_QEMPTY:
;;;;    MSG     '++ Q EMPTY ++'
        INC     TY_COUNT        ;BUMP WAIT COUNTER
        CMP     TY_COUNT,250    ;ALLOW A BUNCH OF RETRIES
        JNL     TY_TIMEOUT      ;ELSE TIMEOUT
        JMP     TY_NOERR1       ;GO CHECK Q AGAIN
TY_TIMEOUT:
        MOV     CX,9999H        ;PHONEY ERRMSG
        JMP     TY_ERR
;
TY_NOERR2:                      ;COMES HERE WITH GET-COMP RC=0(GOOD DATA)
        MOV     AX,ES
        MOV     CX,0CCEEH       ;SPCL ERR SIGNATURE
        CMP     AX,0            ;ANY INFO AVAIL (ES = 0 ?)
        JE      TY_ERR
        MOV     AL,ES:0[DI]     ;GET COMPL CODE FOR SENDKEY
        POP     ES
        MOV     AH,77H          ;TRACE SIGNATURE
        MOV     SYS_ERR2,AX     ;IN CASE OF SOME INT ERR (THIS IS NORMAL CODE)
        CMP     AL,0AH          ;IS COMPL = STILL HAVE OLD COMPL?
        JE      TY_QEMPTY       ;IF SO, GO SEE IF WE CAN GET A COMPL CODE
        JMP     TY_EXIT
;
TY_ERR:
        MOV     SYS_ERR1,4401H  ;CALLER MAY REVALU THIS  <<ERR IN TYPIST CALL>>
        MOV     SYS_ERR2,CX     ;SAVE HIS ERRC
        MOV     AX,09           ;AX=09 INTERNAL ERROR
        JMP     TY_EXIT
TY_EXIT:
        CMP     PCI_ITSTRACE,'Y'  ;TRACE ON ?
        JNE     TY_NOTRACE
        MOV     AH,04           ;WRT KEY FUNC CODE
        CALL    FAR PTR PRT_APITR
TY_NOTRACE:
        MOV     AH,0            ;CLR TOP OF RC
        POP     DI              ;RESTORE REGS
        POP     DX
        POP     CX
        POP     BX
        RET
TYPIST  ENDP
;=======================================================================
; GETSCR  RC,BUFFER
;               - CALL RETURNS PRESENTATION SPACE IN ASCII TO USER
;                 (Does NOT return the 2000 byte hdwe buffer)
;               - RC= 0 = GOOD CALL
;               -     > 0 = KYBD/TERM STATUS WAS ABNORMAL
;                       (BUFFER CONTENTS WERE STILL MOVED)
;
GETSCR  PROC    FAR
;
        CMP     PCI_TRACE,'Y'   ;ARE WE IN TRACE MODE ?
        JNE     GSNOTR          ;0 = NO TRACE
        MSG     'PCI-050 IN COPYPS'
GSNOTR:
        MOV     ES,PS_SEG       ;GET PRESENTATION SP PTR
        MOV     SI,PS_OFF       ;ES:SI POINTS TO THE PS
        MOV     DI,UDOFFS       ;DI = USERS DATA OFFSET
        MOV     DX,UDSEG        ;WILL USE DS FOR USERS DSEG (HOLD IN DX)
        LEA     BX,MFITOASC     ;XLATE TABLE ADDR IN MY DS:
        XOR     CX,CX           ;COUNT = 0
GSLOOP:
        MOV     AL,ES:0[SI]     ;GET MFI FROM 3270 BUFF (PRESENT. SPACE)
        MOV     AH,AL           ;HOLD ORIGINAL VALU IN AL:
        XLAT                    ;MFI TO ASCII
        CMP     AL,00                         ;BUMP COUNTERS
        INC     SI
        CMP     PS_EAB,'E'      ;IS IT A EAB (NOTEPAD) Eab or Normal
        JNE     GS_NOTEAB
        INC     SI              ;IF SO, EVERY OTHER BYTE IS AN ATTRIBUTE
GS_NOTEAB:
        INC     CX
        CMP     CX,PS_SIZE      ;DONE FULL 3270 BUFFER? (0780H)
        JLE     GSLOOP          ;NO, GO FINISH
;
        CALL    FAR PTR CHKSTAT ;CHECK KEYBOARD STATUS (RETURN RETCODE IN AX)
        MOV     URETCODE,AX     ;SET RETURN CODE IN SHADOW PCB
;
        JMP     FAR PTR EXIT    ;GO TO COMMON EXIT
GETSCR  ENDP
;
;========================================================================
;
; WAIT -    PCWAIT USING RETCODE.
;               - CALL WITH RETCODE AS SINGLE PARM. WAITS FOR APPROX
;                 'N' SECONDS IF "X CLOCK" ON 3270. RETURNS A 0 IF
;                  UNLOCKED AND READY.
;               - RETURN CODES:
;                       0 - KYBD READY AND UNLOCKED
;                       1 - INVALID MODE
;                       3 - IN WSCTRL
;                       4 - TIMEOUT WHILE STILL " X CLOCK" MODE.
;                       5 - LOCKED WITH OTHER ERROR CONDITION.
WAIT    PROC    FAR
;
        CMP     PCI_TRACE,'Y'   ;TRACE MODE ?
        JNE     PCWNOTR         ;JMP IF NO
        MSG     'PCI-040 IN WAIT'
PCWNOTR:
        XOR     CX,CX           ;WAIT COUNT = 0
PCWRETRY:
        CALL    FAR PTR CHKSTAT ;GO CHECK KYBD STATUS
        INC     CX
        CMP     AX,0            ;UNLOCKED & OK ?
        JE      PCWEXIT         ;IF SO EXIT WITH CC=0
        CMP     AX,04H          ;WAS IT A "X CLOCK" WAIT (OR X SYSTEM)
        JE      PCWCLKON        ;ELSE FALL OUT AND PASS ON ERR CODE
PCWEXIT:
        MOV     URETCODE,AX     ;SAVE RETCODE IN PCB
        JMP     FAR PTR EXIT    ;COMMON EXIT
;
PCWCLKON:
        CMP     PCI_TIMEO,'Z'   ;ZERO WAIT ? (IE DON'T WAIT)
        JE      PCWEXIT
        CMP     CX,0FEEEH       ;TIMEOUT VALUE FOR WAIT
        JB      PCWRETRY        ;IF LOW KEEP WAITING...
        CMP     PCI_TIMEO,'N'   ;DO WE TIMEOUT
        JE      PCWRETRY        ;NO TIMEOUT = WAIT FOREVER
        JMP     PCWEXIT         ;ELSE PASS OUT RC=4 FOR TIMEOUT.
WAIT    ENDP


;=======================================================================
;  SEARCH
;        CALL 'PCSRCH' USING RETCODE LENGTH SEARCH-STRING.
;        SCANS THE PRESENTATION SPACE FOR A MATCH WITH SEARCH-STRING.
;       (NOTE: Uses the LOGICAL DEVICE buffer NOT the DISPLAY buffer.)
;        SETS RETCODE = 0 IF NO MATCH, ELSE GIVES OFFSET (1s ORIGIN).
;
SEARCH  PROC    FAR
;
        CMP     PCI_TRACE,'N'   ;IN TRACE MODE ?
        JE      SRCHNOTR        ;NO TRACE IF N
        MSG     'PCI-060 IN SEARCH'
SRCHNOTR:
;
;       MOVE & XLATE HIS VIDEO BUFFER (PRES SP) CONTENTS TO MY VBUFFER
;
        CALL FAR PTR GETBUFF
;
;       NOW HAVE ASCII XLATED 3270 BUFFER IN VBUFFER
;
        MOV     SI,UDOFFS       ;GET OFFSET TO COMPARE STRING
        MOV     AX,UDSEG        ;GET SEG OF COMP STR.
        MOV     ES,AX           ;ES: POINTS TO HIS SEGM
        CMP     PCI_STRLEN,'L'  ;LENGTH OR EOT MODE?
        JE      SR_NXT          ;JUMP IF HE GAVE US THE LEN
        MOV     BP,0            ;ELSE WE MUST CALC OUR LENGTH
SR_EOTLP:
        MOV     AL,ES:0 [SI] [BP]       ;GET SRCH STRING BYTE
        CMP     AL,PCI_EOT      ;IS IT EOT ?
        JE      SR_EOT          ;YES, BP=STR LENGTH
        INC     BP              ;ELSE LOOK AGAIN
        CMP     BP,3000         ;MAX POSSIBLE LENGTH
        JL      SR_EOTLP        ;FALL THROUGH SHOULD BE AN ERROR <<<<<<<<<<
                                ;HOWEVER, NO WAY TO PASS RC FOR SEARCH(RC=LOC)
SR_EOT: MOV     UDLEN,BP        ;SAVE THE LENGTH
;
SR_NXT:
        MOV     AX,PS_SIZE      ;SIZE OF SCREEN
        MOV     SC_END,AX       ;SAVE IT AS END OF SEARCH AREA
        MOV     SC_START,0      ;ASSUME SEARCH ALL (IE START AT 0)
        CMP     PCI_SRCH,'F'    ;SEARCH "FROM" MODE
        JNE     SR_SRCHALL      ;IF NOT SEARCH FROM 0 (DEFAULT)
        MOV     AX;WAS IT A ATTRIBUTE ?
        JNE     GS_NOTATTR
        CMP     PCI_ATTRX,'Y'   ;XLATE IT TO BLANK ?
        JE      GS_XLATE
        MOV     AL,AH           ;RESTORE ORIGINASL MFI
        JMP     GS_NOTATTR
GS_XLATE:
        MOV     AL,' '          ;XLATE ATTR TO BLANK
GS_NOTATTR:
        PUSH    DS              ;SAVE MY DSEG
        MOV     DS,DX           ;USERS DS TO DS:
        MOV     BYTE PTR 0[DI],AL       ;MOVE THE BYTE
        POP     DS              ;RESTORE MY DS
        INC     DI,URETCODE     ;SPCL CASE: SRCH START OFFSET PASSED IN PARM 4
        MOV     SC_START,AX     ;SET IT AS STARTING  SEARCH OFFSET
SR_SRCHALL:
        MOV     CX,UDLEN        ;CALL SCANIT WITH SRT LENGTH IN CX, STR @ ES:SI
        CALL    FAR PTR SCANIT  ;BUFFER SEARCH SUBROUTINE
        MOV     URETCODE,AX     ;SAVE THE RETCODE
SRCHEXIT:
        JMP     FAR PTR EXIT
SEARCH  ENDP
;
;......... SCANIT SUBROUTINE: SEARCHES MY VBUFFER FOR STRING
;                             STRING AT ES:SI FOR LENGTH IN CX
;
SCANIT  PROC    FAR
        MOV     SR_OFFS,SI      ;SAVE STRING ORIGIN
        MOV     SR_LEN,CX       ;SAVE LENGTH
        MOV     BX,SC_START     ;INDEX TO PRES SPACE (0 OR STARTING OFFSET)
SLOOP1: MOV     AL,ES:0[SI]     ;GET 1ST BYTE
        CMP     AL,VBUFFER[BX]  ;POSSIBLE STRING MATCH (1ST BYTE =) ?
        JE      POSSIBLE
SL1RE:  INC     BX              ;NO MATCH LOOK AT NEXT BUFFER BYTE
        CMP     BX,SC_END       ;END OF BUFFER ?
        JLE     SLOOP1          ;NO TRA
        JMP     NOMATCH         ;FALL OUT W/OUT STRING IN BUFFER
;
POSSIBLE:
        PUSH    BX              ;SAVE INDEX IN CASE NO MATCH
        PUSH    SI
        MOV     SI,SR_OFFS      ;SOURCE INDEX = DATA POINTER (HIS OFFSET)
        XOR     CX,CX           ;COUNT = 0
SLOOP2: MOV     AL,ES:0 [SI]    ;GET COMPARE STRING
        CMP     AL,VBUFFER[BX]
        JNE     NOCOMP          ;NOT EQ
        INC     BX              ;BUFFER PTR + 1
        INC     SI              ;STRING PTR TO USERDATA + 1
        INC     CX              ;COUNT+1
        CMP     CX,SR_LEN       ;DONE YET ?
        JL      SLOOP2          ;FALLS OUT ON A MATCH
        POP     SI
        POP     BX              ;FIXUP STACK
        INC     BX              ;1'S ORIGIN INDEX
        JMP     MATCH
NOCOMP:
        POP     SI
        POP     BX              ;RESTORE INDEX
        JMP     SL1RE           ;GO LOOK SOME MORE
NOMATCH:
        MOV     BX,0            ;RETURN A 0  ++MUST FALL THROUGH++
MATCH:
        MOV     AX,BX           ;PUT THE RETURN CODE IN AX:
        RET
SCANIT  ENDP
;
;======================================================================
GETSTR  PROC    FAR
;
;  GETSTR - RETURNS STRING OF LENGTH AT OFFSET - 1 IN CURR PRES SPACE.
;               - SPECIAL CASE: USES RETCODE AS OFFSET VALUE IN SCREEN
;                 THEN RETURNS A STRING OF LENGTH FROM THAT LOC - 1.
;
        CMP     PCI_TRACE,'Y'     ;TRACE ?
        JNE     GS_NOTR
        MSG     'PCI-080 IN COPYSTRING'
GS_NOTR:
;
        CALL    FAR PTR GETBUFF         ;REFRESH BUFFER EACH TIME
;
        MOV     CX,UDLEN        ;CX = LENGTH
        MOV     AX,UDSEG        ;GET TARGET SEG
        MOV     ES,AX
        MOV     DI,UDOFFS       ;ES:DI = DATA TARGET
        MOV     SI,URETCODE     ;GET BUFFER OFFSET
        DEC     SI              ;ADJUST FROM 1s ORIGIN TO 0 ORIGIN
GS_LOOP:
        CMP     CX,0            ;ARE WE DONE YET?
        JLE     GS_DONE
        MOV     AL,VBUFFER [SI] ;GET A BYTE
        MOV     ES:0 [DI],AL    ;STORE IT
        INC     SI              ;SOURCE+1
        INC     DI              ;DEST+1
        DEC     CX              ;COUNT - 1
        JMP     GS_LOOP
;
GS_DONE:
        MOV     AX,0
        MOV     URETCODE,AX     ;NO BAD RET CODES POSSIBLE
        JMP     FAR PTR EXIT
GETSTR  ENDP
;
;======================================================================
GETBUFF PROC    FAR
;       GETBUFF MOVES THE MFI SCREEN IMAGE FROM THE PRESENT SPACE
;       (NOTE: LOGICAL DEVICE buffer not the DISPLAY buffer.)
;       AND XLATES MFI TO ASCII IN VBUFFER
;       SAVE ANY WORK REGS YOU NEED BEFORE ENTRY.......
;
        PUSH    ES
        MOV     AX,PS_SEG       ;POINT TO BUFFER SEGMENT (CURR PS)
        MOV     ES,AX           ;ES IS SEGREG
        MOV     SI,PS_OFF       ;GET OFFSET TO CURR PRES SPACE
        LEA     BX,MFITOASC     ;TRANSLATE TABLE MFI --> ASCII
        XOR     CX,CX           ;CLEAR COUNT
        XOR     DI,DI           ;DEST INDEX STARTS AT 0
MOVLOOP:
        MOV     AL,ES:0[SI]     ;GET MFI FROM REAL BUFFER
        MOV     AH,AL           ;SAVE IT IN AH:
        XLAT                    ;CONVERT TO ASCII
        CMP     AL,00H          ;DID IT XLATE TO NULL ?
        JNE     GB_NOTATTR      ;IF NOT, NO PROBLEM
        CMP     PCI_ATTRX,'Y'   ;XLATE ATTR TO BLANKS?
        JE      GB_XLATE
        MOV     AL,AH           ;ELSE RESTORE ORIGINAL VALU
        JMP     GB_NOTATTR
GB_XLATE:
        MOV     AL,' '          ;CONVERT IT TO A BLANK
GB_
Q_CURSOR        PROC    FAR
;
;       Q_CURSOR: QUERY CURSOR LOC RETURNS THE CURRENT CURSOR LOCATION
;
        CMP     PCI_TRACE,'Y'   ;TRACE ON?
        JNE     QC_NOTR
        MSG     'PCI-070 IN QCURSOR'
QC_NOTR:
        CMP     PS_ID,'#'       ;IN WSCTRL ?
        JNE     QC_OK
        CMP     PS_TYP,01       ;PC SESS TYPE ?
        JNE     QC_OK
        MOV     URETCODE,9999H  ;SET ERR CODE TO 9999H
        JMP     FAR PTR EXIT
QC_OK:
        MOV     AX,EPSEG        ;GET HIS SEGREG
        MOV     ES,AX           ;SETIT
        MOV     SI,PS_CURSOR    ;ES:SI POINTS TO ROW/COL OF CURSOR
        MOV     AL,BYTE PTR ES:0[SI]    ;GET THE ROW
        MUL     PS_ROWSIZE      ;AX = CURSOR ROW * ROWSIZE
        XOR     BX,BX           ;BX=0
        MOV     BL,BYTE PTR ES:1 [SI]   ;GET COL #
        ADD     AX,BX           ;ADD COL #
        INC     AX              ;+1 FOR 1'S OFFSET
        MOV     URETCODE,AX     ;RETCODE = CURSOR LOC
        JMP     FAR PTR EXIT
Q_CURSOR  ENDP
;
;==============================================================================
CHKSTAT PROC    FAR
;
; CHKSTAT - CHECKS KEYBOARD, RETURNS STATUS IN AX
;           0 = UNLOCKED, RDY FOR INPUT  4 = BUSY (X CLOCK/X SYSTEM)
;           1 = NOT IN VALID MODE (PC ?) 5 = KYBD LOCKED/NOT HOST CONN
;           2 = NA - INVALID CALL PARM
;           3 = IN WSCTRL MODE           9 = NA - INTERNAL PCIRES ERROR
;
;
        PUSHALL
        MOV     CK_NOHOST,0     ;FF=NO HOST OR NOTEP CONN
        MOV     SI,DLINEOFF     ;GET STATUS LINE ADDR
        MOV     AX,DBUFFSEG     ;GET DISPLAY BUFFER SEG
        MOV     ES,AX           ;ES: = DISPLAY SEGM
;
        CMP     PS_ID,'#'       ;ARE WE IN WSCTRL
        JE      WSCTRL
        JMP     NOTWSCTRL
WSCTRL:
        MOV     AL,ES:188 [SI]  ;GET PSID FROM WINDOW=x (DISPL IS DEC 188)
        LEA     BX,MFITOASC     ;TRANSLATE IT TO ASCII
        XLAT
        MOV     CK_PSID,AL      ;SHOW THE ACTIVE PSID
        MOV     AX,03           ;RC 03 = WS CONTROL MODE.
        JMP     CK_EXIT
CK_EXIT:
        MOV     CK_STATUS,AX    ;SAVE STATUS IN DIAG AREA
        POPALL
        MOV     AX,CK_STATUS    ;RESTORE STATUS
        RET
;
NOTWSCTRL:
;
; NEED TO SET CK_PSID TO LAST PS_ID USED BY CONNECT
;
        MOV     AL,PS_ID        ;GET LAST CONNECT VALUE
        MOV     CK_PSID,AL
;
        CMP     AL,0FFH         ;IS THIS A PC SESSION ?
        JNE     CK_NOTPC
        MOV     AX,01           ;INVALID MODE (NOT CONNECTED)
        MOV     PS_TYP,01       ;FLAG IT FOR SURE (PC SESSION TYPE)
        MOV     CK_NOHOST,0FFH
        JMP     CK_EXIT
;
; NEED TO DETERMINE THE OIA DATA WITHOUT USING THE DISPLAY STATUS LINE
;
CK_NOTPC:
        CMP     PS_TYP,02       ;IS THIS A NOTEPAD?
        JNE     CK_NOTNOTEP     ;IF NOT IT MUST BE A HOST
                                ; ELSE CHECK NOTEPAD OIA BITS
        LES     SI,PS_OIAPTR    ;LOAD ES:SI WITH THE OIA POINTER
        MOV     AL,BYTE PTR ES:1 [SI]   ;GET REAL FLAG BYTE
        AND     AL,7FH          ;TURN OFF TOP BIT (INSERT MODE)
        CMP     AL,0            ;ANY BITS ON ?
        JNE     CK_NP_LOCK      ;IF SO IT IS LOCKED
        MOV     AX,0            ;NOTEPAD UNLOCKED & RDY
        JMP     CK_EXIT
CK_NP_LOCK:
        MOV     AX,05           ;SHOW IT IS LOCKED
        JMP     CK_EXIT
CK_NOTNOTEP:
        CMP     CP_TYPE,02      ;IS THIS A CUT MODE SESSION ?
        JNE     CKL_DFT         ;IF NOT WE ARE DFT MODE
        JMP     CKL_CUTMODE     ;IF CUT MODE OIA IS IN HDWE CARD
CKL_DFT:                                                  ;   ---------------
;                                                             I             I
;   FOR DFT MODE THE OIA IS IN VARIOUS CONTROL BLOCKS....     I    DFT      I
;                                                             I_____________I
        LES     SI,PS_OIAPTR    ;SET ES:SI TO POINT TO THE 3270 SESSION OIA
;
        TEST    BYTE PTR ES:11[SI],20H   ;IS IT X-SYSTEM MODE?
        JNZ     CKL_BUSY
        TEST    BYTENOTATTR:
        MOV     VBUFFER[DI],AL  ;PLACE IN MY BUFFER
        INC     SI
        CMP     PS_EAB,'E'      ;DO WE HAVE EAB (EXTD ATTRIBUTES)? Eab OR Norm
        JNE     GB_NOTEAB       ;
        INC     SI              ;ADD 1 MORE TO SKIP ATTRIBUTE BYTE
GB_NOTEAB:
        INC     DI
        INC     CX
        CMP     CX,PS_SIZE      ;END OF BUFFER
        JLE     MOVLOOP
        POP     ES
        RET
GETBUFF ENDP
;
;====================================================================== PTR ES:09[SI],40H   ;IS IT X-CLOCK?
        JNZ     CKL_BUSY
        CMP     BYTE PTR ES:8[SI],0      ;ANY FLAGS
        JNE     CK_DF_ERR
        CMP     BYTE PTR ES:9[SI],0
        JNE     CK_DF_ERR
        CMP     BYTE PTR ES:10[SI],0
        JNE     CK_DF_ERR
        CMP     BYTE PTR ES:11[SI],04    ;04 IS NORMAL MODE
        JNE     CK_DF_ERR
        TEST    BYTE PTR ES:2[SI],10H    ;CHECK THE LEFT SIDE SYM FOR NOT CONN
        JNZ     CKL_CON
        TEST    BYTE PTR ES:2[SI],08H
        JNZ     CKL_CON
        TEST    BYTE PTR ES:2[SI],20H
        JNZ     CKL_CON
        TEST    BYTE PTR ES:2[SI],04H                           ;++8/11/84++
        JNZ     CKL_CON
CKL_NOTCON:
        MOV     CK_NOHOST,0FFH            ;SET NO HOST FLAG
        JMP     CK_DF_ERR                 ;ELSE WE AREN'T CONNECTED  (LOCKED)
;
CKL_CON:
        MOV     AX,0            ;UNLOCKED & RDY
        JMP     CK_EXIT
CKL_BUSY:
        MOV     AX,04           ;BUSY
        JMP     CK_EXIT
CK_DF_ERR:
        MOV     AX,05           ;LOCKED
        JMP     CK_EXIT
;                                                       ----------
;                                                       I  CUT   I
;                                                       I________I
;
CKL_CUTMODE:                    ;OIA IS AT C000:E000  (CKLC=CHKSTAT LOGICAL CUT)
        MOV     AX,0C000H       ;GET SEG ADDR OF OIA   (UNLESS A NOTEPAD)
        MOV     ES,AX
        MOV     SI,0E000H       ;HDWE OIA IS AT ES:SI
CKL_3270:
        MOV     CX,0400H                 ;RETRY LOOP COUNTER
        CMP     BYTE PTR ES:0 [SI],00H   ;ANY SYMBOL AT OFFSET 0 IN OIA?
        JE      CKLC_NOTCONN             ;IF 0 WE ARE NOT CONNECTED
        JMP     CKLC_CONN               ;ONLY LOOK FOR A LEFTSIDE SYMBOL(BOX4)
CKLC_NOTCONN:
        MOV     AX,05           ;NO HOST (LOCKED)
        MOV     CK_NOHOST,0FFH
        JMP     CK_EXIT
CKLC_BUSY:
        MOV     AX,04           ;BUSY
        JMP     CK_EXIT
CKLC_CONN:
        CMP     BYTE PTR ES:8 [SI],0F6H  ;IS X SYMBOL UP?
        JNE     CKLC_NOTLOCK
        CMP     BYTE PTR ES:10 [SI],0F4H ;IS IT AN X CLOCK?
        JE      CKLC_BUSY
        CMP     BYTE PTR ES:10 [SI],0B2H ;IS IT X System ?
        JE      CKLC_BUSY
CKLC_LOCK:                      ;ELSE WE ARE LOCKED FOR SOME REASON (X IS UP)
        DEC     CX              ;RETRY COUNTER (IN CASE OIA IS BEING UPDATED)
        CMP     CX,0
        JNE     CKLC_CONN
        MOV     AX,05           ;ELSE WE ARE LOCKED (ERR=5)
        JMP     CK_EXIT
CKLC_NOTLOCK:
        CMP     BYTE PTR ES:16 [SI],0    ;CHECK FOR MISC COMM ERRORS <<<
        JNE     CKLC_LOCK
        CMP     BYTE PTR ES:18 [SI],0
        JNE     CKLC_LOCK
        CMP     BYTE PTR ES:20 [SI],0
        JNE     CKLC_LOCK
        MOV     AX,0            ;UNLOCKED & READY
        JMP     CK_EXIT

CHKSTAT ENDP
;=======================================================================
;  CONNECT- CONNECTS USER TO REQUESTED SESSION.
;         - BUILDS PS POINTERS BASED ON SELECTED SESSION ID
;         - RETURNS STANDARD CHKSTAT ENDING STATUS
;
CONNECT PROC    FAR
        CMP     PCI_TRACE,'Y'   ;Y = IN TRACE MODE
        JNE     CN_ND
        MSG     'PCI-010 IN CONNECT'
CN_ND:
;
;   DISCONNECT FIRST FROM ANY PRIOR SESSION
;
        CMP     PS_ID,0FFH      ;NOT CONN?
        JE      CN_DISCOK       ;IF SO DON'T DISCONN
        CMP     PS_ID,0         ;UNDEF?
        JE      CN_DISCOK
        CMP     PS_RESERV,'R'   ;SESS RESERVED?
        JE      CN_DISCOK       ;IF SO NO DISCONN
        CALL    FAR PTR API_DISC        ;GO DISCONN
        CMP     AX,0            ;GOOD DISC ?
        JE      CN_DISCOK
        CMP     AX,04           ;NOT CONN ???
        JE      CN_DISCOK       ;LET IT GO BY (SHOULD BE ERR...)
        MOV     SYS_ERR1,0109H
        MOV     SYS_ERR2,AX
        MOV     AX,9
        MOV     URETCODE,AX     ;INTERNAL ERROR
        JMP     FAR PTR EXIT    ;GO ABEND
CN_DISCOK:
;
        MOV     AX,UDSEG        ;GET HIS SEG ADDR
        MOV     ES,AX           ;SET ES:
        MOV     SI,UDOFFS       ;ES:SI POINTS TO SESSION ID BYTE
        MOV     AL,ES:0[SI]     ;GET SESSION ID
        CMP     AL,'#'
        JE      CN_NOXLAT
        AND     AL,0DFH         ;INSURE NAME IS UPPERCASE
CN_NOXLAT:
        MOV     PS_ID,AL        ;SAVE IT
        CMP     AL,'#'          ;ARE WE CONNECTING TO WSCTRL
        JNE     CN_NOTMGR
        MOV     AL,API_WSCNAM   ;CHANGE HIS WSCTRL NAME (#) TO OFFICIAL NAME
        JMP     CN_LOGICAL      ;IF SO BYPASS CONN PHYSICAL
CN_NOTMGR:
        CMP     PCI_CONN,'P'    ;DO WE CONNECT PHYSICAL (JUMP TO THE SESSION) ?
        JE      CN_PHYS
        JMP     CN_LOGICAL      ;ELSE JUST CONNECT LOGICAL (NOT VISIBLE)
CN_PHYS:
;
;  SETUP ITS CALL FOR CONNECT
;
        MOV     CNP_PSID,AL     ;SAVE ORIGINAL SESSION ID IN SAVEA
        MOV     AL,API_WSCNAM   ;SESSION MGR SHORT NAME
        MOV     PS_ID,AL        ;NEED TO OPEN SESSION W/ SESS_MGR
        MOV     AX,API_WSCID    ;WSCTRL HANDLE #
        MOV     PS_SESSID,AX    ;CURR SESS HANDLE
        CALL    FAR PTR API_CONN ;CONNECT KEY
        CMP     AX,0
        JE      CNP_OK          ;GOOD RET
        CMP     AL,4            ;ALREADY IN SESSION?
        JE      CNP_OK          ;I SUPPOSE THATS OK???
        MOV     SYS_ERR2,AX     ;SAVE ERR CODE
        MOV     SYS_ERR1,0101H
        MOV     AX,09           ;INTERNAL ERROR - CAN'T CONN W/ SESS MGR
        JMP     CN_EXIT         ;GO EXIT
CNP_OK:
        CALL    FAR PTR LOCK    ;LOCK THE SESSMGR SESSION
;
;  SINCE THIS IS A PHYSICAL CONNECT WE NEED TO JUMP TO THE SESSION
;
        MOV     CX,08           ;JUMP LOOP COUNT (MAX NUMBER OF ATTEMPTS)
CN_PLOOP:
        CALL    FAR PTR CHKSTAT
        CMP     AX,03           ;SHOULD BE IN WSCTRL
        JNE     CN_ERR2
        MOV     AL,CNP_PSID     ;GET PS_ID WE WANT
        CMP     AL,CK_PSID      ;ARE WE AT THE RIGHT PS?
        JE      CNP_DISCONN     ;YES GO ON, WE HAVE THE REQUESTED PS
                                ;AND WE NEED TO DISC FROM SESS MGR
        DEC     CX              ;ELSE RETRY COUNT - 1
        CMP     CX,0
        JLE     CN_ERR1         ;CAN'T CONNECT
;
        MOV     AL,03           ;JUMP KEY SCAN   << CHANGE SCREEN >>
        MOV     AH,00           ;NO SHIFT
        CALL    FAR PTR TYPIST
        CMP     AL,10H          ;WSCTRL INHIBITED?
        JE      CN_PLOOP        ;GO AHEAD AND RETRY
        CMP     AL,0            ;GOOD I/O ?
        JNE     CN_ERR2         ;INTERNAL ERR....
;
        JMP     CN_PLOOP        ;KEEP ON UNTIL WE GET IT RIGHT
CN_ERR1:                        ;CAN'T FIND PS, NEED TO DISC FROM WSCTRL
        CALL    FAR PTR UNLOCK  ;UNLOCK THE SESS MGR
        CALL    FAR PTR API_DISC ;GO DISCONNECT W/ API/ITS
        CMP     AL,0            ;GOOD DISCONNECT ?
        JNE     CN_ERR2
        MOV     AX,01           ;MY CAN'T CNNECT RETCODE (DON'T CARE HIS RC)
        JMP     CN_EXIT         ;GO EXIT
CN_ERR2:                        ;BAD RC ON SESS_MGR DISCONNECT
        MOV     SYS_ERR1,0102H
        MOV     SYS_ERR2,AX
        MOV     AX,09           ;INTERNAL ERROR
        JMP     CN_EXIT
CNP_DISCONN:
;
;  COMES HERE AFTER JUMPING TO NEW SESSION - NEED TO DISCONN FROM SESS_MGR
;
        CALL    FAR PTR UNLOCK  ;UNLOCK SESSMGR
        CALL    FAR PTR API_DISC ;GO DISCONNECT (RC BACK IN AL:)
        CMP     AL,0
        JNE     CN_ERR2         ;BAD RC = INTERNAL ERROR
;
        MOV     AL,CNP_PSID     ;RESTORE ORIGINAL PS ID
        MOV     PS_ID,AL        ;SETUP FOR CONN LOGICAL
;
CN_LOGICAL:
;
;  NOW WE NEED TO SET THE Pres Space POINTERS  FROM THE TABLE
;
        CMP     PS_ID,'#'       ;DID HE WANT TO CONNECT W/ WSCTRL ?
        JNE     CN_GOODID
        JMP     CN_WSCTRL       ;IF SO WE HAVE NO PSCB
CN_GOODID:
        LEA     SI,PS1                  ;GET ADDR OF MY PS TABLE
        XOR     CX,CX                   ;COUNT = 0
        MOV     AL,PS_ID                ;DESIRED PS NAME TO SET ADDRESSES FOR....
CN_LOOP2:
        CMP     AL,[SI].PSCB_NAM        ;IS THIS THE ONE ?
        JE      CN_SETADR               ;YES, GO SET THE PS SEG:OFFSET ADDR
        ADD     SI,PSCB_CBSIZE          ;NOT THE ONE, ADDR MY NEXT CB ENTRY
        INC     CX                      ;COUNT+1
        CMP     CX,PSCB_COUNT           ;COUNT OF TABLE ENTRIES
        JLE     CN_LOOP2                ;KEEP LOOKING.....
CN_NOCONN:                              ;FALLS OUT W/NO MATCHUP (BAD ID ?)
        MOV     AX,01                   ;CAN'T CONNECT
        JMP     CN_EXIT                 ;DO A ERROR RETURN
CN_SETADR:                              ;
        MOV     AX,[SI].PSCB_ID         ;GET SESSION HANDLE
        MOV     PS_SESSID,AX            ;CURR HANDLE
        CALL    FAR PTR API_CONN        ;GO CONNECT
        CMP     AX,04                   ;ALREADY CONNECTED ?
        JE      CN_SETREST              ;IF SO, GO ON...
        CMP     AX,0
        JE      CN_SETREST
        MOV     SYS_ERR1,0103H          ;ELSE AN INTERNAL ERR
        MOV     SYS_ERR2,AX
        MOV     AX,9
        JMP     CN_EXIT                 ;GO OUT   <<<
CN_SETREST:
        MOV     PS_PSCBOFF,SI
        MOV     AL,[SI].PSCB_RESERV
        MOV     PS_RESERV,AL
        MOV     AX,[SI].PSCB_SEG ;GET POINTERS TO THE PRES SPACE
        MOV     PS_SEG,AX
        MOV     AX,[SI].PSCB_OFF
        MOV     PS_OFF,AX
        MOV     AL,[SI].PSCB_TYP
        MOV     PS_TYP,AL
        MOV     AX,[SI].PSCB_OIAOFF
        MOV     PS_OIAPTR,AX
        MOV     AX,[SI].PSCB_OIASEG
        MOV     PS_OIAPTR+2,AX
        MOV     AX,[SI].PSCB_SIZE       ;PS SIZE
        MOV     PS_SIZE,AX
        MOV     AX,[SI].PSCB_CURSOR
        MOV     PS_CURSOR,AX
        MOV     AL,[SI].PSCB_ROWSIZE
        MOV     PS_ROWSIZE,AL
;
        MOV     AL,[SI].PSCB_FEAT       ;HAS EAB & PSYM CODES
        MOV     PS_EAB,'E'      ;DEFAULT=EAB
        TEST    AL,80H          ;IS EAB BIT ON?
        JNZ     CN_EABSET       ;NZ=BIT IS ON
        MOV     PS_EAB,'N'      ;ELSE NOT EAB
CN_EABSET:
        JMP     CN_EXIT2        ;GOOD STATUS UP TIL NOW
CN_WSCTRL:
        MOV     PS_TYP,0        ;UNDEF SESS TYPE
        MOV     PS_PSCBOFF,0    ;NO PSCB ENTRY
        MOV     PS_RESERV,0     ;CAN'T RESERV IT
        MOV     AX,API_WSCID    ;GET WSCTRL HANDLE
        MOV     PS_SESSID,AX
        CALL    FAR PTR API_CONN
        CMP     AX,0            ;GOOD CONN
        JE      CN_WSCOK
        CMP     AX,04           ;ALRDY CONN ?
        JE      CN_WSCOK
        MOV     SYS_ERR1,0105H  ;SET INTERN ERR
        MOV     SYS_ERR2,AX
        MOV     AX,09
        JMP     CN_EXIT
CN_WSCOK:
        JMP     CN_NORESET      ;GO EXIT

;
;  CHECK FINAL STATUS FOR EXIT
;
CN_EXIT:
        CMP     AX,0            ;GOOD CONNECT
        JE      CN_EXIT2
        MOV     PS_ID,0FFH      ;FLAG US AS NOT CONNECTED (FF=PC SESSID)
        MOV     PS_TYP,01       ;PC SESSION TYPE
        JMP     CN_ERREXIT      ;IN ERROR STATUS JUST GO EXIT
CN_EXIT2:
        NOP                     ;++ DON'T DO RESET ON CONNECT....
        MOV     CAPSMODE,0      ;CLEAR ANY RESIDUAL CAPS
;;;     CMP     PCI_RESET,'Y'   ;AUTORESET MODE?
;;;     JNE     CN_NORESET      ;IF SO, WE WILL DO A RESET PRIOR TO CKSTAT
;;;     MOV     CAPSMODE,0      ;CLEAR ANY RESIDUAL CAPS/ALT
;;;     CALL    FAR PTR CHKSTAT ;BE SURE WE ARE CONN BEFORE UNLOCK
;;;     CMP     CK_NOHOST,0     ;ARE WE HOST CONN ?
;;;     JNE     CN_ERREXIT      ;CHKSTAT SHOULD HAVE AX=5=LOCKED
;;;     CALL    FAR PTR LOCK    ;IGNORE RETCODES
;;;     MOV     AH,0            ;0 SHIFT STATE
;;;     MOV     AL,11H          ;RESET SCAN CODE
;;;     CALL    FAR PTR TYPIST  ;GO DO A RESET
;;;     CMP     AX,09           ;INTERN ERR?
;;;     JE      CN_ERREXIT
;;;     CALL    FAR PTR UNLOCK  ;IGNORE RETCODES
CN_NORESET:                     ;RET CODE DOESN'T COUNT AS CHKSTAT WILL LOOK
        CALL    FAR PTR CHKSTAT
CN_ERREXIT:
        MOV     URETCODE,AX     ;SET RETCODE
        JMP     FAR PTR EXIT    ;USE COMMON EXIT
CONNECT ENDP
;
;=========================================================================
; DISCON - RETURNS TO PC MODE
;               - NO PARMS, RETCODE = 0 IF OK.  , 1 IF NOT CONNECTED
;                                   = 9 IF INTERNAL ERROR
DISCON  PROC    FAR
        CMP     PCI_TRACE,'N'   ;IS TRACE ON?
        JE      DC_ND
        MSG     'PCI-020 IN DISCONNECT'
DC_ND:
        CMP     PS_ID,0FFH      ;ARE WE NOT CONNECTED ?
        JNE     DC_TRYIT        ;IF WE ARE TRY TO DISC
        MOV     AX,1            ;ERR = NOT CONN
        JMP     DC_EXIT2
DC_TRYIT:
;
;  FIRST DISCONNECT FROM THE ACTIVE SESSION
;
                                 ;CURR SESSION NAME ASSUMED IN PS_ID & PS_SESSID
        CMP     PS_RESERV,'R'    ;IS THIS ID RESERVED ?
        JE      DC_NEXT          ;IF SO DON'T REALLY DISC
        CALL    FAR PTR API_DISC ;GO CALL ITS (RC IN AL: ON RETURN)
        CMP     AL,0             ;GOOD RETURN ?
        JE      DC_NEXT
DC_ERR1:
        MOV     SYS_ERR1,0201H   ;INTERNAL ERR IF WE CAN'T DISCONN
        MOV     SYS_ERR2,AX
        MOV     AX,9
        MOV     URETCODE,AX      ;SET CODE FOR DIRECT EXIT
        JMP     FAR PTR EXIT
;
DC_NEXT:
        CMP     PS_ID,'#'       ;WSCTRL?
        JNE     DC_NOTMGR
        JMP     DC_EXIT         ;IF WSCTRL, DON'T DO A PHYSICAL DISCONN
DC_NOTMGR:
        CMP     PCI_CONN,'P'    ;IS THIS A PHYSICAL DISCONNECT ?
        JE      DC_PHYS         ;YES, JUMP BACK TO PC SESSION
        JMP     DC_EXIT
DC_PHYS:
          AL,03             ;JUMP KEY     <<< CHANGE SCREEN >>>
        MOV     AH,00
        CALL    FAR PTR TYPIST
        CMP     AL,0              ;GOOD I/O ?
        JE      DCP_OK
        MOV     AX,09             ;ELSE INTERNAL ERROR
        MOV     URETCODE,AX
        JMP     FAR PTR EXIT      ;DO A DIRECT EXIT
DCP_OK:
        CALL    FAR PTR CHKSTAT
        CMP     CK_PSID,0FFH      ;PC SESSION ID?
        JE      DCP_DISC          ;NOW NEED TO DISCONN SESS_MGR
        MOV     AL,PS_PCID        ;NAME OF PC SESSION
        CMP     AL,CK_PSID        ;IS IT THE RIGHT SESSION ?
        JE      DCP_DISC
        INC     CX                ;INC COUNT
        CMP     CX,8              ;ONLY JUMP 8 TIMES
        JL      DCP_LOOP
        CALL    FAR PTR UNLOCK    ;SESS MGR
        CALL    FAR PTR API_DISC  ;DISCONNECT FROM WSCTRL
        MOV     AX,0FFFFH         ;AX SET TO LOOP EXIT ERR(FOR SYS_ERR2)
        JMP     DC_ERR1           ;GO ABEND
DCP_DISC:
        CALL    FAR PTR UNLOCK    ;SESS MGR
        CALL    FAR PTR API_DISC  ;NORMAL DISC AFTER JUMPING BACK TO PC SESS
        CMP     AL,0              ;GOOD DISCONNECT
        JE      DC_EXIT           ;OK-GO GIVE GOOD EXIT
        JMP     DC_ERR1           ;ELSE ABEND W/ INTERNAL ERROR
DC_EXIT:                          ;NOTE: DISC ERRS DO A DIRECT EXIT
        MOV     AX,0              ;GOOD RC
DC_EXIT2:
        MOV     PS_ID,0FFH        ;SHOW PC AS ACTIVE SESSION
        MOV     PS_PSCBOFF,0      ;NO CURR PSCB
        MOV     PS_RESERV,0       ;NOTHING RESERVED
        MOV     URETCODE,AX
        JMP     FAR PTR EXIT
DISCON  ENDP
;
;==========================================================================
;   SET_PARM - SETS THE PCI SESSION PARMS
;
;
SET_PARM  PROC  FAR
        CMP     PCI_TRACE,'Y'   ;TRACE ON
        JNE     SP_NOTRACE
        MSG     'PCI-090 IN SET_PARM'
SP_NOTRACE:
;
;  MOVE HIS PARM STRING INTO MY BUFFER. XLAT TO UPPER CASE (EXCEPT AFTER =)
;
        XOR     DI,DI
        XOR     AX,AX
SP_CLRBUF:                      ;ZERO OUT THE INTERNAL BUFFER
        MOV     BYTE PTR VBUFFER[DI],AL
        INC     DI
        CMP     DI,2000
        JL      SP_CLRBUF
;
        CMP     UDLEN,4         ;MIN LENGTH
        JL      SP_ERR0         ;TOO SMALL
        CMP     UDLEN,1000      ;MAX LEN
        JG      SP_ERR0         ;TOO BIG
        JMP     SP_OK1
SP_ERR0:
        MOV     AX,02           ;PARM ERROR
        MOV     URETCODE,AX
        JMP     FAR PTR EXIT    ;GO QUIT
SP_OK1:
        MOV     AX,UDSEG        ;GET HIS SEGREG
        MOV     ES,AX           ;ES: = HIS SEGREG
        MOV     SI,UDOFFS       ;ES:SI POINTS TO HIS STRING
        XOR     CX,CX           ;COUNT=0
        XOR     DI,DI           ;OFFSET IN VBUFFER=0
SP_GETLP:
        MOV     AL,ES:0[SI]     ;GET A BYTE
        CMP     AL,'a'          ;LITTLE a (61H)
        JL      SP_NOTR         ;IF LESS DON'T XLATE IT
        CMP     AL,'z'          ;LITTLE Z (7AH)
        JG      SP_NOTR
        AND     AL,0DFH         ;ELSE CONVERT A-Z TO CAPS
SP_NOTR:
        MOV     BYTE PTR VBUFFER[DI],AL ;MOVE THE BYTE
        CMP     AL,'='          ;DOES IT HAVE A FOLLOWING PARM?
        JNE     SP_NOTSPCL      ;IF AFTER A =, DON'T XLAT TO UPPER CASE
        INC     SI              ;OR USE AS THE EOT CHECK CHARACTER
        INC     DI
        INC     CX
        MOV     AL,ES:0[SI]     ;GET THE BYTE AFTER THE =
        MOV     BYTE PTR VBUFFER[DI],AL ;MOVE IT
SP_NOTSPCL:
        INC     DI              ;BUMP THE COUNTERS
        INC     SI
        INC     CX
        CMP     CX,UDLEN        ;HAVE WE DONE IT ALL
        JNL     SP_CKPARMS      ;WE ARE DONE
        JMP     SP_GETLP        ;ELSE GO DO MORE
;
SP_CKPARMS:
;
;  NOW NEED TO RUN THE PARM KEYWORD TABLE SETTING THE SESSION PARM STRING
;
        MOV     SC_START,0      ;SCAN FROM TOP OF BUFFER
        MOV     SC_END,CX       ;FOR LENGTH IN CX
        PUSH    DS              ;INSURE ES=MY DS
        POP     ES
        LEA     SI,SP_TABLE     ;POI   MOV     AL,API_WSCNAM     ;SESSION MGR SHORT NAME
        MOV     PS_ID,AL          ;NEED TO CONNECT TO JUMP BACK TO PC
        MOV     AX,API_WSCID      ;GET WSCTRL HANDLE
        MOV     PS_SESSID,AX
        CALL    FAR PTR API_CONN  ;CALL COMMON ITS/API ROUTINE
        CMP     AL,0              ;GOOD OPEN?
        JNE     DC_ERR1           ;CAN'T DISCONNECT ERROR
        MOV     CX,0              ;LOOP COUNT FOR JUMPS
        CALL    FAR PTR LOCK      ;LOCK THE SESS MGR
DCP_LOOP:
        MOVNT TO START OF PARM KEYWORD TABLE
SP_LOOP:
        XOR     CX,CX           ;CX=0
        MOV     CL,0[SI]        ;GET LENGTH VALUE
        CMP     CL,0FFH         ;END OF TABLE ?
        JNE     SP_CONT
        JMP     SP_EXIT
SP_CONT:
        MOV     AL,1[SI]        ;GET THE SYMBOL TO SET IF MATCHED
        MOV     SP_SYM,AL       ;SAVE IT
        XOR     AX,AX
        MOV     AL,2[SI]        ;GET OFFSET IN PARM STRING TO SET SYMBOL AT
        MOV     SP_OFFS,AX      ;SAVE IT
        MOV     SP_LEN,CX       ;SAVE LENGTH
        ADD     SI,3            ;POINT TO REAL KEYWORD STRING
        MOV     SP_TABOFFS,SI   ;SAVE OUR OFFSET
        CALL    FAR PTR SCANIT  ;SCAN FOR STRING ES:SI FOR LENGTH CX:
        CMP     AX,0            ;0 = NOT FOUND
        JE      SP_NOHIT
        CMP     SP_SYM,'='      ;MOVE IN KEYWORD SYM OR ACTUAL DATA(EOT=X)
        JE      SP_MOVCODE      ;= SIGN SAYS MOVE THE ACTUAL DATA
        MOV     AL,SP_SYM       ;ELSE MOV THE SYMBOL
        MOV     DI,SP_OFFS      ;DISPLACEMENT TO PUT IT AT
        MOV     BYTE PTR PCI_PARMS[DI],AL       ;SET THE SYMBOL
        JMP     SP_NOHIT
SP_MOVCODE:
        DEC     AX              ;SCANIT RETURNS 1'S ORIGIN (ADJUST TO 0 ORIGIN)
        ADD     AX,SP_LEN       ;POINT PAST KEYWORD IN BUFFER
        MOV     SI,AX           ;(AX HAS SEARCH LOC FROM SCANIT)
        MOV     AL,BYTE PTR VBUFFER[SI]        ;GET THE VALUE
        MOV     DI,SP_OFFS      ;RESTORE STRING DISPL
        MOV     BYTE PTR PCI_PARMS[DI],AL       ;SET THE VALUE
SP_NOHIT:
        MOV     SI,SP_TABOFFS   ;OFFSET TO KEYWRD STRING
        ADD     SI,SP_LEN       ;PLUS STR LENGTH
        JMP     SP_LOOP         ;NOW POINTS TO NEXT KEYWORD TO LOOK FOR
SP_EXIT:
        MOV     AX,0            ;0 RETCODE
        MOV     URETCODE,AX
        JMP     FAR PTR EXIT
SET_PARM  ENDP
;
;===========================================================================
; Q_SESS: RETURNS A LIST OF SESSIONS AND THEIR CHARACTERISTICS
;
;
Q_SESS  PROC    FAR
        CMP     PCI_TRACE,'Y'
        JNE     QS_NOTR
        MSG     'PCI-100 IN QSESS'
QS_NOTR:
        MOV     AX,UDSEG        ;HIS SEG IN ES:
        MOV     ES,AX
        MOV     DI,UDOFFS       ;ES:DI POINTS TO OUTPUT AREA
        LEA     SI,PS1          ;ADDR OF MY PSCBS
        MOV     BX,0            ;MAX SESS = 4 DFT+ 2 NOTEP
QS_LOOP:
        MOV     AL,[SI].PSCB_NAM        ;SHORT NAME
        MOV     BYTE PTR ES:0[DI],AL
        PUSH    SI
        PUSH    DI
        LEA     SI,[SI].PSCB_LNAME      ;SOURCE IN DS:
        LEA     DI,1[DI]                ;TARGET IN ES:
        CLD
        MOV     CX,8
    REP MOVSB
        POP     DI
        POP     SI
        MOV     AL,[SI].PSCB_TYP        ;2=NOTEP, 3 = HOST
        MOV     BYTE PTR ES:9[DI],' '   ;DEF TO BLANK
        CMP     AL,3                    ;HOST ?
        JNE     QS_NOTEP
        MOV     BYTE PTR ES:9[DI],'H'   ;ELSE SET HOST
        JMP     QS_SET
QS_NOTEP:
        CMP     AL,2                    ;NOTEPAD ?
        JNE     QS_SET                  ;ELSE DEFAULT OUT TO BL
        MOV     BYTE PTR ES:9[DI],'N'
QS_SET:
        MOV     AX,[SI].PSCB_SIZE
        MOV     ES:10[DI],AX
;
        ADD     DI,12                   ;EACH ENTRY IS 12 BYTES
        ADD     SI,PSCB_CBSIZE
        INC     BX
        CMP     BX,07                   ;6 = MAX SESS
        JGE     QS_DONE
        JMP     QS_LOOP
QS_DONE:
        MOV     AX,PSCB_COUNT           ;# OF ENTRIES IN RC
        MOV     URETCODE,AX
        JMP     FAR PTR EXIT
Q_SESS  ENDP
;
;
;==========================================================================
;   RESERVE  AND RELEASE
;
;
RESERVE PROC FAR
        CMP     PCI_TRACE,'Y'
        JNE     RV_NOTR
        MSG     'PCI-110 IN RESERVE'
RV_NOTR:
        MOV     SI,PS_PSCBOFF   ;PSCB OFFSET OF CONNECTED ENTRY
        CMP     SI,0            ;GOOD CONNECT
        JNE     RV_OK1
        JMP     RV_PARMERR
RV_OK1:                                 ;RESERVE PROCESSING
        MOV     [SI].PSCB_RESERV,'R'    ;SET RESERVE FLAG ON
        MOV     PS_RESERV,'R'           ;SHOW CURR SESSID LOCKED
        CALL    FAR PTR CHKSTAT         ;SPECIAL PRE-LOCK INHIBITED CK
        CMP     CK_NOHOST,0             ;ARE WE CONNECTED
        JE      RV_LOCKIT
        JMP     RV_PARMERR
RV_LOCKIT:
        CALL    FAR PTR LOCK            ;GO LOCK THE RESERVED SESSION
        CMP     AX,0                    ;GOOD LOCK ?
        JE      RV_OK2
        CMP     AX,10H                  ;IPT INHIBITED
=====================================
;
RELEASE PROC    FAR
        CMP     PCI_TRACE,'Y'
        JNE     RL_NOTR
        MSG     'PCI-120 IN RELEASE'
RL_NOTR:
        CMP     PS_PSCBOFF,0    ;HAVE A CURR PSCB ?
        JNE     RL_OK1
        MOV     AX,01           ;NO VALID SESS
        JMP     RL_EXIT
RL_OK1:
        MOV     SI,PS_PSCBOFF   ;POINT TO CURR PSCB
        MOV     [SI].PSCB_RESERV,0      ;RELEASE THE PSCB
        MOV     PS_RESERV,0             ;RELEASE LOGICALLY
        CALL    FAR PTR UNLOCK
        CMP     AX,0
        JE      RL_OK2
        MOV     SYS_ERR1,1101H          ;INTERNAL ERROR
        MOV     SYS_ERR2,AX
        MOV     AX,09
        JMP     RL_EXIT
RL_OK2:
        MOV     AX,0
        JMP     RL_EXIT
RL_EXIT:
        MOV     URETCODE,AX
        JMP     FAR PTR EXIT
RELEASE ENDP
;
;==========================================================================
;  PRTSTATUS: PRINTS STATUS CODE IN AX: IN MSG PCI-009
;
PRTSTATUS PROC  FAR
        CVHEX   DISPRC          ;SHOW DISPLAY RET CODE
        CMP     SYS_ERR1,0      ;WAS THERE AN EXTENDED ERR CODE ?
        JNE     PRT_ERR
        JMP     PRT_NOERR
PRT_ERR:
        MOV     AX,SYS_ERR1     ;GET EXT ERRCODE
        CVHEX   DISPRC2         ;CNVT TO DISPLAY
        MOV     AX,SYS_ERR2
        CVHEX   DISPRC3
PRT_NOERR:
        PRINTDATA TRACEMSG,39
        MOV     WORD PTR DISPRC2,2020H  ;BLANK OUT THE EXT ERR CODE
        MOV     WORD PTR DISPRC2+2,2020H
        MOV     WORD PTR DISPRC3,2020H
        MOV     WORD PTR DISPRC3+2,2020H
        RET
PRTSTATUS ENDP
;
PRT_APITR PROC  FAR             ;PRINT API/ITS CALL TRACE
        CVHEX   ITSRC
        PRINTDATA ITSMSG,29
        RET
PRT_APITR ENDP
;===========================================================================
;  APIREQST - COMMON CALL TO API 1.2 FOR SYSTEM EXTENSION SERVICES
;           - IF IN ERR AN MODE ONLY RC 0,4,10,12 + 09 (HEX) ARE RETURNED
;
APIREQST  PROC  FAR
        PUSHALL                 ;SAVE ALL REGS
        MOV     DX,API_AMTHDID  ;GET CURRENT ACC MTHD ID (KEYBOARD ?)
        XOR     CX,CX           ;CX MUST = 0
        MOV     AH,09           ;MAKE_REQST PRIMITIVE
        MOV     AL,API_FUNC     ;GET HIS SYS EXTENSION REQ (FUNCTION CODE)
        MOV     BH,API_REPLY    ;REPLY TYPE (USUALLY 80H)
        MOV     BL,API_WAIT     ;WAIT STATUS (USUALLY 20H)
        PUSH    DS              ;SET ES=DS (PROBABLY ALREADY IS)
        POP     ES              ;BUT JUST BE SAFE....
        LEA     DI,API_PARM     ;ES:SI POINTS TO COMMON PARM LIST
        INT     7AH             ;CALL API
;
        MOV     API_LASTCX,CX   ;SAVE RET REG FOR USER
        MOV     API_LASTAX,AX   ;WRTKEY NEEDS REQ ID
        CMP     API_ERR,0FFH    ;FF= DON'T DO ERROR ANALYSIS/PRINT HERE
        JNE     APIR_NXT
        JMP     APIR_PASSIT     ;ELSE JUST GO EXIT TO CALLER
APIR_NXT:
        MOV     AL,API_RC       ;PARMCB ERR CODE IN AL (+ ERR CODE IS IN CL)
        CMP     PCI_ITSTRACE,'Y'        ;TRACE ITS CALLS ?
        JNE     APIR_NOTR
        MOV     AH,API_FUNC     ;PRINT FUNC+ERR CODE
        CALL    FAR PTR PRT_APITR
APIR_NOTR:
        MOV     AH,0            ;ZERO OUT FUNCODE IN AH
        CMP     CL,0            ;ANY ERR CODE IN CL IS AN INTERNAL ERROR
        JNE     APIR_INTERNAL
        CMP     AL,0            ;NO ERROR ?
        JE      APIR_PASSIT     ;IF SO RETURN
        CMP     AL,04           ;NOT CONNECTED ?
        JE      APIR_PASSIT     ;IF SO PASS THAT BACK
        CMP     AL,10H          ;INPUT INHIBITED ? OR NO SESSION MATCH?
        JE      APIR_PASSIT
        CMP     AL,12H          ;AID GENERATED OR AUTOKEY IN PROG
        JE      APIR_PASSIT
        CMP     AL,14H          ;AUTOKEY PLAYBK ? ++
        JNE     APIR_INTERNAL   ;NO, INTERNAL ERR ++
        MOV     AL,10H          ;CNVT PLAYBK TO INHIBITED ++
        JMP     APIR_PASSIT     ;                 ++
APIR_INTERNAL:
        MOV     SYS_ERR2,AX     ;SAVE ORIG STATUS
        MOV     AL,09           ;INTERNAL ERROR
A        JE      RV_ERR1
        MOV     SYS_ERR1,1001H          ;INTERNAL ERROR
        MOV     SYS_ERR2,AX
        MOV     AX,09
        JMP     RV_EXIT
RV_OK2:
        MOV     AX,0
        JMP     RV_EXIT
RV_PARMERR:
        MOV     AX,1                    ;NOT CONN
        JMP     RV_EXIT
RV_ERR1:
        MOV     AX,05                   ;LOCKED / INHIBITED
        JMP     RV_EXIT
RV_EXIT:
        MOV     URETCODE,AX
        JMP     FAR PTR EXIT
RESERVE ENDP
;
;=========================PIR_PASSIT:
        MOV     API_WAIT,20H    ;RESET ALL DEFAULTS
        MOV     API_REPLY,80H
        MOV     API_ERR,0
        MOV     API_LASTRC,AX   ;SAVE ERRCODE (OR AX RC)
        POPALL
        MOV     AX,API_LASTRC   ;RESET RC
        RET
APIREQST ENDP
;
;
APICLR  PROC    FAR
        PUSH    AX              ;SAVE AX
        PUSH    CX              ;SAVE CX
        PUSH    DI              ;SAVE DI
        PUSH    ES              ;SAVE ES
        PUSH    DS
        POP     ES              ;ES=DS
        CLD                     ;INCREMENT DF
        XOR     AX,AX           ;AX = 0
        MOV     CX,7            ;CLEAR 7 WORDS
        LEA     DI,API_PARM     ;POINT TO PARM LIST TOP
    REP STOSW                   ;CLEAR PARM LIST
        POP     ES
        POP     DI
        POP     CX
        POP     AX
        RET
APICLR  ENDP
;
;
LOCK    PROC    FAR
        CALL    FAR PTR APICLR
        MOV     AX,PS_SESSID    ;CURRENT SESSION ID
        MOV     API_SESS,AX     ;SET IN PARMLIST
        MOV     API_FUNC,05     ;LOCK
        CALL    FAR PTR APIREQST
        CMP     AL,12H          ;AUTOKEY ? ++
        JE      LOCK_AUTO
        RET
LOCK_AUTO:                      ;CONSIDER AUTOKEY 10H (INHIBITED) ++
        MOV     AL,10H
        RET
LOCK    ENDP
;
UNLOCK  PROC    FAR
        CMP     PS_RESERV,'R'   ;IS SESS RESERVED
        JNE     UL_OK
        MOV     AX,0            ;ELSE LEAVE LOCKED
        RET
UL_OK:
        CALL    FAR PTR APICLR
        MOV     AX,PS_SESSID    ;CURRENT SESSION ID
        MOV     API_SESS,AX     ;SET IT IN PARMLIST
        MOV     API_FUNC,06     ;UNLOCK
        CALL    FAR PTR APIREQST
        RET
UNLOCK  ENDP
;
;
API_CONN PROC   FAR
        CALL    FAR PTR APICLR
        MOV     AX,PS_SESSID    ;CURR SESS HANDLE
        MOV     API_SESS,AX     ;INTO PARMLIST
        MOV     API_FUNC,01     ;CONNECT KEY
        CALL    FAR PTR APIREQST
        RET
API_CONN ENDP
;
;
API_DISC PROC   FAR
        CALL    FAR PTR APICLR
        MOV     AX,PS_SESSID    ;CURR SESS HANDLE
        MOV     API_SESS,AX     ;INTO PARMLIST
        MOV     API_FUNC,02     ;DISCONNECT KEY
        CALL    FAR PTR APIREQST
        RET
API_DISC ENDP
;
;
CK_OVERLAY PROC FAR
;
; COMPUTES A CHECKDIGIT OVER THE PROGRAM CODE (TO DETECT OVERLAYS)
;
        LEA     SI,CODESTART    ;START OF CODE
        XOR     AX,AX           ;AX=0
        LEA     BX,PPCBID       ;USE START OF BLIM AS END OF MAIN PROG
CO_LOOP:
        ADD     AL,BYTE PTR 0[SI]
        INC     SI
        CMP     SI,BX           ;ENDING ADDR ?
        JNE     CO_LOOP
        RET                     ;PASS BACK AX:
CK_OVERLAY ENDP
;
;=========================================================================;
;  INBLIM - Interpretive BASIC Language Interface module.                 ;
;           V 1.0  04/14/84                                               ;
;=========================================================================;
;
;===================================================================
; Language Interface Module (LIM) PARAMETER CONTROL BLOCK (LIMPCB)
;
PPCBID          DB      'PCB'           ;PSB HDR
PFUNCODE        DB      0               ;USERS FUNCTION REQ CODE
PDSEG           DW      0               ;USERS DATA SEG
PDOFFS          DW      0               ;OFFSET TO USERS DATA
PDLEN           DW      0               ;DATA LENGTH
PSESSID         DB      0               ;BYTE NAME OF REQUESTED SESSION
PRETCODE        DW      0               ;RETURN CODE (1 BYTE EXCEPT FOR SRCH)
URETCODEADR     DW      0               ;NOT IN PCB, NEED ADDR TO PASS BACK TO
USTRDWLEN       DB      0               ;USERS STRING DESCRIPTOR WORD LENGTH
IB_GATESW       DB      0               ;CALL GATE FOR DEBUG (0=IN BASIC FF=PCI)
;====================================================================
;=========================================================================
;       MAIN PCI INTERPRETIVE BASIC BRANCH ENTRY POINT
;               - INT BASIC CAN FIND HIS BR ENTRY ADDR IN LOW CORE @ INT 46
;               - ENTRY & CALL ANALYSIS
;               - CONTROL BLOCK VALIDATION & BUILD
;               - INT44 TO CALL MAIN PCI ROUTINE
;               - CALL WITH DS:SI POINTING TO THE USER PCB
;
INT46   PROC    FAR             ;PSEUDO INT: IS FAR CALLED BUT ADDR IS @ INT46
BASICEPA:
        PUSH    BP              ;SAVE BP
        MOV     BP,SP           ;SET BASE PARM LIST
        MOV     AX,CSEG         ;OK TO DESTROY AX, GET MY SEGREG SET
    USES RETCODE TO PASS IN OFFSET PARM
;
        MOV     AX,ES:0 [SI]    ;GET RETCODE VALU (IN CASE ITS THE OFFSET)
        MOV     PRETCODE,AX     ;PUT INTO PCB            RETCODE IN PCB
        MOV     SI,[BP]+8       ;GET LENGTH ADDR
        MOV     AX,ES:0 [SI]    ;GET LENGTH VALU
        MOV     PDLEN,AX        ;SAVE IN PCB              LEN IN PCB
        MOV     SI,[BP]+10      ;GET PTR TO STRING DESCRIPTOR WORD
        MOV     AL,ES:0 [SI]    ;GET INTERP BASICS LENGTH VALU
        MOV     USTRDWLEN,AL    ;SAVE FOR FUTURE USE (LENGTH ERR CK)
        MOV     AX,ES:0 [SI]+1  ;GET POINTER TO ACTUAL STRING
        MOV     PDOFFS,AX       ;SAVE STRING ADDRESS      STR PTR IN PCB
        MOV     PSESSID,0FFH    ;NO OP THIS FOR NOW.....
;
; CHECK PARM VALIDITY
;
        CMP     PFUNCODE,0      ;IS IT A GATE FUN
        JE      IB_GATE
        CMP     PFUNCODE,05
        JE      IB_PARMERR      ;COPY PS IS INVALID
        CMP     PFUNCODE,08     ;COPY STRING
        JE      IB_CHKLEN
        CMP     PFUNCODE,10     ;QSESS
        JE      IB_CHKLEN2
;
;  READY FOR THE INTERRUPT ...... (NOTE THAT CURRENT STACK IS 6 WORDS)
;
IB_DOIT:
        MOV     IB_GATESW,0FFH  ;SHOW WE ARE GOING TO PCI (FOR DEBUG)
        LEA     SI,PPCBID       ;CALL WITH DS:SI POINTING TO PCB
        INT     44H             ;CALL PCIRES
;
        MOV     AX,CSEG         ;RESET MY SEGREGS
        MOV     DS,AX           ;MY DS = CS
        MOV     IB_GATESW,00    ;BACK TO BASICS (DIAG GATE SHOWS WHERE WE ARE)
IB_RET:
        MOV     AX,PDSEG        ;GET BASICS SEGREGS
        MOV     ES,AX
        MOV     DI,URETCODEADR  ;GET HIS RETCODE ADDR
        MOV     BX,PRETCODE     ;GET THE RETURN WORD
        MOV     WORD PTR ES:0 [DI],BX  ;MOVE THE RETCODE WORD TO BASIC
        MOV     DS,AX           ;RESET BASIC DS
;
        POP     BP
        RET     8               ;RETURN TO BASIC
IB_GATE:
        MOV     PRETCODE,0      ;WE DON'T USE GATE SW
        JMP     IB_RET
IB_PARMERR:
        MOV     PRETCODE,02     ;PARM ERR
        JMP     IB_RET
IB_CHKLEN:
        MOV     AL,USTRDWLEN    ;COMES HERE ON COPY STR
        MOV     AH,0
        CMP     AX,PDLEN
        JL      IB_PARMERR
        JMP     IB_DOIT
IB_CHKLEN2:
        CMP     PDLEN,72        ;6 ENTRIES * 12 BYTES
        JL      IB_PARMERR
        JMP     IB_DOIT
INT46   ENDP
;=========================================================================
VBUFFER DB      3600 DUP (' ')  ;INTERNAL BUFFER
LAST    DB      'LAST'          ;USES THIS AREA FOR DOS RESIDENCY
LASTCK  DB      44H             ;TERMINAL OVERLAY CKDIGIT
;
;=============================================================================
;  INITIALIZATION :  terminate w/ residency behind DOS.
;
INIT    PROC    FAR
REAL_START:
;
; SETUP STD. DOS LINKAGE
;
        PUSH    DS              ;RET SEG ON STACK
        SUB     AX,AX           ;SET RET CODE = 0
        PUSH    AX              ;RC ON STACK
        MOV     AX,CSEG         ;SET DS = CODE SEG
        MOV     DS,AX           ;DS: = CS:
;
; DO COPYRIGHT MSGS
;
        MOV     AH,09                   ;DOS PRT STRING
        LEA     DX,BYTE PTR HDR_MSG     ;POINT TO COPYRIGHT MSG
        INT     21H                     ;CALL PC DOS
;
; ESTABLISH INT 44 = COMMON ENTRY
;           INT 45 = KEYBOARD INTERCEPT HOOK
;
        MOV     AH,35H          ;READ INT VECTOR
        MOV     AL,MYINTNUM
        INT     21H             ;CALL DOS INT ADDR BACK IN ES:BX
        LEA     DX,I44          ;GET INT44 OFFSET
        CMP     DX,BX           ;ARE WE ALREADY LOADED ?
        JNE     SET_INTS
        JMP     ALRDY_SET       ;ELSE DON'T RELOAD
SET_INTS:
;
        CALL    FAR PTR CK_OVERLAY      ;COMPUTE PGM CKSUM
        MOV     PROG_CKSUM,AX           ;SAVE IT FOR LATER
;
;   GO SETUP THE ENVIRONMENT....
;
        JMP     FAR PTR SET_ENVIRON
INIT_OK:
;
;  ENSURE THE COMPLETION Q  IS EMPTY
;
CLR_Q:
        MOV     AH,83H          ;NEED TO CLEAR THE COMPL Q
        MOV     AL,0            ;IN CAS     MOV     DS,AX           ;SET MY SEGREG, HIS ES: STILL = OLD DS:
        MOV     AX,ES           ;GET HIS DSEG PTR
        MOV     PDSEG,AX        ;SAVE SEGREG POINTER      DSEG IN PCB
        MOV     SI,[BP]+12      ;GET FUNCTION CODE ADDRESS
        MOV     AX,ES:0 [SI]    ;GET FUNCTION CODE
        MOV     PFUNCODE,AL     ;SAVE FUNCTION BYTE       FUN CODE IN PCB
        MOV     SI,[BP]+6       ;GET RETCODE ADDRESS
        MOV     URETCODEADR,SI  ;SAVE RET CODE ADDR
;
;  SPECIAL CASE: GETSTRE ANYTHING IS THERE
        MOV     BX,0
        MOV     CX,0
        MOV     DX,0
        MOV     DI,0
        PUSH    ES
        MOV     ES,DX           ;ES=0
        INT     7AH             ;GET COMPLETION_Q CALL TO API
        POP     ES
        CMP     CL,09           ;EMPTY REQUEST Q ?
        JE      Q_CLEAR
        CMP     CL,0            ;VALID ENTRY ???
        JE      CLR_Q           ;IF SO CLEAR UNTIL EMPTY
        MSG     'PCI-901 Internal Error CQ'
        JMP     NOTSET          ;JUST QUIT
Q_CLEAR:
;
        MOV     AH,25H          ;DOS FUNCT = SET INT VECTOR
        MOV     AL,MYINTNUM     ;SET INT 44
        LEA     DX,I44          ;MY INT EPA
        INT     21H             ;CALL DOS....
        JC      NOTSET          ;CF = ERROR
        MOV     AH,25H
        MOV     AL,MYINTNUM
        ADD     AL,1            ;MY INTNUM+1 IS USED BY IBASIC (45)
        LEA     DX,BASICEPA     ;IBAS EPA
        INT     21H             ;CALL DOS
        JC      NOTSET
        JMP     INTSET
NOTSET:
        MSG     'PCI-903 Unable to install PCIRES'
        RET                     ;RET TO DOS (STACK ALREADY SETUP).
ALRDY_SET:
        MSG     'PCI-907 PCIRES is already resident'
        RET
INTSET:
;
        MSG     'PCI-001 PCIRES is now resident'
        LEA     DX,LAST+6       ;GET MY MEMORY SIZE
        ADD     DX,100H         ;ADD IN A SAFETY FACTOR
        INT     27H             ;RETURN W/ RESIDENCY
INIT    ENDP
;

;
;============================================================================
;  SET_ENVIRON - DETERMINES THE PC3270 LOGICAL ENVIRONMENT AND
;                SETS UP ADDRESS POINTERS FOR THAT ENVIRON.
;     DETERMINES: - CUT MODE vs TCAS (TCA-SNA) vs TCAN (TCA NON-SNA).
;                 - PC.CP RELEASE LEVEL AND BR ENTRY POINTS.
;                 - SESSION (PRESENTATION SPACE) NAMES AND ADDRESS POINTERS
;
SET_ENVIRON     PROC FAR
        XOR     AX,AX           ;AX = 0
        MOV     ES,AX           ;ES = 0 SEG
        MOV     AX,ES:014AH     ;GET HIS SEGREG FROM THE INT VECTOR
        MOV     BX,ES:0148H     ;GET HIS OFFSET
        MOV     EPSEG,AX        ;SAVE AS AN ADCON FOR HIS SEG
        CMP     AX,0            ;IS HE INSTALLED ?
        JNE     SE_CPOK         ;GOT SOME VALU SO HE IS THERE (I HOPE...)
SE_ERR1:
        MOV     CX,8            ;PRINT THE ERR MSG 8 TIMES
SE_PRT1:
        MSG     'PCI-902 Improper System Configuration'
        LOOP    SE_PRT1
        JMP     NOTSET          ;EXIT TO DOS
;
SE_SPIN1: JMP   SE_SPIN1        ;JUST HANG HERE WITH A FATAL ERROR.
;
SE_CPOK:
        MOV     ES,AX           ;SET ES: TO HIS SEG
        MOV     AL,BYTE PTR ES:10H      ;GET PART OF HIS COPYRIGHT
        CMP     AL,35H          ;IS IT A 5?
        JNE     SE_ERR1         ;BAD CONFIG (NOT CTRL PGM)
        MOV     SI,WORD PTR ES:32H       ;GET CONFIG PTR
        ADD     SI,20H          ;POINT TO NAME
        MOV     CP_PSCBOFF,SI   ;SET PTR
        MOV     CP_TYPE,2       ;DEFAULT CP TYPE TO CUT (DFT=1)
;
;  NEED TO DO NAME RESOLUTION TO GET ACCESS METHOD IDS
;
        MOV     AH,81H          ;NAME RESO
        MOV     AL,0
        XOR     BX,BX           ;MUST BE 0
        XOR     CX,CX           ;"  "
        XOR     DX,DX           ;"  "
        PUSH    DS              ;SET ES=DS
        POP     ES
        LEA     DI,API_SMGR_INIT  ;POINT ES:DI TO 'SESSMGR '
        INT     7AH               ;CALL API
        CMP     CL,0              ;GOOD RC?
        JNE     SE_ERR2
        MOV     API_SMGR_NAM,DX   ;SET THE NAME CODE
        XOR     CX,CX             ;GET READY TO GO AGAIN
        XOR     DX,DX             ;AX,BX,ES AND DI ARE PRESERVED
        LEA     DI,API_KYBD_INIT  ;DO KEYBOARD NEXT
        INT     7AH               ;CALL API
        CMP     CL,0              ;ANY ERRORS ?
        JNE     SE_ERR2
        MOV     API_KYBD_NAM,DX   ;SET THE NAME CODE
                                  ;<< INSERT MFIC NAME RESO HERE IF NEEDED
        JMP     SE_QUERY
SE_ERR2:
        MSG     'PCI-901 Internal error NR'     ;ERR IN NAME RESOL
        MOV     SYS_ERR2,CX     ;SAVE RC
        JMP     NOTSET          ;GO QUIT
;
;  HAVE NAME RESOLUTION, NOW QUERY THE SESSION IDS
;
SE_QUERY:
        LEA     AX,PS1                  ;ADDR OF 1ST PSCB FOR SE_BLDPSCB
        MOV     PSCB_NEXT,AX
;
        PUSH    DS                      ;CLEAR VBUFFER FOR QPARM OUTPUT
        POP     ES                      ;ES=DS
        CLD
        XOR     AX,AX                   ;AX=0
        MOV     CX,40         AR PTR APICLR          ;CLEAR PARM LIST
        MOV     AL,SE_TYPE              ;GET SESS TYPE
        MOV     BYTE PTR API_SESS+1,AL  ;PUT IN PARM LIST
        MOV     BYTE PTR API_SESS,00H   ;SHOULD ALREADY=0
        LEA     AX,VBUFFER              ;OFFSET TO NAME ARRAY (USE VBUFFER)
        MOV     API_FLD1,AX
        MOV     AX,DS                   ;GET SEG ADDR
        MOV     WORD PTR API_FLD1+2,AX  ;SET SEG ADDR OF NAME ARRAY
        CALL    FAR PTR APIREQST        ;GO QUERY IDS
        CMP     AX,10H                  ;SESSION TYPE NOT FOUND?
        JNE     SE_CK0                  ;ELSE CK FOR OTHER ERRS
        JMP     SE_DO_NEXT              ;IF NONE, TRY NEXT TYPE
SE_CK0:
        CMP     AX,0
        JNE     SE_ERR3
        CMP     SE_TYPE,01              ;IS IT WSCTRL ?
        JE      SE_WSCTRL
        JMP     SE_CRPSCB               ;ELSE WE NEED A PSCB ENTRY
SE_WSCTRL:
        MOV     AL,VBUFFER+2            ;GET SHORT NAME FOR WSCTRL
        MOV     API_WSCNAM,AL
        MOV     AX,WORD PTR VBUFFER+4   ;GET SESSION ID
        MOV     API_WSCID,AX            ;SAVE SESSION ID FOR WSCTRL
        JMP     SE_DO_NEXT
SE_CRPSCB:
        JMP     SE_BLDPSCB              ;GO CREATE A PSCB ENTRY
SE_DO_NEXT:
        INC     SE_TYPE                 ;TYPE + 1
        CMP     SE_TYPE,05              ;LAST TYPE (04) + 1 = EXIT
        JE      SE_QDONE
        JMP     SE_LOOP1                ;ELSE GO DO ANOTHER
SE_ERR3:
        MSG     'PCI-901 Internal Error UQP'    ;UNABLE TO Q-PARMS
        MOV     SE_ERR2,AX              ;SAVE ERR REG
        JMP     NOTSET                  ;GO CRASH
SE_QDONE:
;
;  NOW NEED TO RUN HIS PSCBs AND GET PC SESSID & OIA POINTERS
;
        MOV     SI,CP_PSCBOFF           ;HIS PSCB TABLE ADDR <<<<
        MOV     AX,EPSEG                ;HIS SEG ADDR
        MOV     ES,AX                   ;ES:SI = HIS PSCB TABLE
SE_LOOP2:
        MOV     AL,BYTE PTR ES:0 [SI]   ;GET SHORT NAME
        CMP     AL,10H                  ;BLANK ENTRY ?
        JE      SE_NEXT                 ;IF SO DO ANOTHER
        CMP     AL,2CH                  ;SESSION MGR ?
        JE      SE_NEXT
        CMP     AL,00                   ;END OF TABLE = 00
        JE      SE_ZERO
        JMP     SE_GOOD                 ;ELSE WE HAVE A GOOD ENTRY
SE_NEXT:
        ADD     SI,CP_PSCBSIZ           ;HIS PSCB = DEC 44 LONG <<<<
        JMP     SE_LOOP2
SE_ZERO:
        JMP     SE_EXIT                 ;WE ARE DONE
SE_GOOD:                                ;COMES HERE TO ANALYZE PSCB ENTRY
        LEA     BX,MFITOASC             ;NEED TO XLATE HIS MFI (IN AL) TO ASC
        XLAT                            ;AL NOW IN ASCII
        LEA     BX,PS1                  ;ADDR OF MY PSCB TABLE
        XOR     CX,CX                   ;CX = LOOP COUNT = 0
        CMP     BYTE PTR ES:14[SI],25   ;DOES SIZE = PC (DEC 25 LINES(19H)) ?
        JNE     SE_LOOP3                ;ELSE GO ON
        MOV     PS_PCID,AL              ;SAVE PC SESSION ID
        JMP     SE_NEXT               ALYZE PSCB ENTRY
        LEA     BX,MFITOASC             ;NEED TO XLATE HIS MFI (IN AL) TO ASC
        XLAT                            ;AL NOW IN ASCII
        LEA     BX,PS1                  ;ADDR OF MY PSCB TABLE
        XOR     CX,CX                   ;CX = LOOP COUNT = 0
        CMP     BYTE PTR ES:14[SI],25   ;DOES SIZE = PC (DEC 25 LINES(19H)) ?
        JNE     SE_LOOP3                ;ELSE GO ON
        MOV     PS_PCID,AL              ;SAVE PC SESSION ID
        JMP     SE_NEXT                 ;I HAVE NO PSCB ENTRY FOR PC
SE_LOOP3:
        CMP     AL,[BX].PSCB_NAM        ;COMPARE SHORT NAMES
        JE      SE_MATCHED              ;JMP IF EQ
        ADD     BX,PSCB_CBSIZE          ;POINT TO MY NEXT PSCB
        INC     CX
        CMP     CX,7                    ;OUT OF TABLE W/ NO MATCH
        JNE     SE_LOOP3                ;GO DO ANOTHER
        JMP     SE_ERR4
SE_MATCHED:                             ;BX IS INDEX OF MY PSCB
;
;  SETUP CURSOR POINTER
;
        MOV     AX,ES:20[SI]            ;POINTER TO OIACB
        ADD     AX,18                   ;OFFSET TO CURSOR CB POINTER
        PUSH    SI
        MOV     SI,AX
        MOV     AX,ES:0 [SI]            ;GET CURSOR CB ADDR
        MOV     SI,AX                   ;SI POINTS TO CURSOR CB
        ADD     AX,16                   ;OFFSET IN CB TO CURSOR ROW/COL DATA <<
        MOV     [BX].PSCB_CURSOR ,AX    ;SET CURSOR PTR
        MOV     AL,ES:15 [SI]           ;GET ROW WIDTH
        MOV     [BX].PSCB_ROWSIZE,AL
        POP     SI
;
        CMP     [BX].PSCB_TYP,02        ;NOTEPAD TYPE ?
        JNE     SE_3270
        MOV     AX,ES                   ;THIS SEG HAS NOTEP OIA
        MOV     [BX].PSCB_OIASEG,AX
        MOV     AX,ES:20[SI]            ;GET OIA OFFSET IN PSCB
        ADD     AX,014H                 ;PTR + HEX 14 HAS NOTEP OIA BITSTRING
        MOV     [BX].PSCB_OIAOFF,AX     ;NOTEP OIA BITS ARE IN OIA PTR CB
        JMP     SE_NEXT                 ;GO DO ANOTHER
SE_3270:                                ;COMES HERE TO SET 3270 DFT OIA PTR
        CMP     CP_TYPE,01              ;IS THIS A DFT SYSTEM ?
        JE      SE_DFTOIA
        JMP     SE_NEXT                 ;WE ALREADY KNOW WHERE A CUT OIA IS
SE_DFTOIA:
        MOV     AX,ES:20 [SI]           ;GET POINTER TO OIA POINTER CB
        ADD     AX,014H                 ;OFFSET TO OIA PTR IN PTR CB
        PUSH    SI
        MOV     SI,AX                   ;SI POINTS TO POINTER
        MOV     AX,ES:2 [SI]            ;GET OIA SEG
        MOV     [BX].PSCB_OIASEG,AX
        MOV     AX,ES:0[SI]             ;GET OIA OFFSET
        ADD     AX,CP_OIAOFFS           ;OFFSET TO OIA BITS  <<<<
        MOV     [BX].PSCB_OIAOFF,AX
        POP     SI
        JMP     SE_NEXT
SE_ERR4:
        MSG     'PCI-901 Internal error INT'
        JMP     NOTSET
;
SE_EXIT:
        MOV     AX,API_KYBD_NAM         ;LEAVE KEYBOARD AS DEFAULT ACC/MTHD
        MOV     API_AMTHDID,AX          ;SINCE WE WILL ONLY NEED KYBD
;
        JMP     INIT_OK                 ;RET TO INIT MAIN

;---------------------------------------------------------------------------
;  BLDPSCB - SCANS NAMELIST FROM QPARMS AND BUILDS PSCB DATA
SE_BLDPSCB  PROC NEAR
        MOV     BX,PSCB_NEXT            ;POINT TO NEXT PSCB ENTRY
        LEA     SI,VBUFFER+2            ;OFFSET OF 1ST NAME ENTRY
SEBP_LOOP:
        MOV     AL,0[SI]                ;GET NEXT SHORT NAME
        CMP     AL,0                    ;END OF TABLE ?
        JNE     SEBP_CONT
        JMP     SEBP_EXIT               ;0 SAYS WE ARE DONE...
SEBP_CONT:
        MOV     [BX].PSCB_NAM,AL        ;GET SHORTNAME
        MOV     AL,1[SI]                ;GET SESS TYPE
        CMP     AL,02                   ;IS IT A DFT SESSION
        JNE     SEBP_NOTDFT
        MOV     CP_TYPE,01              ;ELSE WE HAVE A DFT SESSION
SEBP_NOTDFT:
        MOV     [BX].PSCB_TYP,AL
;
        PUSH    BX                      ;SET UP TO MOVE LNAME
        PUSH    SI
        ADD     SI,4                    ;POINT TO LNAME
        XOR     CX,CX                   ;COUNTER
SEBP_NAMLP:
        MOV     AL,0[SI]
        MOV     BYTE PTR [BX].PSCB_LNAME,AL
        INC     BX
        INC     SI
        INC     CX                      ;       { REWRITE FOR CLEANUP
        CMP     CX,8
        JL      SEBP_NAMLP
        POP     SI
        POP     BX
;
        MOV     AX,2[SI]                ;GET SESS ID NUM
        MOV     [BX].PSCB_ID,AX
        CALL    FAR PTR APICLR          ;CLEAR PARM LIST FOR CALL
        MOV     API_SESS,AX             ;SESS ID FOR Q-PARMS
        MOV     API_FUNC,02             ;Q-PARM FUNC
        PUSH    BX                      ;SAVE BASE
        PUSH    SI                      ;SAVE SI (DESTROYED BY INT7A)
        CALL    FAR PTR APIREQST        ;GO DO Q-PARM FOR THIS SESSION
        POP     SI                      ;RESTORE REGS
        POP     BX
        CMP     AX,0                    ;ANY ERRS?
        JE      SEBP_CONT2
        JMP     SEBP_ERR
SEBP_CONT2:
        MOV     AL,BYTE PTR API_FLD1+1  ;GET FEATURES BYTE
        MOV     [BX].PSCB_FEAT,AL
        MOV     AX,WORD PTR API_OPT     ;GET PS SIZE
        MOV     [BX].PSCB_SIZE,AX
        MOV     AX,WORD PTR API_SCAN    ;GET PS OFFSET
        MOV     [BX].PSCB_OFF,AX
        MOV     AX,WORD PTR API_SCAN+2  ;GET PS SEGREG
        MOV     [BX].PSCB_SEG,AX
        MOV     AL,BYTE PTR API_FLD1    ;GET TYPE BYTE (2=DFT,3=CUT,4=NOTEP)
        CMP     AL,02                   ;IS IT DFT ?
        JNE     SEBP_TST1
        JMP     SEBP_DFT                ;ELSE SET UP AS DFT SESSION
SEBP_TST1:
        CMP     AL,03                   ;IS IT CUT ?
        JNE     SEBP_TST2
        JMP     SEBP_CUT
SEBP_TST2:
        CMP     AL,04                   ;IS IT A NOTEPAD ?
        JE      SEBP_NOTEP
        JMP     SEBP_ERR
;
SEBP_NOTEP:
        MOV     [BX].PSCB_FEAT,80H      ;FORCE NOTEPAD TO EAB MODE
        MOV     [BX].PSCB_SIZE,1920     ;FORCE MOD 2 SIZE
        MOV     [BX].PSCB_TYP,02        ;NOTEPAD TYPE
        JMP     SEBP          ;IS IT A MOD 2
        JNE     SEBP_TST3
        JMP     SEBP_M2
SEBP_TST3:
        CMP     AL,32                   ;MOD 3 ?
        JNE     SEBP_TST4
        JMP     SEBP_M3
SEBP_TST4:
        CMP     AL,43                   ;MOD 4 ?
        JNE     SEBP_TST5
        JMP     SEBP_M4
SEBP_TST5:
        CMP     AL,27                   ;MOD 5?
        JNE     SEBP_TST6
        JMP     SEBP_M5
SEBP_TST6:
        JMP     SEBP_ERR                ;ERROR - NO MORE CHOICES
SEBP_M2:
        MOV     [BX].PSCB_SIZE,1920
        MOV     AX,[BX].PSCB_OFF        ;GET OFFSET TO PS
        ADD     AX,48                   ;ADD PREFIX (30H)
        MOV     [BX].PSCB_OFF,AX
        JMP     SEBP_NEXT
SEBP_M3:
        MOV     [BX].PSCB_SIZE,2560
        MOV     AX,[BX].PSCB_OFF        ;GET OFFSET TO PS + HEADER
        ADD     AX,64                   ;ADD M4 PREFIX (40H)
        MOV     [BX].PSCB_OFF,AX
        JMP     SEBP_NEXT
SEBP_M4:
        MOV     [BX].PSCB_SIZE,3440
        MOV     AX,[BX].PSCB_OFF        ;OFFSET TO PS + HDR
        ADD     AX,86                   ;ADD M4 PREFIX (56H)
        MOV     [BX].PSCB_OFF,AX
        JMP     SEBP_NEXT
SEBP_M5:
        MOV     [BX].PSCB_SIZE,3564
        MOV     AX,[BX].PSCB_OFF        ;OFFSET TO PS + HDR
        ADD     AX,54                   ;ADD M5 PREFIX (36H)
        MOV     [BX].PSCB_OFF,AX
        JMP     SEBP_NEXT
;
SEBP_NEXT:
        ADD     SI,12                   ;POINT TO NEXT NAME LIST ENTRY
        ADD     BX,PSCB_CBSIZE
        MOV     PSCB_NEXT,BX            ;POINT TO NEXT FREE ENTRY
        INC     PSCB_COUNT              ;COUNT OF ENTRIES
        CMP     PSCB_COUNT,7            ;MAX SIZE IS 7
        JGE     SEBP_EXIT               ;SHOULD NEVER HAVE MORE
        JMP     SEBP_LOOP               ;GO DO ANOTHER
SEBP_EXIT:
        JMP     SE_DO_NEXT              ;RETURN TO SE MAIN
SEBP_ERR:
        MSG     'PCI-901 Internal Error QP'     ;ERROR DURING Q PARMS
        JMP     NOTSET
SE_BLDPSCB  ENDP
SET_ENVIRON ENDP
;
;
HDR_MSG DB      0DH,0AH                ;CR LF
        DB      '3270PC High Level Language Application Program Interface'
        DB      0DH,0AH,0AH             ;CR LF LF
        DB      'The use of this program is subject to the terms and conditions'
        DB      0DH,0AH                 ;CR LF
        DB      'of the IBM Program License Agreement (Z125-3301) contained in'
        DB      0DH,0AH
        DB      'the 3270PC High Level Language Application Program Interface '
        DB      'Manual'
        DB      0DH,0AH,0AH             ;CR LF LF LF
        DB      '1753180 (c) Copyright IBM Corporation 1984'
        DB      0DH,0AH
        DB      'Licensed Material - Program Property of IBM'
        DB      0DH,0AH,0AH
        DB      'Service Registration Number: '
        DB      '3570000000'                   ;;;<<<- WILL BE 0 ON A REASSMBLY
        DB      '                              '
        DB      0DH,0AH,0AH,'$'         ;CR LF LF + DOS EOT CHARACTER
;
CSEG    ENDS
        END     PCISTART
       JE      PCWRETRY        ;NO TIMEOUT = WAIT FOREVER
        JMP     PCWEXIT         ;ELSE PASS OUT RC=4 FOR TIMEOUT.
WAIT    ENDP


;=======================================================================
;  SEARCH
;        CALL 'PCSRCH' USING RETCODE LENGTH SEARCH-STRING.
;        SCANS THE PRESENTATION SPACE FOR A MATCH WITH SEARCH-STRING.
;       (NOTE: Uses the LOGICAL DEVICE buffer NOT the DISPLAY buffer.)
;        SETS RETCODE = 0 IF NO MATCH, ELSEG    ENDS
        END     PCISTART
