;=========================================================================;
;  PASLIM  PASCAL Language Interface Module                               ;
;           V 1.0  07/31/84                                               ;
;   3270PC HIGH LEVEL LANGUAGE APPLICATION PROGRAM INTERFACE 1753180      ;
;   COPYRIGHT 1984 IBM CORP.(C) LICENSED MATERIAL PROPERTY OF IBM         ;
;=========================================================================;
;
CSEG            SEGMENT PARA PUBLIC 'CODE'
                ASSUME  CS:CSEG,DS:CSEG
PAS_START:      JMP     REAL_START      ;SHOULD NEVER GET HERE !!!
;
;===================================================================
; Language Interface Module (LIM) PARAMETER CONTROL BLOCK (PCB)
;
PPCBID          DB      'PCB'           ;PCB HDR
PFUNCODE        DB      0               ;USERS FUNCTION REQ CODE
PDSEG           DW      0               ;USERS DATA SEG
PDOFFS          DW      0               ;OFFSET TO USERS DATA
PDLEN           DW      0               ;DATA LENGTH
PSESSID         DB      0               ;NOT USED...
PRETCODE        DW      0               ;RETURN CODE (1 BYTE EXCEPT FOR SRCH)
URETCODEADR     DW      0               ;NOT IN PCB, NEED ADDR TO PASS BACK TO
USTRDWLEN       DW      0               ;USERS STRING DESCRIPTOR WORD LENGTH
;====================================================================
        ASSUME  CS:CSEG,DS:CSEG,ES:NOTHING
;=================================================================
;                  INITIALIZATION
;
PASLIM  PROC    FAR
        PUBLIC  PASLIM          ;EXTERNAL MODULE NAME = PASLIM
REAL_START:
;=========================================================================
;       Pascal LIM Entry Point                                 STACK AT ENTRY
;               - ENTRY & CALL ANALYSIS                        00 - FRAME PTR
;               - CONTROL BLOCK VALIDATION & BUILD             02 - RET SEGA
;               - INT44 TO CALL MAIN PCI ROUTINE               04 - RET OFFSA
;               - CALL WITH DS:SI POINTING TO THE USER PCB     06 - RETC PTR
;                                                              08 - LEN PTR
;                                                              10 - STR PTR
;                                                              12 - STR LEN VAL
;                                                              14 - FUNC PTR
PAS_EPA:
        PUSH    BP              ;SAVE BP
        MOV     BP,SP           ;SET BASE PARM LIST
        MOV     DX,DS           ;SAVE HIS DS:
        MOV     AX,CSEG         ;OK TO DESTROY AX, GET MY SEGREG SET
        MOV     DS,AX           ;SET MY SEGREG
        MOV     PDSEG,DX        ;SAVE SEGREG POINTER      DSEG IN PCB
        MOV     SI,[BP]+14      ;GET FUNCTION CODE ADDRESS
        MOV     AX,ES:0 [SI]    ;GET FUNCTION CODE (HIS ES: = DS:)
        MOV     PFUNCODE,AL     ;SAVE FUNCTION BYTE       FUN CODE IN PCB
        MOV     SI,[BP]+6       ;GET RETCODE ADDRESS
        MOV     URETCODEADR,SI  ;SAVE RET CODE ADDR
;
;  SPECIAL CASE: GETSTR USES RETCODE TO PASS IN OFFSET PARM
;
        MOV     AX,ES:0 [SI]    ;GET RETCODE VALU (IN CASE ITS THE OFFSET)
        MOV     PRETCODE,AX     ;PUT INTO PCB            RETCODE IN PCB
        MOV     SI,[BP]+8       ;GET LENGTH ADDR
        MOV     AX,ES:0 [SI]    ;GET LENGTH VALU
        MOV     PDLEN,AX        ;SAVE IN PCB              LEN IN PCB
        MOV     AX,[BP]+10      ;GET PTR TO STRING
        MOV     PDOFFS,AX       ;SAVE STRING ADDRESS      STR PTR IN PCB
;
;  READY FOR THE INTERRUPT ......
;
        PUSH    ES                     ;SAVE ES
        MOV     AX,0                   ;SET ES TO LOW CORE
        MOV     ES,AX
        CMP     WORD PTR ES:0110H,0H   ;IS THERE SOME POINTER AT INT44 ?
        POP     ES                     ;RESTORE ES
        JE      NOINT44                ;IF NO PTR DON'T DO THE INTERRUPT
;
        LEA     SI,PPCBID              ;CALL WITH DS:SI POINTING TO PCB
        INT     44H                    ;CALL PCIRES
;
PRE_EXIT:
        MOV     AX,CSEG                ;RESET MY SEGREGS
        MOV     DS,AX                  ;MY DS = CS
        MOV     AX,PDSEG               ;GET PASCAL SEGREG
        MOV     ES,AX
        MOV     DI,URETCODEADR         ;GET HIS RETCODE ADDR
        MOV     BX,PRETCODE            ;GET THE RETURN WORD
        MOV     WORD PTR ES:0 [DI],BX  ;MOVE THE RETCODE WORD TO PASCAL
        MOV     DS,AX                  ;RESET PASCAL DS:
;
        POP     BP
        RET     10                     ;RETURN TO PASCAL
;
NOINT44:
        MOV     AX,01                  ;NOT CONNECTED ERR (pcires not loaded)
        MOV     PRETCODE,AX            ;SET IT
        JMP     PRE_EXIT
PASLIM  ENDP
;=========================================================================
CSEG    ENDS
        END
