title	'EMPEROR.ASM - PALANTIR Font Definition File -- 04/25/83'

*****************************************************************
*								*
*	NEC EMPEROR P.S. Proportional Font Non-Translation Mode	*
*		         803 - 020004 - 312		        *
*								*
*	The definition table must be assembled to produce	*
*	a HEX file, which should then be LOADed or SAVEd	*
*	(e.g., SAVE 1 name.WPF) from DDT to create the		*
*	font definition file expected by the PALANTIR.		*
*								*
*	The table consists of 128 2-byte entries for the	*
*	character set from Ascii 0-127.  The first byte of	*
*	each entry is the character size in increments.  The	*
*	second byte is the code to be sent to the printer,	*
*	which for some print wheels is different from the	*
*	original Ascii character.  If the high-order bit of	*
*	the second byte is on, the DFSHFT (Shift) logic in	*
*	the print driver is invoked at printout.		*
*								*
*	For mono-spaced wheels, the first byte will be the	*
*	same throughout.  For wheels that use the normal	*
*	character arrangement, the second byte of each entry	*
*	will contain the next higher binary value.  The first	*
*	32 entries of the table are not normally used, unless	*
*	by the Extended Character Set option for printers	*
*	with more than 96 characters per wheel. 		*
*								*
*****************************************************************

	org	100h

	page
;	Control/Extended Range

	db	0,0
	db	10,'O'+128		; Left Arrow <-
	db	10,'W'+128		; Logical NOT
	db	10,']'+128		; 1/2
	db	10,'Z'+128		; Cent Sign
	db	10,'G'+128		; 1/4
	db	0,6
	db	0,7
	db	0,8
	db	0,9
	db	0,10
	db	0,11
	db	0,12
	db	0,13
	db	0,14
	db	0,15
	db	0,16
	db	0,17
	db	0,18
	db	0,19
	db	0,20
	db	0,21
	db	0,22
	db	0,23
	db	0,24
	db	0,25
	db	0,26
	db	0,27
	db	0,28
	db	10,' '		;Soft Space
	db	8,'-'		;Hard Hyphen
	db	10,' '		;Hard Space

	page
;	Standard Ascii Character Set

	db	10,' '	 	;Blank
	db	06,'!' 		;Exclamation Point
	db	08,'"' 		;Double Quotes
	db	12,'#' 		;Pound (Number) Sign

	db	10,'$'		;Dollar Sign
	db	12,'%'		;Percent Sign
	db	12,'&'		;Ampersand
	db	06,''''		;Single Quote

	db	06,'(' 		;Left Parenthesis
	db	06,')' 		;Right Parenthesis
	db	10,'*' 		;Asterisk
	db	10,'+' 		;Plus Sign

	db	06,','		;Comma
	db	08,'-' 		;Hyphen (Minus Sign)
	db	06,'.' 		;Period
	db	08,'/' 		;Slash

	db	10,'0'		;Digit Zero
	db	10,'1'		;Digit One
	db	10,'2'		;Digit Two
	db	10,'3'		;Digit Three

	db	10,'4'		;Digit Four
	db	10,'5'		;Digit Five
	db	10,'6'		;Digit Six
	db	10,'7'		;Digit Seven

	db	10,'8'		;Digit Eight
	db	10,'9'		;Digit Nine
	db	06,':' 		;Colon
	db	06,';' 		;Semicolon

	db	10,'<' 		;Less Than
	db	10,'=' 		;Equal Sign
	db	10,'>' 		;Greater Than
	db	10,'?' 		;Question Mark

	db	12,'@' 		;At-Sign
	db	12,'A' 		;Capital A
	db	10,'B' 		;Capital B
	db	12,'C' 		;Capital C

	db	12,'D' 		;Capital D
	db	10,'E' 		;Capital E
	db	10,'F' 		;Capital F
	db	12,'G' 		;Capital G

	db	12,'H' 		;Capital H
	db	06,'I' 		;Capital I
	db	08,'J' 		;Capital J
	db	12,'K' 		;Capital K

	db	10,'L'		;Capital L
	db	14,'M' 		;Capital M
	db	12,'N' 		;Capital N
	db	14,'O'		;Capital O

	db	10,'P' 		;Capital P
	db	14,'Q'		;Capital Q
	db	12,'R' 		;Capital R
	db	10,'S' 		;Capital S

	db	12,'T' 		;Capital T
	db	12,'U' 		;Capital U
	db	10,'V' 		;Capital V
	db	14,'W' 		;Capital W

	db	12,'X' 		;Capital X
	db	12,'Y' 		;Capital Y
	db	12,'Z' 		;Capital Z
	db	06,'[' 		;Left Square Bracket (Open)

	db	08,'\' 		;Backslash
	db	06,']'		;Right Square Bracket (Close)
	db	10,'^' 		;Carat
	db	10,'_'		;Underscore

	db	10,60H 		;Accent
	db	08,'a'		;Lowercase a
	db	10,'b' 		;Lowercase b
	db	08,'c' 		;Lowercase c

	db	10,'d' 		;Lowercase d
	db	08,'e'		;Lowercase e
	db	06,'f' 		;Lowercase f
	db	08,'g' 		;Lowercase g

	db	10,'h'		;Lowercase h
	db	06,'i'		;Lowercase i
	db	06,'j' 		;Lowercase j
	db	10,'k' 		;Lowercase k

	db	06,'l' 		;Lowercase l
	db	12,'m' 		;Lowercase m
	db	10,'n'		;Lowercase n
	db	10,'o'		;Lowercase o

	db	10,'p' 		;Lowercase p
	db	10,'q' 		;Lowercase q
	db	08,'r' 		;Lowercase r
	db	08,'s'	 	;Lowercase s

	db	06,'t'		;Lowercase t
	db	10,'u' 		;Lowercase u
	db	10,'v' 		;Lowercase v
	db	12,'w' 		;Lowercase w

	db	10,'x' 		;Lowercase x
	db	10,'y' 		;Lowercase y
	db	10,'z' 		;Lowercase z
	db	06,'{' 		;Left Curly Brace (Open)

	db	4,'|' 		;Vertical Bar
	db	06,'}' 		;Right Curly Brace (Close)
	db	10,'~' 		;Tilde
	db	0,0		;Delete Code (Not Used)

	end







































