;
	PAGE	58,132
	NAME	ROMDVR
	TITLE	ROM VERSION OF CORVUS DISK DRIVERS
;
; --- THIS MODULE USES INCLUDE FILES: SYSTEM.EQU, ROMDVRF.LIB, ROMDVRT.LIB
;     TO MAKE A SIMPLE BINARY "ROM" MODULE TO TEST THE DRIVERS.
;     THE MODULE STARTS WITH A TABLE OF 4 "NEAR" JUMPS THAT SIMULATE
;     THOSE USED ON THE CORVUS-IBM NETWORK INTERFACE CARDS
;
;
;
CSEG	SEGMENT PARA PUBLIC 'CODE'
;
;
;*******************
;*   M A C R O S   *
;*******************
;
;
F_CALL	MACRO	SegVal,OffVal
	DB	   9Ah			; direct intersegment CALL opcode
	DW	OffVal			; offset portion of operand
	DW	SegVal			; segment portion of operand
	ENDM
;
F_JMP	MACRO	SegVal,OffVal
	DB	  0EAh			; direct intersegment JMP opcode
	DW	OffVal			; offset portion of operand
	DW	SegVal			; segment portion of operand
	ENDM
;
PRINTE	MACRO	MSG,N
	IF2
	%OUT	* MSG N *
	ENDIF
	ENDM
;
; Miscellaneous Corvus equates
;
TRUE		EQU	0FFFFH		; logical true
FALSE		EQU	    0		; logical false
garbage 	EQU	    0		;
BEL		EQU	  007h		; ASCII bell character
LF		EQU	  00Ah		; ASCII linefeed character
CR		EQU	  00Dh		; ASCII carriage return character
ROMSEG		=	    0		; set default rom segment
;
;
;*************************************
;*   S T A R T	 O F   D R I V E R   *
;*************************************
;
	INCLUDE	SYSTEM.EQU	; INCLUDE SYSTEM SPECS.
;
ROMDRV	PROC	FAR
;
	ASSUME	CS:CSEG,ES:CSEG,DS:CSEG
BEGIN:
START		EQU	$
;
;
ROMJMPS	EQU	$
;
	JMP	ROM_COLD		; ROM cold start
WARMINIT LABEL	NEAR
	JMP	ROM_WARM	 	; ROM warm start
CRVIO	LABEL	NEAR
 	JMP	ROM_IO			; ROM I/O service dispatcher
	JMP	ROM_DUMRET		; ROM dummy interrupt return
;
	INSTMG			; GET PART OF MESSAGE FROM INCLUDE FILE
	DB	' ROM driver routine'
;
; --- MAKE BUILTIN "ROM" ROUTINE ON SEGMENT BOUNDARY ---
;
	 IF ($-START) MOD 16
	ORG	($-START)+16-(($-START) MOD 16)
	 ENDIF
;
	 IF	(NOT ROMDVR) AND FLAT	; IF BUILT IN FLAT CABLE DRIVER
	INCLUDE	ROMDVRF.LIB		;  LOAD DRIVER IN
	 ENDIF
;
	 IF	(NOT ROMDVR) AND (NOT FLAT) ; IF BUILT IN OMNINET DRIVER
	INCLUDE	ROMDVRT.LIB		;  LOAD DRIVER IN
	 ENDIF
;
;
;**********************************************************
;* Reserve 80 hex bytes of patch space for fooling around *
;**********************************************************
;
PATCH   DB	80h DUP (0)		;
;
;***********************************************************************
;
ROMDRV	ENDP				; end of main proc
CSEG	ENDS				; end of code seg defn
	END	BEGIN
