#include <gks/gks_types.h>
#include <gks/gks_structs.h>
#include <gks/message.h>
#include <gks/inputmsg.h>

#include <gks/trace.h>


/*
 *	sample stroke
 */
GKSERR smp_stk( wkid, devno, norm, npts, pts )
	WKID wkid;
	int  devno;
	int  *norm;
	int  *npts;
	WCPT pts[];
	{
	int i;
	int res;
	struct rpinpsmp *reply;
	static char *fname = "smp_stk";

	res = _smp_all(fname, wkid, devno, STROKE, &reply);
	if (res == 0)
		{
		/*
		 *	map back to WC through highest priority viewport
		 */
		*npts = reply->smprec.inpt_stk.stk_npts;
		*norm = _stknorm(*npts, reply->smprec.inpt_stk.stk_pts);
		for(i = 0; i < *npts; ++i)
			_ndc2wc(*norm, &(reply->smprec.inpt_stk.stk_pts[i]), &pts[i]);

		_freemsg(reply);

#ifdef TRACE
		if(Gksdebug & DB_INPUT)
			Gksout("%s returns %d points\n", fname, *npts);
#endif
		}
	
	return (res);

	}
