#include <gks/gks_types.h>
#include <gks/gks_structs.h>
#include <gks/message.h>
#include <gks/qgdpattr.h>

#include <gks/trace.h>

#include "wsinfo.h"

GKSERR
q_wd_gdp(wktype, gdp_id, errno, gdp_attr)
WSTYPE wktype ;
GDP_ID gdp_id ;
GKSERR *errno ;
GDP_ATTR *gdp_attr ;
{
	struct msqgdpattr *msg ;
	struct msqgdpattr *reply ;
	static char *fname = "q_wd_gdp" ;
	WSINFO ws ;
	BOOL must_close = FALSE;

	if(!Gksckstate(GS_GKOP | GS_WSOP | GS_WSAC | GS_SGOP))
	{
		*errno = 8 ;
		return ;
	}
/*
 * see if workstation of specified type is already open.
 */
	for(ws = WsFirst(); ws != NULL; ws = WsNext())
		if(WsGettype(ws) == wktype)
			break ;

	if (ws == NULL)
		{
		*errno = 25;
		return;
		}
/***********************************************************************
	if(ws == NULL)		/* quel dommage!
						 * must open workstation, ask, and close it.
						 */
/***********************************************************************
	{
		if(open_ws(0xffff, "", wktype) != 0)
		{
			*errno = 22 ;
			return ;
		}
		ws = WsId2info(0xffff) ;
		must_close = TRUE ;
	}
***********************************************************************/
	if((WsGetcat(ws) != WSC_OUTPUT) && (WsGetcat(ws) != WSC_OUTIN))
	{
		*errno = 39 ;
		if(must_close)
			close_ws(0xffff) ;
		return ;
	}
/*
 * deliver "inquire GDP" message
 */
	msg = (struct msqgdpattr *)_allocmsg(sizeof(struct msqgdpattr)) ;
	if(msg == NULL)
	{
		*errno = 904 ;
		return ;
	}
	qgdpattrmsg(msg, WsGetpid(ws), gdp_id) ;
	_sendmsg((char *)msg) ;
/*
 * wait for reply
 */
	reply = (struct msqgdpattr *)_recvmsg(WsGetpid(ws)) ;
	if(reply == NULL)
	{
		*errno = WsNomsg() ;
		return ;
	}

	*errno = 0;

	if (reply->mhdr.msg_reply != 0)
		*errno = 41;
	else
		*gdp_attr = reply -> gdp_attr ;

#ifdef TRACE
	if(Gksdebug & DB_INQUIRE)
		Gksout("%s(%d, %d, %d, %d)\n",
			fname, wktype,  gdp_id, *errno, *gdp_attr) ;
#endif
	_freemsg(reply) ;
}

static
qgdpattrmsg(msg, pid, gdp_id)
struct msqgdpattr *msg ;
PID pid ;
GDP_ID gdp_id ;
{
	msg -> mhdr.msg_id = MSQGDPATTR ;
	msg -> mhdr.msg_to = pid ;
	msg -> mhdr.msg_length = sizeof(struct msqgdpattr) - sizeof(MSGHDR) ;
	msg -> mhdr.msg_ack = TRUE ;
	msg -> mhdr.msg_reply = 0 ;
	msg -> gdp_id = gdp_id ;
}

static char *SccsId = "@(#)q_wd_gdp.c	1.5\t2/21/85" ;
