#include <gks/gks_types.h>
#include <gks/message.h>
#include <gks/metwrite.h>

#include <gks/trace.h>

#include "wsinfo.h"

/*
 *	send the user data to a metafile
 */
GKSERR
m_write (wkid, it_type, it_len, it_data)
int wkid ;
int it_type ;
int it_len ;
char *it_data ;
{
	WSINFO ws ;
	struct msmetwrt *msg ;
	char *fname = "m_write" ;

#ifdef TRACE
	if (Gksdebug & DB_META)
		Gksout( "%s(%d, %d, %d, 0x%x)\n",
			fname, wkid, it_type, it_len, it_data) ;
#endif

	if (!Gksckstate( GS_WSAC | GS_SGOP))
		return( err_hand( 7, fname)) ;

	ws = WsId2info( wkid) ;
	if (ws == NULL)
		return( err_hand( 25, fname)) ;

	if (!WsActive( ws))
		return( err_hand( 30, fname)) ;
	
	if (!(WsGetcat(ws) == WSC_MO))
		return( err_hand( 32, fname)) ;
	
	if (it_type < 1)
		return( err_hand( 160, fname)) ;

/*
 *	send "write item" message
 */
	msg =(struct msmetwrt *)_allocmsg( sizeof( struct msmetwrt) + it_len - 1) ;
	if(msg == NULL)
		return(err_hand(904, fname)) ;
	writemsg( msg, WsGetpid( ws), it_type, it_len, it_data) ;
	_sendmsg( msg) ;

/*
 *	wait for reply
 */
	msg =  (struct msmetwrt *)_recvmsg( WsGetpid(ws)) ;
	if(msg == NULL)
		return (err_hand(WsNomsg(), fname));

	if (msg->mhdr.msg_reply == 0)
	{
		_freemsg( msg) ;
		return( 0) ;	/* success */
	}
	else if (msg->mhdr.msg_reply == 1)
	{
		/* invalid item type */
		_freemsg( msg) ;
		return( err_hand( 160, fname)) ;
	}
	else
	{
		/* invalid item length */
		_freemsg( msg) ;
		return( err_hand( 161, fname)) ;
	}
}

static
writemsg (msg, pid, type, len, rec)
struct msmetwrt *msg ;
PID pid ;
int type, len  ;
char *rec ;
{
	msg->mhdr.msg_id = MSMETWRT ;
	msg->mhdr.msg_to = pid ;
	msg->mhdr.msg_length = sizeof(struct msmetwrt) - sizeof(MSGHDR) + len - 1;
	msg->mhdr.msg_ack = TRUE ;
	msg->metw_type = type ;
	msg->metw_len = len ;
	cpybuf( msg->metw_rec, rec, len) ;
}

static char *SccsId = "@(#)m_write.c	1.4\t3/5/85" ;
