/*
 *	GKS:  EVENT INPUT PROCESSING
 *
 *	Copyright (C) 1985 by Chromatics, Inc.
 */

#include "gks_types.h"
#include "gks_structs.h"
#include "gks.h"


/*
 *	await event
 *
 *	The input queue is inspected for an event.
 *
 *	If present: the workstation id and input class are
 *		returned immediately.
 *
 *	If the queue is empty one (of possibly many) CX
 *		workstations is polled for events, which are
 *		added to the queue.
 *
 *	flush denotes whether or not the CX should empty
 *	its queue before reporting events (i.e. queue overflow
 *	detected by the host -> events collected cannot
 *	be added until the queue has been emptied).
 *
 */
GKSERR	await(timeout, wkid, class, devno)
	REAL	timeout;
	WKID   *wkid;
	INPUTCLASS *class;
	int    *devno;
{
	Gevent	event;
	Gint	errno;
	errno = gawaitevent(timeout, &event);
	*wkid = event.ws;
	*devno = event.dev;
	switch (event.class)
		{
	case GNCLASS:
		*class = NOEVENT;
		break;
	case GLOCATOR:
		*class = LOCATOR;
		break;
	case GSTROKE:
		*class = STROKE;
		break;
	case GVALUATOR:
		*class = VALUATOR;
		break;
	case GCHOICE:
		*class = CHOICE;
		break;
	case GPICK:
		*class = PICK;
		break;
	case GSTRING:
		*class = STRING;
		break;
	default:
		printf("gawaitevent parameter out of range");
		}

	return errno;
}

/*
 *	flush device events
 */
GKSERR	flushdev(wkid, class, devno)
	WKID	wkid;
	INPUTCLASS class;
	int	devno;
{
	Giclass c;

	switch (class)
		{
	case NOEVENT:
		c = GNCLASS;
		break;
	case LOCATOR:
		c = GLOCATOR;
		break;
	case STROKE:
		c = GSTROKE;
		break;
	case VALUATOR:
		c = GVALUATOR;
		break;
	case CHOICE:
		c = GCHOICE;
		break;
	case PICK:
		c = GPICK;
		break;
	case STRING:
		c = GSTRING;
		break;
	default:
		printf("gawaitevent parameter out of range");
		}
	return gflushevents(wkid, c, devno);
}

/*
 *	get choice
 */
GKSERR	get_chc(status, choice)
	CHOICESTAT *status;
	CHOICEVAL *choice;
{
	Gchoice choicer;
	Gint	errno;
	errno = ggetchoice(&choicer);
	switch (choicer.status)
		{
	case GC_OK:
		*status = OK;
		break;
	case GC_NOCHOICE:
		*status = NOCHOICE;
		break;
	case GC_NONE:
		*status = NONE;
		break;
	default:
		printf("get_chc parameter out ot range\n");
		}
	*choice = choicer.choice;
	return errno;
}


/*
 *	get locator
 */
GKSERR	get_loc(norm, locx, locy)
	int    *norm;
	WC	   *locx, *locy;
{
	Gloc	returnit;
	Gint	errno;
	errno = ggetloc(&returnit);
	*norm = returnit.transform;
	*locx = returnit.position.x;
	*locy = returnit.position.y;
	return errno;
}

/*
 *	get pick
 */
GKSERR	get_pck(status, segname, pickid)
	PICKSTAT *status;
	SEGNAME *segname;
	PICKID *pickid;
{
	Gpick	pickit;
	Gint	errno;
	errno = ggetpick(&pickit);
	switch (pickit.status)
		{
	case GP_NONE:
		*status = NONE;
		break;
	case GP_OK:
		*status = OK;
		break;
	case GP_NOPICK:
		*status = NOPICK;
		break;
	default:
		printf("get_pck parameter out of range\n");
		}
	*segname = pickit.seg;
	*pickid = pickit.pickid;
	return errno;
}


#if 0
/*
 *	get stroke
 */
GKSERR	get_stk(norm, npts, pts)
	int    *norm;
	int    *npts;
	WCPT	pts[];
{
	int	i;
	int	res;
	static char *fname = "get_stk";

	if ((res = _get_all(fname, STROKE)) == 0)
		{
		/* map back to WC through highest priority viewport */
		*npts = q_cer->ev_data.inpt_stk.stk_npts;
		*norm = _stknorm(*npts, q_cer->ev_data.inpt_stk.stk_pts);
		for (i = 0; i < *npts; ++i)
			_ndc2wc(*norm, &(q_cer->ev_data.inpt_stk.stk_pts[i]), &pts[i]);

		}

	return (res);

}
#endif


/*
 *	get string
 */
GKSERR	get_str(string)
	char   *string;
{
	Gint	errno;
	errno = ggetstring(string);
	return errno;
}

/*
 *	get valuator
 */
GKSERR	get_val(value)
	REAL   *value;
{
	Gint	errno;
	errno = ggetval(value);
	return errno;
}

/*
 *	inquire more simultaneous events
 */
VOID	q_g_more(errno, more)
	GKSERR *errno;
	BOOL   *more;
{
	Gsimultev events;
	ginqmoreevents(&events, errno);
	*more = (events == GMORE) ? 1 : 0;
}

/*
 *	inquire input queue overflow
 */
VOID	q_g_oflo(errno, wkid, class, devno)
	GKSERR *errno;
	WKID   *wkid;
	INPUTCLASS *class;
	int    *devno;
{
	Gqueue	oflow;
	ginqinputoverflow(oflow, errno);
	*devno = oflow.devno;
	*wkid = oflow.ws;
	switch (oflow.class)
		{
	case GNCLASS:
		*class = NOEVENT;
		break;
	case GLOCATOR:
		*class = LOCATOR;
		break;
	case GSTROKE:
		*class = STROKE;
		break;
	case GVALUATOR:
		*class = VALUATOR;
		break;
	case GCHOICE:
		*class = CHOICE;
		break;
	case GPICK:
		*class = PICK;
		break;
	case GSTRING:
		*class = STRING;
		break;
	default:
		printf("q_g_oflo parameter out of range\n");
		}
}
