/*	tapv02.c						*/

/*	TAP - version 2		11/2/83		Roy Blackmer, AED */
/*	      version 2.rt	3/84		A.E. Kossow,  AED */

/*	functions are grouped as follows :
	------ functions available on 512, 767 and 1024	-----
	------ misc. subs - txt, encode, alf, tapint. ------
	------ functions available on 767 and 1024 -------
	------ functions available on 1024 only	------
	------ functions available on 512 only ------
*/

/*	rearranged and CAI bug fixed 11/17/83			*/
/*								*/
/*	removed	ordcmd() and auto command DMA option from	*/
/*	aedsub.c.  following define patches calls		*/
/*	to ordcmd - ice	has no find and	replace	. 11/30/84	*/
/*	changed DSK so that 0 length codes are allowed.		*/
/*	this was done because the terminal allows it and it's	*/
/*	the only way a PFK can regain its default meaning (if	*/
/*	any) after having been defined with DSK or DPK.		*/	

#include "tcp.h"	/* must	be in same directory */
#include <stdio.h>


static int	xspace = 8,	/* charsize set	by sap,	used by	txt	*/
		yspace = 12;

static char aedbf[AEDBFMAX];	/* usually used	to pass		*/
				/* data to ibyte, obyte.	*/
static char aedct[AEDCTMAX];	/* used	by sct(), rct()	for	*/
				/* color table reads/writes	*/



jus(addr)		/* jump	user subroutine	*/

int addr ;
{
	aedbf[0] = JUS;
	aedbf[1] = (*((char*)(&addr)));
	aedbf[2] = (*((char*)(&addr)));
	obyte(aedbf,3);
}


lmr(addr,bytnum,byt)	/* load	microprocessor ram */
int addr,bytnum;
char byt[];
{
	aedbf[0] = LMR;
	aedbf[1] = (*(((char*)(&addr))+1));
	aedbf[2] = (*((char*)(&addr)));
	aedbf[3] = (*(((char*)(&bytnum))+1));
	aedbf[4] = (*((char*)(&bytnum)));
	obyte(aedbf,5);
	obyte(byt,bytnum);
}

sse(addr16)	/* set stack end */
int addr16;
{
	aedbf[0] = SSE;
	aedbf[1] = (*(((char*)(&addr16))+1));
	aedbf[2] = (*((char*)(&addr16)));
	obyte(aedbf,3);
}

sap(size, font,	xspac, yspac, link)
int size, font,	link;
int xspac, yspac;
{
	register char *bufptr;
	bufptr = aedbf;
	xspace = xspac;		/*  xspace and yspace are	*/
	yspace = yspac;		/* parameters of txt		*/

	*bufptr++ = SAP;
	*bufptr++ = size;
	*bufptr++ = font;
	*bufptr++ = xspace;
	*bufptr++ = yspace;
	*bufptr	= link;
	obyte(aedbf, 6);
}

hom()			/* return alpha	cursor to first	character of top */
{			/* line	 */
	aedbf[0]= HOM;
	obyte(aedbf,1);
}

sbc(color)			/* set background color	*/
int color;
{
	aedbf[0] = SBC;
	aedbf[1]= color;
	obyte(aedbf,2);
}

sec(color)	/* set current color */
int color;
{
	aedbf[0] = SEC;
	aedbf[1] = color;
	obyte(aedbf,2);
}


/*	load RGB triples for colors add	.. add+n-1
	with the bytes in red[],green[],blue[].
*/

sct(add, n, red, green,	blue)	/* set color look-up table */
int  add, n;
char *red, *green, *blue;

{
	register char	*ct;
	register char	*r,*b,*g;
	 char	*last;

	r = red; b = blue; g = green;

/*	ensure 0<n<=256	- 0 means 256	*/

	if( (n &= 0377)	== 0)
		n = 256;

/*	ensure add is a	valid color number - 0..255	*/

	add &= 0377;

/*	make sure there's n colors starting with color add
*/
	if(add + n > 256){
		printf(" sct **	first =	%d count = %d\n",add,n);
		printf(" first + count must be < 257\n");
		exit(1);
	}

/*	everything is ok - issue command	*/
	aedbf[0] = SCT;
	aedbf[1] = add;
	aedbf[2] = n;
	obyte(aedbf, 3);
	last = aedct + n * 3; /* last =	last needed pos	in aedct +1 */

/*	splice the three arrays	into a sequence	of rgb triples	*/

	for(ct = aedct;	ct < last; ){
		*ct++ =	*r++;
		*ct++ =	*g++;
		*ct++ =	*b++;
	}
	obyte(aedct, last - aedct);
}

swm(mask)	/* set write mask */
int mask;
{
	aedbf[0] = SWM;
	aedbf[1] = mask;
	obyte(aedbf, 2);
}

srm(m1,m2,m3,m4)	/* set read masks */
int m1,m2,m3,m4;
{
	aedbf[0] = SRM;
	aedbf[1] = m1;
	aedbf[2] = m2;
	aedbf[3] = m3;
	aedbf[4] = m4;
	obyte(aedbf,5);
}

sbl(color,r,g,b,ontime,oftime)	/* set blink */
int color,r,g,b,ontime,oftime;
{
	aedbf[0] = SBL;
	aedbf[1] = color;	/* color number	to blink */
	aedbf[2] = r;		/* red,green,blue	*/
	aedbf[3] = g;		/* values for blink	*/
	aedbf[4] = b;
	aedbf[5] = ontime;	/* time	to display color as itself */
	aedbf[6] = oftime;	/* time	to display color as r,g,b  */
	obyte(aedbf,7);		/* time	is in units of refresh rate*/
}

scc(color1,color2,bltime)	/* set cursor colors */
int color1,color2,bltime;
{
	aedbf[0] = SCC;
	aedbf[1] = color1;
	aedbf[2] = color2;
	aedbf[3] = bltime;
	obyte(aedbf,4);
}

scp(ctype,constraint,plane)	/* set cursor parameter	*/
int ctype,constraint,plane;
{
	switch(ctype){
	case 'L' :	/* full	screen T square	cursor	*/
	case '+' :	/* "+" shaped cursor	*/
	case 'X' :	/* "X" shaped cursor	*/
		aedbf[0] = SCP;
		aedbf[1] = ctype;
		aedbf[2] = constraint &	127;
		aedbf[3] = plane;
		obyte(aedbf,4);
		return;
	default	:
		printf(" scp **	invalid	cursor type : %d\n", ctype);
		printf(" valid types are L + X\n");
		exit(0);
	}
}


ejc()				/* enable joystick cursor */
{
	aedbf[0] = EJC;
	obyte(aedbf,1);
}

djc()				/* disable joystick cursor */
{
	aedbf[0] = DJC;
	obyte(aedbf,1);
}

rcp(x,y)	/* read	cap  */
int *x,*y;
{
	aedbf[0] = RCP;
	obyte(aedbf, 1);
	ibyte(aedbf, 3);

/*	terminal returns x,y packed in 3 bytes -
	first byte is bits 11-8	of x, 11-8 of y,
	next 2 bytes are bits 7-0 x, 7-0 y
*/
	(*(((char*)(x))+1)) = ( aedbf[0] >> 4 ) &0x0F;
	(*((char*)(x))) = aedbf[1];
	(*(((char*)(y))+1)) = aedbf[0] & 0x0F;
	(*((char*)(y))) = aedbf[2];
}



rjp(x,y)	/* Read	joystick position */
int *x,*y;
{
	aedbf[0] = RJP;
	obyte(aedbf, 1);
	ibyte(aedbf, 3);

/*	see rcp	above for returned value format	*/

	(*(((char*)(x))+1)) = (aedbf[0] >> 4) & 0x0F;
	(*((char*)(x))) = aedbf[1];
	(*(((char*)(y))+1)) = aedbf[0] & 0x0F;
	(*((char*)(y))) = aedbf[2];
}



dca(x,y)				/* draw	cursor absolute	*/
int x,y;
{
	encode(&aedbf[1],x,y);
	aedbf[0]= DCA;
	obyte(aedbf,4);
}

ecu()				/* erase cursor	unconditionally	*/
{
	aedbf[0]= ECU;
	obyte(aedbf,1);
}

sac(color)			/* set alpha cursor color */
int color;
{
	aedbf[0]= SAC;
	aedbf[1]=color;
	obyte(aedbf,2);
}

mov(x, y)	/* move	cap */
int x, y;
{
	aedbf[0] = MOV;

/*	terminal wants x,y packed into 3 bytes as follows :
		byte 1 : x bits	11-8, y	bits 11-8
		byte 2 : x bits	7-0
		byte 3 : y bits	7-0
	encode accomplishes this.
*/
	encode(&(aedbf[1]),x,y);
	obyte(aedbf, 4);
}



mvr(dx,	dy)	/* move	cap relative   -127 < dx,dy < 127 */
int dx,	dy;
{
	aedbf[0] = MVR;
	aedbf[1] = dx;
	aedbf[2] = dy;
	obyte(aedbf, 3);
}

dfr(x, y)	/* draw	filled rectangle */
int x, y;
{
	aedbf[0] = DFR;
	encode(aedbf+1,	x, y);
	obyte(aedbf, 4);
}



wpx(color)		/* write a pixel */
int	color;
{
	aedbf[0] = WPX;
	aedbf[1] = color;
	obyte(aedbf, 2);
}

wmp(dx,dy)		/* write multiple pixels. */
char dx[], dy[];	/* after writing i'th pixel */
			/* terminal does mvr(dx[i],dy[i]). */
			/* if both dx[i] and dy[i] */
			/* are zero, it's done	*/
{

	register char *px,*py,*bp;
	int i; /* #dx,dy pairs to send,	inc. terminator	*/

	px = dx;
	py = dy;
	bp = aedbf;


/*	find out how many dx,dy	pairs there are	to send. */
/*	there's	at least 1 - the mandatory 0,0 terminator. */
/*	for no good reason we insist that there	be at most */
/*	32767 of them.					*/

	i = 1;	/* at least */

	while( (*px || *py) && (i > 0) ){
		px++;
		py++;
		i++;
	}

	if(i < 0){
		printf(" wmp **	too many pixels, 32767 max \n");
		exit(0);
	}

/*	issue command	*/

	aedbf[0] = WMP;
	obyte(aedbf,1);

/*	send the i  dx,	dy pairs,	*/
/*	sizeof(aedbf) bytes at a time.	*/

	px = dx;
	py = dy;

	for(;;){
		bp = aedbf;
		while(bp < aedbf + AEDBFMAX - 1){
			*bp++ =	*px++;
			*bp++ =	*py++;
			if(--i == 0){
				obyte(aedbf,bp - aedbf);
				return;
			}
		}
		obyte(aedbf,AEDBFMAX);
	}
}

rpx(col)	/* read	pixel */
int *col;	/* return color	number at CAP	*/
		/* both	in *col	and as function	value */
{
	aedbf[0] = RPX;
	obyte(aedbf,1);
	ibyte(aedbf,1);
	return(*col = aedbf[0] & 0377);
}

dva(x, y)	/* draw	vector absolute	*/
int x, y;
{
	aedbf[0] = DVA;
	encode(aedbf+1,	x, y);
	obyte (aedbf, 4);
}

dvr(dx,dy)			/* draw	vector relative	*/
int dx,dy;
{
	aedbf[0] = DVR;
	aedbf[1] = dx;
	aedbf[2] = dy;
	obyte(aedbf,3);
}

dmv(dx,dy)		/* draw	multiple vectors */
char dx[],dy[];		/* only	difference between dmv	*/
			/* and wmp is the opcode.	*/
{
	register char *px,*py,*bp;
	int i;

	i=1;
	px = dx;
	py = dy;
	bp = aedbf;

	while( (*px || *py) && (i > 0) ){
		px++; py++; i++;
	}

	if(i<0){
		printf(" dmv **	too many vectors, 32767	max\n");
		exit(0);
	}

	aedbf[0] = DMV;
	obyte(aedbf,1);

	px = dx;
	py = dy;

	for(;;){
		bp = aedbf;
		while(bp < aedbf + AEDBFMAX - 1){
			*bp++ =	*px++;
			*bp++ =	*py++;
			if(--i == 0){
				obyte(aedbf,bp - aedbf);
				return;
			}
		}
		obyte(aedbf,AEDBFMAX);
	}
}

bfl(color)				/* boundary fill */
int color;
{
	aedbf[0] = BFL;
	aedbf[1] = color;
	obyte(aedbf,2);
}

/*	set line style.		*/
/*	scale is ridiculous,	*/
/*	TAP really should map	*/
/*	(1,2,4,8) -> (255,85,17,1)	*/

sls(pattern,scale)	/* set line style */
int pattern,scale;
{
	switch(scale){

	case 255:	/* scale factor	is 1	*/
	case 85:	/* scale factor	is 2	*/
	case 17:	/* scale factor	is 4	*/
	case 1:		/* scale factor	is 8	*/

		aedbf[0]= SLS;
		aedbf[1] = pattern;
		aedbf[2] = scale;
		obyte(aedbf,3);
		return;

	default:
		printf(" sls **	bad scale arg :	%d\n",scale);
		printf(" use one of 255,85,17,1\n");
		exit(0);
	}
}

spf(pat)		/* set pattern fill */
int pat;
{
	if( (pat < 0) || (pat >	15) ){
		printf(" spf **	bad pattern number %d\n", pat);
		printf(" pattern number	must be	in 0..15\n");
		exit(0);
	}
	aedbf[0] = SPF;
	aedbf[1] = pat;
	obyte(aedbf,2);
}

wip(n16,byt)	/* write incremental plotter mode */
int n16;	/* number of direction codes in	byt */
char byt[];	/* direction codes, 2 per byte	*/
{
	register int n = n16;

	aedbf[0]= WIP;
	aedbf[1]= ( n >> 8 );
	aedbf[2]= n;
	n/=2;
	obyte(aedbf,3);
	obyte(byt,n);
}

/*	Write n	special	font characters.	*/
/*	code[i]	is a special font identifier.	 */
/*	After special font char	code[i]	has been */
/*	written, terminal does a move relative	*/
/*	dx[i],dy[i].				*/

wsf(n,code,dx,dy)	/* write special font */
int n;
register char code[],dx[],dy[];
{

	char *last = code + n;

	aedbf[0] = WSF;
	obyte(aedbf,1);

	while(code < last){
		aedbf[0] = *code++;
		aedbf[1] = *dx++;
		aedbf[2] = *dy++;
		obyte(aedbf,3);
	}
	aedbf[0] = 0;
	obyte(aedbf,1);
}

dcl(rad)	/* draw	circle	*/
int rad;
{
		aedbf[0] = DCL;
		aedbf[1] = rad & 127;
		obyte(aedbf, 2);
}

frr(dx,	dy)	/* draw	filled rectangle relative */
int dx,	dy;
{
	aedbf[0] = FRR;
	aedbf[1] = dx;
	aedbf[2] = dy;
	obyte(aedbf, 3);
}

dfc(rad)	/* draw	fat circle */
int rad;
{
	aedbf[0]= DFC;
	aedbf[1]= rad &	127;
	obyte(aedbf,2);
}


dsp(patnum,pattern)		/* define stipple pattern */
int patnum;
register char pattern[];
{
	register char *bp = aedbf;

	if( (patnum < 1) || (patnum > 15) ){
		printf(" dsp **	pattern	number must be in 1..15\n");
		printf("	pattern	number = %d\n",patnum);
		exit(0);
	}
	*bp++ =	XTD;
	*bp++ =	DSP;
	*bp++ =	patnum;
	while(bp < &aedbf[11])
		*bp++ =	*pattern++;
	obyte(aedbf,11);
}



ifl()			/* interior fill */
{
	aedbf[0]= IFL;
	obyte(aedbf,1);
}

ofl()		/* overlay fill	*/
{
	aedbf[0]=OFL;
	obyte(aedbf,1);
}

gfl(mask,bcolor)	/* generalized overlay fill */
int mask,bcolor;
{
	aedbf[0]= GFL;
	aedbf[1]=mask;
	aedbf[2]=bcolor;
	obyte(aedbf,3);
}

dsf(code,hsize,vsize,n,mask,bits)	/* define special font */
int code,hsize,vsize;
register char mask[],bits[];
int n;
{
	int num;
	register char *last = mask+n;

	aedbf[0] = DSF;
	aedbf[1] = code;
	aedbf[2] = hsize;
	aedbf[3] = vsize;
	obyte(aedbf,4);

	num=(hsize*vsize+7)/8;

	while( mask < last ){
		obyte(mask++,1);
		obyte(bits,num);
		bits +=	num;
	}
	aedbf[0]=0;
	obyte(aedbf,1);
}

esf(hsize,vsize,dx,dy)	/* erase special font */
int hsize,vsize,dx,dy;
{
	aedbf[0] = ESF;
	aedbf[1] = hsize;
	aedbf[2] = vsize;
	aedbf[3] = dx;
	aedbf[4] = dy;
	obyte(aedbf,5);
}

/*	dai now	requires 2 x,y pairs as	arguments. */
/*	the first pair define CAP, second pair	*/
/*	define 'opposite corner' of AOI.	*/

dai(capx, capy,	oppx, oppy)	/* define area of interest */
int capx, capy,	oppx, oppy,;
{
	aedbf[0] = MOV;			/* aedbf[0..3] hold */
	encode(&aedbf[1], capx,	capy);	/* MOV(capx,capy) code */

	aedbf[4] = DAI;			/* aedbf[4..7] hold	*/
	encode(&aedbf[5],oppx, oppy);	/* DAI(oppx,oppy code	*/

	obyte(aedbf, 8);
}


/*	read horizontal	runs from AOI			*/
/*	byt must be at least 2*isize+1 bytes long.	*/
/*	byt gets up to isize color/count pairs,	+ the	*/
/*	null byte terminator sent by the terminal.	*/
/*	returns	number of count/color pairs read.	*/

rhr(isize,byt)
int isize;
char byt[];
{
	register int i;
	register char *bp = byt,
			*last =	byt + (isize <<	1);
	aedbf[0]= RHR;
	obyte(aedbf,1);
	ibyte(bp,1);	/* read	first count	*/

	while((bp<last)	&& *bp){	/* if there's room and count !=	0 */
		ibyte(aedbf,2);
		*++bp =	aedbf[0];	/* buffer this color	*/
		*++bp =	aedbf[1];	/* and next count	*/
	}
	/* if bp < last	then *bp = 0 and less than isize pairs were */
	/* read. figure	out how	many there are and return it.	*/

	if(bp<last)
		return((bp-byt)>>1);

	/* bp =	last. if *bp ==	0 thats	good, we got isize runs	*/
	/* else	we have	array overflow,	so gobble up the rest	*/
	/* of the color/count pairs and	quit	*/

	if(*bp == 0)
		return(isize);

	do{	/* gobble */
		ibyte(aedbf,2);	/* get color,count */
	}while(	aedbf[1] );	/* while count != 0 */

	printf(" aed: ** rhr **	 array overflow	\n");
	exit(0);

}

/*		RHS -- read AOI, starting at CAP.	*/
/*		read entire AOI	into byt, n MUST be	*/
/*		number of bytes	in AOI as previously	*/
/*		defined	via DAI	command.		*/


rhs(n,byt)
int n;
char byt[];
{
	aedbf[0]=RHS;
	obyte(aedbf,1);
	ibyte(byt,n);
}

whc(n16,byt)	/*write	horizontal scan	( non AOI ) */
int n16;
char byt[];
{
	aedbf[0] = WHC;
	aedbf[1] = (*(((char*)(&n16))+1);
	aedbf[2] = (*((char*)(&n16)));
	obyte(aedbf,3);
	obyte(byt,n16);
}

whr(byt)	/* write horizontal runs */
char byt[];
{
	register int i;
	register char *bp = byt;

	aedbf[0]= WHR;
	obyte(aedbf,1);

/*	byt is a sequence of count/color pairs,	terminated
	by a count of zero.  find the length of	the sequence
	and send it.  length must be < 32768.
*/

	for ( i=0; (i >= 0) && *bp; i+=2, bp +=2);
	if ( i < 0 ) {
		 printf( " aed:	** whr ** error	!\n " );
		 exit(0);
	}
	i++;
	obyte(byt,i);
}

whs(n,byt)	/* write horizontal scan */
int n;
char byt[];
{
	aedbf[0]= WHS;
	obyte(aedbf,1);
	obyte(byt,n);
}

whu(n,byt)	/* write horizontal run	alternate */
int n;
char byt[];
{
	if ( byt[n-1] != 0 ) {
		printf(	" aed: ** whu ** no termination	! \n " );
		exit(0);
	}
	aedbf[0]= WHU;
	obyte(aedbf,1);
	obyte(byt,n);
}

/*	this code forces the reserved bits to	*/
/*	zero - needs to	be changed if they ever	*/
/*	acquire	meaning.			*/
/*	probably we should also	make sure that	*/
/*	bit 5 (16 bit transfers) is set, but	*/
/*	that may be crossing the line between	*/
/*	doing for and doing to.			*/

suc(byt)	/* set up counters for dma */
int byt;
#define	RESERVED (128+64)	/* most	significant 2 bits */

{
	aedbf[0]= SUC;
	aedbf[1]= (byt & ~RESERVED);
	obyte(aedbf,2);
}

drl(val)	/* define LED register */
int val;
{
	aedbf[0] = DRL;
	aedbf[1] = val;
	obyte(aedbf, 2);
 }

dpk(keyno,icode)		/* define programmable key */
int keyno;
register char icode[];
{
	register char *bp = aedbf,
		      *last =  &(aedbf[10]);

	if( (keyno < 0)	|| (keyno > 7) ){
		printf(" dsk **	bad key	number : %d\n",	keyno);
		printf(" key number must be in 0..7\n");
		exit(0);
	}

	*bp++ =	DPK;
	*bp++ =	keyno;

	while( (bp < last) && (*icode) )
		*bp++ =	*icode++;
	if(bp <	last)
		*bp++ =	0;
	obyte(aedbf, bp	- aedbf);
}

dsk(nkey,nbytes,byte)		/* define soft key */
char byte[];
register int nkey,nbytes;
{

	if( (nkey >=0)	&& (nkey < 8)
	&&  (nbytes >= 0) && (nbytes < 16) ){
		aedbf[0] = DSK;
		aedbf[1] = nkey;
		aedbf[2] = nbytes;
		obyte(aedbf,3);
		if(nbytes)
			obyte(byte,nbytes);
		return;
		}
	else{
		printf(" dsk **	invalid	arg(s) :\n");
		printf(" key = %d, count = %d\n",nkey, nbytes);
		printf(" must have key in 0..7,	count in 0..15\n");
		exit(0);
	}
}

scs(byt)	/* set console status */
int byt;
{
	aedbf[0] = SCS;
	aedbf[1] = byt;
	obyte(aedbf,2);
}

esc()	/*  ESC	- Enter	interpreter mode.  */
{
	aedbf[0] = ESC;
	obyte(aedbf, 1);
}

xxx()	/* exit	interpeter, enter text mode	*/
	/* recommend you use alf(), since xxx()	*/
	/* unfortunately causes	a CR to	be	*/
	/* performed in	single char mnemonic mode */

{
	aedbf[0] = XXX;
	obyte(aedbf,1);
}

/*	a frequent source of difficulty	is omitting
	sif('P') after the original tapint().  tapint should
	probably do it,	but then where would those people
	who actually want serial be ?
*/

sif(type)	/* select interface for	returning */
int type;	/* data	to host			*/
{
	switch(type){

	case	'S': /*	return data via	serial interface	*/
	case	'P': /*	    "	"	parallel "		*/
	case	'M': /*	return keystrokes over serial,other	*/
		     /*	over parallel				*/
	case	'D': /*	display	(don't send) returned data	*/

		 aedbf[0] = SIF;
		 aedbf[1] = type;
		 obyte(aedbf,2);
		 return;

	default:
		printf(" sif **	invalid	arg ** %c\n", type);
		printf(" use one of S P	M D\n");
		exit(0);
	}
}

ers()		/* erase  screen */
{
	aedbf[0] = ERS;
	obyte(aedbf, 1);
}


ffd()			/* form	feed */
{
	aedbf[0]= FFD;
	obyte(aedbf,1);
}

opt(opt1,value)			/* set programmable option switch */
int  opt1,value;
{

	if( (opt1 >= 0)	&& (opt1 < 8) ){
		aedbf[0] = OPT;
		aedbf[1] = opt1;
		aedbf[2] = (value ? 1 :	0);
		obyte(aedbf,3);
		}
	else{
		printf(" opt **	invalid	arg %d\n",opt1);
		printf(" option	must be	in 0..7\n");
		exit(0);
	}
}
rst()				/* reset the terminal */
{
	aedbf[0]=RST;
	obyte(aedbf,1);
	sleep(-60);		/* wait	a second	*/
}

scr()		/* send	carriage return	*/
{
	aedbf[0] = SCR;		/* ask for CR */
	obyte(aedbf,1);	/* wait	for it */
	ibyte(aedbf,1);
}

sbr(main,aux)			/* set baud rate */
int main,aux;
{
	if(  ( ((main <	8) && (main >= 0)) || (main == '.') )
	   &&
	     ( ((aux < 8) &&  (aux >= 0))  || (aux == '.' ) )  ){
		aedbf[0] = SBR;
		aedbf[1] = main;
		aedbf[2] = aux;
		obyte(aedbf,3);
		}
	else{
		printf(" sbr **	invalid	arg(s) %d %d\n", main, aux);
		printf(" args must be in 0..7\n");
		exit(0);
	}
}

/*	wait delay/60 seconds before sending	*/
/*	serial data to host.			*/

std(delay)	/* set turnaround delay	*/
int delay;
{
	aedbf[0] = STD;
	aedbf[1] = delay;
	obyte(aedbf,2);
}

sho(x10)		/* set horizontal origin */
int x10;		/* to some value in 0..1023 */
{
	aedbf[0] = SHO;
	aedbf[1] = (*(((char*)(&x10))+1)) & 03;
	aedbf[2] = (*((char*)(&x10)));
	obyte(aedbf,3);
}

svo(y10)	/* set vertical	origin */
int y10;	/* to some value in 0..1023 */
{
	aedbf[0] = SVO;
	aedbf[1] = (*(((char*)(&y10))+1)) & 03;
	aedbf[2] = (*((char*)(&y10)));
	obyte(aedbf,3);
}

/*	return horizontal origin in ox and as function	*/
/*	value.	returned value is in 0..1023		*/

rho(ox)				/* read	horizontal origin */
int *ox;
{
	aedbf[0]= RHO;
	obyte(aedbf,1);
	ibyte(aedbf,2);

	(*(((char*)(ox))+1)) = aedbf[0] &	03;
	(*((char*)(ox))) = aedbf[1];

	return(*ox);
}

/*	return current vertical	origin in y and	as	*/
/*	function value.	 value returned	is in 0..1023  */

rvo(y)				/* read	vertical origin	*/
int *y;
{
	aedbf[0] = RVO;
	obyte(aedbf,1);
	ibyte(aedbf,2);

	(*(((char*)(y))+1)) = aedbf[0] & 03;
	(*((char*)(y))) = aedbf[1];
	return(*y);
}

szr(x,y)	/* set zoom register */
int x,y;
{
	if( (x<1) || (x>16) || (y<1) ||	(y>16) ){
		printf(" szr **	bad zoom factor(s): %d %d\n",x,y);
		printf(" zoom factors must be in 1..16\n");
		exit(0);
	}
	aedbf[0] = SZR;
	aedbf[1] = x;
	aedbf[2] = y;
	obyte(aedbf,3);
}


hsr(dx)			/* horizontal scroll relative */
int dx;
{
	aedbf[0] = HSR;
	aedbf[1] = dx;
	obyte(aedbf,2);
}

vsr(dy)		/* vertical scroll relative */
int dy;
{
	aedbf[0] = VSR;
	aedbf[1] = dy;
	obyte(aedbf,2);
}

bso(x10,y10)		/* set horizontal and vertical origins */
int x10,y10;
{
	aedbf[0]= BSO;
	aedbf[1]= (*((char*)(&x10))+1)) & 03;	/* h and v origins must	be */
	aedbf[2]= (*((char*)(&x10)));	/* in 0..1023		   */
	aedbf[3]= (*(((char*)(&y10))+1)) & 03;
	aedbf[4]= (*((char*)(&y10)));
	obyte(aedbf,5);
}
dpa()				/* disable pan */
{
	aedbf[0]= DPA;
	obyte(aedbf,1);
}

epa()			/* enable panning */
{
	aedbf[0]= EPA;
	obyte(aedbf,1);
}


dtm(ixo,iyo,ixscal,iyscal)	/* define tablet mapping */
int ixo,iyo;
int ixscal,iyscal;
{
	aedbf[0] = DTM;
	aedbf[1] = (*(((char*)(&ixo))+1));
	aedbf[2] = (*((char*)(&ixo)));
	aedbf[3] = (*(((char*)(&iyo))+1));
	aedbf[4] = (*((char*)(&iyo)));
	aedbf[5] = ixscal;
	aedbf[6] = iyscal;
	obyte( aedbf,7);
}

etc(key,iflag,icode,ix,iy)	/* enable tablet cursor	and read cursor	*/
int *key,*iflag,*icode;		/*  position */
int *ix,*iy;
{
	aedbf[0] = ETC;
	aedbf[1] = 126;	/* 126 is tablet id char	*/
	obyte(aedbf,2);

	/*	poll tablet until id char comes	back	*/

	*key = 0;
	while( *key != 126 ){
		ibyte(key,1);
	}

	ibyte(&aedbf[2],5);	/* aedbf[2] because we're not	*/
				/* done	with aedbf[0]		*/

	*iflag = (aedbf[2] >> 4	) &15;
	*icode = aedbf[2] & 15;
	(*(((char*)(ix))+1)) = aedbf[3];
	(*((char*)(ix))) = aedbf[4];
	(*(((char*)(iy))+1)) = aedbf[5];
	(*((char*)(iy))) = aedbf[6];

	aedbf[1]=0;	/* disable tablet */
	obyte(aedbf,2);
}

etp(idchar)		/* enable (idchar!=0) disable (idchar=0) tablet	*/
int idchar;
{
	aedbf[0] = XTD;
	aedbf[1] = ETP;
	aedbf[2] = idchar;
	obyte(aedbf,3);
}

rtp(idchar,istat,ix,iy)	/* read	tablet position	*/
int *idchar,*istat;
int *ix,*iy;
{
	aedbf[0]= RTP;
	obyte(aedbf,1);
	ibyte(aedbf,6);

	*idchar	= aedbf[0];
	*istat = aedbf[1];
	(*(((char*)(ix))+1)) = aedbf[2];
	(*((char*)(ix))) = aedbf[3];
	(*(((char*)(iy))+1)) = aedbf[4];
	(*((char*)(iy)) = aedbf[5];
}

stp(parm)	/* set tablet parameters */
int parm;
{
	aedbf[0] = XTD;
	aedbf[1] = STP;
	aedbf[2] = parm;
	obyte(aedbf,3);
}
/*****************************************************/

/*	DMA specific functions appear below	*/

/* aoidma and dmaraster	are new	entries	in aedsubs.c	*/

extern aoidma(),	/* for r/w access to /dev/aedimaoi	*/
       dmaraster();	/* for r/w access to /dev/aedimage	*/

/*	rflag, wflag are passed	as parameters to the	*/
/*	above functions	by the below functions.		*/

static char rflag = 0;	/* requests  read	*/
static char wflag = 1;	/* requests write	*/

/*	Please note that the parameters	to	*/
/*	these DMA functions differ from	similar	*/
/*	non DMA	functions - n is buffer	size	*/
/*	in WORDS and the buffer	is required to	*/
/*	to be on an even address.		*/
/*	It may be good practice	to declare	*/
/*	your buffer and	access it as follows:	*/
/*

#define	DMABUFSIZE 'some even number of	bytes'
int dmabuf[ DMABUFSIZE / 2 ];	 declare as int	for even address
				 2 bytes per int, so size = nbytes/2

char *dmabytes = (char *)dmabuf;  dmabytes is a	char pointer that can
				  be used as if	it were	an array name,
				  we'll	use it to get at the bytes in
				  dmabuf

	for(i=0;i<DMABUFSIZE; i++)
		dmabytes[i] = 'some byte value';
*/



/*	Read Direct from AOI - DMA function.	*/
/*	n should equal AOIsize,	where AOIsize	*/
/*	is half	the number of pixels in	the AOI	*/
/*	defined	in a previous DAI command.	*/
/*	buf must be at least 2*n bytes long,	*/
/*	and start on an	even address.		*/

rda(buf,n)
int n;
{
	aoidma(buf,n<<1,rflag);
}

wda(buf,n)	/* same	as rda,	except write instead of	read	*/
int n;
char *buf;
{
	aoidma(buf,n<<1,wflag);
}

/*	Read Raster Direct	*/
/*	buf must be at least		*/
/*	2*n bytes long and start on an even add.	*/

rrd(buf,n)
int n;
char *buf;
{
	dmaraster(buf,n<<1,rflag);
}

wrd(buf,n)	/* as above, write instead of read	*/
int n;
char *buf;
{
	dmaraster(buf,n<<1,wflag);
}

/*	end of DMA functions	*/

/********************************************************
*							*
*		miscellaneous subroutines		*
*							*
*********************************************************/

/* tapint MUST be called BEFORE	any other TAP function */

tapint(arg1, arg2)
int arg1, arg2;		/* no current usage	*/
{
	esc();
	rst();
	esc();
}

/* conversion of x,y coord. to xy20 format */

encode(add, x, y)
register char *add;
int x,y;
{
	*add++ = (*(((char*)(&x))+1)) << 4) | (*(((char*)(&y))+1)) & 15);
	*add++ = x;
	*add = y;
}


alf()	/*  ALF	- Enter	alphanumeric mode.  */
{
	aedbf[0] = ALF;
	obyte(aedbf, 1);
}

txt(buf, dir)	/* Print text string, exit interpreter ON. */
register char *buf;/* Pointer to text aedbfer. Ignore '\n', stop on 0. */
int dir;	/* if(dir == 0)	print left; else print down; */
{
	static char iobuf[] = {' ', ESC, MVR, 0, 0, ALF};
	register char	*blast;	/* pointer to end of printable text */

	alf();			/* switch to alpha.	*/
	switch(dir){

		case 0 : /* print left */

			for(;;){

			/* advance buf to next printable
			 char or end of	text (null byte) */

			while( (*buf) && !((*buf >= ' ')&&(*buf <= '~')) )
				buf++;

			if(*buf	== 0) /* end of	text */
				break;

			blast =	buf;

			/* advance blast to next unprintable
			  char or end of text */

			while( (*blast)	&& ((*blast>=' ')&&(*blast<='~')))
				blast++;

			obyte(buf, blast - buf);
			buf = blast;
			}

		default	: /* print down	*/

				    /* xspace, yspace (	set in sap()) are */
			iobuf[3] = -xspace; /* args to MVR, called after */
			iobuf[4] = -yspace; /* each char output.	*/

			while(*buf){
				if( ((*buf>=' ')&&(*buf<='~')) ){
					iobuf[0] = *buf;
					obyte(iobuf,sizeof(iobuf));
				}
				buf++;
			}
			break;

	} /* end of switch */
	esc();
	return;
}

/*	end of miscellaneous subroutines	*/

/************************************************
*						*
*	functions available on 767, 1024	*
*						*
*************************************************/

dfp(tmp_color,vnum,xycoor)	/* draw	filled polygon	*/
int tmp_color;		/* flag	color			*/
int vnum;		/* number of polygon vertices	*/
register int (*xycoor)[2];
{
	register int (*last)[2]	= xycoor[vnum];

	if(vnum	< 3){
		printf(" dfp **	too few	vertices : %d\n",vnum);
		exit(1);
	}

	aedbf[0] = DFP;
	aedbf[1] = tmp_color;
	aedbf[2] = (*(((char*)(&vnum))+1));
	aedbf[3] = (*((char*)(&vnum)));
	obyte(aedbf,4);

	for( ; xycoor <	last; xycoor++ ){
		encode(aedbf,(*xycoor)[0], (*xycoor)[1]);
		obyte(aedbf,3);
	}
}

/*	read num rgb triples from color	table	*/
/*	starting with color number startloc,	*/
/*	into red, green, blue, each of which	*/
/*	must be	at least num bytes long.	*/

rct(startloc,num,red,green,blue)	/* read	color look-up table */
int startloc,num;
char red[], green[], blue[];
{
	int numx3;
	register char	*ct;
	register char	*r = red,
			*g = green,
			*b = blue;
	char	*last;

	aedbf[0]= XTD;
	aedbf[1]= RCT;
	aedbf[2]= startloc;

/*
	make sure that we don't	ask for	more of
	the color table	than there is to get,
	else ibyte will	hang.
*/
	startloc &= 0377;
	if( (num &= 0377) == 0)
		num = 256;
	if(startloc + num > 256)
		num = 256 - startloc;
	aedbf[3] = num;
	obyte(aedbf,4);
	numx3 =	num * 3;

	ibyte(aedct, numx3);
	last = aedct + numx3;

	for(ct = aedct;	ct < last; ){
		*r++ = *ct++;
		*g++ = *ct++;
		*b++ = *ct++;
	}
	return;
}
lat(basecol,rlknum)		/* load	color table number with	*/
int basecol;			/* user	defined	antialiasing ramp */
register char rlknum[];

/*	note that this routine uses aedct for output buffer.	*/
/*	idea is	not to do 2 obytes if we can do	it with	one.	*/
/*	for no good reason aedbf is 16 bytes, we need 19 here	*/
/*	for commands and data.					*/
{
	register char *bp = aedct;

	if( (basecol > 7) || (basecol <	0) ){
		printf(" lat **	invalid	base color %d\n", basecol);
		printf(" base color must be in 0..7\n");
		exit(0);
	}
	*bp++ =	XTD;
	*bp++ =	LAT;
	*bp++ =	basecol;
	while(bp < &aedct[19])
		*bp++ =	*rlknum++;
	obyte(aedct,19);
}
aav(arg)		/* anti-aliased	vector mode */
int arg;
{
	switch(arg){
	case 0:	/* turn	off anti-aliasing */
	case 1:	/* enable AAV, don't init color	table for default */
	case 2:	/* enable AAV, set up color table for default */

		aedbf[0] = XTD;
		aedbf[1] = AAV;
		aedbf[2] = arg;
		obyte(aedbf,3);
		return;
	default:
		printf(" aav **	invalid	arg : %d\n");
		printf(" valid args are	0 1 2\n");
		exit(0);
	}
}
elp(xsize,ysize)	/* draw	ellipse	*/
register int xsize,ysize;
{
	long f,xx,yy;

	xx = (xsize &= 0377);
	yy = (ysize &= 0377);
	xx *= xsize;
	yy *= ysize;

/*	terminal wants
	f = ( (min(x,y)/max(x,y)) ** 2 ) * 255)
	rounded	to nearest int,	f,x,y in 0..255
*/
	if( xx > yy)
		f = ( yy*255 + xx/2)/xx	;
	else
		f = ( xx*255 + yy/2)/yy	;

	aedbf[0]= XTD;
	aedbf[1]= ELP;
	aedbf[2]= xsize;
	aedbf[3]= ysize;
	aedbf[4]= f;
	obyte(aedbf,5);
}
blg(arg)				/* enable/disable blue line grid */
int arg;
{
	aedbf[0] = XTD;
	aedbf[1] = BLG;
	aedbf[2] = arg ? 1 : 0;
	obyte(aedbf,3);
}
/*	set Tektronix window size to 9 bits	*/
/*	if wsize = 0, 10 bits if n != 0.	*/

stw(wsize)
int wsize;
{
	aedbf[0]= XTD;
	aedbf[1]= STW;
	aedbf[2]= ( wsize ? 1 :	0);
	obyte(aedbf,3);
}

mar(xleft,xright)	/* set margin */
int xleft,xright;
{
	aedbf[0] = XTD;
	aedbf[1] = MAR;
	aedbf[2] = (*(((char*)(&(xleft))+1));
	aedbf[3] = (*((char*)(&xleft)));
	aedbf[4] = (*(((char*)(&xright))+1));
	aedbf[5] = (*((char*)(&xright)));
	obyte(aedbf,6);
}

/*	end of functions available on 767, 1024	*/

/************************************************
*						*
*	functions available on AED 1024	only	*
*						*
*************************************************/

/*	select character size	*/
/*	arg	charsize	*/
/*	1	5 x 6		*/
/*	2	7 x 9		*/
/*	3	5 x 6 (double)	*/
/*	4	7 x 9 (double)	*/

chr(arg)
int arg;
{

	if( (arg > 0) && (arg <	5) ){
		aedbf[0] = XTD;
		aedbf[1] = CHR;
		aedbf[2] = arg;
		obyte(aedbf,3);
	}
	else{
		printf(" chr **	invalid	arg %d\n");
		printf(" arg must be in	1..4\n");
	}
}

/*	copy area of interest, to an area of similar	*/
/*	size and shape whose lower left	corner is at	*/
/*	x, y.						*/

cai(x,y)
int x, y;
{
	aedbf[0] = XTD;
	aedbf[1] = CAI;
	encode(&(aedbf[2]), x, y);
	obyte(aedbf,5);
}

/*	rotate area of interest.		*/
/*	area of	interest is scrolled down	*/
/*	arg rows, with wraparound at the top.	*/

rot(arg)
int arg;
{
	aedbf[0] = XTD;
	aedbf[1] = ROT;
	aedbf[2] = arg;
	obyte(aedbf,3);
}

/*	display	terminal status			*/
/*	shows version #, CAP, current color	*/
/*	on the display monitor.			*/

aed()
{
	aedbf[0] = XTD;
	aedbf[1] = AED;
	obyte(aedbf,2);
}

rzr(x,y)		/* read	zoom registers	*/
int *x,	*y;
{
	aedbf[0] = XTD;
	aedbf[1] = RZR;
	obyte(aedbf,2);
	ibyte(aedbf,2);

	*x = aedbf[0];
	*y = aedbf[1];
}

/*	peek into terminal memory	*/
/*	pek(addr) returns the byte at	*/
/*	addr as	a function value, 0..255*/

pek(addr)
int addr;
{
	aedbf[0] = XTD;
	aedbf[1] = PEK;
	aedbf[2] = (*(((char*)(&addr))+1));
	aedbf[3] = (*(char*)(&addr)));

	obyte(aedbf,4);
	ibyte(aedbf,1);
	return(	aedbf[0] & 0377); /* no	sign extension,	thanks */
}

/*	poke into terminal memory	*/
/*	pok(addr,byte) does what you	*/
/*	might expect.			*/

pok(addr,byte)
int addr, byte;
{
	aedbf[0] = XTD;
	aedbf[1] = POK;
	aedbf[2] = (*(((char*)(&addr))+1));
	aedbf[3] = (*((char*)(&addr)));
	aedbf[4] = byte;
	obyte(aedbf,5);
}

/*	mask fill.			*/
/*	boundary pixels	are ....	*/
/*	area is	filled with ...		*/

/*	not implemented	yet

mfl()

{
	aedbf[0] = XTD;
	aedbf[1] = ?
	aedbf[2] = ?
	obyte(aedbf,?);
}
*/

/*	end of AED 1024	specific functions	*/

/************************************************
*						*
*	512 specific functions			*
*						*
*************************************************/

sup(arg)	/* enable/disable auto roam	*/
int arg;
{
	aedbf[0] = SUP;
	aedbf[1] = arg ? 1 : 0;
	obyte(aedbf,2);
}

sar(xysign,xrate,yrate)		/* set auto roam */
int xysign,xrate,yrate;
{
	aedbf[0] = SAR;
	aedbf[1] = xysign;
	aedbf[2] = xrate;
	aedbf[3] = yrate;
	obyte(aedbf,4);
}

/*	end of 512 specific functions.	*/
