C TAP.FTN  --  A.E.D. 512/767 TERMINAL ACCESS PACKAGE
C
C COPYRIGHT (C) 1980, 1981 AED
C REPRODUCTION OR PUBLICATION IN ANY FORM
C OR FORMAT IS PROHIBITED.
C PROPERTY OF ADVANCED ELECTRONICS DESIGN, INC.
C
C
C PROGRAM PN:	800007-01
C
C VERSION:	V01C
C
C DATE:		14-JUN-82
C
C MODIFICATION HISTORY:
C
C	09-SEP-80	INITIAL RELEASE.
C			CHANGES "FFD" TO USE 126.
C	30-JUN-81	CHANGED I/O BYTE CALLS TO ACCEPT MULTIPLE
C			BYTE TRANSFERS.
C			CORRECTED "TXT512" ROUTINE FOR RSX.
C			ADDED NEW FUNCTIONS: OPT,DPA,GFL,DSK,SAR,SAC,
C			STD, AND ERS).
C			REMOVED "TAPERR" TO 512 ROUTINE.
C	08-JAN-82	ADDED 767 FUNCTIONS DSP,RCT,ELP,AAV,BLG,DAC,DFP,SPF
C			ADDED NEW FUNCTION FRR
C	14-JUN-82	MODIFIED TAP FOR 512/767
C			CHANGED NUM512 TO NUMBER
C			CHANGED TXT512 TO TEXT
C			CHANGED DEL50 TO DEL200 FOR 512/767
C			RST NOW CALLS DEL200 INSTEAD OF DEL50
C	16-SEP-82	MODIFIED DFP FOR V782.09
C			DFP(NVERTS,ICORDS)--> DFP(IFLAG,NVERTS,ICORDS)
C			ADDED NEW FUNCTIONS: STP,STW,RTP,ETP
C	09-JUN-83	ADDED NEW FUNCTION CAI,ROT,CHR,AED,RZR
C	11-FEB-84	ADDED MAR FUNCTION FOR 767/1024
C			FIXED BUGS IN RHR, RHS, DSK, DPK, WIP
C	11-MAR-84	IS THERE A BUG IN LMR OR OP2OUT ?
C			I GET 'ATTEMPT TO STORE OUTSIDE OF PARTITION'.
C************************************************
C		COLOR SETUP			*
C************************************************
C
C
C SBC--SET BACKGROUND COLOR
C
	SUBROUTINE SBC(ICOLOR)
	BYTE	IB(776)
	COMMON	/IB/IB
	IB(1)=91
	IB(2)=ICOLOR
	CALL OBYTE(IB,2)
	RETURN
	END
C
C SEC--SET CURRENT COLOR
C
	SUBROUTINE SEC(ICOLOR)
	BYTE	IB(776)
	COMMON	/IB/IB
	IB(1)=67
	IB(2)=ICOLOR
	CALL OBYTE(IB,2)
	RETURN
	END
C
C SCT--SET UP COLOR TABLE
C
	SUBROUTINE SCT(IFIRST,N,REDS,GREENS,BLUES)
	BYTE	IB(776)
	COMMON	/IB/IB
	BYTE REDS(1),GREENS(1),BLUES(1)
	IB(1)=75
	IB(2)=IFIRST
	IB(3)=N
	DO 100 I=1,N
	  J=4+3*(I-1)
	  IB(J)=REDS(I)
	  IB(J+1)=GREENS(I)
	  IB(J+2)=BLUES(I)
100	CONTINUE
	CALL OBYTE(IB,3*N+3)
	RETURN
	END
C
C RCT--READ BACK COLOR TABLE
C
	SUBROUTINE RCT(IFIRST,N,REDS,GREENS,BLUES)
	BYTE IB(776),REDS(1),GREENS(1),BLUES(1)
	COMMON /IB/IB
	IB(1)=43
	IB(2)=35
	IB(3)=IFIRST
	IB(4)=N
	CALL OBYTE(IB,4)
	CALL IBYTE(IB,3*N)
	DO 100 I=1,N
	J=3*I
	REDS(I)=IB(J-2)
	GREENS(I)=IB(J-1)
	BLUES(I)=IB(J)
100	CONTINUE
	RETURN
	END
C
C SWM--SET WRITE MASK
C
	SUBROUTINE SWM(MASK)
	BYTE	IB(776)
	COMMON	/IB/IB
	IB(1)=76
	IB(2)=MASK
	CALL OBYTE(IB,2)
	RETURN
	END
C
C SRM--SET READ MASKS
C
	SUBROUTINE SRM(MASK0,MASK1,MASK2,MASK3)
	BYTE	IB(776)
	COMMON	/IB/IB
	IB(1)=77
	IB(2)=MASK0
	IB(3)=MASK1
	IB(4)=MASK2
	IB(5)=MASK3
	CALL OBYTE(IB,5)
	RETURN
	END
C
C SBL--SET BLINK
C
	SUBROUTINE SBL(ICOLOR,IRED,IGREEN,IBLUE,ONTIME,OFFTIM)
	BYTE	IB(776)
	COMMON	/IB/IB
	INTEGER ONTIME,OFFTIM
	IB(1)=52
	IB(2)=ICOLOR
	IB(3)=IRED
	IB(4)=IGREEN
	IB(5)=IBLUE
	IB(6)=ONTIME
	IB(7)=OFFTIM
	CALL OBYTE(IB,7)
	RETURN
	END
C
C
C************************************************
C		GRAPHICS			*
C************************************************
C
C
C MOV--MOVE
C
	SUBROUTINE MOV(IX,IY)
	BYTE	IB(776)
	COMMON	/IB/IB
	IB(1)=81
	CALL XYOUT(IX,IY,IB,2)
	CALL OBYTE(IB,4)
	RETURN
	END
C
C MVR--MOVE RELATIVE
C
	SUBROUTINE MVR(IDX,IDY)
	BYTE	IB(776)
	COMMON	/IB/IB
	IB(1)=105
	IB(2)=IDX
	IB(3)=IDY
	CALL OBYTE(IB,3)
	RETURN
	END
C
C WPX--WRITE PIXEL
C
	SUBROUTINE WPX(ICOLOR)
	BYTE	IB(776)
	COMMON	/IB/IB
	IB(1)=84
	IB(2)=ICOLOR
	CALL OBYTE(IB,2)
	RETURN
	END
C
C WMP--WRITE MULTIPLE PIXELS
C
	SUBROUTINE WMP(DXS,DYS)
	BYTE	IB(776)
	COMMON	/IB/IB
	BYTE DXS(1),DYS(1)
	IB(1)=107
	CALL OBYTE(IB,1)
	DO 200 J=1,128
	  DO 100 I=1,256
	    K=(J-1)*256+I
	    IB(2*I-1)=DXS(K)
	    IB(2*I)=DYS(K)
	    IF (DXS(K) .EQ. 0 .AND. DYS(K) .EQ. 0) GOTO 105
100	  CONTINUE
105	  CALL OBYTE(IB,2*I)
	  IF (DXS(K) .EQ. 0 .AND. DYS(K) .EQ. 0) RETURN
200	CONTINUE
	TYPE 500
500	FORMAT (1X,'*** WMP -- NO TERMINATING PIXEL ***')
	STOP 'TAP ERROR'
	END
C
C RPX--READ PIXEL VALUE
C
	INTEGER FUNCTION RPX(IVAL)
	BYTE	IB(776)
	COMMON	/IB/IB
	IB(1)=89
	CALL OBYTE(IB,1)
	CALL IBYTE(IVAL,1)
	RPX=IVAL 
	RETURN
	END
C
C DVA--DRAW VECTOR ABSOLUTE
C
	SUBROUTINE DVA(IX,IY)
	BYTE	IB(776)
	COMMON	/IB/IB
	IB(1)=65
	CALL XYOUT(IX,IY,IB,2)
	CALL OBYTE(IB,4)
	RETURN
	END
C
C DVR--DRAW VECTOR RELATIVE
C
	SUBROUTINE DVR(IDX,IDY)
	BYTE	IB(776)
	COMMON	/IB/IB
	IB(1)=108
	IB(2)=IDX
	IB(3)=IDY
	CALL OBYTE(IB,3)
	RETURN
	END
C
C DMV--DRAW MULTIPLE VECTORS
C
	SUBROUTINE DMV(DXS,DYS)
	BYTE	IB(776)
	COMMON	/IB/IB
	BYTE DXS(1),DYS(1)
	IB(1)=109
	CALL OBYTE(IB,1)
	DO 200 J=1,128
	  DO 100 I=1,256
	    K=(J-1)*256+I
	    IB(2*I-1)=DXS(K)
	    IB(2*I)=DYS(K)
	    IF (DXS(K) .EQ. 0 .AND. DYS(K) .EQ. 0) GOTO 105
100	  CONTINUE
105	  CALL OBYTE(IB,2*I)
	  IF (DXS(K) .EQ. 0 .AND. DYS(K) .EQ. 0) RETURN
200	CONTINUE
	TYPE 500
500	FORMAT (1X,'*** DMV -- NO TERMINATING VECTOR ***')
	STOP 'TAP ERROR'
	END
C
C AAV--ANTI ALIAS VECTORS
C
	SUBROUTINE AAV(IARG)
	BYTE IB(776)
	COMMON /IB/IB
	IB(1)=43
	IB(2)=36
	IB(3)=IARG
	CALL OBYTE(IB,3)
	RETURN
	END
C
C LAT--LOAD ANTI ALIAS COLOR TABLE
C
	SUBROUTINE LAT(IBASE,PVALS)
	BYTE IB(776),PVALS(1)
	COMMON /IB/IB
	IB(1)=43
	IB(2)=38
	IB(3)=IBASE
	DO 100 I=1,16
	IB(I+3)=PVALS(I)
100	CONTINUE
	CALL OBYTE(IB,19)
	RETURN
	END
C
C SLS--SET LINE STYLE
C
	SUBROUTINE SLS(IPAT,ISCALE)
	BYTE	IB(776)
	COMMON	/IB/IB
	IB(1)=49
	IB(2)=IPAT
	IB(3)=ISCALE
	CALL OBYTE(IB,3)
	RETURN
	END
C
C WIP--WRITE INCREMENTAL PLOTTER MODE
C
	SUBROUTINE WIP(N,BYTES)
	BYTE	IB(776)
	COMMON	/IB/IB
	BYTE BYTES(1)
	IB(1)=118
	CALL OP2OUT(N,IB,2)
	CALL OBYTE(IB,3)
	NB=(N+1)/2
	CALL OBYTE(BYTES,NB)
	RETURN
	END
C
C ARC.FOR--DRAW CIRCULAR ARCS
C USES WIP FUNCTION CODE
C
C (IXC,IYC)--CENTER OF CIRCLE
C IRAD--RADIUS
C SANG--STARTING ANGLE IN RADIANS (2 PI RADIANS PER CIRCLE)
C FANG--FINISHING ANGLE IN RADIANS
C IBUF--BUFFER TO HOLD PLOTTER CODES, 2 CODES PER ARRAY ELEMENT
C MAXBUF--SIZE OF IBUF
C
	SUBROUTINE ARC(IXC,IYC,IRAD,SANG,FANG,IBUF,MAXBUF)
C
	COMMON ITAB(9)
	DATA ITAB/5,4,3,6,10,2,7,0,1/
C
	BYTE IBUF(1)
	INTEGER ODD
C
	NINCS=0
	NEXT=0
	ODD=1
	TWOPI=6.283184
	RAD=IRAD
	N=RAD*TWOPI
C
	CONS=TWOPI/FLOAT(N)
	ISTART=SANG / CONS
	IFIN=  FANG / CONS
C
	DO 100 I=ISTART,IFIN
		ANG=FLOAT(I)*CONS
C
		IX=RAD*COS(ANG) + .5
		IX=IX+IXC
C
		IY=RAD*SIN(ANG) + .5
		IY=IY+IYC
C
		IF (I .NE. ISTART) GO TO 150
			CALL MOV(IX,IY)
			IPX=IX
			IPY=IY
150		IDX=IX-IPX
		IDY=IY-IPY
C
		IPX=IX
		IPY=IY
C
		ICODE=IDX*3+IDY+5
		ICODE=ITAB(ICODE)
		IF (ICODE .EQ. 10) GO TO 100		!DX,DY=0
		NINCS=NINCS+1
		IF (ODD .EQ. 1) GO TO 200
			IBUF(NEXT)=IBUF(NEXT)+ICODE
			GO TO 300
C
200		NEXT=NEXT+1
		IF (NEXT .GT. MAXBUF) STOP 'WIP BUFFER OVERFLOW'
		IBUF(NEXT)=ICODE*8
C
300		ODD=-ODD
100	CONTINUE
C
	CALL WIP(NINCS,IBUF)
	RETURN
	END
C
C DCL--DRAW CIRCLE
C
	SUBROUTINE DCL(IRAD)
	BYTE	IB(776)
	COMMON	/IB/IB
	IB(1)=79
	IB(2)=IRAD
	CALL OBYTE(IB,2)
	RETURN
	END
C
C DFC--DRAW FAT CIRCLE
C
	SUBROUTINE DFC(IRAD)
	BYTE	IB(776)
	COMMON	/IB/IB
	IB(1)=110
	IB(2)=IRAD
	CALL OBYTE(IB,2)
	RETURN
	END
C
C DFR--DRAW FILLED RECTANGLE
C
	SUBROUTINE DFR(IX,IY)
	BYTE	IB(776)
	COMMON	/IB/IB
	IB(1)=111
	CALL XYOUT(IX,IY,IB,2)
	CALL OBYTE(IB,4)
	RETURN
	END
C
C FRR--DRAW FILLED RECTANGLE RELATIVE
C
	SUBROUTINE FRR(IX,IY)
	BYTE IB(776)
	COMMON /IB/IB
	IB(1)=44
	IB(2)=IX
	IB(3)=IY
	CALL OBYTE(IB,3)
	RETURN
	END
C
C DSP--DEFINE STIPPEL PATTERN
C
	SUBROUTINE DSP(IDNO,IPAT)
	BYTE IB(776),IPAT(1)
	COMMON /IB/IB
	IB(1)=43
	IB(2)=33
	IB(3)=IDNO
	DO 100 I=1,8
	IB(I+3)=IPAT(I)
100	CONTINUE
	CALL OBYTE(IB,11)
	RETURN
	END
C
C SPF--SELECT PATERNED FILL
C
	SUBROUTINE SPF(IPATNO)
	BYTE IB(776)
	COMMON /IB/IB
	IB(1)=34
	IB(2)=IPATNO
	CALL OBYTE(IB,2)
	RETURN
	END
C
C DFP--DRAW FILLED POLYGON
C
	SUBROUTINE DFP(IFLAG,NVERTS,ICORDS)
	BYTE IB(776)
	INTEGER ICORDS(1)
	COMMON /IB/IB
	IB(1)=33
	IB(2)=IFLAG
	CALL OP2OUT(NVERTS,IB,3)
	CALL OBYTE(IB,4)
	DO 100 I=1,NVERTS
	CALL XYOUT(ICORDS(2*I-1),ICORDS(2*I),IB,1)
	CALL OBYTE(IB,3)
100	CONTINUE
	RETURN
	END
C
C ELP--DRAW ELIPSE
C
	SUBROUTINE ELP(IXSIZE,IYSIZE)
	BYTE IB(776)
	COMMON /IB/IB
	IB(1)=43
	IB(2)=34
	IB(3)=IXSIZE
	IB(4)=IYSIZE
	F=FLOAT(IXSIZE)/FLOAT(IYSIZE)
	IF (F.GT.1) F=1./F
	IB(5)=INT(255.*F*F+0.5)
	CALL OBYTE(IB,5)
	RETURN
	END
C
C IFL--INTERIOR FILL
C
	SUBROUTINE IFL
	BYTE	IB(776)
	COMMON	/IB/IB
	IB(1)=73
	CALL OBYTE(IB,1)
	RETURN
	END
C
C BFL--BOUNDARY FILL
C
	SUBROUTINE BFL(ICOLOR)
	BYTE	IB(776)
	COMMON	/IB/IB
	IB(1)=66
	IB(2)=ICOLOR
	CALL OBYTE(IB,2)
	RETURN
	END
C
C OFL--OVERLAY FILL
C
	SUBROUTINE OFL
	BYTE	IB(776)
	COMMON	/IB/IB
	IB(1)=86
	CALL OBYTE(IB,1)
	RETURN
	END
C
C GFL--GENERALIZED OVERLAY FILL
C
	SUBROUTINE GFL(IMASK,ICOLOR)
	BYTE	IB(776)
	COMMON	/IB/IB
	IB(1)=36
	IB(2)=IMASK
	IB(3)=ICOLOR
	CALL OBYTE(IB,3)
	RETURN
	END
C
C DSF--DEFINE SPECIAL FONT CHARACTERS (SYMBOL)
C      *** WILL NOT PRESENTLY WORK WITH 7-BIT OPERANDS
C
	SUBROUTINE DSF(ICODE,IXS,IYS,NPL,MASKS,BYTES)
	BYTE	IB(776)
	COMMON	/IB/IB
	BYTE BYTES(1),MASKS(1)
	N=(IXS*IYS+7)/8
C   FOR 7B OP'S, CHANGE "7)/8" TO "6)/7" IN PREV. LINE
	IB(1)=55
	IB(2)=ICODE
	IB(3)=IXS
	IB(4)=IYS
	CALL OBYTE(IB,4)
	INDEX=1
	DO 100 IPL=1,NPL
	  CALL OBYTE(MASKS(IPL),1)
	  IEND=INDEX+N-1
	  DO 200 I=INDEX,IEND
	    CALL OBYTE(BYTES(I),1)
200	  CONTINUE
	  INDEX=INDEX+N
100	CONTINUE
	IB(1)=0
	CALL OBYTE(IB,1)
	RETURN
	END
C
C WSF--WRITE SPECIAL FONT CHARACTER (SYMBOL)
C
	SUBROUTINE WSF(NCHAR,ICODES,IDXS,IDYS)
	BYTE	IB(776)
	COMMON	/IB/IB
	BYTE ICODES(1),IDXS(1),IDYS(1)
	IB(1)=56
	CALL OBYTE(IB,1)
	DO 100 I=1,NCHAR
	  IB(1)=(ICODES(I))
	  IB(2)=(IDXS(I))
	  IB(3)=(IDYS(I))
	  CALL OBYTE(IB,3)
100	CONTINUE
	IB(1)=0
	CALL OBYTE(IB,1)
	RETURN
	END
C
C ESF--ERASE SPECIAL FONT CHARACTER (SYMBOL)
C
	SUBROUTINE ESF(IXSIZE,IYSIZE,IDX,IDY)
	BYTE	IB(776)
	COMMON	/IB/IB
	IB(1)=57
	IB(2)=(IXSIZE)
	IB(3)=(IYSIZE)
	IB(4)=(IDX)
	IB(5)=(IDY)
	CALL OBYTE(IB,5)
	RETURN
	END
C
C
C************************************************
C		JOYSTICK AND CURSOR		*
C************************************************
C
C
C SCC--SET CURSOR COLORS
C
	SUBROUTINE SCC(ICOL1,ICOL2,IBLINK)
	BYTE	IB(776)
	COMMON	/IB/IB
	IB(1)=99
	IB(2)=ICOL1
	IB(3)=ICOL2
	IB(4)=IBLINK
	CALL OBYTE(IB,4)
	RETURN
	END
C
C SCP--SET CURSOR PARAMETERS
C
	SUBROUTINE SCP(ICTYPE,IHSIZE,IVSIZE)
	BYTE	IB(776)
	COMMON	/IB/IB
	IB(1)=93
	IB(2)=ICTYPE
	IB(3)=IHSIZE
	IB(4)=IVSIZE
	CALL OBYTE(IB,4)
	RETURN
	END
C
C EJC--ENABLE JOYSTICK/CURSOR
C
	SUBROUTINE EJC
	BYTE	IB(776)
	COMMON	/IB/IB
	IB(1)=85
	CALL OBYTE(IB,1)
	RETURN
	END
C
C DJC--DISABLE JOYSTICK/CURSOR
C
	SUBROUTINE DJC
	BYTE	IB(776)
	COMMON	/IB/IB
	IB(1)=100
	CALL OBYTE(IB,1)
	RETURN
	END
C
C RCP--READ CURRENT POSITION
C
	SUBROUTINE RCP(IX,IY)
	BYTE	IB(776)
	COMMON	/IB/IB
	IB(1)=106
	CALL OBYTE(IB,1)
	CALL XYIN(IX,IY)
	RETURN
	END
C
C DCA--DRAW CURSOR ABSOLUTE
C
	SUBROUTINE DCA(IX,IY)
	BYTE	IB(776)
	COMMON	/IB/IB
	IB(1)=112
	CALL XYOUT(IX,IY,IB,2)
	CALL OBYTE(IB,4)
	RETURN
	END
C
C ECU--ERASE CURSOR UNCONDITIONALLY
C
	SUBROUTINE ECU
	BYTE	IB(776)
	COMMON	/IB/IB
	IB(1)=53
	CALL OBYTE(IB,1)
	RETURN
	END
C
C RJP--READ JOYSTICK POSITION
C
	SUBROUTINE RJP(IX,IY)
	BYTE	IB(776)
	COMMON	/IB/IB
	IB(1)=113
	CALL OBYTE(IB,1)
	CALL XYIN(IX,IY)
	RETURN
	END
C
C
C************************************************
C		ZOOM, SCROLL, AND PAN		*
C************************************************
C
C
C SHO--SET HORIZONTAL ORIGIN
C
	SUBROUTINE SHO(IX)
	BYTE	IB(776)
	COMMON	/IB/IB
	IB(1)=102
	CALL OP2OUT(IX,IB,2)
	CALL OBYTE(IB,3)
	RETURN
	END
C
C HSR--HORIZONTAL SCROLL RELATIVE
C
	SUBROUTINE HSR(IDX)
	BYTE	IB(776)
	COMMON	/IB/IB
	IB(1)=119
	IB(2)=IDX
	CALL OBYTE(IB,2)
	RETURN
	END
C
C SVO--SET VERTICAL ORIGIN
C
	SUBROUTINE SVO(IY)
	BYTE	IB(776)
	COMMON	/IB/IB
	IB(1)=101
	CALL OP2OUT(IY,IB,2)
	CALL OBYTE(IB,3)
	RETURN
	END
C
C VSR--VERTICAL SCROLL RELATIVE
C
	SUBROUTINE VSR(IDY)
	BYTE	IB(776)
	COMMON	/IB/IB
	IB(1)=120
	IB(2)=IDY
	CALL OBYTE(IB,2)
	RETURN
	END
C
C BSO--SET BOTH VERTICAL AND HORIZONTAL ORIGINS
C
	SUBROUTINE BSO(IX,IY)
	BYTE	IB(776)
	COMMON	/IB/IB
	IB(1)=103
	CALL OP2OUT(IX,IB,2)
	CALL OP2OUT(IY,IB,4)
	CALL OBYTE(IB,5)
	RETURN
	END
C
C RHO--READ HORIZONTAL ORIGIN
C
	INTEGER FUNCTION RHO(IX)
	BYTE	IB(776)
	COMMON	/IB/IB
	IB(1)=121
	CALL OBYTE(IB,1)
	CALL OP2IN(IX)
	RHO=IX
	RETURN
	END
C
C RVO--READ VERTICAL ORIGIN
C
	INTEGER FUNCTION RVO(IY)
	BYTE	IB(776)
	COMMON	/IB/IB
	IB(1)=122
	CALL OBYTE(IB,1)
	CALL OP2IN(IY)
	RVO=IY
	RETURN
	END
C
C EPA--ENABLE PANNING
C
	SUBROUTINE EPA
	BYTE	IB(776)
	COMMON	/IB/IB
	IB(1)=104
	CALL OBYTE(IB,1)
	RETURN
	END
C
C DPA--DISABLE PANNING
C
	SUBROUTINE DPA
	BYTE	IB(776)
	COMMON	/IB/IB
	IB(1)=38
	CALL OBYTE(IB,1)
	RETURN
	END
C
C SZR--SET ZOOM REGISTERS
C
	SUBROUTINE SZR(IX,IY)
	BYTE	IB(776)
	COMMON	/IB/IB
	IB(1)=69
	IB(2)=IX
	IB(3)=IY
	CALL OBYTE(IB,3)
	RETURN
	END
C
C RZR--READ ZOOM REGISTERS
C
	SUBROUTINE RZR(IX,IY)
	BYTE    IB(776)
	COMMON  /IB/IB
	IB(1)=43
	IB(2)=47
	CALL OBYTE(IB,2)
	CALL IBYTE(IB,2)
	IX=IB(1)
	IY=IB(2)
	RETURN
	END
C
C SAR--SET AUTO ROAM
C
	SUBROUTINE SAR(ISIGN,IXR,IYR)
	BYTE	IB(776)
	COMMON	/IB/IB
	IB(1)=35
	IB(2)=ISIGN
	IB(3)=IXR
	IB(4)=IYR
	CALL OBYTE(IB,4)
	RETURN
	END
C
C
C************************************************
C		IMAGING				*
C************************************************
C
C
C DAI--DEFINE AREA OF INTEREST
C
	SUBROUTINE DAI(IX,IY,IX2,IY2)
	BYTE	IB(776)
	COMMON	/IB/IB
	IB(1)=81
	CALL XYOUT(IX,IY,IB,2)
	CALL XYOUT(IX2,IY2,IB,6)
	IB(5)=114
	CALL OBYTE(IB,8)
	RETURN
	END
C
C CAI--COPY AREA OF INTEREST
C
	SUBROUTINE CAI(IX,IY)
	BYTE    IB(776)
	COMMON /IB/IB
	IB(1)=43
	IB(2)=43
	CALL XYOUT(IX,IY,IB,3)
	CALL OBYTE(IB,5)
	RETURN
	END
C
C ROT-ROTATE AREA OF INRTEREST
C
	SUBROUTINE ROT(IN)
	BYTE    IB(776)
	COMMON  /IB/IB
	IB(1)=43
	IB(2)=44
	IB(3)=IN
	CALL OBYTE(IB,3)
	RETURN
	END
C
C WHS--WRITE HORIZONTAL SCAN
C
	SUBROUTINE WHS(N,BYTES)
	BYTE	IB(776)
	COMMON	/IB/IB
	BYTE BYTES(1)
	IB(1)=88
	CALL OBYTE(IB,1)
	CALL OBYTE(BYTES,N)
	RETURN
	END
C
C RHS--READ HORIZONTAL SCAN
C	
C	RHS is declared as a function for historical reasons
C	only.  The RHS command causes the terminal to send back
C	the entire contents of the (previously defined) AOI.
C	The parameter N should be the size (in bytes) of the AOI.
C	BYTES should be at least N bytes long.
C
	INTEGER FUNCTION RHS(N,BYTES)
	BYTE	IB(776)
	COMMON	/IB/IB
	BYTE BYTES(1)
	IB(1)=116
	IN=N
	CALL OBYTE(IB,1)
	CALL IBYTE(BYTES,IN)
	RHS=N
	RETURN
	END
C
C WHC--WRITE HORIZONTAL SCAN NON-AOI
C
	SUBROUTINE WHC(N,BYTES)
	BYTE	IB(776)
	COMMON	/IB/IB
	BYTE BYTES(1)
	IB(1)=117
	CALL OP2OUT(N,IB,2)
	CALL OBYTE(IB,3)
	CALL OBYTE(BYTES,N)
	RETURN
	END
C
C WHR--WRITE HORIZONTAL RUNS
C
	SUBROUTINE WHR(BYTES)
	BYTE	IB(776)
	COMMON	/IB/IB
	BYTE BYTES(1)
	IB(1)=92
	CALL OBYTE(IB,1)
	DO 100 I=1,32767,2
	  IF (BYTES(I) .EQ. 0) GO TO 200
100	CONTINUE
	IB(1)=0
	CALL OBYTE(IB,1)
	TYPE 500
500	FORMAT (1X,'*** WHR -- NO TERMINATING 0 ***')
	STOP 'TAP ERROR'
200	CALL OBYTE(BYTES,I)
	RETURN
	END
C
C RHR--read horizontal runs
C	ISIZE is the size of BYTES in bytes.
C	The return value is the number of color/count pairs read. 
C 	The total number of bytes returned is RHR*2+1.
C	The last byte is 0.
C
	INTEGER FUNCTION RHR(ISIZE, BYTES)
	BYTE	IB(776)
	COMMON 	/IB/IB
	BYTE BYTES(1)
	IB(1)=97
	CALL OBYTE(IB,1)
C
C	get first count
C
	CALL IBYTE(BYTES,1)
	IF(BYTES(1) .NE. 0) GOTO 10
C	
C	first count was zero.  probably can't happen in real
C	life but handle it correctly anyway.
C
	RHR=0		! set return value
	RETURN		! return
C
C	now read up to ISIZE/2 color/count pairs. 
C	
	J=0
10	DO 100 I=2,ISIZE,2
	CALL IBYTE(IB,2)
	BYTES(I)=IB(1)
	BYTES(I+1)=IB(2)
	J=J+1
	IF(IB(2) .EQ. 0) GOTO 300
100	CONTINUE
C
C	fell through loop, array overflow
C
200	CALL IBYTE(IB,2)
	IF(IB(2) .NE. 0) GOTO 200
	TYPE 210
210	FORMAT(1X,'*** RHR *** ARRAY OVERFLOW')
	STOP 'TAP ERROR'
C
C	normal exit here, from loop above
C
300	RHR=J/2
	RETURN
	END
C
C WHU--WRITE HORIZONTAL RUNS ALTERNATE
C
	SUBROUTINE WHU(N,BYTES)
	BYTE	IB(776)
	COMMON	/IB/IB
	BYTE BYTES(1)
	IB(1)=115
	IF(BYTES(N) .NE. 0) GO TO 100
	CALL OBYTE(IB,1)
	CALL OBYTE(BYTES,N)
	RETURN
C
100	TYPE 500
500	FORMAT (1X,'*** WHU -- NO TERMINATING 0 ***')
	STOP 'TAP ERROR'
	END
C
C
C************************************************
C		KEYBOARD AND CONSOLE		*
C************************************************
C
C
C DPK--DEFINE PROGRAMMABLE FUNCTION KEY
C
	SUBROUTINE DPK(KEYNO,ICODE)
	BYTE	IB(776)
	COMMON	/IB/IB
	BYTE ICODE(1)
	IB(1)=78
	IB(2)=KEYNO
	DO 100 I=1,8
	  IB(I+2)=(ICODE(I))
	  IF (ICODE(I) .EQ. 0) GO TO 200
100	CONTINUE
200	CALL OBYTE(IB,I+2)
	RETURN
	END
C
C DSK--DEFINE SOFTWARE KEY
C
	SUBROUTINE DSK(KEYNO,ISIZE,BYTES)
	BYTE	IB(776)
	COMMON	/IB/IB
	BYTE BYTES(1)
	IF (ISIZE .GT. 15) GO TO 100
	IB(1)=37
	IB(2)=KEYNO
	IB(3)=ISIZE
	CALL OBYTE(IB,3)
	IF(ISIZE .EQ. 0) GOTO 99
	CALL OBYTE(BYTES,ISIZE)
99	RETURN
C
100	TYPE 500
500	FORMAT (1X,'*** DSK -- KEY DEFINED .GT. 15 ***')
	STOP 'TAP ERROR'
	END
C
C DRL--DISPLAY REGISTER
C
	SUBROUTINE DRL(IVAL)
	BYTE	IB(776)
	COMMON	/IB/IB
	IB(1)=61
	IB(2)=IVAL
	CALL OBYTE(IB,2)
	RETURN
	END
C
C SCS--SET CONSOLE STATUS
C
	SUBROUTINE SCS(IBYTE)
	BYTE	IB(776)
	COMMON	/IB/IB
	IB(1)=96
	IB(2)=IBYTE
	CALL OBYTE(IB,2)
	RETURN
	END
C
C
C************************************************
C		GRAPHICS TABLE SUPPORT		*
C************************************************
C
C
C DTM--DEFINE TABLET MAPPING
C
	SUBROUTINE DTM(IXO,IYO,IXSCAL,IYSCAL)
	BYTE	IB(776)
	COMMON	/IB/IB
	IB(1)=50
	IB(6)=IXSCAL
	IB(7)=IYSCAL
	CALL OP2OUT(IXO,IB,2)
	CALL OP2OUT(IYO,IB,4)
	CALL OBYTE(IB,7)
	RETURN
	END
C
C ETC--ENABLE/DISABLE TABLET-CURSOR
C
	SUBROUTINE ETC(KEY,IFLAG,ICODE,IX,IY)
	BYTE	IB(776)
	COMMON	/IB/IB
	IB(1)=51
	IB(2)=126
	CALL OBYTE(IB,2)
	KEY=0
100	CALL IBYTE(ICHAR,1)
	IF (ICHAR .EQ. 126) GO TO 200
	KEY=ICHAR
	GO TO 100
200	CALL IBYTE(ISTAT,1)
	IFLAG=ISTAT/16
	ICODE=MOD(ISTAT,16)
	CALL OP2IN(IX)
	CALL OP2IN(IY)
	IB(2)=0
	CALL OBYTE(IB,2)
	RETURN
	END
C
C ETP--ENABLE TABLET POLLING
C
	SUBROUTINE ETP(IDCHAR)
	BYTE	IB(776)
	COMMON	/IB/IB
	IB(1)=43
	IB(2)=39
	IB(3)=IDCHAR
	CALL OBYTE(IB,3)
	RETURN
	END
C
C RTP--READ TABLET POLLING
C
	SUBROUTINE RTP(IDCHAR,ISTAT,IX,IY)
	BYTE	IB(776)
	COMMON	/IB/IB
	IB(1)=124
	CALL OBYTE(IB,1)
	CALL IBYTE(IDCHAR,1)
	CALL IBYTE(ISTAT,1)
	CALL OP2IN(IX)
	CALL OP2IN(IY)
	RETURN
	END
C
C STP--SET TABLET PARAMETERS
C
	SUBROUTINE STP(IBYTE)
	BYTE	IB(776)
	COMMON	/IB/IB
	IB(1)=43
	IB(2)=40
	IB(3)=IBYTE
	CALL OBYTE(IB,3)
	RETURN
	END
C
C
C************************************************
C		USER FIRMWARE			*
C************************************************
C
C
C LMR--LOAD MICROPROCESSOR RAM
C
	SUBROUTINE LMR(IFIRST,N,BYTES)
	BYTE	IB(776)
	COMMON	/IB/IB
	BYTE BYTES(1)
	IB(1)=58
C	CALL OP2OUT(IFIRST,IB,2)
C	CALL OP2OUT(N,IB,4)
	IB(2) = IFIRST/256
	IB(3) = MOD(IFIRST,256)
	IB(4) = N/256
	IB(5) = MOD(N,256)
	CALL OBYTE(IB,5)
	CALL OBYTE(BYTES,N)
	RETURN
	END
C
C JUS--JUMP USER SUBROUTINE
C
	SUBROUTINE JUS(IADDR)
	BYTE	IB(776)
	COMMON	/IB/IB
	IB(1)=59
	CALL OP2OUT(IADDR,IB,2)
	CALL OBYTE(IB,3)
	RETURN
	END
C
C SSE--SET STACK ENDPOINT
C
	SUBROUTINE SSE(IADDR)
	BYTE	IB(776)
	COMMON	/IB/IB
	IB(1)=125
	CALL OP2OUT(IADDR,IB,2)
	CALL OBYTE(IB,3)
	RETURN
	END
C
C
C************************************************
C		SUPEROAM SUPPORT		*
C************************************************
C
C
C SUP--SET SUPEROAM
C
	SUBROUTINE SUP(IARG)
	BYTE	IB(776)
	COMMON	/IB/IB
	IB(1)=45
	IB(2)=IARG
	CALL OBYTE(IB,2)
	RETURN
	END
C
C
C************************************************
C		DIRECT VIDEO MEMORY ACCESS	*
C************************************************
C
C
C SUC--SET UP COUNTERS FOR DVMA
C
	SUBROUTINE SUC(IBYTE)
	BYTE	IB(776)
	COMMON	/IB/IB
	IB(1)=63
	IB(2)=IBYTE
	CALL OBYTE(IB,2)
	RETURN
	END
C
C
C************************************************
C		ALPHANUMERICS			*
C************************************************
C
C
C HOM--HOME
C
	SUBROUTINE HOM
	BYTE	IB(776)
	COMMON	/IB/IB
	IB(1)=95
	CALL OBYTE(IB,1)
	RETURN
	END
C
C MAR - SET LEFT AND RIGHT TEXT MARGINS
C
	SUBROUTINE MAR(ILM, IRM)
	BYTE 	IB(776)
	COMMON	/IB/IB
	IB(1)= 43
	IB(2)= 42
	CALL OP2OUT(ILM,IB,3)
	CALL OP2OUT(IRM,IB,5)
	CALL OBYTE(IB,6)
	RETURN
	END
C
C SAP--SET ALPHA PARAMETERS
C
	SUBROUTINE SAP(ISIZE,IFONT,IXSPA,IYSPA,LINK)
	BYTE	IB(776)
	COMMON	/IB/IB
	IB(1)=94
	IB(2)=ISIZE
	IB(3)=IFONT
	IB(4)=IXSPA
	IB(5)=IYSPA
	IB(6)=LINK
	CALL OBYTE(IB,6)
	RETURN
	END
C
C CHR-SELECT CHARACTER SIZE
C
	SUBROUTINE CHR(IN)
	BYTE    IB(776)
	COMMON  /IB/IB
	IB(1)=43
	IB(2)=45
	IB(3)=IN
	CALL OBYTE(IB,3)
	RETURN
	END
C
C SAC--SET ALPHA CURSOR COLOR
C
	SUBROUTINE SAC(ICOLOR)
	BYTE	IB(776)
	COMMON	/IB/IB
	IB(1)=123
	IB(2)=ICOLOR
	CALL OBYTE(IB,2)
	RETURN
	END
C
C
C************************************************
C		MISCELLANEOUS TERMINAL		*
C			CONTROL			*
C************************************************
C
C
C ESC--ENTER INTERPRETER
C
	SUBROUTINE ESC
	BYTE	IB(776)
	COMMON	/IB/IB
	IB(1)=27
	IB(2)=0
	CALL OBYTE(IB,1)
	RETURN
	END
C
C ALF--RETURN TO ALPHA. MODE
C
	SUBROUTINE ALF
	BYTE	IB(776)
	COMMON	/IB/IB
	IB(1)=1
	CALL OBYTE(IB,1)
	RETURN
	END
C
C RST--FULL RESET OF AED 512/767
C
	SUBROUTINE RST
	BYTE	IB(776)
	COMMON	/IB/IB
	IB(1)=48
	CALL OBYTE(IB,1)
	CALL DEL200
	RETURN
	END
C
C BLG--BLUE GRID
C
	SUBROUTINE BLG(IARG)
	BYTE IB(776)
	COMMON /IB/IB
	IB(1)=43
	IB(2)=37
	IB(3)=IARG
	CALL OBYTE(IB,3)
	RETURN
	END
C
C FFD--FORM FEED
C
	SUBROUTINE FFD
	BYTE	IB(776)
	COMMON	/IB/IB
	IB(1)=12
	CALL OBYTE(IB,1)
	RETURN
	END
C
C ERS--ERASE SCREEN
C
	SUBROUTINE ERS
	BYTE	IB(776)
	COMMON	/IB/IB
	IB(1)=126
	CALL OBYTE(IB,1)
	RETURN
	END
C
C SIF--SELECT INTERFACE FOR RETURNED OPERANDS
C
	SUBROUTINE SIF(ICHAR)
	BYTE	IB(776)
	COMMON	/IB/IB
	IB(1)=72
	IB(2)=ICHAR
	CALL OBYTE(IB,2)
	RETURN
	END
C
C SCR--HAVE TERMINAL SEND A CARRIAGE RETURN
C
	SUBROUTINE SCR
	BYTE	IB(776)
	COMMON	/IB/IB
	IB(1)=62
	CALL OBYTE(IB,1)
	RETURN
	END
C
C SBR--SET BAUD RATES
C
	SUBROUTINE SBR(MAIN,IAUX)
	COMMON	/BR512/MAINBR
	BYTE	IB(776)
	COMMON	/IB/IB
	DATA MAINBR/5/
	MAINBR=MAIN
	IB(1)=98
	IB(2)=MAIN
	IB(3)=IAUX
	CALL OBYTE(IB,3)
	RETURN
	END
C
C STD--SET TURNAROUND DELAY (SERIAL COMMUNICATION)
C
	SUBROUTINE STD(IDELAY)
	BYTE	IB(776)
	COMMON	/IB/IB
	IB(1)=39
	IB(2)=IDELAY
	CALL OBYTE(IB,2)
	RETURN
	END
C
C OPT--SET OPTION (PROGRAMMABLE)
C
	SUBROUTINE OPT(IOPT,IVALUE)
	BYTE	IB(776)
	COMMON	/IB/IB
	IB(1)=40
	IB(2)=IOPT
	IB(3)=IVALUE
	CALL OBYTE(IB,3)
	RETURN
	END
C
C STW--SET TEKTRONICS WINDOW
C
	SUBROUTINE STW(IVAL)
	BYTE	IB(776)
	COMMON	/IB/IB
	IB(1)=43
	IB(2)=41
	IB(3)=IVAL
	CALL OBYTE(IB,3)
	RETURN
	END
C
C AED--DISPLAY AED TERMINAL STATUS
C
	SUBROUTINE AED
	BYTE    IB(766)
	COMMON  /IB/IB
	IB(1)=43
	IB(2)=46
	CALL OBYTE(IB,2)
	RETURN
	END
C
C
C************************************************
C		TAP SUBROUTINES			*
C************************************************
C
C
C
C XYOUT--INSTERT X,Y COORDINATE (OUT BUF)
C THIS VERSION ASSUMES 8-BIT ENCODING
C
	SUBROUTINE XYOUT(IX,IY,IZ,I)
	BYTE IZ(1)
	IZ(I)=((IX/256)*16 + IY/256)
	IZ(I+1)=(MOD(IX,256))
	IZ(I+2)=(MOD(IY,256))
	RETURN
	END
C
C OP2OUT--INSERT DOUBLE BYTE OPERAND (OUT BUF)
C THIS VERSION ASSUMES 8-BIT ENCODING
C
	SUBROUTINE OP2OUT(IBYTE,IZ,I)
	LOGICAL*1 BYTES(2),IZ(1)
	EQUIVALENCE (JBYTE,BYTES)
	JBYTE=IBYTE
	IZ(I)=(BYTES(2))
	IZ(I+1)=(BYTES(1))
	RETURN
	END
C
C XYIN--GET A COORDINATE FROM TERMINAL
C THIS VERSION ASSUMES 8-BIT ENCODING
C
	SUBROUTINE XYIN(IX,IY)
	BYTE IZ(3)
	CALL IBYTE(IZ,3)
	IX=IZ(2)
	IF(IX .LT. 0) IX=IX+256
	IY=IZ(3)
	IF(IY .LT. 0) IY=IY+256
	II=IZ(1)
	IX=(II/16)*256 + IX
	IY=MOD(II,16)*256 + IY
	RETURN
	END
C
C OP2IN--RETURN WORD LENGTH OPERAND FROM AED 512/767
C THIS VERSION ASSUMES 8-BIT ENCODING
C
	SUBROUTINE OP2IN(IARG)
	BYTE BYTES(2)
	CALL IBYTE(BYTES,2)
	IARG=BYTES(2)
	IF(IARG.LT.0) IARG=IARG+256
	IARG=IARG+BYTES(1)*256
	RETURN
	END
C
C NUMBER--WRITE AN INTEGER AT CAP.
C
	SUBROUTINE NUMBER(NUM,IWIDTH)
	BYTE	IB(776)
	COMMON	/IB/IB
	CALL ALF
	IQUO=NUM
	NEG=0
	IF (IQUO .GE. 0) GO TO 70
	NEG=1
	IQUO=0-IQUO
70	DO 500 IDIG=1,7
	  CALL PUSH(MOD(IQUO,10))
	  IQUO=IQUO/10
	  IF (IQUO .EQ. 0) GO TO 600
500	CONTINUE
600	IF (IWIDTH .EQ. 0) GO TO 800
	IREQ=IDIG+NEG
	NSPA=IWIDTH-IREQ
	IF (NSPA .GE. 0) GO TO 700
	DO 900 I=1,IWIDTH
	  IB(I)='*'
900	CONTINUE
	  CALL OBYTE(IB,IWIDTH)
	DO 400 I=1,IDIG
	  CALL POP(L)
400	CONTINUE
	GO TO 1000
700	IF (NSPA .EQ. 0) GO TO 800
	DO 1100 I=1,NSPA
	  IB(I)=' '
1100	CONTINUE
800	IF (NEG.EQ.0) GOTO 823
	IB(NSPA+1)='-'
	NSPA=NSPA+1
823	DO 200 I=1,IDIG
	  CALL POP(L)
	  IB(I+NSPA)=L+48
200	CONTINUE
	  CALL OBYTE(IB,IWIDTH)
1000	CALL ESC
	RETURN
	END
C
C NUM512--OLD NUMBER TITLE (OBSOLETE)
C
	SUBROUTINE NUM512(NUM,IWIDTH)
	CALL NUMBER(NUM,IWIDTH)
	RETURN
	END
C
C PUSH--PUSH AN INTEGER ONTO STACK
C
	SUBROUTINE PUSH(IARG)
	INTEGER STACK,STACKP
	COMMON /TAPSTK/STACKP,STACK(100)
	DATA STACKP/0/
	STACKP=STACKP+1
	IF (STACKP .GT. 100) GO TO 100
	STACK(STACKP)=IARG
	RETURN
C
100	TYPE 500
500	FORMAT (1X,'*** PUSH -- STACK OVERFLOW ***')
	STOP 'TAP ERROR'
	END
C
C POP--POP AN INTEGER FROM STACK
C
	SUBROUTINE POP(IARG)
	INTEGER STACK,STACKP
	COMMON /TAPSTK/STACKP,STACK(100)
	IF (STACKP .EQ. 0) GO TO 100
	IARG=STACK(STACKP)
	STACKP=STACKP-1
	RETURN
C
100	TYPE 500
500	FORMAT (1X,'*** POP -- STACK UNDERFLOW ***')
	STOP 'TAP ERROR'
	END
C
C TEXT--DRAW A TEXT STRING AT CAP.  EXIT WITH INTERP. ACTIVE
C
C	CARRAIGE CONTROL, FIRST CHARACTER IN MESSAGE
C
C	     SPACE - ADVANCE ONE LINE (CR,LF)
C	  0   ZERO - ADVANCE TWO LINES (CR,LF,LF)
C	  1    ONE - TOP OF SCREEN (HOME)
C	  +   PLUS - TYPE ON SAME LINE
C
C	SPECIAL CHARACTER
C
C	  $ DOLLOR SIGN - ANY WHERE IN MESSAGE WILL CAUSE
C			  ADVANCEMENT OF ONE LINE (CR,LF)
C
	SUBROUTINE TEXT(MESS)
	BYTE MESS(1),IB(776)
	COMMON /IB/IB
	IB(1)=1
	J=1
	IF (MESS(1) .EQ. "60) GO TO 20
	IF (MESS(1) .EQ. "61) GO TO 30
	IF (MESS(1) .EQ. "53) GO TO 50
	IF (MESS(1) .EQ. 0) GO TO 300
10	IB(J+1)="15
	IB(J+2)="12
	J=J+2
	GO TO 50
20	J=J+1
	IB(J)="12
	GO TO 10
30	CALL ESC
	CALL HOM
	IB(1)=1
50	DO 200 I=2,700
	  IF (MESS(I) .EQ. 0) GO TO 300
	  J=J+1
	  IF (MESS(I) .NE. "44) GO TO 100
	  IB(J)="15
	  J=J+1
	  IB(J)="12
	  GO TO 200
100	  IB(J)=MESS(I)
200	CONTINUE
300	IB(J+1) = 27
	CALL OBYTE(IB,J+1)
C	CALL ESC
	RETURN
	END
C
C TXT512--OLD TEXT TITLE (OBSOLETE)
C
	SUBROUTINE TXT512(MESS)
	CALL TEXT(MESS)
	RETURN
	END
C
C DEL200--DELAY APPROX. 200 MSEC.  FOR USE WITH RESET ROUTINE
C
	SUBROUTINE DEL200
	IDL=200
	DO 100 I=1,IDL
	  DO 200 J=1,IDL
	    K=1
200	  CONTINUE
100	CONTINUE
	RETURN
	END
C
C DEL50--OLD DEL200 TITLE (OBSOLETE)
C
	SUBROUTINE DEL50
	CALL DEL200
	RETURN
	END
C
C TAPINT(IOPT)--INITIALIZE TAP
C
	SUBROUTINE TAPINT(I,J)
	CALL ESC
	CALL RST
	CALL ESC
	CALL FFD
	CALL ESC
	RETURN
	END
C
C TAPDON(IOPT)--FINISH WITH TAP
C
	SUBROUTINE TAPDON(I)
	RETURN
	END
