#include <stdio.h>

/*
 *	wings linker 
 * 	
 *	wl
 * 
 *	version 1.1	1-may-85	mark krueger - mse
 *
 *	[C] 1985 AED,inc
 */

/*
 *	NOTE:	wa assembler must be fixed as follows :
 *
 *
 *	>	ABS mode bit not used
 *	>	REL or LITR mode bit set for all immobile code
 *	>	symbol index number include in EXT rel codes
 * 	>	symbol table output includes psect number in
 *		place of next symbol entry
 *	>	BYTE mode bit set for external dcb
 *	>	EXT symbols referenced across sects be flagged
 *		EXT and EXP
 *
 */  

#define	MWORD	011223		/* magic word for input file */
#define	SECTS	8		/* max number of program sections */
#define	WSIZE	2		/* word size in bytes */
#define OPSIZE	8		/* op code size in bits */
#define	MAXFILES 512		/* max number of input files */
#define	MAXSYMS	512		/* max number of symbols  per file*/
#define OUT	"w.out"		/* default output file name */
#define	SNAMLEN 8		/* length of symbol name */
#define	LDCMD	"dls"		/* load command */
#define	SFILE	"/tmp/wsym"	/* symbol file name */
#define	SYMSIZE	sizeof(struct ist) /* size of symbol table entry */
#define MEM	1		/* memory mode symbol storage */

#define	ASECT	0x200		/* program section is absolute */
#define	PSECT	0x400		/* program section is relocatable */
#define	HASREL	0x100		/* obj file has relocation bits */
#define HASSYM	0x200		/* obj file has symbol table    */
#define NONE	-1		/* nack reply word */

/*
 *   symbol table mode descriptors.
 *
 *   IDXMSK are the bits in the mode descriptor used to store
 *   the index of the global/external symbol for the external
 *   symbol table.
 *
 *	BYTE	= literal is one byte only
 *	EXPO	= defined by EXPORT pseudo-op
 *	EXT	= declared in EXTERN pseudo-op or label with 2 colons (::)
 *	LITR	= symbol is a constant ( op code, data, immediate operand )
 *	REL	= 1 = PC rel  0 = Absolute
 *
 *	IDXMSK	= the number of bits availible for global symbol index val
 */

#define	EXPO	0x2000
#define	EXT	0x1000
#define	LITR	0x0800
#define	REL	0x0400
#define IDXMSK	0x01ff
#define	BYTE	0x0200

/*
 *	internal symbol table flags ( in so.ism.e_sect ) 
 */

#define	UNDEF	0x2000		/* undefined symbol flag */
#define	COPY	0x4000		/* copy of undefined symbol */
#define	SMASK	0xf		/* mask for sect number */
	
/*
 *	flags for switches
 */

#define	NOUT	0x2	/*     output file select */
#define	STRIP	0x4	/* -s  strip symbol table from output */
#define	RELOUT	0x8	/* -r  make relocatable output */
#define	RARG	0x10	/*     flag to read another arg */
#define	MAP	0x20	/* -m  produce symbol map output */
#define	DEFINE  0x40	/* -d  define a sect origin value */
#define	LOAD	0x80	/* -x  load obj output when done */
#define	LOADGO	0x100	/* -g  specify load start address */
#define	NOWARN	0x200	/* -w  inhibit warning messages */
#define FMODE	0x400	/* -f  force file mode symbol table */
#define	NOUNLK	0x800	/* -p  preserve symbol table temp file */



/*
 *   struct definition
 */

struct	sect {			/* psect header */
	int	size;		/* size in bytes */
	int	add;		/* start address */
	int	attrib;		/* attributes ( psect asect ) */
	};

struct 	header {		/* file header for all psects */
	struct	sect psect[SECTS];
	};

struct	st	{			/* symbol table	*/
	char	s_name[SNAMLEN];	/* symbol name */
	int	s_value;		/* actual value	*/
	int	s_sect;			/* sect number  */
	int	s_mode;			/* symbol usage	*/
	long	s_dummy;		/* unused bytes */
	};

struct	ist	{			/* internal symbol table */
	char	e_name[SNAMLEN];	/* symbol name */
	int	e_value;		/* symbol value */
	int	e_sect;			/* psect # */
	int	e_mode;			/* symbol mode */
	int	e_file;			/* file # */
	int	e_old;			/* original value before adj */
	};

union soism {			/* symbol buffer (holds one ist record) */
	struct ist ism;		
	char mism[SYMSIZE];
};


union soism so;			/* symbol buffer (in and out) */
FILE *fopen(), *freopen();	/* file functions */
char out[20] = 	OUT;		/* output file name */
char sfile[20] = SFILE;		/* symbol file name */
char *inp[MAXFILES];		/* array of input file names */
int nfiles = 0;		 	/* number of input files */
int flag;			/* flag for opts switches */
static long pptr;		/* pointer into input file */
struct header hdr;		/* input file header */
struct header ohdr;		/* output file header */
int sects;			/* program section counter */
int symtot;			/* total number of symbols */
long optr = (long)(sizeof(struct header)+6) ; /* output pointer */
long osize;			/* size of output code sections */
int dval[SECTS];		/* defined section org value */
int dflg[SECTS];		/* defined section flag */
int cnt;			/* relocation counter */
int pcnt[SECTS];		/* relocation counters */
FILE *sout;			/* symbol table file out */
FILE *sin;			/* symbol table file in */
long *sptr;			/* symbol pointer ( file and mem ) */
int unsym;			/* undefined symbol flag */
static int uscnt = 0;		/* undefined symbol count */
int symcnt = 0;			/* total symbol count */
char *smptr;			/* memory symbol table pointer */
mode = 0;			/* symbol table storage mode */


main(argc,argv)
char *argv[];

{
	register int i, j;
	static char *buf;
	static char *tmpb;

	/*
	 *	read all args  
	 */

	for ( i = 1; i < argc; i++ ) {
		buf = argv[i]; 
		if ( buf[0] == '-' )	{
			flags(buf);
			if ( flag&RARG )
				flags(argv[++i]);
			continue;
		}
		if (freopen( buf,"r",stdin) == NULL)
			oops('c',"can't open",buf);
		inp[nfiles++] = buf;
	}

	if ( nfiles <= 0 ) 
		oops(0,"usage: wl [-mrsfp][-o outfile] [-d s=addr] objfiles");
	if ( nfiles > MAXFILES )
		oops(0,"too many files");

	/*
	 *	check all files 
	 */

	if ( (freopen( out,"w",stdout ) ) == NULL ) 
		oops('c',"can't open ", out);
	if ( fseek(stdout,optr,0) == -1 )
		oops(0,"output error");

	/*
	 *	count symbols
	 */

	for ( j = 0; j < nfiles; j++ ) {
		freopen(inp[j],"r",stdin);
		symct(j);
	}	

	/*
	 * 	try memory symbol table - if no room or forced use file
	 */ 

	if ( !(flag & FMODE) )
		if ( (smptr = sbrk(symcnt*SYMSIZE) ) != -1 )
			mode = MEM;

	/*
	 *	if used make temporary symbol file
	 */

	if ( !(mode&MEM) ) {
		sprintf(tmpb,"%4x",getpid() );
		strncat(sfile,tmpb,4);
		if ( (sout = fopen(sfile,"w") ) == NULL )
			oops('c',"can't open",sfile);
		if ( (sin = fopen(sfile,"r") ) == NULL )
			oops('c',"can't open",sfile);
	}

	/*
	 *	collect all symbols from input files
	 */

	for ( j = 0; j < nfiles; j++ ) {
		freopen(inp[j],"r",stdin);
		symcol(j);
	}

	/*
	 *	adjust exported symbols to link values
	 */

	for (sects = 0; sects <SECTS; sects++ )
 		for (i=0; i < nfiles; i++) {
			freopen(inp[i],"r",stdin);
			symadj(i);
		}

	/*
	 *	relocate code to link all psects
	 */

	for (sects = 0; sects <SECTS; sects++ ) 
 		for (i=0; i < nfiles; i++) {
			freopen(inp[i],"r",stdin);
			reloc(i);
		}

	/*
	 *	add symbol table to output file if relocatable
	 */

	if ( !(flag&STRIP) )
		outsym();

	/*
	 *	add output file header
	 */

	rewind(stdout);
	putw(MWORD,stdout);
	putw(OPSIZE,stdout);
	if ( flag&STRIP )
		putw(8,stdout);
	else if ( flag&RELOUT )
		putw(8|HASREL|HASSYM,stdout);
	else 
		putw(8|HASSYM,stdout);
	fwrite(&ohdr,sizeof(struct header),1,stdout);

	/*
	 *	make link map if requested
	 */

	if ( flag&MAP ) {
		freopen("w.map","w",stdout);
		outmap();
	}

	/*
	 *	close all files
	 */


	fclose(stdout);
	fclose(stdin);
	if ( !(MEM &mode) ) {
		fclose(sout);
		fclose(sin);
	}

	/*
	 *	load output file if requested  !!! NOT WORKING !!!
 	 */

	if (flag&LOAD)	{
		if ( flag&LOADGO )
			if (system(LDCMD,out,"-g","-s") == 127 )
				oops('c',"can not execute",buf);
			else
			if (system(LDCMD,out) == 127 )
				oops('c',"can not execute",buf);
	}

	/*
	 *	remove temporary file unless it's wanted and leave
	 */

	if ( !(MEM&mode) & !(NOUNLK&flag) )
 		unlink(sfile);
	exit(0);
}



flags(arg)	/*	read option flags */

char *arg;		/* next argument string */

{
	static int i,j;

	if ( flag&RARG ) {		/* if this is secondary arg */
		if ( flag&NOUT ) {		/* for output file def */
			strcpy(out,arg);
			if (freopen(out,"w",stdout) == NULL)
				oops('c',"can't open",out);
			flag &= ~NOUT;
		}
		if ( flag&DEFINE ) {		/* for psect org def */
			i = 0;
			j = arg[i++];
			if ( j < '0' || j >= (SECTS+'0') )
				  oops('c',"invalid section number",arg);
			j -= '0';			
			sscanf(arg+i,"=%4x",&dval[j]);
			dflg[j] = 1;
		}
		flag &= ~DEFINE;
		flag &= ~RARG;
		return;
	}							
	
	/*
	 *	read all option characters and set flags
	 */

	i = 0;
	if ( arg[i++] != '-' )
		oops('c',"unknown switch",arg);
	while ( arg[i] != '\0' )
		switch (arg[i++])	{
			case 'o' : {
				flag |= ( RARG | NOUT );
				return;
			}
			case 's' : {
				flag |= STRIP;
				break;
			}
			case 'r' : {
				flag |= RELOUT;
				break;
			}
			case 'm' : {
				flag |= MAP;
				break;
			}
			case 'd' : {
				flag |= ( RARG | DEFINE );
				break;
			}
			case 'w' : {
				flag |= NOWARN;
				break;
			}
			case 'x' : {
				flag |= LOAD;
				break;
			}
			case 'f' : {
				flag |= FMODE;
				break;
			}
			case 'p' : {
				flag |= FMODE|NOUNLK;
				break;
			}
			default :
				oops('c',"unknown switch",arg);
		}
}


symct(f)		/* count symbols for table */

{
	register int j ,i;
	static struct st *sym;

	/*
	 *	check header
	 */

	if ( getw(stdin) != MWORD ) 
		oops('c',"not in m.out format :",inp[f]);
	if (getw(stdin) != OPSIZE )
		oops('c',"not in byte format :",inp[f]);
	if ( HASSYM & (i = getw(stdin)) != HASSYM )
		return; 
	if ( fread(&hdr,sizeof(struct header),1 ,stdin) != 1 )
		oops('c',"input error", inp[f]);
	pptr = 0l;
	for ( j = 0; j < SECTS; j++ ) 
		pptr += (long)hdr.psect[j].size;
	if ( !(i&HASREL) )
		pptr *= 2l;
	else
		pptr *= 4l;
	if (fseek(stdin,pptr,1) == -1 ) 
		oops('c',"seek error",inp[f]);

	/*
	 *	count symbols
	 */

	while ( fread(&sym,sizeof(struct st),1,stdin) == 1 )
		symcnt++;
	return;
}


symcol(f)		/* collect symbols */

int f;		/* input file number */

{

	register int j ,i;
	static struct st *sym;

	/*
	 *	read header
	 */

	fseek(stdin,4l,0);
	if ( HASSYM & (i = getw(stdin)) != HASSYM )
		return; 
	fread(&hdr,sizeof(struct header),1 ,stdin);
	pptr = 0l;
	for ( j = 0; j < SECTS; j++ ) 
		pptr += (long)hdr.psect[j].size;
	if ( !(i&HASREL) )
		pptr *= 2l;
	else
		pptr *= 4l;
	fseek(stdin,pptr,1);

	/*
	 *	read in symbols
	 */

	while ( fread(&sym,sizeof(struct st),1,stdin) == 1 ) {
		sym.s_sect &= SMASK;	/* clean sect entry for flags */
		if ( EXPO&sym.s_mode ) {
		  if ( search(sym.s_name,EXPO) != NONE ) {
		     fprintf(stderr,"wl: %8s multiply defined\n",sym.s_name);
		     exit(1);
		  }
		  if ( search(sym.s_name,EXT) != NONE ) {
		     so.ism.e_sect |= COPY;	/* flag old duplicate refs */
		     putsym();
		  }
		}
		else if ( search(sym.s_name,EXPO|EXT) !=NONE )
		    sym.s_sect |= COPY; 	/* flag new duplicate refs */

		/*
		 *	put symbol in table 
		 */

		strncpy(so.ism.e_name,sym.s_name,SNAMLEN);
		so.ism.e_mode = sym.s_mode;
		so.ism.e_sect = sym.s_sect;
 		so.ism.e_value = sym.s_value;
		so.ism.e_old = sym.s_value;
		so.ism.e_file = f;
		*sptr = (long)(SYMSIZE*(symtot++));
		putsym();
	}
	return;
}


search(target,mode)		/* find symbol in internal table */

char *target;		/* symbol name to find */
int mode;		/* which modes to check for */

{
	register int s;

	for (s=0; s < symtot; s++) {
		*sptr = (long)((SYMSIZE)*s);
		getsym();
		if ( !(so.ism.e_mode & mode) )
			continue;
		if ( strncmp(target,so.ism.e_name,SNAMLEN) == 0 )
			return(1);
	}
	return(NONE);
}


symadj(f)			/* adjust exported symbols */

int f;			/* input file number */

{
	register int s;

	fseek(stdin,4l,0);
	if ( ( (s = getw(stdin)) & HASREL ) != HASREL ) 
		oops('c',"missing relocation bits", inp[f]);
	fread(&hdr,sizeof(struct header),1 ,stdin);
	if ( hdr.psect[sects].size == 0 )
		return;

	/*
	 *	make output header
	 */

	if ( ohdr.psect[sects].size == 0 ) 
		ohdr.psect[sects].attrib = hdr.psect[sects].attrib;
 	if( ASECT & hdr.psect[sects].attrib)
		if ( (ohdr.psect[sects].attrib & ASECT ) != ASECT )
			oops('c',"mixed asects and psects",inp[f]);
	if ( hdr.psect[sects].add != 0 ) {
		if ( ohdr.psect[sects].size != 0 )
			oops('x',"multiple orgs psect",inp[f],sects);
		else 
			cnt = hdr.psect[sects].add;
	}	
	if ( dflg[sects] != 0 && ohdr.psect[sects].size == 0 )
		cnt = dval[sects];
	if ( ohdr.psect[sects].size == 0 )
		ohdr.psect[sects].add = cnt;
	ohdr.psect[sects].size += hdr.psect[sects].size;

	/*
	 *	adjust symbols
	 */

	for ( s = 0; s < symtot; s++) {
		*sptr = (long)( s*SYMSIZE);
		getsym();
		if ( so.ism.e_file != f )	/* only this file */
			continue;
		if ( ((so.ism.e_sect)&SMASK) != sects ) /* only this sect */
			continue;
		if ( !(EXPO&(so.ism.e_mode)) )	/* only exports */
			continue;
		if ( LITR&(so.ism.e_mode) )	/* only absolute addresses */
			continue;
		so.ism.e_value += (cnt-hdr.psect[sects].add);
		putsym();
	}
	osize += (long)(2*hdr.psect[sects].size);
	cnt += hdr.psect[sects].size;
	return;
}


reloc(f)			/* link and relocate all psects */

int f;			/* input file number */

{

	register int j;
	static long start, ofset;
	int op, rel, ad, sop;
	static int aflg = 0;	
	static int maflg = 0;
	static int sbyte = 0;
	static int bflg = 0;
	static int mbflg = 0;
	register int lsb, msb;

	/*
	 *	get header
	 */
	
	fseek(stdin,6l,0);
	fread(&hdr,sizeof(struct header),1 ,stdin);
	if ( hdr.psect[sects].size == 0 )
		return;
	
	/*
	 *	set pointers
	 */

	pptr = (long)(sizeof(struct header)+6);
	for ( j = 1; j <= sects; j++)
		pptr += (long)(2*hdr.psect[j-1].size); 
	ofset = 0l;
	for ( j = 0; j < SECTS; j++ )
		ofset += (long)(2 * hdr.psect[j].size);
	if ( pcnt[sects] == 0 )
		pcnt[sects] = ohdr.psect[sects].add;
	start = pptr;	

	/*
	 *	process all op codes
	 */

	while ( pptr < (start + (long)(2*hdr.psect[sects].size) ) ) {
		fseek(stdin,pptr+ofset,0);
		fread(&rel,2,1,stdin);
		fseek(stdin,pptr,0);
		fread(&op,2,1,stdin);

	/*
	 *	process internal ops
	 */

		if ( !(rel&EXT) ) {

	/*
	 *	adjust internal absolute addresses
	 */

		    if ( ! (rel&(LITR|REL))  ) {

			if ( !aflg ) {		/* first byte */
				lsb = op;
				aflg++;
			}
			else {			/* second byte */
				msb = op << 8;
				msb |= lsb;
				msb += (pcnt[sects]-hdr.psect[sects].add);
				op = msb &0xff;
				fwrite(&op,WSIZE,1,stdout);
				if ( flag&RELOUT) {
					fseek(stdout,(optr-2l)+osize,0);
					fwrite(&rel,WSIZE,1,stdout);
				}
				op = ( msb >> 8 ) &0xff;
			}
		    }
		}

		/*
		 *	process externals
		 */

		else {
			sop = findsym( f,rel&IDXMSK );	/* get symbol value */

	/*
	 *	relative addresses
	 */

			if ( rel&REL ) {

				if ( !sbyte ){ 		/* if lsb */
	
					/* get address relative to sect */

					fread(&ad,2,1,stdin);
					ad = ad << 8;
					ad |= op;

					/* recalculate relative address */

					op = sop - ( pcnt[sects] -
					     hdr.psect[sects].add - ad );

					ad = op;    /* save msb */
					op &= 0xff; /* write lsb */
					sbyte++;    /* flag for msb */

				}			/* if msb */
				else	{
					op = (ad >> 8) & 0xff;
					sbyte--;    /* reset flag */
				}

				if ( !unsym )	/* rel for found symbol */
					rel &= ~EXT & ~IDXMSK;

				else		/* rel for unfound symbol */
					rel = (rel & ~IDXMSK) |
					      (so.ism.e_mode & IDXMSK);
			}

	/*
	 *	external absolute addresses and literals
	 */

			else    {
			   if ( !unsym ) {	/* for found symbols */
				if ( !bflg ) {  /* for lsb */
				  fread(&ad,2,1,stdin);/* get original value */
				  ad = ad << 8;
				  ad |= op;
				  if ( so.ism.e_file != f ) /* add in value */
					sop += ad;
				  else	/* undo assembler adjustment */ 
					sop = ad - so.ism.e_old + sop;
				  ad = sop;
				  op = sop & 0xff;
				  if ( !(rel&BYTE) )
					bflg++;
				}
				else		/* for msb */
				   op = ( ad >> 8) & 0xff;
				rel = so.ism.e_mode & ~EXT & ~IDXMSK;
			    }
			    else 	/* only fix rel for unfound symbols */
				rel = (rel & ~IDXMSK ) | 
				      ( so.ism.e_mode & IDXMSK );
			}
		}

		/*
		 *	update byte count flags
		 */

		if ( maflg ) {
			maflg--;
			aflg--;
		}
		if ( aflg )
			maflg++;
		if (mbflg) {
			bflg--;
			mbflg--;
		}
		else if ( bflg)
			mbflg++;

		/*
		 *	insert new ops to outfile
		 */	
		
		fseek(stdout,optr,0);
		fwrite(&op,WSIZE,1,stdout);
		if ( flag&RELOUT ) {
			fseek(stdout,optr+osize,0);
			fwrite(&rel,WSIZE,1,stdout);
		}			
		optr += 2l;
		pptr += 2l;
	}		

	/*
	 *	adjust relocation counter
	 */	

	pcnt[sects] += hdr.psect[sects].size;
	return;

}


oops(typ,str,nam,num)		/* display error message and abort */

int typ;		/* parameter type */
char *str;		/* message */
char *nam;		/* parameter, string type */
int num;		/* parameter, numeric type */

{	
	if ( typ == 0 )
		fprintf(stderr,"wl: %s\n",str);
	else if (typ == 'c' )
		fprintf(stderr,"wl: %s %s\n",str,nam);
	else if (typ == 'x' )
		fprintf(stderr,"wl: %s %x %s\n",str,num,nam);
	unlink(out);
	if ( !(MEM&mode) & !(NOUNLK&flag) )
 		unlink(sfile);
	exit(1);
}


outsym()		/* output symbol table */

{
	register int s, k;

	for ( s = 0; s < symtot; s++ ) {
		*sptr = (long) ( SYMSIZE*s);
		getsym();
		if ( (so.ism.e_sect)&COPY )	/* no duplicates */
			continue;
		if ( (so.ism.e_sect)&UNDEF || (so.ism.e_mode)&EXPO ) {
			for ( k = 0; k < SNAMLEN; k++)	
				putchar(so.ism.e_name[k]);
			putw(so.ism.e_value,stdout);
			if ( (so.ism.e_sect)&UNDEF ) {   /* externals */
				putw(-1,stdout);
				putw((so.ism.e_mode&IDXMSK)|EXT,stdout);
			}
			else  {				 /* exports */
				putw( (so.ism.e_sect)&SMASK ,stdout);
				putw(((so.ism.e_mode)&~IDXMSK)|uscnt++,stdout);
			}
			putw(0,stdout);
			putw(0,stdout);
		}
	}
	return;
}

 
outmap()		/* output link map */

{
	register int i, k, j, s;
	static int perln = 7;
	static int page = 1;
	static int totsiz = 0;
	static int hiadd = 0;
	int a;
	char c;
	struct ist alsym[MAXSYMS];
	struct ist bsym;

	printf("Load Map\t\t\t%s\n\n",inp[0]);
	for ( j=0; j < SECTS; j++) {
		if ( ohdr.psect[j].size == 0 )
			continue;
		perln += 12;
		printf("\nSection  Address  Size\n");
		printf("   %1x    %4x   %4x\n",j,ohdr.psect[j].add,
		       ohdr.psect[j].size);
		totsiz += ohdr.psect[j].size;
		if ( (s = ohdr.psect[j].add + ohdr.psect[j].size ) > hiadd )
			hiadd = s;

	/*
	 *	get all export symbols for this sect
	 */

		perln -= (perln % 3);
		a = 0;
		for ( s= 0; s < symtot; s++ ) {
		    *sptr = (long)(s*SYMSIZE);
		    getsym();
		    if ( !(EXPO&so.ism.e_mode) )
			continue;
		    if ( (so.ism.e_sect&SMASK) == j) 	{
			strncpy(alsym[a].e_name,so.ism.e_name,SNAMLEN);
			alsym[a].e_value= so.ism.e_value;
			alsym[a++].e_sect = so.ism.e_sect;
		   }
		}
	
	/*
	 *	alpha sort
	 */

		for ( k = (a-1); k > 0; k--)
		 for ( i=0; i< k; i++ )
		  if (strncmp(alsym[i].e_name,alsym[i+1].e_name,SNAMLEN) > 0){
		    strncpy(bsym.e_name,alsym[i].e_name,SNAMLEN);
		    strncpy(alsym[i].e_name,alsym[i+1].e_name,SNAMLEN);
  		    strncpy(alsym[i+1].e_name,bsym.e_name,SNAMLEN);
		    bsym.e_value = alsym[i].e_value;
		    bsym.e_sect = alsym[i].e_sect;
		    alsym[i].e_value = alsym[i+1].e_value;
		    alsym[i].e_sect = alsym[i+1].e_sect;
		    alsym[i+1].e_value = bsym.e_value;
		    alsym[i+1].e_sect = bsym.e_sect;
		  }

	/*
	 *	write out syms
	 */

		printf("\n				");
		for ( i = 0; i < a; i++ ) {
			for ( k = 0; k < SNAMLEN; k++)	{
				if ( (c = alsym[i].e_name[k]) != 0 )
					putchar(c);
				else
					putchar(' ');
			}
			if ( UNDEF&(alsym[i].e_sect) )
				printf(" ****  ");
			else
				printf(" %4x  ",alsym[i].e_value);
			if ( ++perln % 3 == 0 ) {
				printf("\n				");
				if ( perln / 3 >= 53 ) {
					perln = 3;
					page++;
	printf("\n\f");
	printf("\n	Load Map			   Page %4d\n\n",page);
	printf("\nSection  Address  Size\n");
	printf("   %1x    %4x   %4x\n",j,ohdr.psect[j].add,
		       ohdr.psect[j].size);
	printf("    ( continued )\n");
	printf("\n				");
				}
			}
		}
		putchar('\n');
	}
	printf("\n\nTotal Size: %4x   High Address: %4x\n\n",totsiz,hiadd);
	return;
}
		

findsym(f,indx)			/* return value of symbol */

int f;			/* input file number */
int indx;		/* symbol index */

{
	char buf[SNAMLEN+1];
	register int s, i;
	
	unsym = 0;
	for ( s=0; s < symtot; s++ ) {
		*sptr = (long)(s*SYMSIZE);
		getsym();
		if ( so.ism.e_file != f)	/* only this file */
			continue;
		if ( (so.ism.e_mode&IDXMSK) != indx )	/* look for index */
			continue;
		strncpy(buf,so.ism.e_name,SNAMLEN);	/* get name */
		buf[SNAMLEN] = '0/';

		/* check table for name */

		if ( search(buf,EXPO) == NONE ) {	/* not found */

			/*	
			 *	if undefined put in table for map
			 */

			strncpy(so.ism.e_name,buf,SNAMLEN);
			so.ism.e_mode = EXPO|uscnt++;
			so.ism.e_sect = sects|UNDEF;
 			so.ism.e_value = 0;
			so.ism.e_file = f;
 			addsym();
			if ( !(flag&NOWARN) )
			    fprintf(stderr,"wl: warning %8s undefined\n",buf); 
			unsym++;	/* set flag */
			return(0);

		} 	/* found */

		getsym();
		if ( (UNDEF&(i = so.ism.e_sect)) ) {
			unsym++;	/* set flag */
			if ( ( SMASK&(i) ) != sects ) {
				so.ism.e_sect = sects|UNDEF|COPY;
				putsym();
				so.ism.e_sect = i;
				addsym();
			}
			return(0);
		}
		return(so.ism.e_value);
	}
}


getsym()		/* get symbol entry into buffer */

{
	register char *insym;
	register int i;

	if ( !(MEM&mode) ){		/* from file */
		fflush(sout);
		fseek(sin,*sptr,0);
		fread(&so,SYMSIZE,1,sin);
	}
	else	{			/* from core */
		insym = smptr+(int)*sptr;
		for ( i=0 ; i < SYMSIZE; i++ )
			so.mism[i] = insym[i];		
	}
}


putsym()		/* put symbol entry in buffer into table */ 

{	
	register char *outsym;
	register int i;

	if ( !(MEM&mode) ) {		/* to file */
		fseek(sout,*sptr,0);
		fwrite(&so,SYMSIZE,1,sout);
	}				/* to core */
	else	{
		outsym = smptr+(int)*sptr;
		for ( i=0; i < SYMSIZE; i++)
			outsym[i] = so.mism[i];
	}
}


addsym()		/* add symbol table entry */

{
	int i;
	
	*sptr = (long)(SYMSIZE*symtot++);
	if ( MEM&mode )
		if (  (i = brk(smptr+(int)*sptr+SYMSIZE) ) != 0 )
			oops(0,"memory symbol table fault, use -f option");
	putsym();
}
