
#include	"mac.h"
#include	"mac.x"

/*
 * start of pass 1
 */

int	nxtstate;		/* next parser state */
char	*icptr;			/* intercode buf ptr */

pass1()
{

	register struct	fd *f;		/* fmt descr */
	register int sret;		/* success return */
	register int fret;		/* failure return */
	register int s;
	register int i;
	register char *r;		/* for opcode table */

	
	eof = FALSE;
	newline();			/* general initialisation */

	/*
	 *   Start the automaton.  Once	it is going, -
	 *   it	keeps itself going until end-of-input.
	 */
	while (!eof)  {

	  s = parse[nxtstate].tb_sym;

	  /*
	   *   If no match or symtyp != MCH (always match)
	   *   proceed to next case in parser table.
	   */

	  if (symtyp != (s < 0  ?  -s : s)  &&  s != MCH)  {
	    nxtstate++;
	    continue;
	  }

	  /*
	   *   Have a sym match.
	   *   If symtyp < 0 this implies that the member
	   *   must be checked as well !.
	   *   Failure to match can occur here as well.
	   */

	  if (s < 0  &&  member != parse[nxtstate].tb_mem)  {
	    nxtstate++;
	    continue;
	  }

	  /*
	   *   Sym (and member) match -
	   *   perform action specified.
	   */
	  switch (parse[nxtstate].tb_act)  {

	    /* no operation */
	    case NOOP:
	      break;

	    /* add label tag */
	    case ALBL:
	      if ( (i = defsym(clabel,member,locn[lcntr].l_value))
		== ERR ) {
	        newline();
	        continue;
	      }
	      intercode.i_label = i;
	      if (symtab[i].s_loc != ERR)	/* last symbol local ? */
	        lastsym = i;
	      break;

	    /* decode opcode value */
	    case DOPV:
	      i = pscan();		/* pseudo ? */
	      if (i != ERR)  {
	        intercode.i_flags = PS;
	        intercode.i_op = i;
	        fn = pradr[i];
	        break;
	      }
	      i = oscan();		/* opcode ? */
	      if (i == ERR)  {
	        synerr("op not found");
	        newline();
	        continue;
	      }
	      intercode.i_flags = OP;
	      intercode.i_op = i;
	      break;

	    /* out operand label */
	    case OLBL:
	      *icptr++ = '$';
	      icptr = num( lkpsym(clabel, member), icptr);
	      break;

	    /* out operand operator */
	    case OOPR:
	      *icptr++ = oprtab[member];
	      break;

	    /* out operand delimiter */
	    case ODEL:
	      *icptr++ = ',';
	      break;

	    /* out operand constant */
	    case OCON:
	      *icptr++ = '#';
	      icptr = num(member, icptr);
	      break;

	    /* out extra character */
	    case OCHR:
	      *icptr++ = member;
	      break;

	    /* out string in double quotes  */
	    case OSTR:
	      *icptr++ = '"';
	      if(member > MAXOPN-3){
	        synerr("string cons too long");
	        *icptr++ = '"';
	        break;
	      }
	      for (i=0; i<member; i++)
	        *icptr++ = clabel[i];
	      *icptr++ = '"';
	      break;

	    /* end pass 1 */
	    case ENDP:
	      warning("no end stmt");
	      prend();
	      return;

	    /* select options */
	    case SELC:
	      for (i=0; i<4; i++)
	        intercode.i_selc[i] = parse[nxtstate].tb_arg[i];
	      nxtstate = parse[nxtstate].tb_next;
	      continue;

	    /* call expression parser */
	    case EXPR:
	      fret = nxtstate + 1;
	      sret = parse[nxtstate].tb_next;
	      nxtstate = 0;			/* start of expr */
	      continue;

	    /* good expression return */
	    case RETN:
	      nxtstate = sret;
	      sret = NUL;
	      continue;

	    /* fail expression return */
	    case GOTO:
	      nxtstate = fret;
	      fret = NUL;
	      continue;

	    /* input line error */
	    case OERR:
	      synerr("syntax error");
	      newline();
	      continue;

	    /* scan ok, write intercode */
	    case OREC:
/*
 * fprintf(stderr,"mac10> ll:%08X lv:%08X ls:%08X\n", locn[lcntr].l_limit, 
 * locn[lcntr].l_value, locn[lcntr].l_start );
 */
	      *icptr = '\0';
	      write(intfil, &intercode, IT);
	      if(intercode.i_flags & OP){
	        r = &opcode[0] + (intercode.i_op * head.h_o_len);
	        if(intercode.i_selc[0] & SELOPC)
		  i = intercode.i_selc[2];	 /* sel opcode column */
	        else
	          i = 0; 			 /* sel default */
	        if(intercode.i_selc[0] & SELFMT) /* select new format */
	          f = &memory[intercode.i_selc[3]];
	        else				/* select default */
	          f = &memory[ r->o_code[i].o_format ];
	        locn[lcntr].l_value += (f->f_len); /* increment pc */
	      }
	      if (intercode.i_flags & PS)
	        (*fn)();			/* call pseudo rtn */
	      newline();
	      continue;

	    default:				/* bad action -	fatal */
	      synerr("pass 1 non-existant action");
	      exit(1);

	  }


	/*
	 *   Successful	match -	get new	input symbol
	 *   and move to next automaton	state.
	 */
	  gettok();
	  nxtstate = parse[nxtstate].tb_next;
	}
}

newline()
{
	register char *r;
	register int i;

	if(getlin() == 0){
	  intercode.i_op = EORN;
	  write(intfil, &intercode, IT);
	  eof = TRUE;
	  return;
	}

	gettok();
	nline++;				/* adv line number */
	intercode.i_op = intercode.i_label = ERR;
	intercode.i_flags = NUL;
	intercode.i_loc	= lcntr;
	intercode.i_selc[0] = NUL;		/* no actions */
	icptr = r = &intercode.i_opr[0];
	for (i=0; i<MAXOPN; i++)
	  *r++ = '\0';		/* clear intercode argument buffer */
	nxtstate = head.h_p_start;
	return;
}

/*
 * get the next token
 */
gettok()
{
	register int i;
	register int j;
	register char *s;
	register char cc;


	switch (cc = *p++)  {

	  case ' ':
	  case '\t':
	    i=1;
	    while (*p  == ' ' || *p == '\t')  {
	      i++;
	      p++;
	    }
	    symtyp = SPA;
	    member = i;
	    return;

	  case ',':
	    symtyp = DEL;
	    member = ',';
	    return;

	  case '\n':
	    symtyp = EOL;
	    member = NUL;
	    return;

	  case '\'':
	    symtyp = CON;
	    i = 0;
	    while ((cc = getch()) != '\'')
	      i = (i<<8) | cc;
	    member = i;
	    return;

	  case '"':
	    s = clabel;
	    i = 0;
	    while ((cc = getch()) != '"')  {
	      if (i++ > 30)
		break;
	      *s++ = cc;
	    }
	    *s = '\0';
	    symtyp = STR;
	    member = i;
	    return;

	  case ';':
	    s = clabel;
	    *s++ = cc;
	    while (*p != '\n')  *s++ = *p++;
	    symtyp = COM;
	    member = (s - clabel);
	    return;

	  case '\0':
	    symtyp = EORN;
	    member = 0;
	    return;
	}

	if ((j = any(cc, alptab)) >= 0)	 {
	  s = clabel;
	  *s++ = cc;
	  i = 1;
	  while (any(*p, alptab) >= 0 || any(*p, dectab) >= 0)  {
	    *s++ = *p++;
	    i++;
	    if (i > 8)
	      break;
	  }
	  *s++ = '\0';

 	  /* check literal table */
	  for (i=0; i<head.h_literals; i++)
	    if (compar(literals+i*8, clabel))  {
	      symtyp = LIT;
	      member = i;
	      return;
	    }
	    symtyp = LBL;
	    member = j;
	    return;
	}

	if ((j = any(cc, dectab)) >= 0)	 {
	  p--;
	  symtyp = CON;
	  member = argnum();
	  return;
	}

	if ((j = any(cc, oprtab)) >= 0)	 {
	  symtyp = OPR;
	  member = j;
	  return;
	}

	symtyp = CHR;
	member = cc;
	return;
}
