;
; VT100 setup mode routines.
;

;
; Enter here from online or local idle loops.
; The setup routines fudge with curx, cury and
; txtptr in order to use the display routines
; dspchr, echar, dchar, dsplin and undisp.  
; txtptr is used to point at the various constant
; strings that are displayed in setup mode.
;

setup:
	sep	#0x30
	pei	<txtptr
	pei	<curx		; save curx, cury.
	phk
	pla
	sta	<txtptr+2	; set data bank for setup strings.

;
; Setup A.
;

setupa:
	jsl	>0,Erase
	
	lda	#1
	sta	<curx
	lda	<rowmax
	sta	<cury
	bsl	setxy
;
; display 123456789012 ... 
;
	ldx	<colmax
	lda	#'1'
$loop1:
	bsl	dchar
	inc	a
	cmp	#'9'+1
	bcc	$l1
	lda	#'0'
$l1:	dex
	bne	$loop1
;
; move up a line and display 'T' at tab stops.
;
	dec	<cury
	bsl	setxy		; set y.
	ldx	<colmax
	ldy	#0
$loop2:
	lda	(<tabs),y
	cmp	#'T'
	bne	$l2
	sty	<curx
	inc	<curx
	bsl	xsetx
	lda	#'T'
	bsl	dchar
$l2:	iny
	dex
	bne	$loop2
		
	lda	#1
	sta	<curx
	bsl	dcurs
	lda	#128
	sta	<setab		; set setup mode to setup a,
				; exit setup to vt100.
	brl	sidl
;
; draw screen for setup b mode.
;

setupb:
	jsl	>0,Erase
;
; display current state of setup b options.
;
	lda	<rowmax
	sta	<cury
	rep	#0x20
	per	$bmsg
	pla
	sta	<txtptr
	sep	#0x20
	lda	#1
	ldy	#$msgend-$bmsg
	bsl	dsplin

	lda	#1
	sta	<curx
$loop:
	bsl	getopt		; set up to test an option.
	bcs	$no		; br if not an option.
	bit	<0,x		; option set ?
	beq	$no		; br if no.
	lda	#'1'		; yes, display it as set.
	bsl	dspchr
$no:	inc	<curx		; bump to next option.
	lda	<curx		; more options ?
	cmp	#$msgend-$bmsg
	bcc	$loop

	lda	#1		; draw cursor at beginning
	sta	<curx		; of line above options display.
	dec	<cury
	bsl	dcurs
	stz	<setab		; set setup mode to setup b.
	stz	<lstmsg		; no option text displayed yet.
	brl	sidl		; enter setup idle loop.

$bmsg:
	dcs	"1 0000  2 0000  "
	dcs	"3 0000  4 0000  "
	dcs	"5 0000"		; first bit is auto exit.
$msgend: 

;
; setup mode idle loop.
;

sidl:
	sep	#0x30
	bit	<setab		; in setup a ?
	bmi	$1		; br if yes.
	bsl	optmsg		; no, display text for current option.
$1:
	bit	Iqcnt3+1	; key ready ?
	bmi	$2		; br if yes.
	bsl	cursor		; nope, go blink cursor if needed.
	bra	$1
$2:	bsl	rcurs
	jsl	>0,GetKey
	bit	<setab
	bmi	seta
	brl	setb

;
; keycodes unique to setup a
;

seta:
	cmp	#'5'
	bne	$1
	brl	setupb
$1
	cmp	#'2'
	bne	$2
	ldy	<curx
	dey
	lda	(<tabs),y
	eor	#'T'
	sta	(<tabs),y
	bne	$11
	bsl	echar
	brl	sidl
$11:	bsl	xsetx
	lda	#'T'
	bsl	dchar	
	brl	sidl	
$2
	cmp	#'3'
	bne	$3
	lda	#3		;  set up as if a "clear all tabs"
	sta	<param		; command had been received and
	stz	<pncnt
	inc	<parcnt		; call clear tabs routine.
	bsl	clrtab
	lda	#1		; remove displayed 'T's
	ldy	<colmax
	bsl	undisp
	brl	sidl
$3
	brl	abcode		; jump to common key handler.

;
; keycodes unique to setup b.
;

setb:
	cmp	#'5'
	bne	$1
	brl	setupa
$1:
	cmp	#'6'		; toggle an option ?
	bne	$2		; br if no.
	bsl	getopt		; do setup to test option at curx.
	bcs	$no		; br if no such option.
	ldy	#'0'		; assume option is to be reset.
	bit	<0,x		; test option bit.
	bne	$tog		; br if it's set (and will be reset).
	iny			; it's getting set, make y a '1'.
$tog:	eor	<0,x		; toggle the option bit.
	sta	<0,x
	tya			; get option char ('0' or '1').
	inc	<cury		; drop to option display line.
	bsl	dspchr		; display new state of option.
	dec	<cury		; move back up where cursor belongs.
	lda	<curx
	cmp	#5		; toggle reverse video by masking
	bne	$no		; out or exposing 'underlay' planes.
$wdp	bit	Dpdone
	bvc	$wdp
	lda	Rbrmsk
	bne	$setrv
	lda	<svrmsk
	bra	$setmsk
$setrv	lda	#0
$setmsk	sta	Rbrmsk	
$no	brl	sidl

$2:
	cmp	#'7'
	bne	$3
	bsl	baud
	brl	sidl
$3:
	cmp	#'8'
	bne	$4
	bsl	baud
	brl	sidl
$4:
	brl	abcode
baud
	rts

;
; the rest of the possibilities are
; handled the same in setup a or b.
;

abcode:
	cmp	#0xfe		; setup key.
	bne	$1
	brl	sexit
$1
	cmp	#CR
	bne	$2
	bsl	crctl
	brl	sidl
$2
	cmp	#HT
	bne	$3
	bsl	tabctl
	brl	sidl
$3
	cmp	#'0'
	bne	$41
	brl	vtrst
$41
	cmp	#'9'
	bne	$4
	lda	#128
	bit	<clmode
	bpl	$42		; br if originally 80 columns
	trb	<clmode		; reset to make it 80 now
	bra	$43	
$42
	tsb	<clmode
$43	lda	#2
	sta	<param
	lda	#1
	sta	<parcnt
	sta	<curx
	sta	<cury
	bsl	chngln
	bsl	erscrn
	bsl	inibuf
	bsl	stabs
	stz	<xorg+1
	bit	<clmode
	bpl	$44		; br if doing 80 now
	lda	#2
	bsl	setfnt
	lda	#35
	sta	<xorg
	brl	setup
$44	lda	#128
	sta	<xorg
	lda	#0
	bsl	setfnt
	brl	setup
$4
	cmp	#'4'
	bne	$5
	lda	#128
	eor	<lckout
	sta	lckout
	brl	sidl
$5
	cmp	#32
	bne	$6
	inc	<curx
	lda	<colmax	
	cmp	<curx
	bcs	$51
	sta	<curx
$51	brl	sidl
$6
	cmp	#0xf4		; right arrow.
	bne	$7
	lda	#32
	bra	$5	
$7
	cmp	#0xf3		; left arrow
	bne	$8
	bsl	bsctl
	brl	sidl
$8:
	cmp	#'1'
	bne	$9
	lda	#64
	tsb	<setab		; exit to aed intrp.
	brl	sexit
;
; do up/down arrow (screen brightness)
; and '9' (80/132) here.
;

$9:	cmp	#19		; control s - save setup parameters.
	bne	$10
	bsl	shifts		; save params.
	brl	setupa
$10:	cmp	#18		; control r - restore setup parameters.
	bne	$11
	bsl	shiftr		; restore setup features.
	brl	setupa
$11:
	brl	sidl


;;;;;;;;;;;;;;;;;;;;;;;;;
; Exit setup mode.	;
;;;;;;;;;;;;;;;;;;;;;;;;;

sexit:
	rep	#0x20
	sep	#0x10
	pla
	sta	<curx		; restore curx, cury.
	pla
	sta	<txtptr

	sep	#0x30
	stz	Setupk		; clear setup key flag.

	stz	<txtptr+2	; restore text buffer data bank.

	bsl	redraw		; redraw screen.
	bit	<setab		; stay in vt100 mode ?
	bvc	$1		; br if yes.
	brl	vtexit		; no, exit vt100.
$1:
	bit	<lckout		; return to online or local idle loop.
	bmi	$2
	brl	idle
$2:	brl	local

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Get setup b option corresponding to	;
; curx.  Returns carry set if curx	;
; not valid, otherwise returns index	;
; into option array in x, bit mask	;
; in acc.  After calling this routine	;
; you can do things like 		;
; eor	<0,x 	;toggle an option
; bit	<0,x	;see if option set
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

getopt:
	clc			; assume curx ok.
	php

	rep	#0x20
	per	$table
	pla
	sta	<temp
	sep	#0x30
	phk
	pla
	sta	<temp+2

	lda	[<temp]
	tay
	lda	<curx
$loop:
	cmp	[<temp],y
	beq	$found
	dey
	dey
	dey

	bne	$loop
	plp
	sec
	rts
$found:
	iny
	lda	[<temp],y	; get index in direct page of variable.
	tax
	iny
	lda	[<temp],y	; get bit mask.
	plp
	rts
$table:
	dcb	$last-$table	; index last element
	dcb	0
	dcb	0

	dcb	21		; curx ( newline mode)
	dcb	nlmode
	dcb	128		; mask

	dcb	20		; curx ( autowrap mode)
	dcb	nlmode
	dcb	64		; mask

	dcb	13		; curx ( ANSI mode)
	dcb	vtmode
	dcb	128		; mask

	dcb	5		; (rvmode)
	dcb	rvmode
	dcb	128

	dcb	35		; curx (auto exit to aed)
	dcb	xitena
	dcb	128

$last:	dcb	22		; curx ( local echo mode)
	dcb	vtmode
	dcb	64		; mask


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Display explanation of setup b;
; option corresponding to curx.	;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

optmsg:
	php
	rep	#0x30
	pha
	phx
	phy

	sep	#0x30
	lda	<curx
	cmp	<lstmsg		; already show this message ?
	beq	$done		; br if yes.

	sta	<lstmsg
	bsl	rcurs		; erase cursor if drawn.
	lda	#1
	ldy	<colmax
	bsl	undisp		; erase line on screen.

	per	$index
	pla
	sta	<temp
	pla
	sta	<temp+1
	phk
	pla
	sta	<temp+2


	ldy	#0		; first table element is index of last.
	lda	[<temp],y
	tay
	lda	<curx
$loop:
	cmp	[<temp],y
	beq	$found
	dey
	dey
	dey
	bne	$loop
	bra	$done
$found:
	iny
	rep	#0x30
	lda	[<temp],y	; get option message offset.
	tay			; save it.
	per	$explan		; point temp at option message table.
	pla
	sta	<temp
	lda	[<temp],y	; get length this option.
	tax			; save it.
	tya			; generate pointer to message (y+temp+1).
	sec			; set for +1.
	adc	<temp
	sta	<txtptr		; now [<txtptr] points to message.
	sep	#0x30
	lda	#1
	txy
	bsl	dsplin		; display the message.
	bsl	dcurs		; display cursor.
$done:
	rep	#0x30
	ply
	plx
	pla
	plp
	rts
	
$index:
	dcb	$lstidx-$index
	dcw	0

	dcb	21		; curx corresponding to option.
	dcw	$nl-$explan	; offset into table of message info.

	dcb	20
	dcw	$aw-$explan

	dcb	13
	dcw	$an-$explan

	dcb	5
	dcw	$rv-$explan

	dcb	35
	dcw	$ax-$explan
$lstidx:
	dcb	22
	dcw	$le-$explan

$explan:
$nl	dcb	$aw-$nl-1
	dcs	"newline mode"
$aw	dcb	$an-$aw-1
	dcs	"autowrap mode"
$an	dcb	$rv-$an-1
	dcs	"ANSI/VT52 mode"
$rv	dcb	$ax-$rv-1
	dcs	"hide graphics"
$ax	dcb	$le-$ax-1
	dcs	"auto exit to AED"
$le	dcb	$exlast-$le-1
	dcs	"local echo mode"
$exlast

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; restore defaults from eeprom.	;
; doesn't do serial stuff.	;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

shiftr:
	bsl	ce2ram
	brl	stabs

ce2ram:	php
	rep	#0x30
	phx
	phy
	sep	#0x30

	ldx	#5			; 6 variables for now
$1:	bit	0xff1e
	bpl	$1
	lda	>EEP,option,x
	sta	<nlmode,x	
	dex
	bpl	$1

	rep	#0x30
	ply
	plx
	plp
	rts

;
; set tabs
;
stabs:	php
	rep	#0x30
	phx
	phy
	sep	#0x30

	ldx	#131
	txy
$2:	lda	>EEP,eetabs,x
	sta	(<tabs),y
	dex
	dey
	cpx	#0xff
	bne	$2

	rep	#0x30
	ply
	plx
	plp
	rts

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; the following code saves eeprom	;
; options from their ram copies		;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

shifts:	
	php
	rep	#0x30
	phx
	phy
	sep	#0x30

	ldx	#5

$mloop:	lda	<nlmode,x
$30	bit	0xff1e
	bpl	$30
	cmp	>EEP,option,x
	beq	$2			; if nothing changed then do next one

$1:	bit	0xff1e			; else here to update
	bpl	$1			; wait for ee2 to be ready
	sta	>EEP,option,x

$2:	dex
	bpl	$mloop

	ldx	#131
	txy

$loop:	lda	(<tabs),y
	cmp	>EEP,eetabs,x
	beq	$l1
	sta	>EEP,eetabs,x
$l1:	dex
	dey
	cpx	#0xff
	bne	$loop

	rep	#0x30
	ply
	plx
	plp
	rts

	end
