;
; VT100 compatible interpreter.
;
;

idle:
	sep	#0x30
$20
	lda	#0x20		; see if noscroll
	bit	<lckout		; mode in effect.
	bne	$curs		; br if noscroll mode.
	lda	(<bytcnt)	; host char avail ?
	bpl	$curs		; br if no.
	bsl	rcurs		; remove cursor.
	bsl	getchr		; online, get next ASCII char.
	beq	$dcurs		; br if was control, go check kbd.
	bvs	$dcurs		; or CAN, SUB.
	bcc	$10		; br if not ESC.
	bsl	escseq		; yes, go parse escape sequence.
	bra	$dcurs
$10:	bsl	putbuf		; not control, buffer and display it.
$dcurs:	lda	(<bytcnt)	; redraw cursor unless more 
	bmi	$kbd		; host input available.
	bsl	dcurs
	bra	$kbd
;
; here if no host input to service,
; do cursor and then check keyboard.
;

$curs:
	bsl	cursor		; blink cursor if it's time to do so.
;
; Handle keyboard input.
;

$kbd:
	bit	<lckout		; kbd locked out ?
	bvs	idle		; br if yes.
	bit	Iqcnt3+1
	bmi	$l1
	lda	(<bytcnt)
	bmi	$20

	bit	<xitena		; auto exit to aedland ?
	bpl	idle		; loop if no.
	bit	PolDev		; yes, check parallel port
	bpl	idle		; loop if no parallel data avail.
	bsl	rcurs		; exit to caller, presumably aed intrp.
	brl	vtexit		; nothing at serial, exit VT100 to 
				; service parallel
$l1	jsl	>0,GetKey

	bit	#0x80		; special key ?
	beq	$3		; br if no.
	cmp	#0xfe		; SetUp key ?
	bne	$22
	brl	setup		; yes, enter special idle loop.
$22:	cmp	#0xb0		; NoScroll ?
	bne	$21
	lda	#0x20		; yes, toggle no scroll switch.
	eor	<lckout
	sta	<lckout
	brl	idle
$21:	
	bsl	spkey		; yes, go do special key.
	brl	idle

$3:	cmp	#0x20		; control char ?
	bcs	$4		; br if no.
	bsl	ctlkey		; yes, go check special cases.
	brl	idle

$4:	bsl	putchr		; nothing special, just send it.
	brl	idle
;
; Local mode idle loop.
;

local:
	sep	#0x30
$idle:
	bit	Iqcnt3+1	; key ready ?
	bmi	$2		; br if yes.
	bsl	cursor		; no, blink cursor if time.
	bra	$idle
$2:
	bsl	rcurs		; erase cursor.
	jsl	>0,GetKey	; get key.

	bit	#0x80		; special key ?
	beq	$4		; br if no.
	cmp	#0xfe		; SetUp key ?
	bne	$3
	brl	setup		; yes, enter special idle loop.
$3:	bsl	spkey		; go do special key.

$4:	cmp	#0x20		; control char ?
	bcs	$5		; br if no.
	bsl	ctlkey		; yes, go check special cases.
	bra	$idle

$5:	bsl	putbuf		; nothing special, just display it.
	bra	$idle

;
; Cursor service routines.
;

;
; Draw or erase cursor if it's time.
;

cursor:
	php
	rep	#0x20

	lda	<cutime		; get time to toggle cursor.
	cmp	Vcount		; time yet ?
	bcc	$1		; br if yes.
	lda	<curx		; (and cury).
	cmp	<oldcx
	beq	$done		; done if cursor didn't move.
$1:
	sep	#0x20
	bit	<chrsiz		; don't draw cursor on top line
	bvc	$doit		; of double size chars. 
	bpl	$done
$doit:				; draw cursor if erased, 
	bit	<cdrawn		; erase if drawn.
	bpl	$2
	plp
	brl	rcurs
$2:	plp
	brl	dcurs
$done:
	plp
	rts


dcurs:
	php
	rep	#0x30
	phx
	phy

	sep	#0x30
	bit	<cdrawn
	bpl	$ok
	bsl	rcurs
$ok:
	bsl	csetup
	ldx	#1		; cursor color.
	dec	<cdrawn
$l1:
	lda	Vm
	sta	(<curbuf),y
	stx	Vmimaj
	dey
	cpy	<temp
	bne	$l1

	rep	#0x20
	lda	<xpos
	sta	Xcap
	sep	#0x20
	bit	Vmimin
$l2:
	lda	Vm
	sta	(<curbuf),y
	stx	Vmimaj
	dey
	bne	$l2

	rep	#0x30
	clc
	lda	Vcount
	adc	##45
	sta	<cutime

	lda	<curx		; (and cury).
	sta	<oldcx

	ply
	plx
	plp
	rts

rcurs:
	php
	rep	#0x30
	phx
	phy

	sep	#0x30
	bit	<cdrawn
	bpl	$done
	stz	<cdrawn

	bsl	csetup

$1:	lda	(<curbuf),y
	sta	Vmimaj
	dey
	cpy	<temp
	bne	$1

	rep	#0x20

	clc
	lda	<cutime
	adc	##15
	sta	<cutime

	lda	<xpos
	sta	Xcap
	sep	#0x20
	bit	Vmimin
$2:
	lda	(<curbuf),y
	sta	Vmimaj
	dey
	bne	$2

$done:
	rep	#0x30
	ply
	plx
	plp
	rts

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Local routine to set up for	;
; drawing or erasing cursor.	;
; Returns with total number of	;
; pixels in cursor in y, length	;
; of cursor in <temp, sets cap	;
; and cap control reg.		;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

csetup:
	php
	rep	#0x30

	bsl	setxy
	clc
	lda	<ypos
	adc	<cslop
	dec	a
	dec	a
	sta	Ycap
	lda	<xpos
	sta	Xcap

	sep	#0x30
	lda	#7
	trb	Capctl		; x major, both up.

	lda	<csx
	ldy	<chrsiz		; doing double size ?
	beq	$2		; br if no.
	asl	a		; yes, double the length.
$2:	sta	<temp		; save length.
	asl	a		; get total # pixels to do.
	tay

	plp
	rts

	end
