;
; "VT100-style" setup routines.
; Called from alpha or intrp idle loops
; on setup key.  Trashes overlay plane.
;

sptr	equ	temp
scrptr	equ	temp+3
fields	equ	temp+6
curfld	equ	temp+9
curscr	equ	temp+10
setab	equ	temp+11
curval	equ	temp+12
hostbr	equ	temp+14
hostdb	equ	temp+16
hostsb	equ	temp+17
hostpa	equ	temp+18
hostfc	equ	temp+19
padace	equ	hostbr
auxace	equ	hostbr+6
hstace	equ	hostbr+12
;next at hostbr+18
brptr	equ	temp+32	;3 bytes.
fldidx	equ	temp+37
nxtout	equ	temp+39

;
; eeprom switch options.
;
dcopt	equ	temp+41		; destructive chars.
leopt	equ	temp+42		; local echo.
tkopt	equ	temp+43		; tek priority.
roopt	equ	temp+44		; ignore rubout.
avopt	equ	temp+45		; auto vt100 - '0' = normal Cware,
				; '2' = enter vt100 on host serial input,
				; '1' = save host serial for vt100 but
				; switch mode only on command.
bpopt	equ	temp+46		; bit pad type, 'G' - GTCO,
				; 'K' - Kurta pad, 'M' - Summa mouse,
				; 'L' - Logitech mouse, 'S' - Summa-
				; graphics Bit Pad 1 (default).
setup:
	php
	rep	#0x30
	pha
	phx
	phy


	pei	<color
	pei	<xpos
	pei	<ypos
	pei	<acx
	pei	<acy	
	pei	<acflag

	lda	##0
	jsl	>0,SaveDa
	pha

	bsl	rcurs		; make sure no loose cursors.
	bsl	racurs

	bsl	savfnt		; save alpha parameters.
	bsl	chinit		; set default alpha parameters.

	sep	#0x30
	lda	#64		; link alpha/gfx caps.
	trb	<acflag
;
; Gobble up all buffered keys until
; the setup key comes through.
;

$gob:
	bit	Iqcnt3+1
	bpl	$gob1
	jsl	>0,GetKey
	cmp	#0xfe
	bne	$gob
$gob1:
	inc	Setupk

;
; Set color 0 to 0 and color 1 to green.
; Don't need to save anything here because
; we're changing only the clt DACs, not
; the ram copy of the clt.
;
	stz	Rbcltn		; select color 0, set to black.
	stz	0xfe46
	stz	0xfe48
	stz	0xfe4a

	stz	Rbrmsk		; mask out planes 0-7.

	lda	#1
	sta	DaColr		; make sure current color <> 0
	sta	<color
	sta	Rbovcl		; set overlay color to 1.
	sta	Rbcltn		; select color 1, set to green.
	lda	#0xff
	sta	0xfe48
	stz	0xfe46
	stz	0xfe4a

	stz	DaBclr		; set background color to 0..
	stz	<bcolor
	lda	#0x20		; r/w 9th plane (display later).
	sta	Capctl	
	stz	DaCtl		; turn off clipping etc.
	rep	#0x20		; set window = full screen.
	stz	Xorg
	stz	Yorg
	stz	Xwbot
	stz	Ywbot
	lda	##0x500
	sta	Xwtop
	lda	##0x400
	sta	Ywtop
;
; Initialize parameter values for each screen.
; Here when setup first entered and after
; eeprom save or restore.

$start:

;
; Screen 0.
;
	sep	#0x30
	ldx	#'N'
	ldy	#'Y'
	stx	<tkopt		; assume AED priority over Tek.
	bit	<tekpri		; true ?
	bpl	$opt1		; br if yes.
	sty	<tkopt
$opt1:	stx	<dcopt		; assume chars don't erase.
	bit	<chropt		; true ?
	bpl	$opt2		; br if yes.
	sty	<dcopt
$opt2:	stx	<leopt		; assume no local echo.
	bit	<locsw		; true ?
	bvc	$opt3		; br if yes.
	sty	<leopt
$opt3:	stx	<roopt		; assume rubout not ignored.
	bit	<rubopt		; true ?
	bpl	$opt4		; br if yes.
	sty	<roopt
$opt4:	ldx	#'2'		; assume auto vt.
	lda	<autovt
	bmi	$vt
	dex
	cmp	#64		; 64 = ignore serial, save for vt100.
	beq	$vt
	dex			; assume normal cware operation.
$vt	stx	<avopt
	lda	<bptype
	sta	<bpopt
;
; Screen 1.
;
	rep	#0x20
	sep	#0x10
	ldx	#16
$asloop:
	lda	Acedat,x
	sta	<hostbr,x
	dex
	dex
	bpl	$asloop

;
; Draw first setup screen.
;
	sep	#0x20
	stz	<curscr		; select screen 0.
	lda	#128
	trb	<chropt
	bsl	setscr		; init screen.

	sep	#0x30
$w10:	bit	Dpdone
	bvc	$w10
	lda	#0x30		; make overlay plane visible.
	sta	Capctl
	
	stz	<setab		; in setup a, exit to intrp.	
;
; top of setup-idle loop.
;

$idle:
	bit	Iqcnt3+1	; key ready ?
	bmi	$get		; br if yes.
	bsl	acursr		; no, blink cursor.
	bra	$idle		; wait some more.

$get:	bsl	racurs		; key waiting, turn off cursor.
	jsl	>0,GetKey	; get the key.
	cmp	#0xfe		; setup key ?
	bne	$1
	stz	Setupk
	brl	$exit		; exit if yes.

$1:	cmp	#'0'		; reset command ?
	bne	$2
	jmp	>0,Start

$2:	cmp	#9		; tab ?
	bne	$3
	inc	<curfld		; move cursor to next field on tab.
	bsl	feldxy
	bra	$curs		; draw cursor and go to idle.

$3:	cmp	#'1'
	bne	$4
	lda	#128
	tsb	<setab		; exit to vt100 mode.
	brl	$exit		
$4:
	cmp	#'5'
	bne	$5
	inc	<curscr
	bsl	setscr
	bra	$curs		; draw cursor and go to idle.
$5:
	cmp	#'6'
	bne	$6
	bsl	nxtval		; display next value for field.
	bra	$curs		; draw cursor and go to idle.
$6:
	cmp	#19		; control s - save to eeprom.
	bne	$7
	bsl	update
	bsl	shifts
	brl	$start
$7:
	cmp	#18		; control r - restore from eeprom.
	bne	$8
	bsl	update
	lda	<curscr
	beq	$70
	cmp	#1
	beq	$71
	bra	$curs
$70	bsl	eeinit
	brl	$start
$71	jsl	>0,AceRst
	brl	$start
$8:
$curs:
	bsl	dacurs
	brl	$idle

$exit:
	sep	#0x30
	jsl	>0,Erase	; erase overlay plane.

	rep	#0x20
	pla
	beq	$done0
	jsl	>0,RstrDa	; restore da registers.
	pha
	jsl	>0,FreHeap
$done0:
	bsl	resfnt		; restore alpha parameters.
	sep	#0x30	
	ldx	#2		; restore colors 0,1.
	ldy	#0
	jsl	>0,SetClt

	bsl	update
$don10:	
;
; see if exiting to VT100 mode.
;
	bit	<setab
	bpl	$done1
	jsl	>0,Vt100
$done1:
	rep	#0x30
	pla
	sta	<acflag
	pla
	sta	<acy
	pla
	sta	<acx
	pla
	sta	<ypos
	pla
	sta	<xpos
	pla
	sta	<color
	ply
	plx
	pla
	plp
	rtl

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Display next value for current field.	;
; Called when '6' key hit.		;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

nxtval:
	php
	rep	#0x30
	pha
	phx
	phy
	pei	<xpos
	pei	<ypos

	sep	#0x30
	lda	#128
	tsb	<chropt		; make chars destructive.
	rep	#0x20
	lda	<nxtout
	beq	$1
	per	$1-1
	clc
	per	sujump
	adc	1,s
	dec	a
	sta	1,s
	bsl	feldxy
	ldx	<fldidx
	lda	<0,x
	sep	#0x20
	rts
$1:	
	sep	#0x20
	lda	#128
	trb	<chropt
	rep	#0x30
	pla
	sta	<ypos
	pla
	sta	<xpos
	ply
	plx
	pla
	plp
	rts

sujump:
	nop			; so nxtout <> 0 for first routine.
nextdb:
	inc	a
	cmp	#9
	bcc	$1
	lda	#5
$1:	brl	digout

nextsb:	eor	#3		; 1,2 -> 2,1
	brl	digout

nextfc:	cmp	#'X'
	bne	$1
	lda	#'M'
	bra	$out
$1:	cmp	#'M'
	bne	$2
	lda	#0
	bra	$out
$2:	lda	#'X'
$out:	brl	digout
	
nextpa:	cmp	#'N'
	bne	$1
	lda	#'E'
	bra	digout
$1:	cmp	#'E'
	bne	$2
	lda	#'O'
	bra	digout
$2:	cmp	#'O'
	bne	$3
	lda	#'0'
	bra	digout
$3:	cmp	#'0'
	bne	$4
	lda	#'1'
	bra	digout
$4:	lda	#'N'
	bra	digout

digout:
	sta	<0,x
	cmp	#10
	bcs	$1
	adc	#'0'
$1:	jsl	>0,Dchar
	rts

yorn:
;	eor	#'Y' xor 'N'	; Y,N -> N,Y
	eor	#0x17
	bra	digout
nextbp:
	cmp	#'S'
	bne	$1
	lda	#'G'
	bra	digout
$1:	cmp	#'G'
	bne	$2
	lda	#'K'
	bra	digout
$2:	cmp	#'K'
	bne	$3
	lda	#'L'
	bra	digout
$3:	cmp	#'L'
	bne	$4
	lda	#'M'
	bra	digout
$4:	lda	#'S'
	bra	digout


vtmode:	inc	a
	cmp	#'3'
	bcc	digout
	lda	#'0'
	bra	digout
nextbr:
	phk
	ply
	sty	<brptr+2
	rep	#0x20
	per	$brate
	pla
	sta	<brptr
	ldy	#0
	lda	<0,x
$loop:
	cmp	[<brptr],y
	beq	$found	
	iny
	iny
	cpy	#$lstbr
	bcc	$loop
	rts

$found:	iny
	iny
	cpy	#$lstbr
	bcc	$1
	ldy	#0
$1:	lda	[<brptr],y
	sta	<0,x

	pei	<xpos
	ldy	#5
	lda	##32	; space
$2:	jsl	>0,Dchar
	dey
	bne	$2
	pla
	sta	<xpos

	lda	<0,x
	bsl	decout
	rts
$brate:
	dcw	50
	dcw	75
	dcw	110
	dcw	135
	dcw	150
	dcw	300
	dcw	600
	dcw	1200
	dcw	1800
	dcw	2000
	dcw	2400
	dcw	3600
	dcw	4800
	dcw	7200
	dcw	9600
	dcw	19200
	dcw	38400
	dcw	56000
$lstbr	equ	!-$brate

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; display current values of	;
; current screen parameters.	;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

dvalue:
	php
	rep	#0x30
	pha
	phx
	phy

	sep	#0x30

	stz	<curfld
	bsl	feldxy

	lda	<curscr
	beq	$scrn0
	cmp	#1
	beq	$scrn1
	cmp	#2
	beq	$scrn2
	brl	$done
$scrn0:
	ldx	<fldidx
	lda	<0,x
	bsl	$chrout
	lda	<curfld
	bne	$scrn0
	brl	$done	
$scrn1:
	ldx	#12
$loop1:
	rep	#0x20
	
	lda	<hostbr,x
	bsl	decout

	sep	#0x20
	inc	<curfld
	bsl	feldxy

	lda	<hostdb,x
	ora	#0x30
	bsl	$chrout

	lda	<hostsb,x
	ora	#0x30
	bsl	$chrout

	lda	<hostpa,x
	bsl	$chrout

	lda	<hostfc,x
	bsl	$chrout

	txa
	sec
	sbc	#6
	tax
	bpl	$loop1
	brl	$done

$scrn2:
$done:
	sep	#0x20
	stz	<curfld
	bsl	feldxy

	rep	#0x30
	ply
	plx
	pla
	plp
	rts

$chrout:
	jsl	>0,Dchar
	inc	<curfld
	bsl	feldxy
	rts
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Draw current setup screen.  Points	;
; scrptr to the text for the screen,	;
; fields to the data entry fields in	;
; the screen.  Sets curfld = 0 and	;
; calls feldxy.				;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

setscr:
	php
	sep	#0x20

	phk
	pla
	sta	<scrptr+2
	sta	<fields+2

	lda	<curscr
	cmp	#2
	bcc	$ok
	lda	#0
	stz	<curscr
$ok:
	cmp	#0
	bne	$1		
	per	$feld0
	per	$scrn0
	bra	$10
$1:
	cmp	#1
	bne	$2
	per	$feld1
	per	$scrn1
	bra	$10
$2:
	cmp	#2
	bne	$3
	per	$feld2
	per	$scrn2
	bra	$10
$3:
$10:
	rep	#0x20
	pla
	sta	<scrptr
	pla
	sta	<fields	
	bsl	dscrn	
	sep	#0x20
	stz	<curfld
	bsl	feldxy
	
	plp
	rts


$scrn1:
	dcb	2			; character position
	dcb	16			; line, column.
	dcs	"Colorware 1280 setup " ; associated text.
	dcs	" (serial ports).\0"

	dcb	5
	dcb	1
	dcs	"Baud rate\0"

	dcb	6
	dcb	1
	dcs	"Data bits\0"

	dcb	7
	dcb	1
	dcs	"Stop bits\0"

	dcb	8
	dcb	1
	dcs	"Parity\0"

	dcb	8
	dcb	30
	dcs	"N none E even O odd"
	dcs	" 1/0 stick at 1/0\0"

	dcb	9
	dcb	1
	dcs	"Flow control\0"

	dcb	9
	dcb	30
	dcs	"X xon/xoff M rts/cts 0 none\0"

	dcb	4
	dcb	15
	dcs	"Host\0"

	dcb	4
	dcb	21
	dcs	"Aux\0"

	dcb	4
	dcb	27
	dcs	"Mouse\0"

	dcb	18
	dcb	1
	dcs	"0 Reset terminal.\0"

	dcb	19
	dcb	1
	dcs	"1 Enter VT100 mode\0"

	dcb	20
	dcb	1
	dcs	"5 Advance to next screen.\0"

	dcb	21
	dcb	1
	dcs	"Tab key advance"
	dcs	" to next field.\0"

	dcb	22
	dcb	1
	dcs	"6 Choose next"
	dcs	" value in field.\0"

	dcb	23
	dcb	1
	dcs	"Control S sets the default"
	dcs	" parameters of this screen"
	dcs	" to be those shown.\0"

	dcb	24
	dcb	1
	dcs	"Control R resets the "
	dcs	"parameters of this screen"
	dcs	" to their default values.\0"
	dcw	-1
	
$feld1:
	dcw	$lst1-$feld1/6	; number of entries in table

	dcb	5		; fields for host
	dcb	15		; baud, data bits, stop bits,
	dcw	hostbr+12	; parity, flow control.
	dcw	nextbr-sujump

	dcb	6
	dcb	15
	dcw	hostdb+12
	dcw	nextdb-sujump

	dcb	7
	dcb	15
	dcw	hostsb+12
	dcw	nextsb-sujump

	dcb	8
	dcb	15
	dcw	hostpa+12
	dcw	nextpa-sujump

	dcb	9
	dcb	15
	dcw	hostfc+12
	dcw	nextfc-sujump


	dcb	5		; fields for aux
	dcb	21		; baud, data bits, stop bits,
				; parity, flow control.
	dcw	hostbr+6
	dcw	nextbr-sujump

	dcb	6
	dcb	21
	dcw	hostdb+6
	dcw	nextdb-sujump

	dcb	7
	dcb	21
	dcw	hostsb+6
	dcw	nextsb-sujump

	dcb	8
	dcb	21
	dcw	hostpa+6
	dcw	nextpa-sujump

	dcb	9
	dcb	21
	dcw	hostfc+6
	dcw	nextfc-sujump

	dcb	5		; fields for host
	dcb	27		; baud, data bits, stop bits,
				; parity, flow control.
	dcw	hostbr
	dcw	nextbr-sujump

	dcb	6
	dcb	27
	dcw	hostdb
	dcw	nextdb-sujump

	dcb	7
	dcb	27
	dcw	hostsb
	dcw	nextsb-sujump

	dcb	8
	dcb	27
	dcw	hostpa
	dcw	nextpa-sujump

	dcb	9
	dcb	27
	dcw	hostfc
	dcw	nextfc-sujump

$lst1:	;eot



$scrn0:
	dcb	2			; character position
	dcb	16			; line, column.
	dcs	"Colorware 1280 setup"	; associated text.
	dcs	" (graphics options).\0"

	dcb	5
	dcb	1
	dcs	"Destructive chars\0"

	dcb	6
	dcb	1
	dcs	"Tek priority\0"

	dcb	7
	dcb	1
	dcs	"Local echo\0"

	dcb	8
	dcb	1
	dcs	"Ignore delete\0"

	dcb	9
	dcb	1
	dcs	"AED vs VT100\0"

	dcb	9
	dcb	22
	dcs	"0 Host serial input"
	dcs	" handled in AED mode.\0"

	dcb	10
	dcb	22
	dcs	"1 Save host serial input"
	dcs	" for VT100 mode.\0"

	dcb	11
	dcb	22
	dcs	"2 Host serial input causes"
	dcs	" exit to VT100 mode.\0"

	dcb	13
	dcb	1
	dcs	"Bit pad type\0"

	dcb	13
	dcb	22
	dcs	"G - GTCO pad, "
	dcs	"K - Kurta pad, "
	dcs	"L - Logitech mouse,\0"

	dcb	14
	dcb	22
	dcs	"M - Summa mouse, "
	dcs	"S - Summagraphics pad.\0" 

	dcb	18
	dcb	1
	dcs	"0 Reset terminal.\0"

	dcb	19
	dcb	1
	dcs	"1 Enter VT100 mode.\0"

	dcb	20
	dcb	1
	dcs	"5 Advance to next screen.\0"

	dcb	21
	dcb	1
	dcs	"Tab key advance"
	dcs	" to next field.\0"

	dcb	22
	dcb	1
	dcs	"6 Choose next"
	dcs	" value in field.\0"

	dcb	23
	dcb	1
	dcs	"Control S sets the default"
	dcs	" parameters of this screen"
	dcs	" to be those shown.\0"

	dcb	24
	dcb	1
	dcs	"Control R resets the "
	dcs	"parameters of this screen"
	dcs	" to their default values.\0"
	
	dcw	-1			; eot.

$feld0:
	dcw	$lst0-$feld0/6

	dcb	5
	dcb	20
	dcw	dcopt
	dcw	yorn-sujump

	dcb	6
	dcb	20
	dcw	tkopt
	dcw	yorn-sujump

	dcb	7
	dcb	20
	dcw	leopt
	dcw	yorn-sujump

	dcb	8
	dcb	20
	dcw	roopt
	dcw	yorn-sujump

	dcb	9
	dcb	20
	dcw	avopt
	dcw	vtmode-sujump

	dcb	13
	dcb	20
	dcw	bpopt
	dcw	nextbp-sujump

$lst0:

$scrn2:
	dcb	2
	dcb	16
	dcs	"1280 Status\0"

	dcw	-1

$feld2:
	dcw	$lst2-$feld2/6
	dcb	1
	dcb	1	
	dcw	0
	dcw	0
$lst2:

	

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Local routine to draw a setup		;
; screen.  Erases overlay plane,	;
; then draws text from screen table.	;
; Point [<scrptr] to table.		;
; Last table entry is -1.		;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

dscrn:
	php
	rep	#0x30
	pha
	phx
	phy

	jsl	>0,Erase

	ldy	##0
$loop:
	rep	#0x20
	lda	[<scrptr],y
	cmp	##-1
	beq	$eval
	iny
	iny
	sep	#0x20
	sta	<ypos
	xba
	sta	<xpos
	bsl	setxy
	bra	$1
$dloop:
	jsl	>0,Dchar	
	iny
$1:	lda	[<scrptr],y
	bne	$dloop
	iny
	bra	$loop

$eval:
	bsl	dvalue
	rep	#0x30
	ply
	plx
	pla
	plp
	rts


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Local routine to display text string.	;
; Set xpos, ypos, point [<sptr] at	;
; (null terminated) string.		;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

putstr:
	php
	rep	#0x30
	pha
	phx
	phy
	sep	#0x30
	ldy	#0
$loop:
	lda	[<sptr],y
	beq	$done
	jsl	>0,Dchar
	iny
	bra	$loop
$done:
	rep	#0x30
	ply
	plx
	pla
	plp
	rts

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Local routine to move xpos,ypos	;
; to beginning of field (# in curfld.)	;
; Wraps to field 0 if necessary.	;
; Sets fldidx = dp address of associated;
; value, nxtout = address of routine to ;
; generate next value for field.	;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

feldxy:
	php
	rep	#0x30
	pha
	phx
	phy

	lda	<curfld
	and	##0xff
	cmp	[<fields]
	bcc	$ok
	lda	##0
	sep	#0x20
	sta	<curfld
	rep	#0x20
$ok:	
	asl	a
	pha
	asl	a
	adc	1,s
	ply
	tay
	iny
	iny
	lda	[<fields],y
	sep	#0x20
	sta	<ypos
	xba
	sta	<xpos
	rep	#0x20
	iny
	iny
	lda	[<fields],y
	sta	<fldidx
	iny
	iny
	lda	[<fields],y
	sta	<nxtout

	bsl	setxy

	rep	#0x30
	ply
	plx
	pla
	plp
	rts

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Convert row, column coords in	;
; ypos, xpos to corresponding	;
; x, y coordinates.		;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

setxy:
	php
	rep	#0x20
	lda	<chight
$1:	bit	Dpdone-1
	bvc	$1
	sta	0xfe00
	lda	<ypos
	dec	a
	and	##0xff
	sta	0xfe04
	sta	DaMul
	sec
	lda	##1000
$2:	bit	Dpdone-1
	bvc	$2
	sbc	0xfe02
	sta	<ypos
	bra	setx1
xsetx:
	php
	rep	#0x20
$1:	bit	Dpdone-1
	bvc	$1
setx1:
	lda	<xpos
	dec	a
	and	##0xff
	beq	$ez
	sta	0xfe04
	lda	<cwidth
	sta	0xfe00
	sta	DaMul
$1:	bit	Dpdone-1
	bvc	$1
	lda	0xfe02
	clc
	adc	##100
	sta	<xpos

	plp
	rts
$ez
	lda	##100
	sta	<xpos
	plp
	rts

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Local routine to display the (unsigned);
; value in acc in decimal format.	;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

decout:
	php
	rep	#0x30
	pha
	phx
	phy
;
; point edtemp at table of powers of ten
;
	per	$tens
	plx
	stx	<edtemp
	phk
	phk
	plx
	stx	<edtemp+2

	ldy	##-2
;
; inc y until 10**y > acc.
;
$1:
	iny
	iny
	cmp	[<edtemp],y	; acc >= ten**y ?
	bcs	$1		; br if yes.
; 
; while(--y > 0)	(while acc >= 10)
; 	x = '0'
; 	while(acc >= 10**y)
;		acc -= 10**y
;		x++
;	output(x)
; output(acc + '0')
;
	bra	$4		; loop if --y > 0.
$2:
	sbc	[<edtemp],y	; subtract 10**y.
	inx			; inc coefficient of 10**y.
$22:	cmp	[<edtemp],y	; acc >= 10**y ?
	bcs	$2		; br if yes.
$3:
	pha			; save val being converted.
	txa			; get decimal digit.
	jsl	>0,Dchar
	pla			; recover val to convert.
$4:
	ldx	##'0'		; init coefficient of 10**y.
	dey			; down to onesies ?
	dey
	beq	$done
	bpl	$22		; br if no.
$done:
	ora	##'0'		; convert acc to decimal
	jsl	>0,Dchar

	rep	#0x30
	ply
	plx
	pla
	plp
	rts
$tens:
	dcw	0
	dcw	10
	dcw	100
	dcw	1000
	dcw	10000
	dcw	-1

;
; save parameters to eeprom.
; only the parameters of the 
; current screen are saved.

shifts:
	php
	sep	#0x30
	lda	<curscr
	cmp	#1
	bne	$1
	jsl	>0,AceSav
	bra	$done

$1:	cmp	#0
	bne	$done
	ldx	#0
$le
	bit	0xff1e
	bpl	$le
	lda	<dcopt,x
	cmp	>EEP,eeopt0,x
	beq	$10
	sta	>EEP,eeopt0,x
$10	inx
	cpx	#bpopt-dcopt+1	; index last ee option+1
	bcc	$le
$done:
	plp
	rts
	
update:
;
; see if asynch format change requested.
;
	php
	rep	#0x20
	sep	#0x10		
	ldx	#0

$ploop:	lda	<padace,x
	cmp	Acedat,x
	beq	$nxtp
	pea	##Intdrp+padace
	ldx	#0
	jsl	>0,AceSet
	ldx	#5
$nxtp:	inx
	cpx	#6
	bcc	$ploop

$aloop:	lda	<padace,x
	cmp	Acedat,x
	beq	$nxta
	pea	##Intdrp+auxace
	ldx	#1
	jsl	>0,AceSet
	ldx	#11
$nxta:	inx
	cpx	#12
	bcc	$aloop

$hloop:	lda	<padace,x
	cmp	Acedat,x
	beq	$nxth
	pea	##Intdrp+hstace
	ldx	#2
	jsl	>0,AceSet
	bra	$done
$nxth:	inx
	cpx	#18
	bcc	$hloop
$done:
;
; save new direct page parameter values.
;
	sep	#0x30
	lda	#64
	trb	<locsw
	ldx	<leopt
	cpx	#'Y'
	bne	$optdc
	tsb	<locsw
$optdc	lda	#128
	tsb	<chropt
	ldx	<dcopt
	cpx	#'Y'
	beq	$opttk
	trb	<chropt
$opttk
	lda	#128
	trb	<tekpri
	ldx	<tkopt
	cpx	#'N'
	beq	$optro
	tsb	<tekpri
$optro
	lda	#128
	trb	<rubopt
	ldx	<roopt
	cpx	#'N'
	beq	$opvt
	tsb	<rubopt

$opvt	lda	#128
	ldx	<avopt
	cpx	#'2'
	beq	$vt1
	lsr	a
	cpx	#'1'
	beq	$vt1
	lda	#0
$vt1	sta	<autovt
	ldx	<bpopt
	stx	<bptype
	lda	#'1'
	cpx	#'K'
	beq	$bp
	cpx	#'L'
	beq	$bp
	cpx	#'M'
	beq	$bp
	lda	#'D'
$bp	sta	<cudfmt
	plp
	rts

	end
