
; Ellipse generator.  See /u0/roy/elp/fibelp.c
;
;

;
; Colorware compatible version of ellipse.
;

elp:	php
	sep	#0x30
	jsl	>0,Getb		; get x size.
	tax
	jsl	>0,Getb		; get y size.
	tay
	jsl	>0,Getb		; get junk.
$1:	bit	Dpdone		;wait dpu done
	bvc	$1
	rep	#0x20
	lda	<xpos
	sta	Xcap
	lda	<ypos
	sta	Ycap	
	pea	##0		; ellipse flag
	cpx	#0		; kludge.
	beq	$done
	phk
	bsl	ellips		; draw ellipse.
$done	pla			; clean up stack.
	plp
	rtl

dfc:	php
	sep	#0x30
	lda	#128+64		; fat circle flag.
	bra	dcl1
dcl:
	php
	sep	#0x30
	lda	#128		; normal circle flag.
dcl1:	pha
	pha
	jsl	>0,Getb	
	tax
	tay
$1:	bit	Dpdone
	bvc	$1	
	rep	#0x20
	lda	<xpos
	sta	Xcap
	lda	<ypos
	sta	Ycap
	cpx	#0
	bne	$2
	ldx	<color
	stx	Clp
	bra	$done
$2:	phk
	bsl	ellips
$done:	pla
	plp
	rtl		

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; This routine draws an ellipse centered;
; at Xcap, Ycap with axes parallel to	;
; the x,y axes.  Enter with x and y 	;
; sizes (16 bits) in x,y registers.	;
; All registers preserved.		;
; Bits 15 and 14 of the word below the 	;
; return address indicate whether the	;
; ellipse is a circle (15 set) and if	;
; so, a fat circle (14).  Caller must	;
; clean up stack.			;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

ellips:

;
; Direct page (stack) scratch:
;

$fx	equ	0
$fy	equ	4
$fxx	equ	8
$fyy	equ	12

$falpha	equ	16
$fX	equ	20
$fY	equ	24
$fXY	equ	28

$absfX	equ	32
$absfY	equ	36
$abfXY	equ	40

$axx	equ	44
$byy	equ	48

;	Int variables.
$xandy	equ	52
;$ox	equ	54
$px	equ	56
$py	equ	58
$mx	equ	60
$my	equ	62
$xsemi	equ	64
$prod	equ	66
$plier	equ	68
$plcnd	equ	70
$savx	equ	72
$savy	equ	74
$nbytes	equ	$savy+2	; amount of stack needed for dir page.
$fcflag equ	$nbytes+12	; bit 15 set if drawing circle,
				; bit 14 set if fat circle.

	php
	rep	#0x30
	phd
	pha
	phx
	phy

	sec
	tsc
	sbc	##$nbytes
	tcs
	inc	a
	tcd

;	
; Init coordinates of real ellipse (px,py),(mx,my)
; to (xsemi,0).
;
	stx	<$xsemi
	stx	<$px
	txa
	eor	##-1
	inc	a
	sta	<$mx
	stz	<$py
	stz	<$my

;
; adjust Xorg, Yorg so that the
; ellipse is centered at 0,0.
;
	lda	Xorg
	sta	<$savx
	sec
	sbc	Xcap
	sta	Xorg
	lda	Yorg
	sta	<$savy
	sec
	sbc	Ycap
	sta	Yorg

;
; Compute coefficients axx and byy of x**2 and y**2
; in the ellipse equation, and second partials
; fxx, fyy = 2axx, 2byy.
;
	tyx			; Square ysemi.
	bsl	$mult		; Get low word in acc, high in x.
	sta	<$axx		; axx = ysemi * ysemi.
	stx	<$axx+2

	asl	a		; Set fxx = 2*axx.
	sta	<$fxx
	txa
	rol	a
	sta	<$fxx+2

	ldx	<$xsemi		; Square xsemi.
	txy
	bsl	$mult		; Get low word in acc, high in x.
	sta	<$byy		; byy = xsemi * xsemi.
	stx	<$byy+2

	asl	a		; Set fyy = 2*byy.
	sta	<$fyy
	txa
	rol	a
	sta	<$fyy+2
		
;
; Init first partials fx, fy.
;
	stz	<$fy		; fy = 0.
	stz	<$fy+2
;
; Init fx = xsemi * fxx.  Since fxx is a long,
; this takes some doing.
;
	ldx	<$xsemi
	ldy	<$fxx
	bsl	$mult		; Low word in acc, high in x.

	sta	<$fx		; Save partial result low word.
	stx	<$fx+2		; Ditto high word.  Partial result
				; is complete if fxx high word = 0.
	
	ldx	<$fxx+2		; fxx high = 0 ?
	beq	$1		; Branch if yes, saved a multiply.

	ldy	<$xsemi		; Oh well, we tried.
	bsl	$mult		; Get low word in acc, high should
	clc			; be zero.
	adc	<$fx+2
	sta	<$fx+2

$1
;
; Init decision variable falpha.
;
	stz	<$falpha
	stz	<$falpha+2
;
; This is the main loop.
;

$loop
	bsl	$plot		; plot 4 points.
;	
; Set fX = falpha + axx - fx.
;
	lda	<$falpha
	clc
	adc	<$axx	 
	tax			; x = axx+falpha low.
	lda	<$falpha+2	; a = falpha high.
	adc	<$axx+2		; a = falpha+axx high 
	tay			; save in y.
;
; Now x,y = axx+falpha, subtract fx.
;
	sec
	txa
	sbc	<$fx
	sta	<$fX
	sta	<$absfX
	tya
	sbc	<$fx+2
	sta	<$fX+2
	sta	<$absfX+2
;
; Set fY = falpha + byy + fy.
;
	lda	<$falpha
	clc
	adc	<$byy	 
	tax			; x = byy+falpha low.
	lda	<$falpha+2	; a = falpha high.
	adc	<$byy+2		; a = falpha+byy high 
	tay			; save in y.
;
; Now x,y = byy+falpha, add fy.
;
	clc
	txa
	adc	<$fy
	sta	<$fY
	sta	<$absfY
	tax			; save for fXY below.
	tya
	adc	<$fy+2
	sta	<$fY+2
	sta	<$absfY+2
	tay			; save for fXY below.
;
; Set fXY = fY + fX - falpha.  fY is in x,y registers now.
;
	txa
	clc
	adc	<$fX
	tax			; x = fY + fX low.
	tya			; a = fY high.
	adc	<$fX+2		; a = fY + fX high 
	tay			; save in y.
;
; Now x,y = fX + fY, subtract falpha.
;
	sec
	txa
	sbc	<$falpha
	sta	<$fXY
	sta	<$abfXY
	tya
	sbc	<$falpha+2
	sta	<$fXY+2
	sta	<$abfXY+2
;
; Now compute absolute values of fX, fY, fXY.
;
	ldx	##0

	bit	<$fXY+2
	bpl	$10		; Branch if fXY not negative.
	txa
	sec
	sbc	<$fXY
	sta	<$abfXY
	txa
	sbc	<$fXY+2
	sta	<$abfXY+2
$10
	bit	<$fX+2
	bpl	$11		; Branch if fX not negative.
	txa
	sec
	sbc	<$fX
	sta	<$absfX
	txa
	sbc	<$fX+2
	sta	<$absfX+2
$11
	bit	<$fY+2
	bpl	$12		; Branch if fY not negative.
	txa
	sec
	sbc	<$fY
	sta	<$absfY
	txa
	sbc	<$fY+2
	sta	<$absfY+2
$12
;
; Now find the smallest of absfX, absfY, abfXY, and
; set up to move accordingly.
;	R1 : absfX < absfY
;	R2 : absfY < absXY
;	R3 : absfX < abfXY.
;
;	if(R1)
;		if(R3) move in x direction
;		else move in x and y.
;	else
;		if(R2) move in y direction
;		else move in x and y.
; Note - for a circle we can be sure R1 is false.
;
;
; Evaluate R1 (absfX - absfY < 0)
;
	stz	<$xandy		; Shared code flag for move in 
				; x and y.
	bit	<$fcflag
	bmi	$cir

	sec
	lda	<$absfX
	sbc	<$absfY
	lda	<$absfX+2
	sbc	<$absfY+2
	bcc	$chkR3		; R1 true, check R3.
;
; R1 false, check R2 (absfY - abfXY < 0).		
;
$cir:	sec
	lda	<$absfY
	sbc	<$abfXY
	lda	<$absfY+2
	sbc	<$abfXY+2
	bcc	$20		; R1 false, R2 true, move in X,Y.
	dec	<$xandy
$20	bra	$movy		; R1 false, R2 false, move in Y.
	
;
; R1 true, check R3 ( absfX - abfXY < 0).
;
$chkR3
	sec
	lda	<$absfX
	sbc	<$abfXY
	lda	<$absfX+2
	sbc	<$abfXY+2
	bcc	$movx
	dec	<$xandy		; R1 true, R3 false, move in X,Y.

$movy
	dec	<$my
	inc	<$py

	clc			; fy += fyy
	lda	<$fy
	adc	<$fyy
	sta	<$fy
	lda	<$fy+2
	adc	<$fyy+2
	sta	<$fy+2

	bit	<$xandy		; move in x and y ?
	bpl	$movy1		; br if no.
	bit	<$fcflag	; yes, doing fat circle ?
	bvc	$movx		; br if no.
	bsl	$plot		; yes, plot at new y before moving x.
	bra	$movx		; continue as for normal circle/ellipse.
$movy1
	lda	<$fY
	sta	<$falpha
	lda	<$fY+2
	sta	<$falpha+2
	bra	$cont
;
; R1 true, R3 true, move in X.
;
$movx	
	dec	<$px
	inc	<$mx

	sec			; fx -= fxx
	lda	<$fx
	sbc	<$fxx
	sta	<$fx
	lda	<$fx+2
	sbc	<$fxx+2
	sta	<$fx+2

	bit	<$xandy
	bmi	$30

	lda	<$fX
	sta	<$falpha
	lda	<$fX+2
	sta	<$falpha+2
	bra	$cont
$30
	lda	<$fXY
	sta	<$falpha
	lda	<$fXY+2
	sta	<$falpha+2
$cont
	bit	<$fcflag	; doing a circle ?
	bmi	$ccont		; br if yes.
	bit	<$px		; ellipse is done when px < 0.
	bmi	$done
	brl	$loop
$ccont	lda	<$px		; circle is done when
	cmp	<$py		; py > px.
	bcc	$done
	brl	$loop	
$done
	rep	#0x30
	lda	<$savx
	sta	Xorg
	lda	<$savy
	sta	Yorg

	clc
	tsc
	adc	##$nbytes
	tcs

	ply
	plx
	pla
	pld
	plp
	rtl
;								
; Plot the 4 points
; (px,py),(px,my),(mx,my),(mx,py).
; If we're doing a circle, also plot
; (py,px),(my,px),(my,mx),(mx,py).
;
$plot:
	php
	sep	#0x20
	ldx	<$px
	stx	Xcap
	ldx	<$py
	stx	Ycap
	lda	DaColr
	sta	Clp		; (px,py)
	
	ldx	<$my
	stx	Ycap
	sta	Clp		; (px,my)

	ldx	<$mx
	stx	Xcap
	sta	Clp		; (mx,my)

	ldx	<$py
	stx	Ycap
	sta	Clp		; (mx,py)

	bit	<$fcflag+1
	bmi	$cplot
	plp
	rts
$cplot:
	ldx	<$px
	stx	Ycap
	ldx	<$py
	stx	Xcap
	sta	Clp		; (py,px)
	
	ldx	<$my
	stx	Xcap
	sta	Clp		; (my,px)

	ldx	<$mx
	stx	Ycap
	sta	Clp		; (my,mx)

	ldx	<$py
	stx	Xcap
	sta	Clp		; (py,mx)
	plp
	rts
;
; Unsigned 16 bit multiply.
; Multiplies contents of x,y registers.
; Product low word in acc, high in x.
;

$mult
	lda	##0		; init product low word.
	sta	<$prod		; ditto high word.
	stx	<$plier		; Save multiplier 
	sty	<$plcnd		; and multiplicand.

	lda	##0
	ldy	##16		; bit count.

$mloop
	lsr	<$plier
	bcc	$m1
	clc
	adc	<$plcnd
$m1
	ror	a
	ror	<$prod
	dey
	bne	$mloop
	tax
	lda	<$prod
	rts

	end
