;
; Edge flag polygon fill.
;
; 
; Direct page vars :
;		color
;		xpos, ypos
;		wmask
;
; Global subroutines.
;
;		Getw
;		Getb
;		Gcoor
;

dfp:

edgclr	equ	tmpblk
newx	equ	tmpblk+29
newy	equ	tmpblk+31

$dx	equ	tmpblk+1
$dy	equ	tmpblk+3
$d	equ	tmpblk+5
$temp	equ	tmpblk+7
$xmin	equ	tmpblk+9
$xmax	equ	tmpblk+11
$ymin	equ	tmpblk+13
$ymax	equ	tmpblk+15
$firstx	equ	tmpblk+17
$frsty	equ	tmpblk+19
$ysign	equ	tmpblk+21
$nverts	equ	tmpblk+23
$inc1	equ	tmpblk+25
$inc2	equ	tmpblk+27
;**newx, newy equ tmpblk+29

	php
	rep	#0x30
;
; Get color to write edge flags with.
; AND with write mask because that
; is the color edge flags are written in.
;
	sep	#0x20

	jsl	>0,Getb
	and	<wmask
	sta	<edgclr
;
; Get # vertices, quit if < 3
;
	rep	#0x20
	jsl	>0,Getw
	sta	<$nverts
	cmp	##3
	bcs	$start

; < 3 vertices, gobble em up and return

	cmp	##0
	beq	$done
$hosed:
	jsl	>0,Gcoor
	dec	a
	bne	$hosed
$done:	
	plp
	rtl
;
; Save vertex count.
; Set cap at the first vertex.
; Save first vertex so we can close polygon
; after getting last vertex.
; Get count # of vertices,
; record max,min x and y coords.
; Draw the edges of the polygon as
; the vertices come in, with edge
; flags for the fill later.
;

$start:
	rep	#0x30
	jsl	>0,Gcoor

	stx	<$xmin
	stx	<$xmax
	stx	<xpos
	stx	<$firstx

	sty	<$ymin
	sty	<$ymax
	sty	<ypos
	sty	<$frsty

	dec	<$nverts
;
; Get next vertex, update max
; and min, draw edge from last vertex
; to this one.
;

		
$nxtedg:
	jsl	>0,Gcoor

	cpx	<$xmin		; x < current min ?
	bcs	$1		; br if no.
	stx	<$xmin		; yes, save new min
	bra	$2		; go check y coord.
$1:
	cpx	<$xmax		; x >= current max ?
	bcc	$2		; br if no, check y coord
	stx	<$xmax		; yes, save new max.
$2:	
	cpy	<$ymin		; y < current min ?
	bcs	$3		; br if no.
	sty	<$ymin		; yes, save new min
	bra	$4		; go do edge.
$3:
	cpy	<$ymax		; y >= current max ?
	bcc	$4		; br if no.
	sty	<$ymax		; yes, save new max.
$4:
	bsl	$drwedg		; draw edge.
	dec	<$nverts	; more vertices ?
	bne	$nxtedg		; loop if yes.
;
; Draw edge from last vertex to first.
;
	ldx	<$firstx
	ldy	<$frsty
	bsl	$drwedg

;
; Set up drawing accelerator for edge flag fill.
;
	lda	<edgclr
	and	##0xff
	sta	0xfe00
	lda	<$xmin

	dec	a
	dec	a

	sta	Xcap
;	nop
;	nop
	sta	0xfe02
	lda	<$ymin
	sta	Ycap
;	nop
;	nop
	sta	0xfe04
	lda	<$xmax

	inc	a		; ucode bug ?
	inc	a

	sta	0xfe06
	lda	<$ymax
	sta	0xfe08
;	nop
;	nop
	sta	DaDfp
	brl	$done
;
; All the edges and edge flags are drawn, do the fill.
; In real life, at this point we call the drawing accelerator
; with parameters xmin, ymin, xmax, ymax, and edgclr,
; and it does the fill.
;
;
;	sep	#0x20
;	lda	#7
;	trb	Capctl
;	rep	#0x20
;	
;	sec
;	lda	<$xmax		; set xcount = width of  
;	sbc	<$xmin		; window in pixels.
;	sta	<$dx
;	
;	sec
;	lda	<$ymax		; set ycount = # scan lines
;	sbc	<$ymin		; in window.
;	sta	<$dy
;
;	lda	<$ymin		; set y cap to bottom of window.
;	sta	Ycap
;
;	sep	#0x30		; 8 bit mem idx
;	inc	<$dy
;	inc	<$dy+1
;	ldy	<color		; fill color in y forever.
;;
;; top of per line loop
;;
;
;$ylup:	
;	rep	#0x20
;
;	lda	<$xmin		; set x cap to left edge of window.
;	sta	Xcap
;
;	sep	#0x20
;
;	ldx	<$dx+1		; reload pixel counter
;	inx
;	stx	<$temp
;	ldx	<$dx
;	inx	
;;
;; top of looking for start flag loop.
;; Advance x cap until flagged pixel is found
;; or end of line reached.
;;
;
;$xlup:
;	lda	Vm		; pixel at cap a flag ?
;	and	<wmask	
;	cmp	<edgclr
;	beq	$flup		; br if yes, start filling.
;	bit	Vmimaj		; no, bump x cap.
;$lup:	dex			; more pixels this line ?
;	bne	$xlup		; xlup if yes.
;	dec	<$temp
;	bne	$xlup
;
;$nxtlin
;	bit	Vmimin		; advance y cap to next line.
;	dec	<$dy		; more lines in window ?
;	bne	$ylup
;	dec	<$dy+1
;	bne	$ylup
;	brl	$done
;;
; Here when flagged pixel found.  Write <color at
; at cap and advance x cap, filling until next
; flagged pixel.
;
;$flup:
;	sty	Vmimaj
;	dex
;	bne	$f1
;	dec	<$temp
;	beq	$nxtlin	; in case no flag seen (there is one though).
;$f1:	lda	Vm
;	and	<wmask
;	cmp	<edgclr
;	bne	$flup
;	sty	Vmimaj
;	bra	$lup
;
; Edge flag drawing subroutine.
; This is Bresenhams algorithm, perverted to
; generate edge flags at the appropriate places.
; Draw edge from <xpos, <ypos to reg x,y.
; The edge is drawn in <color, except for
; the flags, drawn in <edgclr.  <color never
; replaces <edgclr.  If a flag exists where a
; flag is to be drawn, the flag is replaced
; with <color.
; Flags are drawn at the leftmost pixel of 
; every run of pixels in an edge, except the
; bottom-most run of an x-major edge.  A flag
; is set at the higher vertex of an edge.
; No flags are set in a horizontal edge.
; Edges are always draw in direction of increasing
; x.
; No registers preserved, exit with <xpos, <ypos 
; at the new vertex.
;

$drwedg:
	php
	rep	#0x30
	stx	<newx		; save exit value of <xpos.
	sty	<newy		; save exit value of <ypos.
	
;
; Set dy = abs(y-ypos), dx = abs(x-xpos).
;  If (x-xpos) > 0 set x = xpos, y = ypos
; (draw in direction of increasing x).
; 
	sec
	txa
	sbc	<xpos
	bmi	$d11

	ldx	<ypos
	sty	<ypos
	txy
	ldx	<xpos
	bra	$d1	
$d11:
	eor	##-1		; dx < 0, make it positive.
	inc	a
$d1:
	sta	<$dx

	sec
	tya
	sbc	<ypos
	sta	<$ysign		; save sign of y - ypos.
	bpl	$d2		; br if y going down.

	eor	##-1		; make dy positive.
	inc	a
$d2:
	sta	<$dy
;
; set y cap ctl
;
	sep	#0x20
$w1:	bit	Dpdone
	bvc	$w1
	lda	#7
	trb	Capctl
	lda	#1
	bit	<$ysign+1	; y going up ?
	bmi	$ohyeah		; br if yes.
	tsb	Capctl
$ohyeah:
	rep	#0x20

	stx	Xcap		; set cap.
	sty	Ycap

	lda	<$dy		; dy = 0 ?
	beq	$horz		; br if yes, easy one.
	cmp	<$dx		; dy < dx ?
	bcc	$xmajor		; br if yes
	beq	$diag		; br if dx = dy.
	lda	<$dx
	beq	$vert
	brl	$ymajor		; dy > dx.

$vert:	brl	$vertic
$horz:	brl	$horiz
$diag:	brl	$diagon

$xmajor:
;
; Set up Bresenham variables for y major vector.
; d = 2*dy - dx, inc1 = 2*dy, inc2 = 2*(dy-dx), or
; inc1 = 2*dy, d = inc1 - dx, inc2 = d - dx.
;
	lda	<$dy
	asl	a
	sta	<$inc1

	sec
	sbc	<$dx
	sta	<$d

	sec
	sbc	<$dx
	sta	<$inc2

	inc	<$dx		; set dx = number of pixels to write.
	sep	#0x10		; 8 bit idx.

;
; Draw vector of length dx, in increasing x direction,
; (first pixel of a run is also leftmost)
; with a flag pixel at the leftmost edge of all but the
; lowest horizontal run in each vector.  The lowest run
; will be drawn first if y is going up, last if y down.
; If y is increasing, don't flag the first pixel of
; the first run (that's easy).  If y decreasing, don't
; flag the first pixel of the last run.  We manage that
; by counting runs (dy+1 total).  When we get to the last
; run, we abandon the vector drawing loop and draw the
; remaining (horizontal) pixels without flags.
;
	bit	<$ysign		; y going down ?
	bpl	$xydown		; br if yes.

	lda	<$d		; y going up, don't flag first run.
	bra	$xloop

$xydown:
	bsl	doflag		; flag first run of downward edge.
	lda	<$d
	bra	$xu0


$xloop:
	bsl	docolr		; write color at cap
$xu0:	bit	##0x8000	; advance in x only ?
	beq	$xu3		; br if no, advance x and y.

	ldy	Vmimaj		; yes, next pixel on same line.
	clc
	adc	<$inc1
$xu1:
	dec	<$dx		; more pixels to write ?
	bne	$xloop		; br if yes.
	brl	$leave		; no, update <xpos,<ypos and return.
$xu3:
	ldy	Vmimm		; advance x and y.
;
; flag first pixel of run unless it is the last run
; of an edge going down in y.  in the latter case, just
; go ahead and write the remaining dx pixels (they are
; all on current line).  Dec dx and check for 0 BEFORE
; writing, we wrote a pixel at xloop, advanced cap but
; haven't checked to see if it was the last one yet.
;
	ldy	<$ysign+1	; y going up ?
	bmi	$xu4		; br if yes.
	dec	<$dy		; down, are we at last run ?
	beq	$xu6		; br if yes, finish up.
;
; Here on beginning of every run except
; last run if y going down.
;

$xu4:	dec	<$dx
	beq	$xu7
	bsl	doflag		; flag the first pixel of the run.
	clc
	adc	<$inc2
	bra	$xu0		; go do next pixel.

;
; Here on last run of y down edge
; (enter at xu6 to keep pixel count honest).
;

$xu5:
	bsl	docolr		; write current color.
	ldy	Vmimaj		; advance x cap.
$xu6:	dec	<$dx		; more pixels in vector ?
	bne	$xu5		; yes, do em.
$xu7:	brl	$leave
	

;
; Here to do a y major edge.  This is easier than x major
; because the horizontal runs are all exactly 1 pixel long.
; Flag leftmost pixel of every "run", except lowest as
; with x major.
;

$ymajor:

;
; Set up Bresenham variables for y major vector.
; d = 2*dx - dy, inc1 = 2*dx, inc2 = 2*(dx-dy), or
; inc1 = 2*dx, d = inc1 - dy, inc2 = d - dy.
;
	lda	<$dx
	asl	a
	sta	<$inc1

	sec
	sbc	<$dy
	sta	<$d

	sec
	sbc	<$dy
	sta	<$inc2

	sep	#0x10

;
; If y going up, don't flag first pixel, but still
; write dy+1 pixels and exit.  If y going down,
; write dy flags, then 1 unflagged.
;
	bit	<$ysign
	bpl	$ydown

	bsl	docolr		; lower vertex pixel is not a flag.
	lda	<$d
	inc	<$dy		; number pixels to write.
	bra	$yu0		; skip first flag.

$ydown:
	lda	<$d
$yloop:
	bsl	doflag		; flag pixel at cap.
$yu0:
	bit	##0x8000	; move cap in y only ?
	beq	$yu3		; br if no, advance x and y.

	ldx	Vmimin		; yes, advance y.
	clc
	adc	<$inc1
$yu1:
	dec	<$dy
	bne	$yloop
	ldy	<$ysign+1	; did we quit early for a y down?
	bmi	$yu2		; br if no.
	bsl	docolr		; yes, do last (lowest) pixel in <color.
$yu2:
	brl	$leave		; no, update <xpos,<ypos and return.
$yu3:
	ldx	Vmimm		; advance major,minor
	clc
	adc	<$inc2
	bra	$yu1
;
; Vertical edge, all flags except lowest pixel.
;
$vertic:	
	rep	#0x10
	sep	#0x20
	ldx	<$dy
	bit	<$ysign+1
	bpl	$vdown

	bsl	docolr
	bit	Vmimin
$v1:	bsl	doflag
	bit	Vmimin
	dex
	bne	$v1
	brl	$leave
$vdown:	
	bsl	doflag
	bit	Vmimin
	dex
	bne	$vdown
	bsl	docolr
	brl	$leave
;
; Diagonal edge, all flags except lowest pixel.
;
$diagon:
	rep	#0x10
	sep	#0x20

	ldx	<$dx
	bit	<$ysign+1
	bpl	$ddown

	bsl	docolr
	bit	Vmimm
$di1:	bsl	doflag
	bit	Vmimm
	dex
	bne	$di1
	bra	$leave
$ddown:	
$di2:	bsl	doflag
	bit	Vmimm
	dex
	bne	$di2
	bsl	docolr
	bra	$leave
;
; Horizontal edge, no flags.
;
$horiz:
	sep	#0x20
	rep	#0x10
	ldx	<$dx
	beq	$leave
	inx
$h1:	bsl	docolr
	bit	Vmimaj
	dex
	bne	$h1
	bra	$leave
			
;
; Here after drawing an edge.
; Set <xpos, <ypos = current vertex,
; restore memory mode etc.
;
$leave:
	rep	#0x30
	lda	<newx
	sta	<xpos
	lda	<newy
	sta	<ypos
	plp
	rts
;
; Write a pixel in current color, unless
; the pixel is flagged, in which case
; leave it alone.
;
docolr:
	php
	rep	#0x20
	pha
	sep	#0x20
	lda	Vm
	and	<wmask
	cmp	<edgclr
	beq	$done
	lda	<color
	sta	Vm
$done:
	rep	#0x20
	pla
	plp
	rts
;
; Write a pixel in edge flag color,
; unless it is flagged, in which case
; replace it with current color.
;
doflag:
	php
	rep	#0x20
	pha
	sep	#0x20
	lda	Vm
	and	<wmask
	cmp	<edgclr
	bne	$1
	lda	<color
	sta	Vm
	rep	#0x20
	pla
	plp
	rts
$1:	lda	<edgclr
	sta	Vm
	rep	#0x20
	pla
	plp
	rts
finis:
	end


