#include "tcp.h"

mov(x, y)	/* move cap */
int x, y;
{
	aedbf[0] = MOV;

/*	terminal wants x,y packed into 3 bytes as follows :
		byte 1 : x bits 11-8, y bits 11-8
		byte 2 : x bits 7-0
		byte 3 : y bits 7-0
	encode accomplishes this.	
*/
	
	encode(&(aedbf[1]),x,y);
	obyte(aedbf, 4);
}

mvr(dx, dy)	/* move cap relative   -127 < dx,dy < 127 */
int dx, dy;
{
	aedbf[0] = MVR;
	aedbf[1] = dx;
	aedbf[2] = dy;
	obyte(aedbf, 3);
}

dfr(x, y)	/* draw filled rectangle */
int x, y;
{
	aedbf[0] = DFR;
	encode(aedbf+1, x, y);
	obyte(aedbf, 4);
}

wpx(color)		/* write a pixel */
int	color;
{
	aedbf[0] = WPX;
	aedbf[1] = color;
	obyte(aedbf, 2);
}

wmp(dx,dy)		/* write multiple pixels. */
char dx[], dy[];	/* after writing i'th pixel */
			/* terminal does mvr(dx[i],dy[i]). */
			/* if both dx[i] and dy[i] */
			/* are zero, it's done	*/
{
	register char *px = dx,
  		      *py = dy,
		      *bp = aedbf;

	int i; /* #dx,dy pairs to send, inc. terminator */

/*	find out how many dx,dy pairs there are to send. */
/*	there's at least 1 - the mandatory 0,0 terminator. */
/*	for no good reason we insist that there be at most */
/*	32767 of them.					*/

	i = 1;	/* at least */

	while( (*px || *py) && (i > 0) ){
		px++;
		py++;
		i++;
	}

	if(i < 0){
		printf(" wmp ** too many pixels, 32767 max \n");
		exit(0);
	}

/*	issue command	*/

	aedbf[0] = WMP;
	obyte(aedbf,1);

/*	send the i  dx, dy pairs, 	*/
/*	sizeof(aedbf) bytes at a time.	*/
	
	px = dx;
	py = dy;

	for(;;){
		bp = aedbf;
		while(bp < aedbf + AEDBFMAX - 1){
			*bp++ = *px++;
			*bp++ = *py++;
			if(--i == 0){
				obyte(aedbf,bp - aedbf);
				return;
			}				
		}
		obyte(aedbf,AEDBFMAX);
	}
}

rpx(col)	/* read pixel */
int *col;	/* return color number at CAP	*/
		/* both in *col and as function value */
{
	aedbf[0] = RPX;
	ordcmd(aedbf,1);
	ibyte(aedbf,1);
	return(*col = aedbf[0] & 0377);
}
	
dva(x, y)	/* draw vector absolute */
int x, y;
{
	aedbf[0] = DVA;
	encode(aedbf+1, x, y);
	obyte (aedbf, 4);
}

dvr(dx,dy)			/* draw vector relative */
int dx,dy;
{
	aedbf[0] = DVR;
	aedbf[1] = dx;
	aedbf[2] = dy;
	obyte(aedbf,3);
}

dmv(dx,dy)		/* draw multiple vectors */
char dx[],dy[];		/* only differencce between dmv */
			/* and wmp is the opcode.	*/
{
	register char *px = dx,
		      *py = dy,
		      *bp = aedbf;
	int    i = 1;


	while( (*px || *py) && (i > 0) ){
		px++; py++; i++;
	}

	if(i<0){
		printf(" dmv ** too many vectors, 32767 max\n");
		exit(0);
	}

	aedbf[0] = DMV;
	obyte(aedbf,1);

	px = dx;
	py = dy;

	for(;;){
		bp = aedbf;
		while(bp < aedbf + AEDBFMAX - 1){
			*bp++ = *px++;
			*bp++ = *py++;
			if(--i == 0){
				obyte(aedbf,bp - aedbf);
				return;
			}
		}
		obyte(aedbf,AEDBFMAX);
	}			
}
		
aav(arg)		/* anti-aliased vector mode */
int arg;
{
	switch(arg){
	case 0: /* turn off anti-aliasing */
	case 1: /* enable AAV, don't init color table for default */
	case 2: /* enable AAV, set up color table for default */

		aedbf[0] = XTD;
		aedbf[1] = AAV;
		aedbf[2] = arg;
		obyte(aedbf,3);
		return;
	default:
		printf(" aav ** invalid arg : %d\n");
		printf(" valid args are 0 1 2\n");
		exit(0);
	}
}
bfl(color)				/* boundary fill */
int color;
{
	aedbf[0] = BFL;
	aedbf[1] = color;
	obyte(aedbf,2);
}

/*	set line style.		*/
/*	scale is ridiculous,	*/
/*	TAP really should map	*/
/*	(1,2,4,8) -> (255,85,17,1)	*/

sls(pattern,scale)	/* set line style */
int pattern,scale;
{
	switch(scale){

	case 255:	/* scale factor is 1	*/
	case 85:	/* scale factor is 2	*/
	case 17:	/* scale factor is 4	*/
	case 1:		/* scale factor is 8	*/

		aedbf[0]= SLS;
		aedbf[1] = pattern;
		aedbf[2] = scale;
		obyte(aedbf,3);
		return;

	default:
		printf(" sls ** bad scale arg : %d\n",scale);
		printf(" use one of 255,85,17,1\n");
		exit(0);
	}
}

spf(pat)		/* set pattern fill */
int pat;
{
	if( (pat < 0) || (pat > 15) ){
		printf(" spf ** bad pattern number %d\n", pat);
		printf(" pattern number must be in 0..15\n");
		exit(0);
	}
	aedbf[0] = SPF;
	aedbf[1] = pat;
	obyte(aedbf,2);
}

wip(n16,byt)	/* write incremental plotter mode */
int n16;	/* number of direction codes in byt */
char byt[];	/* direction codes, 2 per byte	*/
{
	register int n = n16;

	aedbf[0]= WIP;
	aedbf[1]= ( n >> 8 );
	aedbf[2]= n;
	n/=2;
	obyte(aedbf,3);
	obyte(byt,n);
}

/*	Write n special font characters.	*/
/*	code[i] is a special font identifier.	 */
/*	After special font char code[i] has been */
/*	written, terminal does a move relative	*/
/*	dx[i],dy[i].				*/

wsf(n,code,dx,dy)	/* write special font */
int n;
register char code[],dx[],dy[];
{

	char *last = code + n;

	aedbf[0] = WSF;
	obyte(aedbf,1);

	while(code < last){
		aedbf[0] = *code++;
		aedbf[1] = *dx++;
		aedbf[2] = *dy++;
		obyte(aedbf,3);
	}
	aedbf[0] = 0;
	obyte(aedbf,1);
}

dcl(rad)	/* draw circle	*/
int rad;
{
		aedbf[0] = DCL;
		aedbf[1] = rad & 127;
		obyte(aedbf, 2);
}

frr(dx, dy)	/* draw filled rectangle relative */
int dx, dy;
{
	aedbf[0] = FRR;
	aedbf[1] = dx;
	aedbf[2] = dy;
	obyte(aedbf, 3);
}

dfc(rad)	/* draw fat circle */
int rad;
{
	aedbf[0]= DFC;
	aedbf[1]= rad & 127;
	obyte(aedbf,2);
}

dfp(tmp_color,vnum,xycoor)	/* draw filled polygon */
int tmp_color;
int vnum;		/* number of polygon vertices */
register int (*xycoor)[2];
{
	register int (*last)[2] = xycoor[vnum];

	if(vnum < 3){
		printf(" dfp ** too few vertices : %d\n",vnum);
		exit(1);
	}

	aedbf[0] = DFP;
	aedbf[1] = tmp_color;
	aedbf[2] = vnum.hibyte;
	aedbf[3] = vnum.lobyte;
	obyte(aedbf,4);	

	for( ; xycoor < last; xycoor++ ){
		encode(aedbf,(*xycoor)[0], (*xycoor)[1]);
		obyte(aedbf,3);
	}
}

dsp(patnum,pattern)		/* define stipple pattern */	
int patnum;
register char pattern[];
{
	register char *bp = aedbf;

	if( (patnum < 1) || (patnum > 15) ){
		printf(" dsp ** pattern number must be in 1..15\n");
		printf("        pattern number = %d\n",patnum);
		exit(0);
	}
	*bp++ = XTD;
	*bp++ = DSP;
	*bp++ = patnum;
	while(bp < &aedbf[11])
		*bp++ = *pattern++;
	obyte(aedbf,11);
}

/*	modified to compute constant	*/
/*	as in tap.ftn 			*/

elp(xsize,ysize)	/* draw ellipse */
register int xsize,ysize;
{
	long f,xx,yy;

	xsize &= 0377;
	ysize &= 0377;
	xx = xsize * xsize;
	yy = ysize * ysize;

/*	terminal wants
	f = ( (min(x,y)/max(x,y)) ** 2 ) * 255)
	rounded to nearest int, f,x,y in 0..255
*/
	if( xx > yy) 
		f = ( yy*255 + xx/2)/xx ;
	else
		f = ( xx*255 + yy/2)/yy ;
	
	aedbf[0]= XTD;
	aedbf[1]= ELP;
	aedbf[2]= xsize;
	aedbf[3]= ysize;
	aedbf[4]= f;
	obyte(aedbf,5);
}

ifl()			/* interior fill */
{
	aedbf[0]= IFL;
	obyte(aedbf,1);
}

ofl()		/* overlay fill */
{
	aedbf[0]=OFL;
	obyte(aedbf,1);
}

gfl(mask,bcolor)	/* generalized overlay fill */
int mask,bcolor;
{
	aedbf[0]= GFL;
	aedbf[1]=mask;
	aedbf[2]=bcolor;
	obyte(aedbf,3);
}

dsf(code,hsize,vsize,n,mask,bits)	/* define special font */
int code,hsize,vsize;
register char mask[],bits[];
int n;
{
	int num;
	register char *last = mask+n;

	aedbf[0] = DSF;
	aedbf[1] = code;
	aedbf[2] = hsize;
	aedbf[3] = vsize;
	obyte(aedbf,4);

	num=(hsize*vsize+7)/8;	

	while( mask < last ){
		obyte(mask++,1);
		obyte(bits,num);
		bits += num;
	}
	aedbf[0]=0;
	obyte(aedbf,1);
}

esf(hsize,vsize,dx,dy)	/* erase special font */
int hsize,vsize,dx,dy;
{
	aedbf[0] = ESF;
	aedbf[1] = hsize;
	aedbf[2] = vsize;
	aedbf[3] = dx;
	aedbf[4] = dy;
	obyte(aedbf,5);
}
