/*
	Ellipse generator.
	Generates an ellipse, centered at CAP.
	Shape given by ax**2 + by**2 - ab = 0.	
*/

#include <stdio.h>
#include <math.h>

double sqrt();
long atol();

long	fx,
	fy,
	fxx,
	fyy;

long	falpha,
	fX,
	fY,
	fXY;

long	absfX,
	absfY,
	absfXY;

int	deltax, deltay;

int	ox,oy;

long	a,b;

main(argc,argv)
int argc;
char **argv;
{
	a = 100L;
	b = 49L;
	
	if(argc == 3){
		a = atol(argv[1]);
		b = atol(argv[2]);
	}
	printf("%ld %ld\n",a,b);

	ox = sqrt((double)b);
	oy = 0;
	mov(400,400);


	fx = (2.0 * (double)a * sqrt((double)b));
	fy = 0;
	fxx = a<<1;
	fyy = b<<1;

	falpha = 0;
	
	for(;;){
		dxdy();
		feasibles();
		step();
		partials();
	}
}

dxdy()
{
	deltax = fy < 0 ? 1 : -1;
	deltay = fx < 0 ? -1 : 1;
}

feasibles()
{
	fX = falpha + fx*deltax + a;
	fY = falpha + fy*deltay + b;
	fXY = fY + fX - falpha;
	absfX = fX > 0 ? fX : -fX;
	absfY = fY > 0 ? fY : -fY;
	absfXY = fXY > 0 ? fXY : -fXY;
}

step()
{
	if((absfY <= absfX) && (absfY < absfXY)){
		deltax = 0;
		falpha = fY;
	}
	else
	if((absfXY <= absfX) && (absfXY <= absfY)){
		falpha = fXY;
	}
	else
	if((absfX < absfY) && (absfX < absfXY)){
		deltay = 0;
		falpha = fX;
	}
	else{
		printf("Hosed step\n");
		exit(0);
	}

	wpx(2);
	mvr(deltax,deltay);
	ox += deltax;
	oy += deltay;

	if(ox < 0)
		exit(0);
}

partials()
{
	fx += fxx*deltax;
	fy += fyy*deltay;
}
