
;	Ellipse generator.  See /u0/roy/elp/fibelp.c

	psect	0

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;	Draw an ellipse centered at CAP, x,y semiaxes in	;
;	X, Y registers.  For now, these values should be	;
; 	positive (don't have signed multiply yet).		;
;	This routine assumes 16 bit 802 mode has been set.	;
;	Local storage is gotten off the stack.			;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;	Define local store offsets.
;	Long variables.

fx	equ	0
fy	equ	4
fxx	equ	8
fyy	equ	12

falpha	equ	16
fX	equ	20
fY	equ	24
fXY	equ	28

absfX	equ	32
absfY	equ	36
absfXY	equ	40

axx	equ	44
byy	equ	48

;	Int variables.
xandy	equ	52
ox	equ	54
px	equ	56
py	equ	58
mx	equ	60
my	equ	62
xsemi	equ	64

;	# bytes of local storage.
LOCSIZ 	equ	66

tstelp
	jsr	set8bit
	jsr	.GET2
	phy
	phx
	jsr	.GET2
	phy
	phx
	jsr	set802
	sei
	rep	#0x30
	ply
	plx
	bsr	elp
	jsr	set8bit
	cli
	bra	tstelp
elp

;	Reserve stack space for local variables
;	and point direct page register at it.

	phd			; Save callers direct page.

	lda	##0x100
	tcd

;	tsc			; Set direct page = stack - LOCSIZ.
;	sec
;	sbc	##LOCSIZ-1
;	tcd
;
;	sta	0x0fe		;*******debug
;
;	dec	a		; Point stack at next free byte.
;	tcs

	stx	<xsemi
	stx	<ox

	
;	Init coordinates of real ellipse (px,py,mx,my) and
; 	(0,0) centered ellipse (ox,oy).	

	ldx	XPOS

	txa
	clc			; Start real ellipse at
	adc	<xsemi		; (XPOS+xsemi,YPOS).
	sta	<px		; Set px = XPOS + xsemi.

	txa			; Set mx = XPOS - xsemi.
	sec
	sbc	<xsemi
	sta	<mx	

	lda	YPOS		; Set my = py = YPOS.
	sta	<py
	sta	<my


;	Compute coefficients axx and byy of x**2 and y**2
;	in the ellipse equation, and second partials
;	fxx, fyy = 2axx, 2byy.

	tyx			; Square ysemi.
	bsl	mult		; Get low word in acc, high in x.
	sta	<axx		; axx = ysemi * ysemi.
	stx	<axx+2

	asl	a		; Set fxx = 2*axx.
	sta	<fxx
	txa
	rol	a
	sta	<fxx+2

	ldx	<xsemi		; Square xsemi.
	txy
	bsl	mult		; Get low word in acc, high in x.
	sta	<byy		; byy = xsemi * xsemi.
	stx	<byy+2

	asl	a		; Set fyy = 2*byy.
	sta	<fyy
	txa
	rol	a
	sta	<fyy+2
		

;	Init first partials fx, fy.

	stz	<fy		; fy = 0.
	stz	<fy+2

;	Init fx = xsemi * fxx.  Since fxx is a long,
; 	this takes some doing.

	ldx	<xsemi
	ldy	<fxx
	bsl	mult		; Low word in acc, high in x.

	sta	<fx		; Save partial result low word.
	stx	<fx+2		; Ditto high word.  Partial result
				; is complete if fxx high word = 0.
	
	ldx	<fxx+2		; fxx high = 0 ?
	beq	$1		; Branch if yes, saved a multiply.

	ldy	<xsemi		; Oh well, we tried.
	bsl	mult		; Get low word in acc, high should
	clc			; be zero.
	adc	<fx+2
	sta	<fx+2

$1
;	Init decision variable falpha.

	stz	<falpha
	stz	<falpha+2

;	This is the main loop.

loop
	bsl	plot		; Plot (px,py,mx,my).
	bsl	nextpt		; Update (px,py,mx,my).

	bit	<ox		; Done yet ?
	bpl	loop		; Branch if no.

;	tsc			; Restore stack to entry value
;	clc			; and return.
;	adc	##LOCSIZ
;	tcs

	pld			; Restore callers direct page.
	rts


nextpt
	
;	Set fX = falpha + axx - fx.

	lda	<falpha
	clc
	adc	<axx	 
	tax			; x = axx+falpha low.
	lda	<falpha+2	; a = falpha high.
	adc	<axx+2		; a = falpha+axx high 
	tay			; save in y.
; Now x,y = axx+falpha, subtract fx.
	sec
	txa
	sbc	<fx
	sta	<fX
	sta	<absfX
	tya
	sbc	<fx+2
	sta	<fX+2
	sta	<absfX+2

;	Set fY = falpha + byy + fy.

	lda	<falpha
	clc
	adc	<byy	 
	tax			; x = byy+falpha low.
	lda	<falpha+2	; a = falpha high.
	adc	<byy+2		; a = falpha+byy high 
	tay			; save in y.
; Now x,y = byy+falpha, add fy.
	clc
	txa
	adc	<fy
	sta	<fY
	sta	<absfY
	tax			; save for fXY below.
	tya
	adc	<fy+2
	sta	<fY+2
	sta	<absfY+2
	tay			; save for fXY below.

;	Set fXY = fY + fX - falpha.  fY is in x,y registers now.

	txa
	clc
	adc	<fX
	tax			; x = fY + fX low.
	tya			; a = fY high.
	adc	<fX+2		; a = fY + fX high 
	tay			; save in y.
; Now x,y = fX + fY, subtract falpha.
	sec
	txa
	sbc	<falpha
	sta	<fXY
	sta	<absfXY
	tya
	sbc	<falpha+2
	sta	<fXY+2
	sta	<absfXY+2

;	Now compute absolute values of fX, fY, fXY.

	ldx	##0

	bit	<fXY+2
	bpl	$1		; Branch if fXY not negative.
	txa
	sec
	sbc	<fXY
	sta	<absfXY
	txa
	sbc	<fXY+2
	sta	<absfXY+2
$1
	bit	<fX+2
	bpl	$2		; Branch if fX not negative.
	txa
	sec
	sbc	<fX
	sta	<absfX
	txa
	sbc	<fX+2
	sta	<absfX+2
$2
	bit	<fY+2
	bpl	$3		; Branch if fY not negative.
	txa
	sec
	sbc	<fY
	sta	<absfY
	txa
	sbc	<fY+2
	sta	<absfY+2
$3

;	Now find the smallest of absfX, absfY, absfXY, and
;	set up to move accordingly.
;	R1 : absfX < absfY
;	R2 : absfY < absfXY
;	R3 : absfX < absfXY.
;
;	if(R1)
;		if(R3) move in x direction
;		else move in x and y.
;	else
;		if(R2) move in y direction
;		else move in x and y.

;	Evaluate R1 (absfX - absfY < 0)

	stz	<xandy		; Shared code flag for move in 
				; x and y.

	sec
	lda	<absfX
	sbc	<absfY
	lda	<absfX+2
	sbc	<absfY+2
	bcc	chkR3		; R1 true, check R3.

;	R1 false, check R2 (absfY - absfXY < 0).		
	sec
	lda	<absfY
	sbc	<absfXY
	lda	<absfY+2
	sbc	<absfXY+2
	bcc	$4		; R1 false, R2 true, move in X,Y.
	dec	<xandy
$4	bra	movy		; R1 false, R2 false, move in Y.
	

;	R1 true, check R3 ( absfX - absfXY < 0).
chkR3
	sec
	lda	<absfX
	sbc	<absfXY
	lda	<absfX+2
	sbc	<absfXY+2
	bcc	movx
	dec	<xandy		; R1 true, R3 false, move in X,Y.

movy
	dec	<my
	inc	<py

	clc			; fy += fyy
	lda	<fy
	adc	<fyy
	sta	<fy
	lda	<fy+2
	adc	<fyy+2
	sta	<fy+2

	bit	<xandy		; move in x and y ?
	bmi	movx		; branch if yes.

	lda	<fY
	sta	<falpha
	lda	<fY+2
	sta	<falpha+2
	rts

; R1 true, R3 true, move in X.
movx	
	dec	<ox
	dec	<px
	inc	<mx

	sec			; fx -= fxx
	lda	<fx
	sbc	<fxx
	sta	<fx
	lda	<fx+2
	sbc	<fxx+2
	sta	<fx+2

	bit	<xandy
	bmi	$1

	lda	<fX
	sta	<falpha
	lda	<fX+2
	sta	<falpha+2
	rts
$1
	lda	<fXY
	sta	<falpha
	lda	<fXY+2
	sta	<falpha+2
	rts
								
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;	This routine plots the 4 points	;
;	(px,py),(px,my),(mx,my),(mx,py).;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

plot
	ldx	<px
	stx	XLO
	ldx	<py
	stx	YLO

	sep	#0x20		; Set 8 bit memory for pixel writes.
	lda	COLOR		; Get current color.
	sta	VM		; (px,py)
	rep	#0x20
	
	ldx	<my
	stx	YLO

	sep	#0x20
	sta	VM		; (px,my)
	rep	#0x20

	ldx	<mx
	stx	XLO

	sep	#0x20
	sta	VM		; (mx,my)
	rep	#0x20

	ldx	<py
	stx	YLO

	sep	#0x20
	sta	VM		; (mx,py)
	rep	#0x30

	rts

;	Unsigned 16 bit multiply.
;	Multiplies contents of x,y registers.  Product
;	low word in acc, high in x.

PLIER equ 1
PLCAND equ 3
PRODCT equ 5

mult
	phd
	
	lda	##0		; init product low word.
	pha			; ditto high word.
	phx			; Save multiplier 
	phy			; and multiplicand.

	tsc
	tcd

	lda	##0
	ldy	##16		; bit count.

MLOOP
	lsr	<PLIER
	bcc	$1
	clc
	adc	<PLCAND
$1
	ror	a
	ror	<PRODCT
	dey
	bne	MLOOP

	plx			; cleanup stack
	plx

	tax			; High result in x,
	pla			; low in acc.

	pld
	rts

