
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;	This routine is	an implementation of	;
;	Bresenhams line	drawing	algorithm.	;
;	See Foley/Van Dam pg. 435  for details.	;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;	It might be a good idea to always draw from the
;	'lesser' endpoint.  The line from a to b is not
;	the same as the line from b to a, which can be
;	inconvenient when rubber-banding or dragging.

	asect  1
	org	0x1200

;	Entries
;	.GLOBL	BRESEN		; This entry gets NEWX,	NEWY from
				; the host, draws from (XPOS,YPOS)
				; to (NEWX, NEWY).

;	.GLOBL	VECTOR		; Enter	here if	NEWX, NEWY are
				; already established.
;	External routines.
;	.GCOOR			; Routine to get X,Y pair
				; from host - values returned
				; in NEWX, NEWY.

;	Zero page globals.
;	.GLOBL	XPOS, YPOS, NEWX, NEWY,	COLOR

;	Local scratch
DX:	ds	2
DY:	ds	2
INC1:	ds	2
INC2:	ds	2
D:	ds	2
PIXCNT:	ds	2		; max (DX, DY)
VMPTR	ds	2		; points to either VMIY, VMIX.
CTRS:	ds	2		; temp storage for xyctrs mask index.
CTINDX: dcb	0
	dcb	040
	dcb	0100
	dcb	0140


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;	Draw line from (XPOS, YPOS) to (NEWX, NEWY).	;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

BRESEN:
	jsr	set8bit		; get in 8 bit 802 mode.
	jsr	.GCOOR		; Get NEWX, NEWY from host.

VECTOR:
	jsr	set802
	rep	#0x30		; make regs 16 bit.	

	ldx	<XPOS
	stx	<XLO

	ldx	<YPOS
	stx	<YLO

	ldx	##03
	stx	CTRS		; x, y counters both up.

	ldx	##VMIX		; assume DY < DX.
	stx	VMPTR		

	sec			; DX = NEWX - XPOS.
	lda	<NEWX
	sbc	<XPOS
	
	bcs	A1		; Branch if DX >= 0.

	dec	CTRS
	eor	##-1		; Make DX positive and
	inc	a		; reverse X direction.



A1
	sta	DX
	sec			; As above, for	DY.
	lda	<NEWY
	sbc	<YPOS

	bcs	A2

	dec	CTRS		; reverse Y direction.
	dec	CTRS

	eor	##-1
	inc	a


A2
	sta	DY

;	If DX <	DY, the	algorithm is the same
;	but with X,Y reversed.	Find out which is the case
;	here and swap DX, DY if DX < DY.

	cmp	DX
	bcc	A3		; branch if DX >= DY.

	ldx	DX		; swap DX, DY .
	sta	DX
	stx	DY

	ldx	##VMIY
	stx	VMPTR
		
A3

;	Init D,	INC1, INC2 as in Foley/VanDam :
;	D = 2DY	- DX, INC1 = 2DY, INC2 = 2(DY-DX).

	lda	DY		; Set INC1 = 2*DY.
	asl	a
	sta	INC1	

				; D = INC1 - DX	= 2*DY - DX.
	sec
	sbc	DX
	sta	D
	
				; INC2 = D - DX	= 2(DY-DX).
	sec
	sbc	DX
	sta	INC2


;	Now we can draw	the line.
;	First need to setup counters.
;	The bulk of the loop is updating D, so that stays in the
;	16 bit acc.  Need 8 bit reg to write pixels with so ..

	ldx	DX
	inx
	stx	PIXCNT

	sep	#0x30
	lda	0x24
	and	#0377-0140
	ldx	CTRS
	ora	CTINDX,x
	sta	0x24		; set counters.
	ldx	<COLOR		; Get color to draw line with.
	ldy	VMPTR		; <0,y is either VMIX or VMIY.
	rep	#0x20		; 16 bit acc.
	lda	D
LOOP
	bit	##0x8000	; Decision variable positive ?
	beq	L1		; branch if yes.

	sep	#0x20
	stx	<0,y
	rep	#0x20

	clc
	adc	INC1

	dec	PIXCNT
	bne	LOOP
	jmp	set8bit
L1
	sep	#0x20
	stx	<VMIXY		; Bump Y for next pixel
	rep	#0x20

	clc
	adc	INC2

	dec	PIXCNT		; Dec pixel count, LOOP	if not 0.
	bne	LOOP
	jmp	set8bit		; No more pixels, return.


