#include <stdio.h>

#define TOLEFT 1
#define TORIGHT 2
#define TOTOP 	8
#define TOBOTTOM 4

typedef struct {
		int x, y;
	} POINT;

typedef struct {
		POINT p1, p2;
	} LINE;

typedef struct {
		int xleft, ybottom, xright, ytop; 
	} WINDOW;


clipl(pp1,pp2,wp)	/* return  0 for trivial reject, */
POINT *pp1, *pp2;	/* else clip xy to wp and return <>0 */
WINDOW *wp;
{
	int c1, c2;
	POINT *p1, *p2;

	p1 = pp1;
	p2 = pp2;

	c1 = vcode(p1,wp);
	c2 = vcode(p2,wp);

	
		if(c1 & c2)			/* trivial reject */
			return(0);
		if( (c1 | c2) == 0)		/* trivial accept */
			return(1);
	
	/*
		At least 1 endpoint outside.
	*/
		if(c1)
			bisect(p2,c2,p1,&c1,wp); /* clip p1 */
		if(c2)
			bisect(p1,c1,p2,&c2,wp); /* clip p2 */

		if(c1 & c2)			/* trivial reject */
			return(0);
		if( (c1 | c2) == 0)		/* trivial accept */
			return(1);

}

bisect(pin,vin,pout,vout,wp)	/* clip pout, also return code(vout) */
POINT 	*pin, *pout;
int	vin, *vout;
WINDOW 	*wp;
{
	POINT p, m;
	int vm;

	p.x = pin->x;		/* save pin */
	p.y = pin->y;

	for(;;){
			
		m.x = (p.x + pout->x) >> 1;
		m.y = (p.y + pout->y) >> 1;

	
		if(((m.x == p.x) && (m.y == p.y))
		|| ((m.x == pout->x) && (m.y == pout->y))){
			pout->x = p.x;
			pout->y = p.y;
			*vout = 0;
			return;
		}

		vm = vcode(&m, wp);				

			
		if(vm & *vout){
			if(vin & vm){
/*
				pout->x = pin->x;
				pout->y = pin->y;
*/
				*vout = vin;
				return;
			}
			pout->x = m.x;
			pout->y = m.y;
			*vout = vm;
		}else{
			p.x = m.x;
			p.y = m.y;
			vin = vm;
		}
	}
}
/*
	return code indicating location of x,y
	with respect to window.
*/

vcode(p,wp)	
POINT *p;
WINDOW *wp;
{
	int vc;
	vc = 0;

	if(p->x < wp->xleft)
		vc = TOLEFT;
	else if(p->x > wp->xright)
		vc = TORIGHT;

	if(p->y < wp->ybottom)
		vc |= TOBOTTOM;
	else if(p->y > wp->ytop)
		vc |= TOTOP;

	return(vc);
}


/*
	Wait for pendown.  Return status and coords. 
*/

getpick(x,y)
int *x, *y;
{
	int flag, dummy, dummy1;

	flag = 0;
	do{
		rtp(&dummy,&flag,x,y);
		sleep(-2);
	}while((flag&1) == 0);

	dummy1 = 1;
	do{	/* debounce */
		rtp(&dummy,&dummy1,&dummy,&dummy);
		sleep(-2);
	}while(dummy1&1);

	return(flag);
}


/*	Enable tablet, delay appropriately */

enable()
{
	int i;
	etp(126);
	for(i=0;i<300;i++)
		;
}
