;
;	Debugger Load Ram Command
;
lcmd::
	php
	sep	#0x20	; 8 bit memory

$1:	bsl	waitp	; wait for a parallel byte
	cmp	#'}'
	bne	$1	; wait for a sse cmd

	bsl	waitp
	bsl	waitp	; throw away the address

	bsl	waitp	; get the ":" (hopefully)

	bsl	waitp	; get the starting adr
	pha
	bsl	waitp
	pha		; push adr onto stack
$2:
	rep	#0x30	; 16 bit M/X
	bsl	crlf
	pla

	tay		; save adr in Y

	bsl	wtox	; print the adr
	bsl	putsp
	sep	#0x20

	bsl	waitp	; get the count
	pha
	bsl	waitp
	pha

	rep	#0x20
	pla
	tax		; save count in x
	bsl	wtox	; print the count

$3:	sep	#0x20

	sty	<nextin
	ldy	<sdb
	sty	<nextin+2

	ldy	##0
$31:	bsl	waitp	; get a byte
	sta	[<nextin],y	; store it
	iny		; incr pointer
	dex		; decr count
	bne	$31
	bsl	crlf	; all done
;
;
;
$4:	bsl	waitp	; check for ';' cmd
	bsl	btox
	cmp	#';'
	beq	$5

	cmp	#':'	; or a ":" cmd
	bsl	waitp
	pha
	bsl	waitp
	pha		; get the adr
	rep	#0x20
	pla
	cmp	##0x2801	; last cmd for load without start?
	beq	$6	; yes
	pha		; no.. do a normal load
	bra	$2	; do the lmr cmd

$6:
;
;	ignore last 0x2801 cmd
;
	sep	#0x20
	bsl	waitp
	bsl	waitp	; grab the count
	bsl	waitp	; and the last chr
	bra	$7

;
;	ignore jus cmds
;
$5:
	bsl	waitp	; get the address
	bsl	waitp

$7:
	plp
	rts
	end
