;
; Here on powerup.
;
	sei
	nop			; to preserve prom format.
	brl	setup
	dcs	"Kernel Rev 1.2\0"
	dcb	1
	dcb	2

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Download table of routines	;
; and their global entry points.;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

kdltab:

;
; Entries from heap.asm
;
	dcw	freheap-getheap		; routine length.
	dcw	getheap			; prom address.
	dcw	GetHeap			; global entry (ram) address.

	dcw	chkheap-freheap
	dcw	freheap
	dcw	FreHeap

;	dcw	endheap-chkheap		; this don't need to be here !
;	dcw	chkheap
;	dcw	ChkHeap

;
; Entries from aceint.asm.
;
	dcw	ace1int-ace0int
	dcw	ace0int
	dcw	Ivace0

	dcw	ace2int-ace1int
	dcw	ace1int
	dcw	Ivace1

	dcw	ace3int-ace2int
	dcw	ace2int
	dcw	Ivace2

	dcw	acecom-ace3int
	dcw	ace3int
	dcw	Ivace3

	dcw	getkey-acecom
	dcw	acecom
	dcw	0

	dcw	gethst-getkey	
	dcw	getkey
	dcw	GetKey

	dcw	sndhst-gethst	; this should be in intrp prom.
	dcw	gethst
	dcw	GetHst

	dcw	break-sndhst	; ditto.
	dcw	sndhst
	dcw	SndHst

	dcw	putoutq-break
	dcw	break
	dcw	Break

	dcw	getinq-putoutq
	dcw	putoutq
	dcw	Putoutq

	dcw	qend-getinq
	dcw	getinq
	dcw	Getinq
;
; Entries from vblank.asm
;
	dcw	vblend-vblint
	dcw	vblint
	dcw	Ivblnk

;
; Entries from gfx.asm
;
	dcw	rstrda-saveda
	dcw	saveda
	dcw	SaveDa

	dcw	setclt-rstrda
	dcw	rstrda
	dcw	RstrDa

	dcw	erase-setclt
	dcw	setclt
	dcw	SetClt

	dcw	gfxend-erase
	dcw	erase
	dcw	Erase

	dcw	0			; end of table.

partab:

;
; Entries from pario.asm.
; These should be loaded if
; at power up the 'parallel card present'
; flag is true in eeprom, or the 'host
; power ok' bit is true in the parallel status reg.
;
	dcw	getpar-putpar
	dcw	putpar
	dcw	Putpar

	dcw	cdmctl-getpar
	dcw	getpar
	dcw	Getpar

	dcw	getcdm-cdmctl
	dcw	cdmctl
	dcw	Cdmctl

	dcw	cdmend-getcdm
	dcw	getcdm
	dcw	Getcdm

	dcw	0		; end of table.

	
setup:

;
; init ram
;
	rep	#0x38		; 16 bit m/x, cld.
	lda	##0
	sta	>0,0
	tax
	tay
	iny
;
; see if this prom is in powerup socket
; and clear all ram if yes, else leave
; stuff used by debugger alone.
;

	lda	##0x100
	tcs
	per	!
	pla
	cmp	##0xe000
	bcc	$zap1

	lda	##0x7ffe	;this is the real thing.
	mvn	>0,>0
	bra	$zap2
$zap1:
	lda	##0x3000	;leave dbgr stuff intact.
	mvn	>0,>0
	ldx	##0x4000
	txy
	iny
	stz	0x4000
	lda	##0x7f80-0x4000-2
	mvn	>0,>0
$zap2:
	stz	Iemask
;
; reset drawing acc
; (returns rev level.)
;
	sep	#0x20
	lda	#vbmask
$wvb1:	bit	Vbflag
	bne	$wvb1
$wvb2:	bit	Vbflag
	beq	$wvb2
	lda	DaRst
	sta	DaRev
	rep	#0x20
;
; init heap, stack.
; heap starts out using 0..0x3ff.
; borrow 0xa..0xff for power up stack.
; init heap so that it looks like stack space
; gotten from an empty heap - initial free list
; contains block from 0x100 - 0x3ff.
;
	lda	##256-8		; make sure size word is kosher.
	sta	8
	lda	##0x100		; next free block at 0x100.
	sta	2		; init head.next
	dec	a		; point sp at last byte of this block.
	tcs
	lda	##0x300		; size of first free block.
	sta	0x100
	lda	##-1		; no next block.
	sta	0x102
;
; Init HeapTop, StkMin, StkBas so
; Malloc, Downld, DlTabl, GetHeap, FreHeap
; can be used.
; 
	lda	##0x3ff		; current high address allocated
	sta	HeapTop		; to the heap.
	lda	##0x200		; 512 bytes of stack is the minimum.
	sta	StkMin
	lda	##Start-1	; Reserve memory from Start on up,
	sta	StkBas		; memory below is allocated via
				; Malloc, which moves StkBas as
				; needed.

;
; Set up jump table entries for global
; routines that don't get downloaded -
; Malloc, Downld, DlTabl, Qcbini, ChkHeap.
; Really ought to have a routine to do this.
;

	sep	#0x30
	phk
	pla			; pbr in acc.
	ldx	#0x5c		; jmp long instr.

	stx	Malloc		; jmp long.
	sta	Malloc+3	; pbr containing code.

	stx	Downld		; jmp long.
	sta	Downld+3	; pbr containing code.

	stx	DlTabl		; jmp long.
	sta	DlTabl+3	; pbr containing code.

	stx	Qcbini		; jmp long.
	sta	Qcbini+3	; pbr containing code.

	stx	ChkHeap		; jmp long.
	sta	ChkHeap+3	; pbr containing code.

	stx	AceSet
	sta	AceSet+3	

	stx	Cnout
	sta	Cnout+3

	stx	AceSav
	sta	AceSav+3

	stx	AceRst
	sta	AceRst+3

	rep	#0x30
	per	malloc
	pla	
	sta	Malloc+1

	per	downld
	pla	
	sta	Downld+1

	per	dltabl
	pla	
	sta	DlTabl+1

	per	qcbini
	pla	
	sta	Qcbini+1

	per	chkheap
	pla	
	sta	ChkHeap+1

	per	aceset
	pla
	sta	AceSet+1

	per	cnout
	pla
	sta	Cnout+1	

	per	acesav
	pla
	sta	AceSav+1

	per	acerst
	pla
	sta	AceRst+1

;
; Set ACE data formats.
; Set up ACE and vertical blank interrupt vectors.
; Download ACE and vertical blank interrupt handlers.
; Download ACE q handlers.
; Download heap routines and enter them in jump table.
; Download parallel i/o routines.
;
	jsl	>0,AceRst	; set parity, word length, baud etc.

	per	kdltab
	jsl	>0,DlTabl
	bcc	$1
	inc	Inierr
$1:
;
; Need to undo some of the nice stuff DlTabl did to us.
; The jmps at Ivace0..3 are not appropriate, just want
; the address.  Move addresses down 1 to cover up the jump,
; then supply 0 for bank byte.
;
	lda	Ivace0+1
	sta	Ivace0

	lda	Ivace1+1
	sta	Ivace1

	lda	Ivace2+1
	sta	Ivace2

	lda	Ivace3+1
	sta	Ivace3

	lda	Ivblnk+1
	sta	Ivblnk

	sep	#0x20
	stz	Ivace0+2
	stz	Ivace1+2
	stz	Ivace2+2
	stz	Ivace3+2
	stz	Ivblnk+2
	rep	#0x20

	per	partab
	jsl	>0,DlTabl
	bcc	$2
	inc	Inierr
$2:
;
; Download the interrupt entry and exit routines.
; Can't use Downld as they go to fixed addresses.
;
	per	irqdon
	plx
	ldy	##Irqdon
	lda	##endirq-irqdon-1
	phb
	mvn	>ROM,>0
	plb

	per	irqsav
	plx
	ldy	##Irqsav
	lda	##irqdon-irqsav-1
	phb
	mvn	>ROM,>0
	plb
;
; Do host serial and keyboard setup.
;

	pea	##2*qcbsiz
	jsl	>0,Malloc
	bcc	$3
	inc	Inierr
	brl	$nogo
$3:	pla
	sta	Qcbac3
	clc
	adc	##qcbsiz
	sta	Qcbac2

	phb
	phk
	plb

	per	$kbdqcb
	lda	##3
	jsl	>0,Qcbini

	per	$hstqcb
	lda	##2
	jsl	>0,Qcbini

	plb
	
;
; For development purposes, go see if
; any prom sockets contain ram.  If 
; yes, wait for download from host before
; continuing.
;
	bsl	ldprom
;
; Call the other init routines.
; Any prom socket having the magic word
; 0x1549 at its first location has
; a powerup routine following - call it.
;
	rep	#0x30	
	ldx	##0

$iloop:
	lda	>ROM,0,x
	cmp	##0x1549
	bne	$nogo

	per	$nogo-1		; push return address.

	txa			; call the init routine
	inc	a		; via rts.
	pha
	rts
$nogo:
	lda	Inierr
	beq	$ok
;	jsl	>0,ChkHeap
	brk	
$ok:
	txa
	clc
	adc	##0x2000
	tax
	bne	$iloop

;
; Give the stack space back to the heap.
;
	pea	##10		; pointer to the block we took.
	jsl	>0,FreHeap	; return block to heap free list.
;
; Set stack to top of available ram
; minus a little padding in case of
; momentary stack underflow and
; enable appropriate interrupts.
;
	lda	StkBas
	sec
	sbc	##10
	sta	StkBas
	tcs

	lda	##0x800		; enable vertical interrupt.
	sta	Iemask

	asl	a
	ldx	Qcbac0
	beq	$int1
	tsb	Iemask
$int1:	asl	a	
	ldx	Qcbac1
	beq	$int2
	tsb	Iemask
$int2:	asl	a	
	ldx	Qcbac2
	beq	$int3
	tsb	Iemask
$int3:	asl	a	
	tsb	Iemask

	sep	#0x20
	lda	#1
	sta	Leds

	cli				; enable interrupts
;
; jump to start routine.
;
	jmp	>0,Start
;
; qcb init data for keyboard and host.
;

$kbdqcb	dcb	0		; no io control.
	dcb	64		; in q size.
	dcb	0		; out q size.

$hstqcb	dcb	128		; xon/xoff.
	dcb	255		; iq size.
	dcb	64		; oq size.

	end
