

;
; I/O addresses
;

devend	equ	0xff54	; write to pulse device end - intrpt host
parprt	equ	0xff42	; parallel i/o port (2 bytes).  Writing
			; the low byte sets byte assembled for
			; the host.  Writing the high byte does
			; nothing.
dmaena  equ	0xff48	; write to set ADRE - enable dma transfer
dmadsb	equ	0xff4a	; write clears ADRE - disable dma transfer
intpol	equ	0xff48	; device polling is done by inspecting 
			; bits in this word.
;  
;	0xff48 :
;	bit 7 - host command out, set if data available
;		in parallel port.
;	bit 6 - set when terminal count register(s) overflow.
;	bit 5 - set when EE prom ready for writing.
;	bit 4..0 no current use.
;
;	0xff49 :	
;	bit 7 - host data out, set when command dma word
;		available in parallel port.
;	bit 6..0 no current use.
;
;
; Here on power up or hard reset.  Load prom bank
; from host running dl.
;

start:
	rep	#0x30		; set 16 bit m/x
;
; init stack
;
	lda	##0xff
	tcs
;
; zero prom bank, set dbr = ff.
;
	lda	##0
	sta	>0xff,0
	tax			; addr first source byte
	ldy	##2		; addr first target byte
	lda	##0xcffd	; zap first 56k of prom
	mvn	>0xff,>0xff	; do it (also sets dbr = ff)
;
; dl until jus
;
	
loop:	bsr	lcmd
	bra	loop	
	

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;	Debugger Load Ram Command	;
; The host (running dl) sends a series	;
; of lmr commands, ending with either a ;
; jus command or lmr 2801 1 <beep>.	;
; This routine does an rts in the latter;
; case, else executes the jus.	The 	;
; called routine has same dbr and psw	;
; as the caller (ff).			;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

lcmd::
	php		; and m/x mode
	rep	#0x10	; 16 bit index
	sep	#0x20	; 8 bit memory

$1:	bsl	waitp	; wait for a parallel byte
	cmp	#'}'
	bne	$1	; wait for a sse cmd

	bsl	waitp
	bsl	waitp	; throw away the address


$loop:	bsl	waitp	; get the ":" (hopefully)
	cmp	#':'	; lmr command ?
	beq	$lmr	; branch if yes
	cmp	#';'	; jus command ?
	bne	$loop	; no, junk.
;
; jus command, instead of returning to
; lcmd caller, return to downloaded code.
;
	bsl	waitp	; get addr high byte
	pha
	bsl	waitp	; get addr low byte
	pha

	rep	#0x20
	pla		; get jus addr
	dec	a	; make a return addr
	sta	2,s	; replace callers return addr

	plp
	rts		; jump to downloaded code
	
; lmr command - 
; get addr, count and load ram
;

$lmr:	bsl	waitp	; get the starting addr high byte
	pha
	bsl	waitp	; start addr low byte
	pha		; push adr onto stack
$2:
	bsl	waitp	; get the count high byte
	pha
	bsl	waitp	; count low byte
	pha		; push count on stack


	ply		; get byte count
	plx		; get addr
	cpx	##0x2801 ; are we done ?
	bne	$3	; branch if no

	bsl	waitp	; yes, gobble last char
	plp		; and return to caller
	rts

$3:	bsl	waitp	; get a byte
	sta	0,x	; store it
	inx		; incr pointer
	dey		; decr count
	bne	$3
	brl	$loop	; get next lmr or jus

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Send a byte to the parallel interface.;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

sendp:
	php
	rep	#0x20

;
; send the byte
;

	sta	>0,parprt	; put the byte in parallel port.
				; set byte assembled flag for host.
	sta	>0,devend
				; and pulse device end - interrupt host.

;
; wait for ack (any parallel byte from host)
;

$1:	lda	>0,intpol-1	; data avail  (bit 15) ?
	bpl	$1		; no

	lda	>0,parprt	; Get status bits in high byte of acc
	bit	##0x0200	; no intr?
	bne	$2		; yes.. skip
	sta	>0,devend	; pulse device end
$2:
	plp
	rts


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Read one byte from the parallel interface.	;
; Generate device end if bit 2 of the high	;
; byte of the parallel data is non-zero.	;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

waitp:
	php
	rep	#0x20		; 16 bit mem
$1:	lda	>0,intpol-1	; data avail  (bit 15)?
	bpl	$1		; no

	lda	>0,parprt	; Get status bits.
	bit	##0x0200	; no intr?
	bne	$2		; yes.. skip
	sta	>0,devend	; pulse device end
$2:
	and	##0xff		; mask off status bits
	plp
	rts


;
; Here on powerup 
;
	brl	start
	end
