cd \glib340
echo off 
rem +----------------------------------------------------------------------+
rem :			   TMS340 Graphics Library			   :
rem :		 Copyright (c) 1988,90 Texas Instruments Inc.		   :
rem +----------------------------------------------------------------------+
if "%1" == "" goto INTRO
if "%1" == "34010" goto GSP10
if "%1" == "10" goto GSP10
if "%1" == "34020" goto GSP20
if "%1" == "20" goto GSP20
goto INTRO

:GSP10
echo +----------------------------------------------------------------------+
echo :                                                                      :
echo :    About to modify object libraries in \corprims and \extprims to    :
echo :    be 34010-compatible (i.e., run on both 34010 and 34020).          :
echo :                          Type ^C to abort.                           :
echo :                                                                      :
echo +----------------------------------------------------------------------+
pause

copy oem34010.inc .\include\oem.inc
touch .\include\oem.inc

REM --- Remake the core primitives
REM --- Change to \corprims directory
cd .\corprims
..\make INC=..\include corprims.mak
if errorlevel 1 goto END

REM --- Remake the extended primitives
REM --- Change to \extprims directory
cd ..\extprims
..\make INC=..\include extprims.mak
if errorlevel 1 goto END
cd ..

goto END

:GSP20
echo +----------------------------------------------------------------------+
echo :                                                                      :
echo :    About to modify object libraries in \corprims and \extprims to    :
echo :    be 34020-specific (i.e., run on 34020, but not 34010).            :
echo :                          Type ^C to abort.                           :
echo :                                                                      :
echo +----------------------------------------------------------------------+
pause

copy oem34020.inc .\include\oem.inc
touch .\include\oem.inc

REM --- Remake the core primitives
REM --- Change to \corprims directory
cd .\corprims
..\make INC=..\include corprims.mak
if errorlevel 1 goto END

REM --- Remake the extended primitives
REM --- Change to \extprims directory
cd ..\extprims
..\make INC=..\include extprims.mak
if errorlevel 1 goto END
cd ..

goto END

:INTRO
echo +----------------------------------------------------------------------+
echo :                                                                      :
echo :  This batch file configures the object library archive files         :
echo :  corprims.lib and extprims.lib in the \corprims and \extprims        :
echo :  subdirectories, respectively, either for 34010-compatible code      :
echo :  that runs on both the 34010 and 34020, or for 34020-specific        :
echo :  code that runs only on the 34020.                                   :
echo :                                                                      :
echo :  To configure library for 34010-compatible object code:              :
echo :                         CONFIG 34010                                 :
echo :  To configure library for 34020-specific object code:                :
echo :                         CONFIG 34020                                 :
echo :                                                                      :
echo +----------------------------------------------------------------------+

:END

