//---------------------------------------------------------------------------
//
// %FILE     wd.h
// %VSS-REV  $Revision: 8 $
// %CREATED  1996.02.28
// %REVISED  $Date: 4/18/97 4:27p $
// %AUTHOR   Michael C. Draeger 
// %PROJECT  NS486SXF evaluation board software 
// %PART     NS486SXF, NS486SXL 
// %SUMMARY  Watchdog Timer code
//
// %VSS      $Author: Miked $ $Date: 4/18/97 4:27p $ $Revision: 8 $
//
// DESCRIPTION
//
//   Header for wd.c.
//
// HISTORY
//
/*
 *
 * $History: wd.h $ 
 * 
 * *****************  Version 8  *****************
 * User: Miked        Date: 4/18/97    Time: 4:27p
 * Updated in $/nsdemo
 *  New header (comment) changes.
 * 
 * *****************  Version 7  *****************
 * User: Miked        Date: 8/06/96    Time: 11:59a
 * Updated in $/nsdemo
 * Version 1.4.  Maintainance release.  See README.TXT for info.
 * 
 * *****************  Version 6  *****************
 * User: Miked        Date: 7/23/96    Time: 2:26p
 * Updated in $/nsdemo
 * Maintainance release.  README.TXT describes changes.
 * 
 * *****************  Version 5  *****************
 * User: Miked        Date: 7/16/96    Time: 11:54a
 * Updated in $/nsdemo
 * Updated for rev C0 release.
 * 
 * *****************  Version 4  *****************
 * User: Miked        Date: 5/03/96    Time: 2:50p
 * Updated in $/nsdemo
 * Maintainence release.
 * 
 * *****************  Version 3  *****************
 * User: Miked        Date: 4/18/96    Time: 11:06a
 * Updated in $/nsdemo
 * Clean up for release.
 * 
 * *****************  Version 2  *****************
 * User: Miked        Date: 4/04/96    Time: 3:13p
 * Updated in $/board test
 * changed headers for VSS
 *
 */
//
// COPYRIGHT
//
//      (c) 1996, 1997 National Semiconductor Corporation
//
//---------------------------------------------------------------------------

#ifndef WD_H_INC
#define WD_H_INC

//---------------------------------------------------------------------------
// Required headers

#include "nsglobal.h"
#include "pit.h"

//---------------------------------------------------------------------------
// Register bit definitions

  // WD Control 
  
  #define WT_RST    (1<<2)  // WD Reset Enable
  #define WT_NMI    (1<<1)  // WD NMI Enable
  #define WTE       (1<<0)  // WD Enable

  // WD Retrigger Value

  #define RETRIGGER  0x8421  // Value to retrigger WD

  // WD Disable

  #define WD_DISABLE1 0x69   // Write to WD_CONTROL first
  #define WD_DISABLE2 0x5A   // Write to WD_RETRIGGER second

//---------------------------------------------------------------------------
// Function parameter values

  // Watchdog Modes

  #define WD_IRQ   0
  #define WD_NMI   1
  #define WD_RST   2

//---------------------------------------------------------------------------

extern USHORT WD_Set( ULONG time, int mode );
extern USHORT WD_Cancel( void );
extern USHORT WD_Retrigger( void );

//---------------------------------------------------------------------------


#endif // #ifndef WD_H_INC

//---------------------------------------------------------------------------
// END       wd.h
//---------------------------------------------------------------------------
