//---------------------------------------------------------------------------
//
// %FILE     ns486cfg.h
// %VSS-REV  $Revision: 25 $
// %CREATED  1996.04.12
// %REVISED  $Date: 4/18/97 4:12p $
// %AUTHOR   Michael C. Draeger 
// %PROJECT  NS486SXF evaluation board software
// %PART     NS486SXF
// %SUMMARY  configuration info 
//     
// %VSS      $Author: Miked $ $Date: 4/18/97 4:12p $ $Revision: 25 $
//
// DESCRIPTION
//
//   Configuration options for the NSDEMO.  The intent was that this file  
//   would be automatically generated.  Some items, such as interrupts
//   can be changed here.  Some others may not work if changed, so
//   check the source code first.
//
// HISTORY
//
/*
 *
 * $History: ns486cfg.h $ 
 * 
 * *****************  Version 25  *****************
 * User: Miked        Date: 4/18/97    Time: 4:12p
 * Updated in $/nsdemo
 * Moved declaration of ECP, UART, and PCMCIA controller base addresses to
 * here.   New header (comment) changes.
 * 
 * *****************  Version 24  *****************
 * User: Miked        Date: 3/25/97    Time: 10:35a
 * Updated in $/nsdemo
 * Removed a few lines left in by accident from NSTEST.
 * 
 * *****************  Version 23  *****************
 * User: Miked        Date: 3/25/97    Time: 7:42a
 * Updated in $/nsdemo
 * Fixed typo (MW1_E->MWI_E), enable I2C, more specific on BIU_V_CONTROL2.
 * 
 * *****************  Version 20  *****************
 * User: Miked        Date: 8/06/96    Time: 11:59a
 * Updated in $/nsdemo
 * Version 1.4.  Maintainance release.  See README.TXT for info.
 * 
 * *****************  Version 19  *****************
 * User: Miked        Date: 8/05/96    Time: 6:03p
 * Updated in $/nsdemo
 * Added mapping from pin IRQ2 (external UART) to internal IRQ 3 (COM2).
 * 
 * *****************  Version 18  *****************
 * User: Miked        Date: 7/23/96    Time: 2:25p
 * Updated in $/nsdemo
 * Maintainance release.  README.TXT describes changes.
 * 
 * *****************  Version 17  *****************
 * User: Miked        Date: 7/22/96    Time: 10:57a
 * Updated in $/nsdemo
 * Changed BIU_V_CS_EN to Flash Loader default chip selects.  BIU.C
 * ORes in others that it adds.
 * 
 * *****************  Version 16  *****************
 * User: Miked        Date: 7/16/96    Time: 11:54a
 * Updated in $/nsdemo
 * Updated for rev C0 release.
 * 
 * *****************  Version 15  *****************
 * User: Miked        Date: 6/26/96    Time: 11:10a
 * Updated in $/nsdemo
 * Added DMA_V_IDRSR entry for DMA mapping.
 * 
 * *****************  Version 14  *****************
 * User: Miked        Date: 6/07/96    Time: 10:05a
 * Updated in $/nsdemo
 * Changed chip select enables (got rid of un-cacheable workaround for rev
 * B).
 * 
 * *****************  Version 13  *****************
 * User: Miked        Date: 5/03/96    Time: 2:50p
 * Updated in $/nsdemo
 * Maintainence release.
 * 
 * *****************  Version 12  *****************
 * User: Noreen       Date: 4/30/96    Time: 3:28p
 * Updated in $/nstest
 * Added values for PIC Misc Internal  Interrupt Selections
 * 
 * *****************  Version 11  *****************
 * User: Miked        Date: 4/23/96    Time: 1:03p
 * Updated in $/nsdemo
 * Removed unused stuff.
 * 
 * *****************  Version 10  *****************
 * User: Miked        Date: 4/18/96    Time: 12:03p
 * Updated in $/nsdemo
 * Cleaned up for release.
 * 
 * *****************  Version 9  *****************
 * User: Noreen       Date: 4/18/96    Time: 11:34a
 * Updated in $/nsdemo
 * Updated BIU values for CS8
 * 
 * *****************  Version 8  *****************
 * User: Miked        Date: 4/17/96    Time: 5:48p
 * Updated in $/nsdemo
 * Fixed dumb error with | vs &.
 * 
 * *****************  Version 7  *****************
 * User: Miked        Date: 4/17/96    Time: 5:38p
 * Updated in $/nsdemo
 * Enabled ECP for Pharlap running on ECP port.
 * 
 * *****************  Version 6  *****************
 * User: Noreen       Date: 4/17/96    Time: 2:36p
 * Updated in $/nsdemo
 * Changed mapping value for IRQ15 to zero
 * 
 * *****************  Version 5  *****************
 * User: Miked        Date: 4/17/96    Time: 11:32a
 * Updated in $/nsdemo
 * Got rid of some unused PIC mappings.
 * 
 * *****************  Version 4  *****************
 * User: Miked        Date: 4/17/96    Time: 9:43a
 * Updated in $/nsdemo
 * Small changes for interrupts in Pharlap.
 * 
 * *****************  Version 3  *****************
 * User: Miked        Date: 4/12/96    Time: 2:46p
 * Updated in $/nstest
 * Fixed MSVC problem.
 * 
 * *****************  Version 2  *****************
 * User: Miked        Date: 4/12/96    Time: 10:54a
 * Updated in $/nstest
 * New VSS Header.
 * Added UART enable to BIU.
 *
 */
//
// COPYRIGHT
//
//      (c) 1996, 1997 National Semiconductor Corporation
//
//---------------------------------------------------------------------------

#ifndef NS486CFG_H_INC
#define NS486CFG_H_INC

//---------------------------------------------------------------------------
// IRQ Interrupt Map - this is the interrupt vector values used

#ifdef PHARLAP
enum _IRQInterruptMap
{
  IRQIV_Controller1 = 0x08,
  IRQIV_Controller2 = 0x70,
};
#else
enum _IRQInterruptMap
{
  IRQIV_Controller1 = 0x70,
  IRQIV_Controller2 = 0x78,
};
#endif

//---------------------------------------------------------------------------
// PIC internal IRQ selections

#define PIC_II1S  0x00
#define PIC_II3S  0x04   // External UART (COM2)
#define PIC_II4S  0x00   
#define PIC_II5S  0x00
#define PIC_II6S  0x00  
#define PIC_II7S  0x00
#define PIC_II9S  0x00
#define PIC_II10S 0x00
#define PIC_II11S 0x00
#define PIC_II12S 0x00   
#define PIC_II13S 0x80   // Watchdog
#define PIC_II14S 0x80   // Timer 1
#define PIC_II15S 0x00

//---------------------------------------------------------------------------
// PIC misc internal IRQ selections

#define PIC_MIS1  0x00
#define PIC_MIS2  0x00
#define PIC_MIS3  0x20  // PCMCIA on IRQ 12

//---------------------------------------------------------------------------
// symbolic IRQ #'s

#define IRQ_PIT0     0
#define IRQ_RES1     1
#define IRQ_CASCADE  2
#define IRQ_COM2     3
#define IRQ_RES4     4
#define IRQ_RES5     5
#define IRQ_RES6     6
#define IRQ_RES7     7
#define IRQ_RTC      8
#define IRQ_RES9     9
#define IRQ_RES10    10
#define IRQ_RES11    11
#define IRQ_PCM      12
#define IRQ_WD       13
#define IRQ_PIT1     14
#define IRQ_DMA      15

//---------------------------------------------------------------------------
// PIT Defines

// Speed of PIT clock if CPU speed not detected
#define DEFAULT_PIT_CLOCK_INPUT 25000000L

// Speed of Watchdog clock
#define WD_CLOCK_INPUT 1000L

// PIT clock divisor to use
#define PIT_V_CLOCK 0x03      //Divided by 32

// PIT - Value to write to TICR during init.  Sets functions of pins
// T0 and T1
#define PIT_V_TICR  0xFA

//---------------------------------------------------------------------------
// Bus Interface Unit

// define which address is used for ECP, PCMCIA, and the internal UART (if
// used)

#define PCM_BASE  PCM_BASE1    // 0x3E0-0x3E1  (primary)
#define UART_BASE UART_COM1    // 0x3F8-0x3FF  (COM1)

// BIU Control 1 controls access to many ns486 peripherals.  This tells
// NSDEMO which to enable

#define BIU_ICD     (1 << 0)
#define BIU_SHR     (1 << 1)
#define BIU_RTC_E   (1 << 2)
#define BIU_TMR_E   (1 << 3)
#define BIU_INT_E   (1 << 4)
#define BIU_DMA_E   (1 << 5)
#define BIU_URT_E   (1 << 6)
#define BIU_MWI_E   (1 << 7)

#define BIU_V_CONTROL1 ( BIU_SHR | BIU_RTC_E | BIU_TMR_E | BIU_INT_E | BIU_DMA_E | BIU_URT_E | BIU_MWI_E )

// BIU Control 2 also controls access to peripherals

#define BIU_ECP_E  (1 << 0)
#define BIU_PCM_E  (1 << 1)
#define BIU_GPE    (1 << 2)
#define BIU_PCM_S0 (1 << 3)
#define BIU_ECP_S0 (1 << 4)
#define BIU_ECP_S1 (1 << 5)
#define BIU_UART_S0 (1 << 6)
#define BIU_UART_S1 (1 << 7)

#define BIU_V_CONTROL2  ( BIU_ECP_E | BIU_PCM_E | BIU_GPE & (~BIU_PCM_S0) & (~BIU_ECP_S0) & (~BIU_ECP_S1) & (~BIU_UART_S0) & (~BIU_UART_S1) )

// This tells NSDEMO which chip selects to enable.  We leave the pre-set up
// ones on (Flash Loader).  

#define BIU_V_CS_EN      0x073     

// This tells NSDEMO which are memory and which are IO.  Again, we are
// leaving this as set up by the Flash Loader except for 8, 4, and 3

#define BIU_V_CS_TYPE    0x0D9

// Base and Mask for chip select 8 - used to shadow Flash

#define BIU_V_CSBAR8_0  0x0000
#define BIU_V_CSBAR8_2  0x01f0
#define BIU_V_CSARR8_0  0xFFFF    
#define BIU_V_CSARR8_2  0x000F

// Base and Mask for CS4 and 3 - used to workaround cache problem

#define BIU_V_CSBAR3_0  0x0000
#define BIU_V_CSBAR3_2  0x0000
#define BIU_V_CSARR3_0  0xFFFF    
#define BIU_V_CSARR3_2  0x03FF
#define BIU_V_CSBAR4_0  0x0000
#define BIU_V_CSBAR4_2  0x0000
#define BIU_V_CSARR4_0  0xFFFF    
#define BIU_V_CSARR4_2  0x03FF

// This adds chip selects to the CS0 pin.  We add 8.  1 was already set
// up by the Flash Loader

#define BIU_V_RBSR      0x081     

// Chip select timing.  CSATR4 is used for CS8.  CSATR2 is used for
// CS 4 and 3.  Note: CSATR4 is also used for CS7, so we set that value
// as set by the Flash Loader.

#define BIU_V_CSATR4    0x0CA
#define BIU_V_CSATR2    0x000

// CS8 is 16 bit.  CS1 was also 16 bit, as set up by the Flash Loader

#define BIU_V_P16LCSR   0x081     

//---------------------------------------------------------------------------
// DMA Controller

// this maps the internal peripherals to internal DMA devices

#define DMA_V_IDRSR  0x03

//---------------------------------------------------------------------------

#endif // ifndef NS486CFG_H_INC

//---------------------------------------------------------------------------
// END       ns486cfg.h
//---------------------------------------------------------------------------
