//---------------------------------------------------------------------------
//
// %FILE     lcdtest.h
// %VSS-REV  $Revision: 5 $
// %CREATED  1996.06.26
// %REVISED  $Date: 4/18/97 4:07p $ 
// %AUTHOR   Michael C. Draeger 
// %PROJECT  NS486SXF evaluation board software
// %PART     NS486SXF 
// %SUMMARY  LCD Test Code header
//     
// %VSS      $Author: Miked $ $Date: 4/18/97 4:07p $ $Revision: 5 $
//
// DESCRIPTION
//
//   Header file for lcdtest.c
//
// HISTORY
//
/*
 *
 * $History: lcdtest.h $
 * 
 * *****************  Version 5  *****************
 * User: Miked        Date: 4/18/97    Time: 4:07p
 * Updated in $/nsdemo
 * Added #defines from LCDTEST.C file.   New header (comment) changes.
 * 
 * *****************  Version 4  *****************
 * User: Miked        Date: 8/06/96    Time: 11:59a
 * Updated in $/nsdemo
 * Version 1.4.  Maintainance release.  See README.TXT for info.
 * 
 * *****************  Version 3  *****************
 * User: Miked        Date: 7/23/96    Time: 2:25p
 * Updated in $/nsdemo
 * Maintainance release.  README.TXT describes changes.
 * 
 * *****************  Version 2  *****************
 * User: Miked        Date: 7/16/96    Time: 11:54a
 * Updated in $/nsdemo
 * Updated for rev C0 release.
 * 
 * *****************  Version 1  *****************
 * User: Miked        Date: 6/27/96    Time: 11:42a
 * Created in $/nsdemo
 * Initial LCD test code.  Works, but needs to be cleaned up.
 *
 */
//
// COPYRIGHT
//
//      (c) 1996, 1997 National Semiconductor Corporation
//
//---------------------------------------------------------------------------

#ifndef LCDTEST_H_INC
#define LCDTEST_H_INC

//---------------------------------------------------------------------------
// Required headers

#include "nsglobal.h"
#include "pit.h"
#include "dma.h"

//---------------------------------------------------------------------------
// LCD buffer is defined in lcdbm.c, including the GLUT

#define LCD_BUFSIZE 19232             // 320x240x2/8 bytes + 32 bytes GLUT
extern BYTE lcd_buffer[LCD_BUFSIZE];

//---------------------------------------------------------------------------

// We use the debug UART just to use the OUT1 and OUT2 signals to
// enable the LCD

#define OUT1  (1<<2)
#define OUT2  (1<<3)

// Location of the Debug UART MCR register, which has the OUT1 and OUT2
// bits.

#define DEBUG_UART_MCR 0x2FC 


//---------------------------------------------------------------------------
// Function prototypes

extern USHORT LCD_Test( void );

//---------------------------------------------------------------------------

#endif // #ifndef LCDTEST_H_INC

//---------------------------------------------------------------------------
// END       lcdtest.h
//---------------------------------------------------------------------------
