//---------------------------------------------------------------------------
//
// %FILE     dram.h
// %VSS-REV  $Revision: 11 $
// %CREATED  1996.01.17
// %REVISED  $Date: 4/18/97 4:05p $
// %AUTHOR   Noreen Bell
// %PROJECT  NS486SXF evaluation board software
// %PART     NS486SXF, NS486SXL
// %SUMMARY  Dynamic RAM module header file
//     
// %VSS      $Author: Miked $ $Date: 4/18/97 4:05p $ $Revision: 11 $
//
//
// DESCRIPTION
//
//   This header file contains definitions for the DRAM Controller
//
// HISTORY
//
/*
 *
 * $History: dram.h $
 * 
 * *****************  Version 11  *****************
 * User: Miked        Date: 4/18/97    Time: 4:05p
 * Updated in $/nsdemo
 * Removed unused #defines.   New header (comment) changes.
 * 
 * *****************  Version 10  *****************
 * User: Miked        Date: 8/06/96    Time: 11:59a
 * Updated in $/nsdemo
 * Version 1.4.  Maintainance release.  See README.TXT for info.
 * 
 * *****************  Version 9  *****************
 * User: Miked        Date: 7/23/96    Time: 2:25p
 * Updated in $/nsdemo
 * Maintainance release.  README.TXT describes changes.
 * 
 * *****************  Version 8  *****************
 * User: Miked        Date: 7/16/96    Time: 11:54a
 * Updated in $/nsdemo
 * Updated for rev C0 release.
 * 
 * *****************  Version 7  *****************
 * User: Noreen       Date: 7/10/96    Time: 5:10p
 * Updated in $/nstest
 * Changed definition of BankMask for bug fix in DRAM_Status function
 * 
 * *****************  Version 6  *****************
 * User: Miked        Date: 5/03/96    Time: 3:16p
 * Updated in $/nsdemo
 * Fixed bug is DRAM size display.
 * 
 * *****************  Version 5  *****************
 * User: Miked        Date: 5/03/96    Time: 2:50p
 * Updated in $/nsdemo
 * Maintainence release.
 *
 */
//
// COPYRIGHT
//
//      (c) 1996, 1997 National Semiconductor Corporation
//
//---------------------------------------------------------------------------

#ifndef DRAM_H_INC
#define DRAM_H_INC

//---------------------------------------------------------------------------
// Required Headers

#include "nsglobal.h"

//---------------------------------------------------------------------------
// Function Structures

typedef struct {
	USHORT Parity;
	USHORT Pagesize0;
	USHORT Pagesize1;
	USHORT CyclePageMiss;
	BOOL ExtendedCAS;
	USHORT RefreshRate;
	USHORT RASTimeout;
	USHORT ParityError;
	USHORT BankSize0;
	USHORT BankSize1;
	ULONG  Bank1Address;
} DRAMC_STATUS;

//---------------------------------------------------------------------------
// Register Bit definitions

// DRAM Control Register
#define Disable_Parity    (0<<2)
#define Enable_Parity     (1<<2)
#define Enable_Parity_NMI (1<<14)

// DRAM Status Register
#define Clear_Parity_Error (1<<2)

#define BANK1      8
#define BANK0      4
#define BOTH       12

#define Disabled    0
#define Enabled     1
#define Enabled_NMI 2

#define ThreeCycle 3
#define FourCycle  4

#define Normal     0
#define Extended   1

#define NoParityError    0
#define ParityErrorBank0 1
#define ParityErrorBank1 2
#define ParityErrorBoth  3

#define PageMask 0x07
#define BitMask 0x02
#define BankMask 0x07

#define halfMb  0
#define oneMb   1
#define twoMb   2
#define fourMb  4
#define eightMb 8

//---------------------------------------------------------------------------
//External Function Prototypes

extern USHORT DRAM_Status(DRAMC_STATUS *pStatus);

#endif  // #ifndef DRAM_H_INC

//---------------------------------------------------------------------------
// END       dram.h
//---------------------------------------------------------------------------
