//---------------------------------------------------------------------------
//
// %FILE     dma.h
// %VSS-REV  $Revision: 14 $
// %CREATED  1995.12.15
// %REVISED  $Date: 4/18/97 4:02p $
// %AUTHOR   Noreen Bell
// %PROJECT  NS486SXF evaluation board software
// %PART     NS486SXF (B0+)
// %SUMMARY  Direct Memory Access module header file
//     
// %VSS      $Author: Miked $ $Date: 4/18/97 4:02p $ $Revision: 14 $
//
// DESCRIPTION
//
//   This header file contains definitions for the DMA Controller
//
// HISTORY
//
/*
 *
 * $History: dma.h $
 * 
 * *****************  Version 14  *****************
 * User: Miked        Date: 4/18/97    Time: 4:02p
 * Updated in $/nsdemo
 * Got rid of unused defines.   New header (comment) changes.
 * 
 * *****************  Version 13  *****************
 * User: Miked        Date: 12/04/96   Time: 3:57p
 * Updated in $/nsdemo
 * Changed MAX_DRQ to 5, which is correct for rev B0 and newer.
 * 
 * *****************  Version 12  *****************
 * User: Miked        Date: 8/06/96    Time: 11:59a
 * Updated in $/nsdemo
 * Version 1.4.  Maintainance release.  See README.TXT for info.
 * 
 * *****************  Version 11  *****************
 * User: Miked        Date: 7/23/96    Time: 2:25p
 * Updated in $/nsdemo
 * Maintainance release.  README.TXT describes changes.
 * 
 * *****************  Version 10  *****************
 * User: Miked        Date: 7/16/96    Time: 11:54a
 * Updated in $/nsdemo
 * Updated for rev C0 release.
 * 
 * *****************  Version 9  *****************
 * User: Miked        Date: 6/26/96    Time: 3:07p
 * Updated in $/nsdemo
 * Added DMA_ prefix to a bunch of #defines used in DMA structures.  The
 * one called "Set" in particular was interfering with other modules when
 * DMA.H was included before PIT.H.  The names were too generic to expect
 * them not to be steped on.
 * 
 * *****************  Version 8  *****************
 * User: Miked        Date: 6/26/96    Time: 2:39p
 * Updated in $/nsdemo
 * Added a Clocks per transfer field to the DMA Transfer structure to
 * support
 * different DMA speeds.  (LCD needs fast DMA, Memory to Memory
 * DMA needs slow.)
 * 
 * *****************  Version 7  *****************
 * User: Miked        Date: 6/26/96    Time: 11:09a
 * Updated in $/nsdemo
 * moved IDRSR value to ns486cfg.h
 * 
 * *****************  Version 6  *****************
 * User: Miked        Date: 5/03/96    Time: 2:50p
 * Updated in $/nsdemo
 * Maintainence release.
 * 
 * *****************  Version 5  *****************
 * User: Noreen       Date: 4/18/96    Time: 10:48a
 * Updated in $/nsdemo
 * Updated comments for release version
 * 
 * *****************  Version 4  *****************
 * User: Miked        Date: 4/17/96    Time: 1:28p
 * Updated in $/nsdemo
 * Removed DMA chaining and modified so that MemToMem writes to a buffer
 * in DRAM.
 * 
 * *****************  Version 3  *****************
 * User: Miked        Date: 4/12/96    Time: 3:07p
 * Branched in $/nsdemo
 * NS Demo
 * 
 * *****************  Version 2  *****************
 * User: Noreen       Date: 4/12/96    Time: 3:00p
 * Updated in $/nstest
 * Updated headers for VSS
 *
 */
//
// COPYRIGHT
//
//      (c) 1995, 1996, 1997 National Semiconductor Corporation
//
//---------------------------------------------------------------------------

#ifndef DMA_H_INC
#define DMA_H_INC

//---------------------------------------------------------------------------
// Required headers

#include "nsglobal.h"

//---------------------------------------------------------------------------
// Function structures

enum DATA_TRANSFER_MODE { TransferMode_Demand,
	    TransferMode_Single,
	    TransferMode_Block,
	    TransferMode_Cascade};

enum DMA_CLOCKS_PER_TRANSFER { Clocks2 = 0, Clocks4, Clocks6, Clocks8,
  Clocks10, Clocks12, Clocks14, Clocks16 };

typedef struct {
	enum DATA_TRANSFER_MODE Mode;
	BOOL TC_EOP;
	BOOL IO_MEM;
	BOOL Direction;
	BOOL AutoInit;
	USHORT Channel;
	BOOL RequestorDirection;
	BOOL TargetDirection;
	enum DMA_CLOCKS_PER_TRANSFER Clocks;
	BOOL BusSize;
	USHORT CPUDMARequest;
	ULONG TargetAddress;
	ULONG RequestorAddress;
	USHORT TransferByteCount;
} DMA_TRANSFER;

typedef struct {
	BOOL PriorityType;
	BOOL ControllerEnable;
	USHORT LowestBits;
	BOOL TCStatus;
	BOOL RequestStatus;
	BOOL CPUDMAReg;
	ULONG CurrentTargetAddress;
	ULONG CurrentRequestorAddress;
	USHORT CurrentByteCount;
	BOOL Mask;
	BOOL ChainingMode;
} DMA_STATUS;

//---------------------------------------------------------------------------
// Register bit definitions

// Channel Mode Registers
#define DMA_Channel0     0
#define DMA_Channel1     1
#define DMA_Channel2     2
#define DMA_Channel3     3
#define DMA_Channel4     DMA_Channel0
#define DMA_Channel5     DMA_Channel1

#define CMR_DemandMode      0
#define CMR_SingleMode      (1<<6)
#define CMR_BlockMode       (2<<6)
#define CMR_CascadeMode     (3<<6)

#define CMR_TC              0
#define CMR_EOP             (1<<5)

#define CMR_RequestorIO     0
#define CMR_RequestorMem    (1<<4)

#define CMR_TransferRead    0
#define CMR_TransferWrite   (1<<3)

#define CMR_AutoInitDisable 0
#define CMR_AutoInitEnable  (1<<2)

// Data Mode Registers
#define DMR_Channel0         0
#define DMR_Channel1         1
#define DMR_Channel2         2
#define DMR_Channel3         3
#define DMR_Channel4         DMR_Channel0
#define DMR_Channel5         DMR_Channel1

#define DMR_Width8          0
#define DMR_Width16         (1<<2)

#define DMR_Clocks2         0
#define DMR_Clocks4         (1<<3)
#define DMR_Clocks6         (2<<3)
#define DMR_Clocks8         (3<<3)
#define DMR_Clocks10        (4<<3)
#define DMR_Clocks12        (5<<3)
#define DMR_Clocks14        (6<<3)
#define DMR_Clocks16        (7<<3)

#define DMR_TargetDecrement 0
#define DMR_TargetIncrement (1<<6)

#define DMR_RequestorDecrement  0
#define DMR_RequestorIncrement  (1<<7)

// Chaining Registers
#define CHAIN_Channel0      0
#define CHAIN_Channel1      1
#define CHAIN_Channel2      2
#define CHAIN_Channel3      3
#define CHAIN_Channel4      CHAIN_Channel0
#define CHAIN_Channel5      CHAIN_Channel1

#define CHAIN_Disable       0
#define CHAIN_Enable        (1<<2)
#define CHAIN_Reserved      (2<<2)
#define CHAIN_BaseUpdate    (3<<2)

// Highest DRQ on controller ( not Highest + 1 like in PIC.c )
#define MAX_DRQ 5

// DRQ above which to access CMR1, DMR1, and CHAIN1 instead of
// CMR0, DMR0, and CHAIN0
#define SPLIT_DRQ 3

#define FixedPriority     0
#define RotatingPriority  (1<<1)
#define DMADisable        0
#define DMAEnable         (1<<0)
#define LowestPriority    (5<<2) //Channel5 the default lowest priority

#define DMA_Command_Init (   FixedPriority \
			   | LowestPriority \
			   | DMAEnable )

#define DMA_TC                 0
#define DMA_EOP                1
#define DMA_IO                 0
#define DMA_MEM                1
#define DMA_Read               0
#define DMA_Write              1
#define DMA_Disable            0
#define DMA_Enable             1
#define DMA_NoAction           0
#define DMA_Set                1
#define DMA_Clear              2
#define DMA_Empty              1
#define DMA_NotEmpty           0
#define DMA_TC_NotReached      0
#define DMA_TC_Reached         1
#define DMA_RequestNotPending  0
#define DMA_RequestPending     1
#define DMA_ChannelEnable      0
#define DMA_ChannelDisable     1
#define DMA_Disable_Chaining   0
#define DMA_Enable_Chaining    1
#define DMA_Decrement          0
#define DMA_Increment          1
#define DMA_bit8               0
#define DMA_bit16              1
#define DMA_Fixed              0
#define DMA_Rotating           1

//---------------------------------------------------------------------------
//External Function Prototypes

extern USHORT DMA_Initialize(void);
extern USHORT DMA_Status(USHORT DMAChannel, DMA_STATUS * pStatus);
extern USHORT DMA_Transfer(DMA_TRANSFER Transfer);
extern USHORT DMA_Cancel(USHORT DMAChannel);

//---------------------------------------------------------------------------

#endif // #ifndef DMA_H_INC

//---------------------------------------------------------------------------
// END       dma.h
//---------------------------------------------------------------------------
