;---------------------------------------------------------------------------
;
; %FILE     boiler.inc
; %VSS-REV  $Revision: 1 $
; %VERSION  1.5
; %CREATED  1995.08.01
; %REVISED  $Date: 10/30/96 5:25p $
; %AUTHOR   Michael C. Draeger 
; %PROJECT  NS486SXF evaluation board software
; %PART     NS486SXF 
; %SUMMARY  header file for "Boiler Plate" code
;     
; %VSS      $Author: Miked $ $Date: 10/30/96 5:25p $ $Revision: 1 $
;
; DESCRIPTION
;
;   Useful equates and macros for writing tests to go with the boiler
;   plate module.
;
; RELEASE HISTORY
;
;   1.0   1995.08.01  mcd  genesis
;   1.1   1996.01.10  mcd  version for evb
;   1.5   1996.10.30  mcd  updated for version 1.5 of "BOILER.ASM"
;
; COPYRIGHT
;
;      (c) 1995, 1996 National Semiconductor Corporation
;
;---------------------------------------------------------------------------

; these are the segment registers most simple test programs will use 

CS32F   equ     008h    ; flat 32 bit code segment ring 0
DS32F   equ     010h    ; flat 32 bit data segment ring 0
SSR0    equ     048h    ; ring 0 stack segment

; these segment allow easier access to GDT and IDT

GDTR0   equ     058h    ; GDT at ring 0     
IDTR0   equ     068h    ; IDT at ring 0

; configurable stuff for boiler.asm

        ; descriptors need to be changed in GDT data area too!
        ; (in boiler.asm)

GDTB    equ     0000A0000h      ; GDT base
GDTL    equ     0FFFFh          ; GDT limit
IDTB    equ     0000B0000h      ; IDT base
IDTL    equ     007FFh          ; IDT limit
ISRB    equ     0000E0000h      ; location of default ISR
   
        ; base of this image - used to adjust code for actual location

boiler_base   equ 0FFFF0000h      

; macro to change offset in IDT entry
; 
; entry - which interrupt (0x0 to 0xFF)
; off - 32 bit offset to ISR (in CS32F)

setidt MACRO entry, off

        push    eax
        push    ebx
        push    esi

        mov     bx, fs          ; save fs segment register

        mov     ax, IDTR0       ; descriptor with IDT
        mov     fs, ax          ; set up as fs

        mov     esi, entry      ; IDT entry
        shl     esi, 3          ; entry * 8 = offset in IDT

        mov     eax, off        ; offset to ISR
        mov     fs:[esi], ax    ; offset 15..0
        shr     eax, 16         ; now use upper word of offset
        mov     fs:[esi+6], ax  ; offset 31..16

        mov     fs, bx          ; restore fs segment register

        pop     esi
        pop     ebx
        pop     eax

ENDM

;---------------------------------------------------------------------------
; END       boiler.inc 
;---------------------------------------------------------------------------
