;PROGRAM   :   COP800 1200 BAUD UART RECEIVER " UARTREC8 " @ 2uS
;              instruction cycle time.
;
;DATE      :   4-20-1988   REV.- A 
;
;
; EDITTED MAY 11, 1994 - REVISED FOR NEW ASSEMBLER (ASMCOP v4.2) 
;

;                                       
;Use  the  following  procedure to determine the HEX  value  that 
;corresponds to the desired buad rate.
;
;1/1200 BUAD = 833 uSEC/BIT DECIMAL = 0341 HEX
;1/2 BIT TIME IS = 833 uSEC/2 uSEC = 416.5 DECIMAL = 01A0 HEX.
;
;
 
	.TITLE  UARTR
	.CHIP	ANYCOP
        .SECT   MAIN,ROM,INPAGE

          PSW    = 0EF
          CNTROL  = 0EE
          TMRLO  = 0EA
          TMRHI  = 0EB
          TAULO = 0EC
          TAUHI = 0ED
          PORTGD  = 0D4
          PORTGC = 0D5 
          PORTGP = 0D6
          REG1   = 0F1
          TRUN = 4  
          TPND = 5
          RECREG = 020        ;REG TO HOLD RECEIVED DATA.
          HAFBDL = 0A0
          HAFBDH = 001
          BUADLO = 041
          BUADHI = 003
;    
          LD     SP , #02F
          RC
          LD     PORTGC ,#000 ;SET UP G1,& G2 AS INPUTS.
;
STRTRX:   LD     B , #0EA     ;INITIALIZE "B" TO POINT AT THE 
                              ;TMRLO REG.                    
          LD     [B+],#HAFBDL  ;TIMER VALUE IS 1200 BUAD => 
          LD     [B+],#HAFBDH  ;833 uSEC/BIT. @ 2 uSEC INST.
SETIMR:   LD     [B+],#BUADLO ;CYCLE TIME. HALF A BIT DELAY
          LD     [B+],#BUADHI ;TO TEST AT THE HALF WAY POINT OF
                              ;THE START BIT,THIS IS 0D0 HEX.
          LD     [B] , #0A0   ;LOAD TIMER MODE INFORMATION INTO
                              ;CNTROL, PWM WITH TIO TOGGLE.
          LD     REG1 , #009  ;INITIALIZE THE BIT COUNTER TO 8.
;
REQUST:   IFBIT  2 , PORTGP   ;WAIT FOR THE CTS SIGNAL FROM UART.
          JP     REQUST       ;ON LINE G2.
          JSR    WSTRT    
          JP     STRTRX
;
WSTRT:    IFBIT  1 , PORTGP   ;TEST FOR THE START BIT ON LINE G1.
          JP     WSTRT
;
CHECK:    SBIT   TRUN , CNTROL ;START THE TIMER.
          RBIT   TPND , PSW   ;RESET THE INTERRUPT PENDING FLAG.
CHECK0:   IFBIT  TPND , PSW   ;TEST INT FLAG FOR END OF COUNT.
          JP     CONTST
          JP     CHECK0         
CONTST:   RBIT   TRUN , CNTROL ;STOP THE TIMER/COUNTER.
          RBIT   TPND , PSW   ;RESET INTERRUPT PENDING FLAG.
          IFBIT  1 , PORTGP   ;TE1T FOR A VALID START BIT. IF
                              ;G1 IS STILL LOW, WE HAVE A VALID
                              ;START BIT,OTHERWISE TEST G1 AGAIN
          JMP    STRTRX
;
          CLRA
RECEV:    SBIT   TRUN , CNTROL ;BEGIN THE DELAY TO RECEIVE A DATA
CHICK1:   IFBIT  TPND , PSW   ;BIT. IT WILL BE TESTED AT IT'S
          JP     CONT
          JP     CHICK1       ;HALF WAY POINT TO INSURE THAT IT
CONT:     RBIT   TRUN , CNTROL ;IS NOT A GLITCH. THE DELAY IS =
          RBIT   TPND , PSW   ;1 BIT TIME.
;
          IFBIT  1 , PORTGP   ;IS THE FIRST DATA BIT A 1, OR 0.
          JP     ONE          ;DATA BIT IS A ONE.
          JP     ZERO         ;DATA BIT IS A ZERO.
;                                            
ZERO:     LD     A , RECREG   
          RC                  ;RESET CARRY BIT IF DATA BIT IS 0
          RRCA                ;ROTATE A TO SHIFT IN THE CORRECT
          X      A , RECREG   ;DATA  BITS  DETECTED ON G0  LINE.
          DRSZ   REG1         ;DECREMENT THE BIT COUNT.
          JP     RECEV        ;GO BACK TO RECEIVE NEXT DATA BIT.
          JP     STOPBT       ;PREPARE TO OUTPUT A  STOP  BIT.
;
ONE:      LD     A , RECREG
          SC                  ;SET CARRY IF DATA IS A ONE, THIS 
          RRCA                ;WILL GET ROTATED INTO A. ALL DATA
          X      A , RECREG   ;BITS WILL BE IN A AT THE END OF 
                              ;THE TRANSMITION.
          DRSZ   REG1         ;DECREMENT THE BIT COUNT.
          JMP    RECEV        ;GO BACK TO RECEIVE NEXT DATA BIT.
          X      A , RECREG   ;PREPARE TO OUTPUT A STOP BIT. 
;    
STOPBT:   IFBIT  1 , PORTGP
          JP     CHECK2
          JP     STOPBT
CHECK2:   SBIT   TRUN , CNTROL
CHECK3:   IFBIT  TPND , PSW
          JP     FINISH
          JP     CHECK3
FINISH:   RBIT   TRUN , CNTROL
          RBIT   TPND , PSW
          RET
;
          .END


