;    
;PROGRAM   : COP800 UART TRANSMISSION, 1200 BAUD 
;            @ 1uSec instruction cycle time.
;            TOTAL BYTES: 103          
;
;DATE      : 5-26-1987   REV.- D   
;
; EDITTED MAY 11, 1994 - REVISED FOR NEW ASSEMBLER (ASMCOP v4.2) 
;                      
;Use  the  following  procedure to determine the HEX  value  that 
;corresponds to the desired BAUD rate.
;
;1/1200 BAUD = 833 uSEC/BIT  = 0340 HEX
;833 uSEC / 1 uSEC PER CYCLE = 833.33 = 0340 HEX
;
          .TITLE UARTRANS.ASM 
          .CHIP ANYCOP
          .SECT MAIN,ROM,ABS=0
;
          LOBAUD = 040
          HIBAUD = 003
;
          TRUN  = 4
          TPND  = 5 
          PSW    = 0EF
          CNTRL  = 0EE
          TIMLO  = 0EA
          TIMHI  = 0EB
          AUTOLO = 0EC
          AUTOHI = 0ED
          GDATA  = 0D4
          CONFIG = 0D5 
          REG0   = 0F0        ;THIS IS A BIT COUNTER REGISTER.
          TXDREG = 010        ;REG THAT HOLDS TRANSMITTED DATA.
;
          LD    SP , #02F     ;INITIALIZE THE STACK POINTER.
          LD    CONFIG , #009 ;SETUP G0, & G3 TO BE AN OUTPUT.
;                                    
START:    LD    B , #0EA      ;INITIALIZE B TO LOAD TIMER REGS.
          RC
          LD    [B+],#LOBAUD  ;TIMER VALUE IS 1200 BAUD => 
          LD    [B+],#HIBAUD  ;833 uSEC/BIT. @ 1 uSEC INST.
          LD    [B+] , #040   ;CYCLE TIME.                 
          LD    [B+] , #003 
          LD    [B] , #0A0    ;LOAD THE CNTRL REG. WITH PWM 
                              ;TIMER WITH TIO TOGGLE MODE.
          LD    TXDREG , #0A0
CNTNU:    LD    A , TXDREG
          INCA
          IFEQ  A , #0B7       
          JP    START
          X     A , TXDREG
          LD    A , TXDREG
          LAID
          JSR   TXMIT
          JP    CNTNU
;
TXMIT:    LD    REG0 , #009   ;SETUP BIT COUNTER TO OUTPUT 8 BITS
          RBIT  0 , GDATA     ;OUTPUT THE START BIT.
          SBIT  TRUN , CNTRL  ;START THE TIMER.
;
OUTPUT:   RRCA                ;ROTATE TO TEST 1st DATA BIT IN C.
WAIT1:    IFBIT TPND , PSW    ;TEST TIMER PENDING FLAG FOR TIMER
                              ;UNDERFLOW.
          JP    DATA
          JP    WAIT1
DATA:     RBIT  TPND , PSW    ;RESET TIMER PENDING FLAG.
          DRSZ  REG0
          JP    BACK
STOP:     SBIT  0 , GDATA     ;BEGIN TO SEND OUT THE STOP BIT.
WAIT2:    IFBIT TPND , PSW
          JP    EXIT
          JP    WAIT2
EXIT:     RBIT  TRUN , CNTRL  ;STOP THE TIMER.
          RBIT  TPND , PSW    ;RESET THE TIMER PENDING FLAG.
          RET
;
BACK:     IFC                 ;TEST 1st DATA BIT IN C.  
          JP    ONE           ;C = 1st DATA BIT WHICH IS A ONE.
          RBIT  0 , GDATA     ;DATA BIT IS A ZERO.
          JP    OUT 
ONE:      NOP
          SBIT  0 , GDATA     ;DATA BIT IS A ONE, OUTPUT A ONE.
OUT:      JMP   OUTPUT
;
;THE TABLE BELOW CONTAINS THE ASCII CODE TO OUTPUT THE 
;FOLLOWING MESSAGE: " FROM COPS APPS ! "
;
.=00A0
.BYTE     007
.BYTE     022
.BYTE     020
.BYTE     046
.BYTE     052
.BYTE     04F
.BYTE     04D
.BYTE     020
.BYTE     043
.BYTE     04F 
.BYTE     050
.BYTE     053
.BYTE     020
.BYTE     041
.BYTE     050
.BYTE     050
.BYTE     053
.BYTE     020
.BYTE     021
.BYTE     020
.BYTE     022
.BYTE     007
;
          .END
