// (C) 2005 Max Howell (max.howell@methylblue.com)
// See COPYING file for licensing information

#include "codeineConfig.h"
#include "listView.cpp"
#include <tdeapplication.h>
#include <tdeconfig.h>
#include <kguiitem.h>
#include <tdelistview.h>
#include <kpushbutton.h>
#include <kstdguiitem.h>
#include "playDialog.h"
#include "../mxcl.library.h"
#include <tqfile.h>
#include <tqlabel.h>
#include <tqlayout.h>
#include <tqsignalmapper.h>

TQString i18n( const char *text );


namespace Codeine {


PlayDialog::PlayDialog( TQWidget *parent, bool be_welcome_dialog )
      : TQDialog( parent )
{
   setCaption( tdeApp->makeStdCaption( i18n("Play Media") ) );

   TQSignalMapper *mapper = new TQSignalMapper( this );
   TQWidget *o, *closeButton = new KPushButton( KStdGuiItem::close(), this );
   TQBoxLayout *hbox, *vbox = new TQVBoxLayout( this, 15, 20 );

   vbox->addWidget( new TQLabel( i18n( "What media would you like to play?" ), this ) );

   TQGridLayout *grid = new TQGridLayout( vbox, 1, 3, 20 );

   //TODO use the kguiItems from the actions
   mapper->setMapping( o = new KPushButton( KGuiItem( i18n("Play File..."), "folder" ), this ), FILE );
   connect( o, TQ_SIGNAL(clicked()), mapper, TQ_SLOT(map()) );
   grid->TQLayout::add( o );

   mapper->setMapping( o = new KPushButton( KGuiItem( i18n("Play VCD"), "media-optical-cdaudio-unmounted" ), this ), VCD );
   connect( o, TQ_SIGNAL(clicked()), mapper, TQ_SLOT(map()) );
   grid->TQLayout::add( o );

   mapper->setMapping( o = new KPushButton( KGuiItem( i18n("Play DVD"), "media-optical-dvd-unmounted" ), this ), DVD );
   connect( o, TQ_SIGNAL(clicked()), mapper, TQ_SLOT(map()) );
   grid->TQLayout::add( o );

   mapper->setMapping( closeButton, TQDialog::Rejected );
   connect( closeButton, TQ_SIGNAL(clicked()), mapper, TQ_SLOT(map()) );

   createRecentFileWidget( vbox );

   hbox = new TQHBoxLayout( vbox );
   hbox->addItem( new TQSpacerItem( 10, 10, TQSizePolicy::Expanding ) );

   if( be_welcome_dialog ) {
      TQWidget *w = new KPushButton( KStdGuiItem::quit(), this );
      hbox->addWidget( w );
      connect( w, TQ_SIGNAL(clicked()), tdeApp, TQ_SLOT(quit()) );
   }

   hbox->addWidget( closeButton );

   connect( mapper, TQ_SIGNAL(mapped( int )), TQ_SLOT(done( int )) );
}

void
PlayDialog::createRecentFileWidget( TQBoxLayout *layout )
{
   TDEListView *lv;
   lv = new Codeine::ListView( this );
   lv->setColumnText( 1, i18n("Recently Played Media") );

   const TQStringList list1 = Codeine::config( "General" )->readPathListEntry( "Recent Urls" );
   KURL::List urls;

   foreach( list1 )
      urls += *it;

   for( KURL::List::Iterator it = urls.begin(), end = urls.end(); it != end; ) {
      if( urls.contains( *it ) > 1 )
         //remove duplicates
         it = urls.remove( it );
      else if( (*it).protocol() == "file" && !TQFile::exists( (*it).path() ) )
         //remove stale entries
         it = urls.remove( it );
      else
         ++it;
   }

   for( KURL::List::ConstIterator it = urls.begin(), end = urls.end(); it != end; ++it ) {
      const TQString fileName = (*it).fileName();
      new TDEListViewItem( lv, nullptr, (*it).url(), fileName.isEmpty() ? (*it).prettyURL() : fileName );
   }

   if( lv->childCount() ) {
      layout->addWidget( lv, 1 );
      connect( lv, TQ_SIGNAL(executed( TQListViewItem* )), TQ_SLOT(done( TQListViewItem* )) );
   }
   else
      delete lv;
}

void
PlayDialog::done( TQListViewItem *item )
{
   m_url = item->text( 0 );
   TQDialog::done( RECENT_FILE );
}

}

#include "playDialog.moc"
