/***************************************************************************
                          tagwidget.h  -  description
                             -------------------
    begin                : Sat Apr 1 2000
    copyright            : (C) 2000 by Yacovlev Alexander & Dmitry Poplavsky <pdima@mail.univ.kiev.ua>
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef TAGWIDGET_H
#define TAGWIDGET_H

#include <tqwidget.h>
#include <tqdict.h>

class TQComboBox;
class TQLineEdit;
class TQSpinBox;
class TQCheckBox;
class KColorButton;
class KURL;

/**base class for tag widgets
  *@author Yacovlev Alexander & Dmitry Poplavsky
  */

class TagWidget {
public:
  TagWidget(TQObject *parent=0, const char *name=0);
  virtual ~TagWidget();

  virtual void readAttributes(TQDict<TQString> *) {};
  virtual void writeAttributes(TQDict<TQString> *) {};
  void updateDict(const TQString &attr, TQComboBox *combo);
  void updateDict(const TQString &attr, TQLineEdit *line);
  void updateDict(const TQString &attr, TQSpinBox *spin);
  void updateDict(const TQString &attr, TQCheckBox *check);

  void setValue(const TQString &val, TQComboBox *combo);
  void setValue(const TQString &val, TQLineEdit *line);
  void setValue(const TQString &val, TQSpinBox *spin);
  void setValue(const TQString &val, KColorButton *button);

protected:
  TQDict<TQString> *dict; // dictionary of attributes and values
  KURL baseURL;
};

#endif
