/***************************************************************************
                         debuggerbreakpointlist.h
                         ------------------------
    begin                : 2004-04-04
    copyright            : (C) 2004 Thiago Silva

 ***************************************************************************/

/****************************************************************************
 *                                                                          *
 *   This program is free software; you can redistribute it and/or modify   *
 *   it under the terms of the GNU General Public License as published by   *
 *   the Free Software Foundation; either version 2 of the License, or      *
 *   (at your option) any later version.                                    *
 *                                                                          *
 ***************************************************************************/

#ifndef DEBUGGERBREAKPOINTLIST_H
#define DEBUGGERBREAKPOINTLIST_H

#include <tqobject.h>
#include <tqstring.h>
#include <tqvaluelist.h>

class DebuggerBreakpoint;
    typedef TQValueList<DebuggerBreakpoint*> BreakpointList_t;

class DebuggerBreakpointList
{

  private:
    BreakpointList_t* m_breakpointList;
    BreakpointList_t::iterator m_current;
    BreakpointList_t::iterator find(const DebuggerBreakpoint &bp);

  public:
    DebuggerBreakpointList();
    ~DebuggerBreakpointList();

    void add(DebuggerBreakpoint*);
    void remove(DebuggerBreakpoint*);
    //int remove(TQString filePath, int line);
    void clear();
    bool exists(DebuggerBreakpoint*);
    //bool exists(TQString filePath, int line);

    DebuggerBreakpoint* retrieve(const TQString& filePath, int line);

    DebuggerBreakpoint * findDebuggerBreakpoint(const TQString& key);
    void updateBreakpointKey(const DebuggerBreakpoint &bp, const TQString& newkey);

    size_t count();
    void rewind();
    DebuggerBreakpoint* next();

};

#endif
