/* This file is part of the KDE project
   Copyright (C) 2001 Bernd Gehrmann <bernd@kdevelop.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

#ifndef _ADDENVVARDLG_H_
#define _ADDENVVARDLG_H_

#include <tqdialog.h>
#include <klineedit.h>
class TQPushButton;

/**
Dialog to add environment variables.
*/
class AddEnvvarDialog : public TQDialog
{
    TQ_OBJECT
  

public:
    AddEnvvarDialog( TQWidget *parent=0, const char *name=0 );
    ~AddEnvvarDialog();

    TQString varname() const
        { return varname_edit->text(); }
    TQString value() const
        { return value_edit->text(); }
    void setvarname(const TQString name) const
        { varname_edit->setText(name); }
    void setvalue(const TQString value) const
        { value_edit->setText(value); }
 private slots:
    void slotTextChanged();
private:
    KLineEdit *varname_edit;
    KLineEdit *value_edit;
    TQPushButton *m_pOk;
};

#endif
