// Copyright 2005 Max Howell (max.howell@methylblue.com)
// See COPYING file for licensing information

#include <tqtoolbutton.h>

#include "../debug.h"
#include "../mxcl.library.h"
#include "actions.h"
#include "xineEngine.h"


namespace Codeine
{
   PlayAction::PlayAction( TQObject *receiver, const char *slot, TDEActionCollection *ac )
         : TDEToggleAction( i18n("Play"), "media-playback-start", TQt::Key_Space, receiver, slot, ac, "play" )
   {}

   void
   PlayAction::setChecked( bool b )
   {
      if( videoWindow()->state() == Engine::Empty && sender() && TQCString(sender()->className()) == "TDEToolBarButton" ) {
         // clicking play when empty means open PlayMediaDialog, but we have to uncheck the toolbar button
         // as KDElibs sets that checked automatically..
         ((TQToolButton*)sender())->setOn( false );
      }
      else
         TDEToggleAction::setChecked( b );
   }
}
