;;; most-faces.el --- A List of Most Available Faces  -*- lexical-binding: t; -*-

;; Copyright (C) 2024 Free Software Foundation, Inc.

;; Author:                  Mekeor Melire <mekeor@posteo.de>
;; Created:                 2024
;; Homepage:                https://codeberg.org/mekeor/most-faces
;; Keywords:                faces
;; Maintainer:              Mekeor Melire <mekeor@posteo.de>
;; Package-Requires:        ((emacs "24"))
;; SPDX-License-Identifier: GPL-3.0-or-later
;; Package-Version: 0.2
;; Package-Revision: e37cd1baa74f

;; This file is NOT part of GNU Emacs.

;; This program is free software; you can redistribute it and/or
;; modify it under the terms of the GNU General Public License as
;; published by the Free Software Foundation, either version 3 of the
;; License, or (at your option) any later version.

;; This program is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with this program.  If not, see
;; <https://www.gnu.org/licenses/>.

;;; Commentary:

;; `most-faces' is a package that provides a list of most faces (as
;; symbols) available in GNU Emacs core as well as packages from GNU
;; Elpa, Nongnu Elpa and Melpa.  In fact, `most-faces' provides two
;; variables:

;; `most-faces-as-faces' is a list of symbols that are defined as
;; faces, e.g. via `defface'.  For example, `foo' might be a member of
;; it because it might have been defined as follows:
;;
;;   (defface foo '((t :foreground "#123456")) "Some docstring.")

;; `most-faces-as-variables' is a list of symbols that are defined as
;; variables with a value that is a symbol that is defined as a face.
;; For example, `bar' might be a member of it because it might be
;; defined as follows:
;;
;;   (defvar bar 'foo)

;; Please contribute missing faces!

;;; Code:

(defconst most-faces-as-faces
  '( default
     a-defface
     abbrev-table-name
     ac-candidate-face
     ac-candidate-mouse-face
     ac-clang-candidate-face
     ac-clang-selection-face
     ac-completion-face
     ac-gtags-candidate-face
     ac-gtags-selection-face
     ac-selection-face
     ac-yasnippet-candidate-face
     ac-yasnippet-selection-face
     active-hole-face
     adoc-align-face
     adoc-anchor-face
     adoc-attribute-face
     adoc-bold-face
     adoc-code-face
     adoc-command-face
     adoc-comment-face
     adoc-complex-replacement-face
     adoc-emphasis-face
     adoc-gen-face
     adoc-internal-reference-face
     adoc-language-info-face
     adoc-language-keyword-face
     adoc-link-title-face
     adoc-list-face
     adoc-markup-face
     adoc-meta-face
     adoc-meta-hide-face
     adoc-passthrough-face
     adoc-preprocessor-face
     adoc-reference-face
     adoc-replacement-face
     adoc-secondary-text-face
     adoc-subscript-face
     adoc-superscript-face
     adoc-table-face
     adoc-title-0-face
     adoc-title-1-face
     adoc-title-2-face
     adoc-title-3-face
     adoc-title-4-face
     adoc-title-5-face
     adoc-title-face
     adoc-typewriter-face
     adoc-value-face
     adoc-verbatim-face
     adoc-warning-face
     ag-hit-face
     ag-match-face
     ahs-definition-face
     ahs-definition-face-unfocused
     ahs-edit-mode-face
     ahs-face
     ahs-face-unfocused
     ahs-plugin-bod-face
     ahs-plugin-default-face
     ahs-plugin-default-face-unfocused
     ahs-plugin-whole-buffer-face
     ahs-warning-face
     alect-author
     alect-block
     alect-block-title
     alect-button
     alect-button-mouse
     alect-button-pressed
     alect-color-level-1
     alect-color-level-10
     alect-color-level-11
     alect-color-level-12
     alect-color-level-2
     alect-color-level-3
     alect-color-level-4
     alect-color-level-5
     alect-color-level-6
     alect-color-level-7
     alect-color-level-8
     alect-color-level-9
     alect-field-title
     alect-file
     alect-key
     alect-prompt
     alect-selected-item
     alect-tab-default
     alect-tab-mouse
     alect-tab-selected
     alect-tab-unselected
     alect-time
     alect-title
     alect-title-1
     alect-title-2
     alect-title-3
     alect-title-4
     alect-title-5
     alect-title-6
     alect-title-7
     alect-title-8
     alert-high-face
     alert-low-face
     alert-moderate-face
     alert-normal-face
     alert-trivial-face
     alert-urgent-face
     all-the-icons-blue
     all-the-icons-blue-alt
     all-the-icons-cyan
     all-the-icons-cyan-alt
     all-the-icons-dblue
     all-the-icons-dcyan
     all-the-icons-dgreen
     all-the-icons-dmaroon
     all-the-icons-dorange
     all-the-icons-dpink
     all-the-icons-dpurple
     all-the-icons-dred
     all-the-icons-dsilver
     all-the-icons-dyellow
     all-the-icons-green
     all-the-icons-lblue
     all-the-icons-lcyan
     all-the-icons-lgreen
     all-the-icons-lmaroon
     all-the-icons-lorange
     all-the-icons-lpink
     all-the-icons-lpurple
     all-the-icons-lred
     all-the-icons-lsilver
     all-the-icons-lyellow
     all-the-icons-maroon
     all-the-icons-orange
     all-the-icons-pink
     all-the-icons-purple
     all-the-icons-purple-alt
     all-the-icons-red
     all-the-icons-red-alt
     all-the-icons-silver
     all-the-icons-yellow
     annotate-highlight
     annotate-prefix
     ansi-color-black
     ansi-color-blue
     ansi-color-bold
     ansi-color-bright-black
     ansi-color-bright-blue
     ansi-color-bright-cyan
     ansi-color-bright-green
     ansi-color-bright-magenta
     ansi-color-bright-red
     ansi-color-bright-white
     ansi-color-bright-yellow
     ansi-color-cyan
     ansi-color-faint
     ansi-color-fast-blink
     ansi-color-green
     ansi-color-inverse
     ansi-color-italic
     ansi-color-magenta
     ansi-color-red
     ansi-color-slow-blink
     ansi-color-underline
     ansi-color-white
     ansi-color-yellow
     ansible-doc-choices
     ansible-doc-default
     ansible-doc-header
     ansible-doc-label
     ansible-doc-literal
     ansible-doc-mandatory-option
     ansible-doc-module-xref
     ansible-doc-option
     ansible-doc-section
     ansible-section-face
     ansible-task-label-face
     antlr-default
     antlr-keyword
     antlr-literal
     antlr-ruledef
     antlr-ruleref
     antlr-syntax
     antlr-tokendef
     antlr-tokenref
     anzu-match-1
     anzu-match-2
     anzu-match-3
     anzu-mode-line
     anzu-mode-line-no-match
     anzu-replace-highlight
     anzu-replace-to
     appt-notification
     apropos-button
     apropos-function-button
     apropos-keybinding
     apropos-misc-button
     apropos-property
     apropos-symbol
     apropos-user-option-button
     apropos-variable-button
     auto-dim-other-buffers-face
     auto-dim-other-buffers-hide-face
     avy-background-face
     avy-goto-char-timer-face
     avy-lead-face
     avy-lead-face-0
     avy-lead-face-1
     avy-lead-face-2
     aw-background-face
     aw-key-face
     aw-leading-char-face
     aw-minibuffer-leading-char-face
     aw-mode-line-face
     axiom-boot-keyword
     axiom-buffer-menu-group-heading
     axiom-category-name
     axiom-domain-name
     axiom-input-doc-comment
     axiom-input-keyword
     axiom-operation-name
     axiom-package-name
     axiom-spad-doc-comment
     axiom-spad-keyword
     bad-face
     bat-label-face
     battery-load-critical
     battery-load-low
     bc-face
     bc-imenu-crumbs-face
     bc-imenu-leaf-face
     bc-project-base-face
     bc-project-crumbs-face
     bc-project-leaf-face
     beacon-fallback-background
     bg:erc-color-face0
     bg:erc-color-face1
     bg:erc-color-face10
     bg:erc-color-face11
     bg:erc-color-face12
     bg:erc-color-face13
     bg:erc-color-face14
     bg:erc-color-face15
     bg:erc-color-face2
     bg:erc-color-face3
     bg:erc-color-face4
     bg:erc-color-face5
     bg:erc-color-face6
     bg:erc-color-face7
     bg:erc-color-face8
     bg:erc-color-face9
     bg:kite-dataReceived
     bg:kite-pageStart
     bg:kite-receiveHeadersEnd
     bg:kite-requestStart
     bg:kite-sendEnd
     bg:kite-table-head
     bg:kite-tick
     biblio-detail-header-face
     biblio-highlight-extend-face
     biblio-results-header-face
     blink-matching-paren-offscreen
     bold
     bold-italic
     bookmark-face
     bookmark-menu-bookmark
     border
     breadcrumb-face
     breadcrumb-imenu-crumbs-face
     breadcrumb-imenu-leaf-face
     breadcrumb-project-base-face
     breadcrumb-project-crumbs-face
     breadcrumb-project-leaf-face
     breakpoint-disabled
     breakpoint-enabled
     browse-url-button
     buffer-menu-buffer
     bui-action-button
     bui-action-button-mouse
     bui-file-name
     bui-hint-key
     bui-history-button
     bui-info-heading
     bui-info-param-title
     bui-time
     bui-url
     button
     button-lock-button-face
     button-lock-mouse-face
     c-annotation-face
     calc-nonselected-face
     calc-selected-face
     calendar-month-header
     calendar-today
     calendar-weekday-header
     calendar-weekend-header
     caml-font-doccomment-face
     caml-font-stop-face
     caml-types-def-face
     caml-types-expr-face
     caml-types-occ-face
     caml-types-scope-face
     caml-types-typed-face
     camldebug-event
     camldebug-underline
     cfrs-border-color
     cfw:face-annotation
     cfw:face-day-title
     cfw:face-default-content
     cfw:face-default-day
     cfw:face-disable
     cfw:face-grid
     cfw:face-header
     cfw:face-holiday
     cfw:face-periods
     cfw:face-saturday
     cfw:face-select
     cfw:face-sunday
     cfw:face-title
     cfw:face-today
     cfw:face-today-title
     cfw:face-toolbar
     cfw:face-toolbar-button-off
     cfw:face-toolbar-button-on
     change-log-acknowledgment
     change-log-conditionals
     change-log-date
     change-log-email
     change-log-file
     change-log-function
     change-log-list
     change-log-name
     child-frame-border
     cider-browse-ns-extra-info-face
     cider-debug-code-overlay-face
     cider-debug-prompt-face
     cider-deprecated-face
     cider-docview-emphasis-face
     cider-docview-literal-face
     cider-docview-strong-face
     cider-docview-table-border-face
     cider-enlightened-face
     cider-enlightened-local-face
     cider-error-highlight-face
     cider-error-overlay-face
     cider-fragile-button-face
     cider-fringe-good-face
     cider-instrumented-face
     cider-reader-conditional-face
     cider-repl-input-face
     cider-repl-prompt-face
     cider-repl-result-face
     cider-repl-stderr-face
     cider-repl-stdout-face
     cider-result-overlay-face
     cider-stacktrace-error-class-face
     cider-stacktrace-error-message-face
     cider-stacktrace-face
     cider-stacktrace-filter-active-face
     cider-stacktrace-filter-inactive-face
     cider-stacktrace-fn-face
     cider-stacktrace-ns-face
     cider-stacktrace-promoted-button-face
     cider-stacktrace-suppressed-button-face
     cider-test-error-face
     cider-test-failure-face
     cider-test-success-face
     cider-traced-face
     cider-warning-highlight-face
     circe-fool-face
     circe-highlight-nick-face
     circe-my-message-face
     circe-originator-face
     circe-prompt-face
     circe-server-face
     circe-topic-diff-new-face
     circe-topic-diff-removed-face
     clojure-character-face
     clojure-keyword-face
     clojure-ts-character-face
     clojure-ts-keyword-face
     comint-highlight-input
     comint-highlight-prompt
     company-echo
     company-echo-common
     company-preview
     company-preview-common
     company-preview-search
     company-scrollbar-bg
     company-scrollbar-fg
     company-template-field
     company-tooltip
     company-tooltip-annotation
     company-tooltip-annotation-selection
     company-tooltip-common
     company-tooltip-common-selection
     company-tooltip-deprecated
     company-tooltip-mouse
     company-tooltip-quick-access
     company-tooltip-quick-access-selection
     company-tooltip-scrollbar-thumb
     company-tooltip-scrollbar-track
     company-tooltip-search
     company-tooltip-search-selection
     company-tooltip-selection
     compare-windows-added
     compare-windows-removed
     compilation-column-number
     compilation-error
     compilation-info
     compilation-line-number
     compilation-mode-line-exit
     compilation-mode-line-fail
     compilation-mode-line-run
     compilation-warning
     completion-preview
     completion-preview-exact
     completion-preview-highlight
     completions-annotations
     completions-common-part
     completions-first-difference
     completions-group-separator
     completions-group-title
     completions-highlight
     confusingly-reordered
     consult-async-failed
     consult-async-finished
     consult-async-running
     consult-async-split
     consult-bookmark
     consult-buffer
     consult-erc-annotation-server
     consult-erc-annotation-topic
     consult-file
     consult-grep-context
     consult-help
     consult-highlight-mark
     consult-highlight-match
     consult-imenu-prefix
     consult-key
     consult-line-number
     consult-line-number-prefix
     consult-line-number-wrapped
     consult-narrow-indicator
     consult-preview-insertion
     consult-preview-line
     consult-preview-match
     consult-separator
     context-coloring-level-0-face
     context-coloring-level-1-face
     context-coloring-level-10-face
     context-coloring-level-11-face
     context-coloring-level-12-face
     context-coloring-level-13-face
     context-coloring-level-14-face
     context-coloring-level-15-face
     context-coloring-level-16-face
     context-coloring-level-17-face
     context-coloring-level-18-face
     context-coloring-level-19-face
     context-coloring-level-2-face
     context-coloring-level-20-face
     context-coloring-level-21-face
     context-coloring-level-22-face
     context-coloring-level-23-face
     context-coloring-level-24-face
     context-coloring-level-25-face
     context-coloring-level-3-face
     context-coloring-level-4-face
     context-coloring-level-5-face
     context-coloring-level-6-face
     context-coloring-level-7-face
     context-coloring-level-8-face
     context-coloring-level-9-face
     coq-button-face
     coq-button-face-active
     coq-button-face-pressed
     coq-cheat-face
     coq-context-qualifier-face
     coq-diffs-added-bg-face
     coq-diffs-added-face
     coq-diffs-removed-bg-face
     coq-diffs-removed-face
     coq-question-mark-face
     coq-solve-tactics-face
     coq-symbol-binder-face
     coq-symbol-face
     corfu-annotations
     corfu-bar
     corfu-border
     corfu-current
     corfu-default
     corfu-deprecated
     corfu-echo
     corfu-indexed
     corfu-popupinfo
     corfu-quick1
     corfu-quick2
     counsel--mark-ring-highlight
     counsel-active-mode
     counsel-application-name
     counsel-evil-register-face
     counsel-key-binding
     counsel-outline-1
     counsel-outline-2
     counsel-outline-3
     counsel-outline-4
     counsel-outline-5
     counsel-outline-6
     counsel-outline-7
     counsel-outline-8
     counsel-outline-default
     counsel-variable-documentation
     cperl-array-face
     cperl-hash-face
     cperl-method-call
     cperl-nonoverridable-face
     cscope-file-face
     cscope-function-face
     cscope-line-number-face
     cscope-mouse-face
     cscope-separator-face
     css-property
     css-proprietary-property
     css-selector
     csv-separator-face
     ctbl:face-cell-select
     ctbl:face-continue-bar
     ctbl:face-row-select
     cua-global-mark
     cua-rectangle
     cua-rectangle-noselect
     cursor
     custom-button
     custom-button-mouse
     custom-button-pressed
     custom-button-pressed-unraised
     custom-button-unraised
     custom-changed
     custom-comment
     custom-comment-tag
     custom-documentation
     custom-face-tag
     custom-group-subtitle
     custom-group-tag
     custom-group-tag-1
     custom-invalid
     custom-link
     custom-modified
     custom-rogue
     custom-saved
     custom-set
     custom-state
     custom-themed
     custom-variable-button
     custom-variable-obsolete
     custom-variable-tag
     custom-visibility
     cvs-filename
     cvs-handled
     cvs-header
     cvs-marked
     cvs-msg
     cvs-need-action
     cvs-unknown
     cypher-clause-face
     cypher-function-face
     cypher-keyword-face
     cypher-node-type-face
     cypher-pattern-face
     cypher-relation-type-face
     cypher-symbol-face
     cypher-variable-face
     dap-mouse-eval-thing-face
     dap-result-overlay-face
     dap-ui-breakpoint-verified-fringe
     dap-ui-compile-errline
     dap-ui-controls-fringe
     dap-ui-locals-scope-face
     dap-ui-locals-variable-face
     dap-ui-locals-variable-leaf-face
     dap-ui-marker-face
     dap-ui-pending-breakpoint-face
     dap-ui-sessions-active-session-face
     dap-ui-sessions-running-face
     dap-ui-sessions-stack-frame-face
     dap-ui-sessions-terminated-active-face
     dap-ui-sessions-terminated-face
     dap-ui-sessions-thread-active-face
     dap-ui-sessions-thread-face
     dap-ui-verified-breakpoint-face
     dap-variables-pid-face
     dape-breakpoint-face
     dape-exception-description-face
     dape-expression-face
     dape-log-face
     dape-repl-error-face
     dape-repl-success-face
     dape-stack-trace-face
     debbugs-gnu-archived
     debbugs-gnu-done
     debbugs-gnu-forwarded
     debbugs-gnu-handled
     debbugs-gnu-marked
     debbugs-gnu-marked-stale
     debbugs-gnu-new
     debbugs-gnu-pending
     debbugs-gnu-stale-1
     debbugs-gnu-stale-2
     debbugs-gnu-stale-3
     debbugs-gnu-stale-4
     debbugs-gnu-stale-5
     debbugs-gnu-tagged
     debbugs-gnu-title
     debugger-not-running
     debugger-running
     deft-filter-string-error-face
     deft-filter-string-face
     deft-header-face
     deft-separator-face
     deft-summary-face
     deft-time-face
     deft-title-face
     denote-faces-date
     denote-faces-day
     denote-faces-delimiter
     denote-faces-extension
     denote-faces-hour
     denote-faces-keywords
     denote-faces-link
     denote-faces-minute
     denote-faces-month
     denote-faces-prompt-current-name
     denote-faces-prompt-new-name
     denote-faces-prompt-old-name
     denote-faces-second
     denote-faces-signature
     denote-faces-subdirectory
     denote-faces-time
     denote-faces-time-delimiter
     denote-faces-title
     denote-faces-year
     devdocs-code-block
     diary
     diary-anniversary
     diary-button
     diary-time
     dictionary-button-face
     dictionary-reference-face
     dictionary-word-definition-face
     dictionary-word-entry-face
     diff-added
     diff-ansi-default-face
     diff-changed
     diff-changed-unspecified
     diff-context
     diff-error
     diff-file-header
     diff-function
     diff-header
     diff-hl-change
     diff-hl-delete
     diff-hl-dired-change
     diff-hl-dired-delete
     diff-hl-dired-ignored
     diff-hl-dired-insert
     diff-hl-dired-unknown
     diff-hl-insert
     diff-hl-margin-change
     diff-hl-margin-delete
     diff-hl-margin-ignored
     diff-hl-margin-insert
     diff-hl-margin-unknown
     diff-hl-reverted-hunk-highlight
     diff-hl-show-hunk-posframe
     diff-hl-show-hunk-posframe-button-face
     diff-hunk-header
     diff-index
     diff-indicator-added
     diff-indicator-changed
     diff-indicator-removed
     diff-nonexistent
     diff-refine-added
     diff-refine-changed
     diff-refine-removed
     diff-removed
     dired-async-failures
     dired-async-message
     dired-async-mode-message
     dired-broken-symlink
     dired-directory
     dired-flagged
     dired-header
     dired-ignored
     dired-mark
     dired-marked
     dired-perm-write
     dired-set-id
     dired-special
     dired-symlink
     dired-warning
     dirvish-collapse-dir-face
     dirvish-collapse-empty-dir-face
     dirvish-collapse-file-face
     dirvish-emerge-group-title
     dirvish-file-device-number
     dirvish-file-group-id
     dirvish-file-inode-number
     dirvish-file-link-number
     dirvish-file-modes
     dirvish-file-size
     dirvish-file-time
     dirvish-file-user-id
     dirvish-free-space
     dirvish-git-commit-message-face
     dirvish-hl-line
     dirvish-media-info-heading
     dirvish-media-info-property-key
     dirvish-subtree-guide
     dirvish-subtree-state
     dirvish-vc-needs-merge-face
     dirvish-vc-unregistered-face
     display-time-date-and-time
     dns-mode-bad-control-entity
     dns-mode-class
     dns-mode-control-entity
     dns-mode-type
     doc-show-inline-face
     doc-view-svg-face
     dockerfile-image-alias
     dockerfile-image-name
     dokuwiki-box
     dokuwiki-code
     dokuwiki-footnote
     dokuwiki-headline-1
     dokuwiki-headline-2
     dokuwiki-headline-3
     dokuwiki-headline-4
     dokuwiki-headline-5
     dokuwiki-image
     dokuwiki-link
     dokuwiki-list
     dokuwiki-smiley
     dokuwiki-table
     dokuwiki-verbatim
     doom-modeline-buffer-active
     doom-modeline-buffer-active-i
     doom-modeline-buffer-modified
     doom-modeline-buffer-modified-i
     easycrypt-tactics-closing-face
     easycrypt-tactics-dangerous-face
     easycrypt-tactics-tacticals-face
     eat-shell-prompt-annotation-failure
     eat-shell-prompt-annotation-running
     eat-shell-prompt-annotation-success
     eat-term-bold
     eat-term-color-0
     eat-term-color-1
     eat-term-color-10
     eat-term-color-100
     eat-term-color-101
     eat-term-color-102
     eat-term-color-103
     eat-term-color-104
     eat-term-color-105
     eat-term-color-106
     eat-term-color-107
     eat-term-color-108
     eat-term-color-109
     eat-term-color-11
     eat-term-color-110
     eat-term-color-111
     eat-term-color-112
     eat-term-color-113
     eat-term-color-114
     eat-term-color-115
     eat-term-color-116
     eat-term-color-117
     eat-term-color-118
     eat-term-color-119
     eat-term-color-12
     eat-term-color-120
     eat-term-color-121
     eat-term-color-122
     eat-term-color-123
     eat-term-color-124
     eat-term-color-125
     eat-term-color-126
     eat-term-color-127
     eat-term-color-128
     eat-term-color-129
     eat-term-color-13
     eat-term-color-130
     eat-term-color-131
     eat-term-color-132
     eat-term-color-133
     eat-term-color-134
     eat-term-color-135
     eat-term-color-136
     eat-term-color-137
     eat-term-color-138
     eat-term-color-139
     eat-term-color-14
     eat-term-color-140
     eat-term-color-141
     eat-term-color-142
     eat-term-color-143
     eat-term-color-144
     eat-term-color-145
     eat-term-color-146
     eat-term-color-147
     eat-term-color-148
     eat-term-color-149
     eat-term-color-15
     eat-term-color-150
     eat-term-color-151
     eat-term-color-152
     eat-term-color-153
     eat-term-color-154
     eat-term-color-155
     eat-term-color-156
     eat-term-color-157
     eat-term-color-158
     eat-term-color-159
     eat-term-color-16
     eat-term-color-160
     eat-term-color-161
     eat-term-color-162
     eat-term-color-163
     eat-term-color-164
     eat-term-color-165
     eat-term-color-166
     eat-term-color-167
     eat-term-color-168
     eat-term-color-169
     eat-term-color-17
     eat-term-color-170
     eat-term-color-171
     eat-term-color-172
     eat-term-color-173
     eat-term-color-174
     eat-term-color-175
     eat-term-color-176
     eat-term-color-177
     eat-term-color-178
     eat-term-color-179
     eat-term-color-18
     eat-term-color-180
     eat-term-color-181
     eat-term-color-182
     eat-term-color-183
     eat-term-color-184
     eat-term-color-185
     eat-term-color-186
     eat-term-color-187
     eat-term-color-188
     eat-term-color-189
     eat-term-color-19
     eat-term-color-190
     eat-term-color-191
     eat-term-color-192
     eat-term-color-193
     eat-term-color-194
     eat-term-color-195
     eat-term-color-196
     eat-term-color-197
     eat-term-color-198
     eat-term-color-199
     eat-term-color-2
     eat-term-color-20
     eat-term-color-200
     eat-term-color-201
     eat-term-color-202
     eat-term-color-203
     eat-term-color-204
     eat-term-color-205
     eat-term-color-206
     eat-term-color-207
     eat-term-color-208
     eat-term-color-209
     eat-term-color-21
     eat-term-color-210
     eat-term-color-211
     eat-term-color-212
     eat-term-color-213
     eat-term-color-214
     eat-term-color-215
     eat-term-color-216
     eat-term-color-217
     eat-term-color-218
     eat-term-color-219
     eat-term-color-22
     eat-term-color-220
     eat-term-color-221
     eat-term-color-222
     eat-term-color-223
     eat-term-color-224
     eat-term-color-225
     eat-term-color-226
     eat-term-color-227
     eat-term-color-228
     eat-term-color-229
     eat-term-color-23
     eat-term-color-230
     eat-term-color-231
     eat-term-color-232
     eat-term-color-233
     eat-term-color-234
     eat-term-color-235
     eat-term-color-236
     eat-term-color-237
     eat-term-color-238
     eat-term-color-239
     eat-term-color-24
     eat-term-color-240
     eat-term-color-241
     eat-term-color-242
     eat-term-color-243
     eat-term-color-244
     eat-term-color-245
     eat-term-color-246
     eat-term-color-247
     eat-term-color-248
     eat-term-color-249
     eat-term-color-25
     eat-term-color-250
     eat-term-color-251
     eat-term-color-252
     eat-term-color-253
     eat-term-color-254
     eat-term-color-255
     eat-term-color-26
     eat-term-color-27
     eat-term-color-28
     eat-term-color-29
     eat-term-color-3
     eat-term-color-30
     eat-term-color-31
     eat-term-color-32
     eat-term-color-33
     eat-term-color-34
     eat-term-color-35
     eat-term-color-36
     eat-term-color-37
     eat-term-color-38
     eat-term-color-39
     eat-term-color-4
     eat-term-color-40
     eat-term-color-41
     eat-term-color-42
     eat-term-color-43
     eat-term-color-44
     eat-term-color-45
     eat-term-color-46
     eat-term-color-47
     eat-term-color-48
     eat-term-color-49
     eat-term-color-5
     eat-term-color-50
     eat-term-color-51
     eat-term-color-52
     eat-term-color-53
     eat-term-color-54
     eat-term-color-55
     eat-term-color-56
     eat-term-color-57
     eat-term-color-58
     eat-term-color-59
     eat-term-color-6
     eat-term-color-60
     eat-term-color-61
     eat-term-color-62
     eat-term-color-63
     eat-term-color-64
     eat-term-color-65
     eat-term-color-66
     eat-term-color-67
     eat-term-color-68
     eat-term-color-69
     eat-term-color-7
     eat-term-color-70
     eat-term-color-71
     eat-term-color-72
     eat-term-color-73
     eat-term-color-74
     eat-term-color-75
     eat-term-color-76
     eat-term-color-77
     eat-term-color-78
     eat-term-color-79
     eat-term-color-8
     eat-term-color-80
     eat-term-color-81
     eat-term-color-82
     eat-term-color-83
     eat-term-color-84
     eat-term-color-85
     eat-term-color-86
     eat-term-color-87
     eat-term-color-88
     eat-term-color-89
     eat-term-color-9
     eat-term-color-90
     eat-term-color-91
     eat-term-color-92
     eat-term-color-93
     eat-term-color-94
     eat-term-color-95
     eat-term-color-96
     eat-term-color-97
     eat-term-color-98
     eat-term-color-99
     eat-term-faint
     eat-term-fast-blink
     eat-term-font-0
     eat-term-font-1
     eat-term-font-2
     eat-term-font-3
     eat-term-font-4
     eat-term-font-5
     eat-term-font-6
     eat-term-font-7
     eat-term-font-8
     eat-term-font-9
     eat-term-italic
     eat-term-slow-blink
     ebrowse-default
     ebrowse-file-name
     ebrowse-member-attribute
     ebrowse-member-class
     ebrowse-progress
     ebrowse-root-class
     ebrowse-tree-mark
     edebug-disabled-breakpoint
     edebug-enabled-breakpoint
     ediff-current-diff-A
     ediff-current-diff-Ancestor
     ediff-current-diff-B
     ediff-current-diff-C
     ediff-even-diff-A
     ediff-even-diff-Ancestor
     ediff-even-diff-B
     ediff-even-diff-C
     ediff-fine-diff-A
     ediff-fine-diff-Ancestor
     ediff-fine-diff-B
     ediff-fine-diff-C
     ediff-odd-diff-A
     ediff-odd-diff-Ancestor
     ediff-odd-diff-B
     ediff-odd-diff-C
     edit-indirect-edited-region
     edmacro-label
     eelll
     eglot-diagnostic-tag-deprecated-face
     eglot-diagnostic-tag-unnecessary-face
     eglot-highlight-symbol-face
     eglot-inlay-hint-face
     eglot-mode-line
     eglot-parameter-hint-face
     eglot-type-hint-face
     eieio-custom-slot-tag-face
     ein:basecell-input-area-face
     ein:cell-output-area
     ein:cell-output-area-error
     ein:cell-output-prompt
     ein:cell-output-stderr
     ein:markdown-blockquote-face
     ein:markdown-bold-face
     ein:markdown-code-face
     ein:markdown-comment-face
     ein:markdown-footnote-marker-face
     ein:markdown-footnote-text-face
     ein:markdown-header-delimiter-face
     ein:markdown-header-face
     ein:markdown-header-rule-face
     ein:markdown-highlight-face
     ein:markdown-hr-face
     ein:markdown-html-attr-name-face
     ein:markdown-html-attr-value-face
     ein:markdown-html-entity-face
     ein:markdown-html-tag-delimiter-face
     ein:markdown-html-tag-name-face
     ein:markdown-inline-code-face
     ein:markdown-italic-face
     ein:markdown-language-info-face
     ein:markdown-language-keyword-face
     ein:markdown-line-break-face
     ein:markdown-link-face
     ein:markdown-link-title-face
     ein:markdown-list-face
     ein:markdown-markup-face
     ein:markdown-math-face
     ein:markdown-metadata-key-face
     ein:markdown-metadata-value-face
     ein:markdown-missing-link-face
     ein:markdown-plain-url-face
     ein:markdown-pre-face
     ein:markdown-reference-face
     ein:markdown-strike-through-face
     ein:markdown-table-face
     ein:markdown-url-face
     ein:notification-tab-normal
     ein:pos-tip-face
     eldoc-highlight-function-argument
     elfeed-log-date-face
     elfeed-log-debug-level-face
     elfeed-log-error-level-face
     elfeed-log-info-level-face
     elfeed-log-warn-level-face
     elfeed-score-date-face
     elfeed-score-debug-level-face
     elfeed-score-error-level-face
     elfeed-score-info-level-face
     elfeed-score-scoring-explain-text-face
     elfeed-score-warn-level-face
     elfeed-search-date-face
     elfeed-search-feed-face
     elfeed-search-filter-face
     elfeed-search-last-update-face
     elfeed-search-tag-face
     elfeed-search-title-face
     elfeed-search-unread-count-face
     elfeed-search-unread-title-face
     elisp-shorthand-font-lock-face
     elixir-atom-face
     elixir-attribute-face
     elixir-number-face
     elixir-ts-atom
     elixir-ts-attribute
     elixir-ts-comment-doc-attribute
     elixir-ts-comment-doc-identifier
     elixir-ts-font-comment-doc-attribute-face
     elixir-ts-font-comment-doc-identifier-face
     elixir-ts-font-sigil-name-face
     elixir-ts-keyword-key
     elixir-ts-sigil-name
     elpher-binary
     elpher-gemini
     elpher-gemini-heading1
     elpher-gemini-heading2
     elpher-gemini-heading3
     elpher-gemini-preformatted
     elpher-gemini-preformatted-toggle
     elpher-gemini-quoted
     elpher-html
     elpher-image
     elpher-index
     elpher-info
     elpher-margin-brackets
     elpher-margin-key
     elpher-other-url
     elpher-search
     elpher-telnet
     elpher-text
     elpher-unknown
     elpy-breakpoint-fringe-face
     elpy-codecell-boundary
     elpy-folding-face
     elpy-folding-fringe-face
     emacs-authors-author
     emacs-authors-default
     emacs-authors-descriptor
     emacs-authors-other-files
     emacs-news-does-not-need-documentation
     emacs-news-is-documented
     embark-collect-annotation
     embark-collect-candidate
     embark-collect-group-separator
     embark-collect-group-title
     embark-keybinding
     embark-keybinding-repeat
     embark-keymap
     embark-selected
     embark-target
     embark-verbose-indicator-documentation
     embark-verbose-indicator-shadowed
     embark-verbose-indicator-title
     ement-room-fully-read-marker
     ement-room-list-direct
     ement-room-list-favourite
     ement-room-list-invited
     ement-room-list-left
     ement-room-list-low-priority
     ement-room-list-name
     ement-room-list-recent
     ement-room-list-space
     ement-room-list-unread
     ement-room-list-very-recent
     ement-room-membership
     ement-room-mention
     ement-room-message-emote
     ement-room-message-text
     ement-room-name
     ement-room-quote
     ement-room-reactions
     ement-room-reactions-key
     ement-room-read-receipt-marker
     ement-room-redacted
     ement-room-self
     ement-room-self-message
     ement-room-timestamp
     ement-room-timestamp-header
     ement-room-user
     ement-room-wrap-prefix
     ement-tabulated-room-list-direct
     ement-tabulated-room-list-favourite
     ement-tabulated-room-list-invited
     ement-tabulated-room-list-left
     ement-tabulated-room-list-low-priority
     ement-tabulated-room-list-name
     ement-tabulated-room-list-recent
     ement-tabulated-room-list-unread
     ement-tabulated-room-list-very-recent
     emms-browser-album-face
     emms-browser-artist-face
     emms-browser-composer-face
     emms-browser-performer-face
     emms-browser-track-face
     emms-browser-year/genre-face
     emms-metaplaylist-mode-current-face
     emms-metaplaylist-mode-face
     emms-playlist-selected-face
     emms-playlist-track-face
     emoji
     emoji-list-header
     emoji-with-derivations
     epa-field-body
     epa-field-name
     epa-mark
     epa-string
     epa-validity-disabled
     epa-validity-high
     epa-validity-low
     epa-validity-medium
     epc:face-title
     erb-comment-delim-face
     erb-comment-face
     erb-delim-face
     erb-exec-delim-face
     erb-exec-face
     erb-face
     erb-out-delim-face
     erb-out-face
     erc-action-face
     erc-bold-face
     erc-button
     erc-button-nick-default-face
     erc-capab-identify-unidentified
     erc-command-indicator-face
     erc-control-default-bg
     erc-control-default-fg
     erc-current-nick-face
     erc-dangerous-host-face
     erc-default-face
     erc-direct-msg-face
     erc-error-face
     erc-fill-wrap-merge-indicator-face
     erc-fool-face
     erc-header-line
     erc-input-face
     erc-inverse-face
     erc-italic-face
     erc-keep-place-indicator-arrow
     erc-keep-place-indicator-line
     erc-keyword-face
     erc-my-nick-face
     erc-my-nick-prefix-face
     erc-nick-default-face
     erc-nick-msg-face
     erc-nick-prefix-face
     erc-notice-face
     erc-pal-face
     erc-prompt-face
     erc-spoiler-face
     erc-timestamp-face
     erc-underline-face
     eros-result-overlay-face
     error
     ert-test-result-expected
     ert-test-result-unexpected
     erts-mode-end-test
     erts-mode-specification-name
     erts-mode-specification-value
     erts-mode-start-test
     escape-glyph
     eshell-ls-archive
     eshell-ls-backup
     eshell-ls-clutter
     eshell-ls-directory
     eshell-ls-executable
     eshell-ls-missing
     eshell-ls-product
     eshell-ls-readonly
     eshell-ls-special
     eshell-ls-symlink
     eshell-ls-unreadable
     eshell-prompt
     eshell-syntax-highlighting-alias-face
     eshell-syntax-highlighting-command-substitution-face
     eshell-syntax-highlighting-comment-face
     eshell-syntax-highlighting-default-face
     eshell-syntax-highlighting-delimiter-face
     eshell-syntax-highlighting-directory-face
     eshell-syntax-highlighting-envvar-face
     eshell-syntax-highlighting-file-arg-face
     eshell-syntax-highlighting-invalid-face
     eshell-syntax-highlighting-lisp-function-face
     eshell-syntax-highlighting-option-face
     eshell-syntax-highlighting-shell-command-face
     eshell-syntax-highlighting-string-face
     ess-%op%-face
     ess-assignment-face
     ess-bp-fringe-browser-face
     ess-bp-fringe-inactive-face
     ess-bp-fringe-logger-face
     ess-bp-fringe-recover-face
     ess-constant-face
     ess-debug-blink-ref-not-found-face
     ess-debug-blink-same-ref-face
     ess-debug-current-debug-line-face
     ess-function-call-face
     ess-keyword-face
     ess-matrix-face
     ess-modifiers-face
     ess-numbers-face
     ess-operator-face
     ess-paren-face
     ess-r-control-flow-keyword-face
     ess-tracebug-last-input-fringe-face
     ess-watch-current-block-face
     esw/label-face
     esw/selection-face
     eval-sonic-pi-flash
     eval-sonic-pi-flash-error
     evil-ex-commands
     evil-ex-info
     evil-ex-lazy-highlight
     evil-ex-search
     evil-ex-substitute-matches
     evil-ex-substitute-replacement
     evil-goggles--pulse-face
     evil-goggles-change-face
     evil-goggles-commentary-face
     evil-goggles-default-face
     evil-goggles-delete-face
     evil-goggles-fill-and-move-face
     evil-goggles-indent-face
     evil-goggles-join-face
     evil-goggles-nerd-commenter-face
     evil-goggles-paste-face
     evil-goggles-record-macro-face
     evil-goggles-replace-with-register-face
     evil-goggles-set-marker-face
     evil-goggles-shift-face
     evil-goggles-surround-face
     evil-goggles-yank-face
     evil-visual-mark-face
     eww-form-checkbox
     eww-form-file
     eww-form-select
     eww-form-submit
     eww-form-text
     eww-form-textarea
     eww-invalid-certificate
     eww-valid-certificate
     excerpt
     eyebrowse-mode-line-active
     eyebrowse-mode-line-delimiters
     eyebrowse-mode-line-inactive
     eyebrowse-mode-line-separator
     face-explorer-example-blue-background
     face-explorer-example-blue-foreground
     face-explorer-example-distant-foreground
     face-explorer-example-green-foreground
     face-explorer-example-green-yellow
     face-explorer-example-inh-nonexisting
     face-explorer-example-inherit-from-remapped-face
     face-explorer-example-red-blue
     face-explorer-example-red-foreground
     face-explorer-example-red-foreground-remapped
     face-explorer-example-underlined
     faces--test-extend
     faces--test-face3
     faces--test-inherit-extend
     faces--test-inherit-no-extend
     faces--test-no-extend
     faces--test1
     faces--test2
     fb2-reader-cite
     fb2-reader-default
     fb2-reader-header-line
     fb2-reader-info-category
     fb2-reader-info-field
     fb2-reader-link
     fb2-reader-poem
     fb2-reader-splash
     fb2-reader-text-author
     fb2-reader-title
     fedi-post-docs-face
     fedi-post-success-face
     ffap
     fg:erc-color-face0
     fg:erc-color-face1
     fg:erc-color-face10
     fg:erc-color-face11
     fg:erc-color-face12
     fg:erc-color-face13
     fg:erc-color-face14
     fg:erc-color-face15
     fg:erc-color-face2
     fg:erc-color-face3
     fg:erc-color-face4
     fg:erc-color-face5
     fg:erc-color-face6
     fg:erc-color-face7
     fg:erc-color-face8
     fg:erc-color-face9
     file-name-shadow
     fill-column-indicator
     fixed
     fixed-pitch
     fixed-pitch-serif
     flx-highlight-face
     flycheck-delimited-error
     flycheck-error
     flycheck-error-delimiter
     flycheck-error-list-checker-name
     flycheck-error-list-column-number
     flycheck-error-list-error
     flycheck-error-list-error-message
     flycheck-error-list-filename
     flycheck-error-list-highlight
     flycheck-error-list-id
     flycheck-error-list-id-with-explainer
     flycheck-error-list-info
     flycheck-error-list-line-number
     flycheck-error-list-warning
     flycheck-fringe-error
     flycheck-fringe-info
     flycheck-fringe-warning
     flycheck-info
     flycheck-verify-select-checker
     flycheck-warning
     flymake-end-of-line-diagnostics-face
     flymake-eol-information-face
     flymake-error
     flymake-error-echo
     flymake-error-echo-at-eol
     flymake-note
     flymake-note-echo
     flymake-note-echo-at-eol
     flymake-popon
     flymake-popon-posframe-border
     flymake-warning
     flymake-warning-echo
     flymake-warning-echo-at-eol
     flyspell-duplicate
     flyspell-incorrect
     focus-focused
     focus-unfocused
     font-latex-bold-face
     font-latex-doctex-documentation-face
     font-latex-doctex-preprocessor-face
     font-latex-italic-face
     font-latex-math-face
     font-latex-script-char-face
     font-latex-sectioning-0-face
     font-latex-sectioning-1-face
     font-latex-sectioning-2-face
     font-latex-sectioning-3-face
     font-latex-sectioning-4-face
     font-latex-sectioning-5-face
     font-latex-sedate-face
     font-latex-slide-title-face
     font-latex-string-face
     font-latex-subscript-face
     font-latex-superscript-face
     font-latex-underline-face
     font-latex-verbatim-face
     font-latex-warning-face
     font-lock-bracket-face
     font-lock-builtin-face
     font-lock-command-face
     font-lock-comment-delimiter-face
     font-lock-comment-face
     font-lock-constant-face
     font-lock-delimiter-face
     font-lock-doc-face
     font-lock-doc-markup-face
     font-lock-escape-face
     font-lock-function-call-face
     font-lock-function-name-face
     font-lock-interface-def-face
     font-lock-keyword-face
     font-lock-misc-punctuation-face
     font-lock-module-def-face
     font-lock-negation-char-face
     font-lock-number-face
     font-lock-opencl-face
     font-lock-operator-face
     font-lock-preprocessor-face
     font-lock-prompt-face
     font-lock-property-name-face
     font-lock-property-use-face
     font-lock-punctuation-face
     font-lock-regexp-face
     font-lock-regexp-grouping-backslash
     font-lock-regexp-grouping-construct
     font-lock-string-face
     font-lock-type-def-face
     font-lock-type-face
     font-lock-variable-name-face
     font-lock-variable-use-face
     font-lock-warning-face
     font-mediawiki-bold-face
     font-mediawiki-italic-face
     font-mediawiki-math-face
     font-mediawiki-sedate-face
     font-mediawiki-string-face
     font-mediawiki-verbatim-face
     font-mediawiki-warning-face
     font-pov-csg-face
     font-pov-directive-face
     font-pov-keyword-face
     font-pov-macro-name-face
     font-pov-number-face
     font-pov-object-face
     font-pov-operator-face
     font-pov-variable-face
     forge-active-suffix
     forge-dimmed
     forge-issue-completed
     forge-issue-open
     forge-issue-unplanned
     forge-notification-done
     forge-notification-pending
     forge-notification-unread
     forge-post-author
     forge-post-date
     forge-pullreq-merged
     forge-pullreq-open
     forge-pullreq-rejected
     forge-tablist-hl-line
     forge-tablist-topic-label
     forge-topic-header-line
     forge-topic-label
     forge-topic-slug-completed
     forge-topic-slug-open
     forge-topic-slug-saved
     forge-topic-slug-unplanned
     forge-topic-slug-unread
     form-feed-line
     frimacs-boot-keyword
     frimacs-buffer-menu-group-heading
     frimacs-category-name
     frimacs-domain-name
     frimacs-domex-content-face
     frimacs-input-doc-comment
     frimacs-input-keyword
     frimacs-operation-name
     frimacs-package-name
     frimacs-spad-doc-comment
     frimacs-spad-keyword
     fringe
     fsharp-ui-error-face
     fsharp-ui-generic-face
     fsharp-ui-operator-face
     fsharp-ui-warning-face
     geiser-font-lock-autodoc-current-arg
     geiser-font-lock-autodoc-identifier
     geiser-font-lock-doc-button
     geiser-font-lock-doc-link
     geiser-font-lock-doc-title
     geiser-font-lock-error-link
     geiser-font-lock-image-button
     geiser-font-lock-repl-input
     geiser-font-lock-repl-output
     geiser-font-lock-repl-prompt
     geiser-font-lock-xref-header
     geiser-font-lock-xref-link
     ggtags-global-line
     ggtags-highlight
     git-commit-comment-action
     git-commit-comment-branch-local
     git-commit-comment-branch-remote
     git-commit-comment-detached
     git-commit-comment-file
     git-commit-comment-heading
     git-commit-keyword
     git-commit-known-pseudo-header
     git-commit-nonempty-second-line
     git-commit-overlong-summary
     git-commit-pseudo-header
     git-commit-summary
     git-commit-trailer-token
     git-commit-trailer-value
     git-rebase-action
     git-rebase-comment-hash
     git-rebase-comment-heading
     git-rebase-description
     git-rebase-hash
     git-rebase-killed-action
     git-rebase-label
     git-timemachine-commit
     git-timemachine-minibuffer-author-face
     git-timemachine-minibuffer-detail-face
     gitlab--green-face
     gitlab--red-face
     gitlab--title
     gitlab--yellow-face
     gitmerge-skip-face
     glyphless-char
     gnu-apl-default
     gnu-apl-error
     gnu-apl-help
     gnu-apl-kbd-help-screen
     gnu-apl-user-status-text
     gnuplot-gui-button-face
     gnuplot-gui-error-face
     gnuplot-gui-flat-text-face
     gnuplot-gui-labels-face
     gnuplot-gui-menu-face
     gnuplot-prompt-face
     gnus-bookmark-menu-heading
     gnus-button
     gnus-cite-1
     gnus-cite-10
     gnus-cite-11
     gnus-cite-2
     gnus-cite-3
     gnus-cite-4
     gnus-cite-5
     gnus-cite-6
     gnus-cite-7
     gnus-cite-8
     gnus-cite-9
     gnus-cite-attribution
     gnus-emphasis-bold
     gnus-emphasis-bold-italic
     gnus-emphasis-highlight-words
     gnus-emphasis-italic
     gnus-emphasis-strikethru
     gnus-emphasis-underline
     gnus-emphasis-underline-bold
     gnus-emphasis-underline-bold-italic
     gnus-emphasis-underline-italic
     gnus-group-mail-1
     gnus-group-mail-1-empty
     gnus-group-mail-2
     gnus-group-mail-2-empty
     gnus-group-mail-3
     gnus-group-mail-3-empty
     gnus-group-mail-low
     gnus-group-mail-low-empty
     gnus-group-news-1
     gnus-group-news-1-empty
     gnus-group-news-2
     gnus-group-news-2-empty
     gnus-group-news-3
     gnus-group-news-3-empty
     gnus-group-news-4
     gnus-group-news-4-empty
     gnus-group-news-5
     gnus-group-news-5-empty
     gnus-group-news-6
     gnus-group-news-6-empty
     gnus-group-news-low
     gnus-group-news-low-empty
     gnus-header
     gnus-header-content
     gnus-header-from
     gnus-header-name
     gnus-header-newsgroups
     gnus-header-subject
     gnus-server-agent
     gnus-server-closed
     gnus-server-cloud
     gnus-server-cloud-host
     gnus-server-denied
     gnus-server-offline
     gnus-server-opened
     gnus-signature
     gnus-splash
     gnus-summary-cancelled
     gnus-summary-high-ancient
     gnus-summary-high-read
     gnus-summary-high-ticked
     gnus-summary-high-undownloaded
     gnus-summary-high-unread
     gnus-summary-low-ancient
     gnus-summary-low-read
     gnus-summary-low-ticked
     gnus-summary-low-undownloaded
     gnus-summary-low-unread
     gnus-summary-normal-ancient
     gnus-summary-normal-read
     gnus-summary-normal-ticked
     gnus-summary-normal-undownloaded
     gnus-summary-normal-unread
     gnus-summary-selected
     gnus-x-face
     go-coverage-0
     go-coverage-1
     go-coverage-10
     go-coverage-2
     go-coverage-3
     go-coverage-4
     go-coverage-5
     go-coverage-6
     go-coverage-7
     go-coverage-8
     go-coverage-9
     go-coverage-covered
     go-coverage-untracked
     go-dot-mod-module-name
     go-dot-mod-module-semver
     go-dot-mod-module-version
     go-guru-hl-identifier-face
     gomoku-O
     gomoku-X
     google-translate-listen-button-face
     google-translate-phonetic-face
     google-translate-suggestion-face
     google-translate-suggestion-label-face
     google-translate-text-face
     google-translate-translation-face
     grep-heading
     groovy-annotation-face
     gud-highlight-current-line-face
     guix-build-log-phase-end
     guix-build-log-phase-fail
     guix-build-log-phase-name
     guix-build-log-phase-seconds
     guix-build-log-phase-start
     guix-build-log-phase-success
     guix-build-log-title-end
     guix-build-log-title-fail
     guix-build-log-title-head
     guix-build-log-title-start
     guix-build-log-title-success
     guix-derivation-drv-file-name
     guix-derivation-file-name
     guix-devel-gexp-symbol
     guix-devel-modify-phases-keyword
     guix-false
     guix-generation-info-current
     guix-generation-info-heading
     guix-generation-info-not-current
     guix-help-heading
     guix-help-key
     guix-location
     guix-operation-option-key
     guix-package-info-description
     guix-package-info-future
     guix-package-info-heading
     guix-package-info-hidden
     guix-package-info-inputs
     guix-package-info-installed-outputs
     guix-package-info-license
     guix-package-info-name
     guix-package-info-name-button
     guix-package-info-native-inputs
     guix-package-info-obsolete
     guix-package-info-propagated-inputs
     guix-package-info-source
     guix-package-info-superseded
     guix-package-info-synopsis
     guix-package-info-uninstalled-outputs
     guix-package-info-unknown
     guix-package-info-version
     guix-package-list-future
     guix-package-list-hidden
     guix-package-list-installed
     guix-package-list-obsolete
     guix-package-list-superseded
     guix-package-list-unknown
     guix-profile-info-current
     guix-profile-info-not-current
     guix-service-info-description
     guix-service-info-extension
     guix-service-info-heading
     guix-store-item-invalid
     guix-true
     h/column-header
     h/dimmed
     h/directory
     h/domain
     h/file-name
     h/header
     h/header-arrow
     h/history-existent
     h/history-nonexistent
     h/history-range
     h/history-unknown
     h/nickname
     h/petname
     h/public-key
     h/seed
     h/selected-column-header
     h/size
     h/timestamp
     haskell-c2hs-hook-name-face
     haskell-c2hs-hook-pair-face
     haskell-constructor-face
     haskell-debug-heading-face
     haskell-debug-keybinding-face
     haskell-debug-muted-face
     haskell-debug-newline-face
     haskell-debug-trace-number-face
     haskell-debug-warning-face
     haskell-definition-face
     haskell-error-face
     haskell-hole-face
     haskell-interactive-face-compile-error
     haskell-interactive-face-compile-warning
     haskell-interactive-face-garbage
     haskell-interactive-face-prompt
     haskell-interactive-face-prompt-cont
     haskell-interactive-face-result
     haskell-keyword-face
     haskell-liquid-haskell-annotation-face
     haskell-literate-comment-face
     haskell-operator-face
     haskell-pragma-face
     haskell-quasi-quote-face
     haskell-tng-conid-face
     haskell-tng-keyword-face
     haskell-tng-module-face
     haskell-tng-type-face
     haskell-type-face
     haskell-warning-face
     header-line
     header-line-highlight
     helm-action
     helm-ag-edit-deleted-line
     helm-bookmark-addressbook
     helm-bookmark-directory
     helm-bookmark-file
     helm-bookmark-file-not-found
     helm-bookmark-gnus
     helm-bookmark-info
     helm-bookmark-man
     helm-bookmark-w3m
     helm-buffer-archive
     helm-buffer-directory
     helm-buffer-file
     helm-buffer-modified
     helm-buffer-not-saved
     helm-buffer-process
     helm-buffer-saved-out
     helm-buffer-size
     helm-candidate-number
     helm-candidate-number-suspended
     helm-comint-prompts-buffer-name
     helm-comint-prompts-promptidx
     helm-command-active-mode
     helm-completion-invalid
     helm-completions-annotations
     helm-completions-detailed
     helm-delete-async-message
     helm-eob-line
     helm-eshell-prompts-buffer-name
     helm-eshell-prompts-promptidx
     helm-etags-file
     helm-fd-finish
     helm-ff-backup-file
     helm-ff-denied
     helm-ff-directory
     helm-ff-dirs
     helm-ff-dotted-directory
     helm-ff-dotted-symlink-directory
     helm-ff-executable
     helm-ff-file
     helm-ff-file-extension
     helm-ff-invalid-symlink
     helm-ff-nofile
     helm-ff-pipe
     helm-ff-prefix
     helm-ff-rsync-progress
     helm-ff-rsync-progress-1
     helm-ff-rsync-progress-2
     helm-ff-rsync-progress-3
     helm-ff-socket
     helm-ff-suid
     helm-ff-symlink
     helm-ff-truename
     helm-grep-cmd-line
     helm-grep-file
     helm-grep-finish
     helm-grep-lineno
     helm-grep-match
     helm-header
     helm-header-line-left-margin
     helm-helper
     helm-history-deleted
     helm-history-remote
     helm-lisp-completion-info
     helm-lisp-show-completion
     helm-locate-finish
     helm-M-x-key
     helm-M-x-short-doc
     helm-mark-prefix
     helm-match
     helm-match-item
     helm-minibuffer-prompt
     helm-moccur-buffer
     helm-mode-prefix
     helm-mu-contacts-address-face
     helm-mu-contacts-name-face
     helm-no-file-buffer-modified
     helm-non-file-buffer
     helm-prefarg
     helm-resume-need-update
     helm-rg-active-arg-face
     helm-rg-base-rg-cmd-face
     helm-rg-colon-separator-ripgrep-output-face
     helm-rg-directory-cmd-face
     helm-rg-directory-header-face
     helm-rg-error-message
     helm-rg-extra-arg-face
     helm-rg-file-match-face
     helm-rg-inactive-arg-face
     helm-rg-line-number-match-face
     helm-rg-match-text-face
     helm-rg-preview-line-highlight
     helm-rg-title-face
     helm-selection
     helm-selection-line
     helm-separator
     helm-source-header
     helm-time-zone-current
     helm-time-zone-home
     helm-top-columns
     helm-ucs-char
     helm-visible-mark
     help-argument-name
     help-for-help-header
     help-key-binding
     helpful-heading
     hexl-address-region
     hexl-ascii-region
     hi-aquamarine
     hi-black-b
     hi-black-hb
     hi-blue
     hi-blue-b
     hi-green
     hi-green-b
     hi-pink
     hi-red-b
     hi-salmon
     hi-yellow
     hide-ifdef-shadow
     highlight
     highlight-changes
     highlight-changes-delete
     highlight-indentation-current-column-face
     highlight-indentation-face
     highlight-parentheses-highlight
     hl-column
     hl-line
     hl-todo
     hlt-property-highlight
     hlt-regexp-level-1
     hlt-regexp-level-2
     hlt-regexp-level-3
     hlt-regexp-level-4
     hlt-regexp-level-5
     hlt-regexp-level-6
     hlt-regexp-level-7
     hlt-regexp-level-8
     holiday
     homoglyph
     hydra-face-amaranth
     hydra-face-blue
     hydra-face-pink
     hydra-face-red
     hydra-face-teal
     ibuffer-locked-buffer
     icomplete-first-match
     icomplete-section
     icomplete-selected-match
     icon
     icon-button
     idle-highlight
     idlwave-help-link
     idlwave-shell-bp
     idlwave-shell-disabled-bp
     idlwave-shell-electric-stop-line
     idlwave-shell-pending-electric-stop
     idlwave-shell-pending-stop
     ido-first-match
     ido-incomplete-regexp
     ido-indicator
     ido-only-match
     ido-subdir
     ido-virtual
     idris-active-term-face
     idris-antiquotation-face
     idris-char-face
     idris-colon-face
     idris-definition-face
     idris-directive-argument-face
     idris-directive-face
     idris-equals-face
     idris-hole-face
     idris-identifier-face
     idris-info-title-face
     idris-inline-doc-face
     idris-ipkg-keyword-face
     idris-ipkg-package-name-face
     idris-keyword-face
     idris-link-face
     idris-loaded-region-face
     idris-log-level-1-face
     idris-log-level-2-face
     idris-log-level-3-face
     idris-log-level-4-face
     idris-log-level-5-face
     idris-log-level-face
     idris-log-level-higher-face
     idris-log-timestamp-face
     idris-module-face
     idris-operator-face
     idris-parameter-face
     idris-prover-processed-face
     idris-prover-processing-face
     idris-quasiquotation-face
     idris-repl-input-face
     idris-repl-output-face
     idris-repl-prompt-face
     idris-repl-result-face
     idris-semantic-bound-face
     idris-semantic-data-face
     idris-semantic-function-face
     idris-semantic-implicit-face
     idris-semantic-module-face
     idris-semantic-namespace-face
     idris-semantic-postulate-face
     idris-semantic-type-face
     idris-unsafe-face
     idris-warning-face
     iedit-occurrence
     iedit-read-only-occurrence
     image-dired-thumb-flagged
     image-dired-thumb-header-directory-name
     image-dired-thumb-header-file-name
     image-dired-thumb-header-file-size
     image-dired-thumb-header-image-count
     image-dired-thumb-mark
     imenu-list-entry-face
     imenu-list-entry-face-0
     imenu-list-entry-face-1
     imenu-list-entry-face-2
     imenu-list-entry-face-3
     imenu-list-entry-subalist-face-0
     imenu-list-entry-subalist-face-1
     imenu-list-entry-subalist-face-2
     imenu-list-entry-subalist-face-3
     important-elfeed-entry
     inactive-hole-face
     inf-ruby-result-overlay-face
     info-header-node
     info-header-xref
     info-index-match
     info-menu-header
     info-menu-star
     info-node
     Info-quoted
     info-title-1
     info-title-2
     info-title-3
     info-title-4
     info-xref
     info-xref-visited
     internal-border
     isearch
     isearch-fail
     isearch-group-1
     isearch-group-2
     iswitchb-current-match
     iswitchb-invalid-regexp
     iswitchb-single-match
     iswitchb-virtual-matches
     italic
     ivy-action
     ivy-completions-annotations
     ivy-confirm-face
     ivy-current-match
     ivy-cursor
     ivy-explorer-separator
     ivy-gitlab--title
     ivy-grep-info
     ivy-grep-line-number
     ivy-highlight-face
     ivy-hoogle-candidate-face
     ivy-hoogle-candidate-source-face
     ivy-hoogle-doc-code-background-face
     ivy-hoogle-doc-code-face
     ivy-hoogle-doc-xref-link-face
     ivy-match-required-face
     ivy-minibuffer-match-face-1
     ivy-minibuffer-match-face-2
     ivy-minibuffer-match-face-3
     ivy-minibuffer-match-face-4
     ivy-minibuffer-match-highlight
     ivy-modified-buffer
     ivy-modified-outside-buffer
     ivy-omni-org-bookmark-name
     ivy-omni-org-buffer-file-name
     ivy-omni-org-buffer-name
     ivy-omni-org-custom-agenda-desc
     ivy-omni-org-custom-agenda-key
     ivy-omni-org-file-name
     ivy-org
     ivy-posframe
     ivy-posframe-border
     ivy-posframe-cursor
     ivy-prompt-match
     ivy-remote
     ivy-separator
     ivy-subdir
     ivy-virtual
     ivy-yanked-word
     ivy-yasnippet-key
     ivy-yasnippet-key-matching
     iwindow-highlight-default
     iwindow-highlight-fringe
     iwindow-highlight-mode-line
     iwindow-minibuffer-keys-face
     izonmoji-mac-face
     izonmoji-win-face
     j-adverb-face
     j-conjunction-face
     j-other-face
     j-verb-face
     jabber-activity-face
     jabber-activity-personal-face
     jabber-chat-error
     jabber-chat-prompt-foreign
     jabber-chat-prompt-local
     jabber-chat-prompt-system
     jabber-chat-text-foreign
     jabber-chat-text-local
     jabber-muc-presence-dim
     jabber-rare-time-face
     jabber-roster-user-away
     jabber-roster-user-chatty
     jabber-roster-user-dnd
     jabber-roster-user-error
     jabber-roster-user-offline
     jabber-roster-user-online
     jabber-roster-user-xa
     jabber-title-large
     jabber-title-medium
     jabber-title-small
     japanese-holiday-saturday
     jdee-font-lock-api-face
     jdee-font-lock-bold-face
     jdee-font-lock-code-face
     jdee-font-lock-constant-face
     jdee-font-lock-constructor-face
     jdee-font-lock-doc-tag-face
     jdee-font-lock-italic-face
     jdee-font-lock-javadoc-face
     jdee-font-lock-link-face
     jdee-font-lock-modifier-face
     jdee-font-lock-number-face
     jdee-font-lock-operator-face
     jdee-font-lock-package-face
     jdee-font-lock-pre-face
     jdee-font-lock-private-face
     jdee-font-lock-protected-face
     jdee-font-lock-public-face
     jdee-font-lock-underline-face
     jdee-java-properties-font-lock-backslash-face
     jdee-java-properties-font-lock-class-name-face
     jdee-java-properties-font-lock-comment-face
     jdee-java-properties-font-lock-equal-face
     jdee-java-properties-font-lock-key-face
     jdee-java-properties-font-lock-substitution-face
     jdee-java-properties-font-lock-value-face
     jedi-direx:class
     jedi-direx:method
     jedi:highlight-function-argument
     jemdoc-mode-face-bold
     jemdoc-mode-face-bullet
     jemdoc-mode-face-bullet-warning
     jemdoc-mode-face-dashes-2
     jemdoc-mode-face-dashes-3
     jemdoc-mode-face-ellipsis
     jemdoc-mode-face-equation
     jemdoc-mode-face-html-text
     jemdoc-mode-face-http-mail
     jemdoc-mode-face-italics
     jemdoc-mode-face-monospace
     jemdoc-mode-face-monospace-html
     jemdoc-mode-face-other
     jemdoc-mode-face-special-keywords
     jemdoc-mode-face-special-keywords-name
     jemdoc-mode-face-tilde-block-delimiters
     jemdoc-mode-face-title-1
     jemdoc-mode-face-title-2
     jemdoc-mode-face-title-3
     jemdoc-mode-face-title-4
     jg-quicknav-directory-face
     jg-quicknav-file-face
     jg-quicknav-selected-directory-face
     jg-quicknav-selected-file-face
     jinx-annotation
     jinx-highlight
     jinx-key
     jinx-misspelled
     jinx-save
     jira-markup-blockquote-face
     jira-markup-bold-face
     jira-markup-header-face
     jira-markup-header-face-1
     jira-markup-header-face-2
     jira-markup-header-face-3
     jira-markup-header-face-4
     jira-markup-header-face-5
     jira-markup-header-face-6
     jira-markup-inline-code-face
     jira-markup-italic-face
     jira-markup-link-face
     jira-markup-link-title-face
     jira-markup-list-face
     jira-markup-missing-link-face
     jira-markup-pre-face
     jira-markup-reference-face
     jira-markup-url-face
     jiralib-comment-face
     jiralib-comment-header-face
     jiralib-issue-info-face
     jiralib-issue-info-header-face
     jiralib-issue-summary-face
     jiralib-link-filter-face
     jiralib-link-issue-face
     jiralib-link-project-face
     jirascope-diff-alert
     jirascope-diff-new
     jirascope-diff-old
     jirascope-issue-key
     jirascope-project-key
     jmt-angle-bracket
     jmt-annotation-delimiter
     jmt-annotation-mark
     jmt-annotation-package-name
     jmt-annotation-qualifier
     jmt-annotation-string
     jmt-annotation-string-delimiter
     jmt-block-tag-name
     jmt-block-tag-parameter
     jmt-boilerplate-keyword
     jmt-bracket
     jmt-curly-bracket
     jmt-delimiter
     jmt-expression-keyword
     jmt-HTML-end-tag-name
     jmt-HTML-start-tag-name
     jmt-HTML-tag-name
     jmt-inline-rendered-parameter
     jmt-inline-tag-name
     jmt-inline-tag-parameter
     jmt-Javadoc-outer-delimiter
     jmt-Javadoc-tag
     jmt-Javadoc-tag-delimiter
     jmt-Javadoc-tag-mark
     jmt-Javadoc-tag-name
     jmt-named-literal
     jmt-package-name
     jmt-package-name-declared
     jmt-param-tag-parameter
     jmt-principal-keyword
     jmt-qualifier-keyword
     jmt-round-bracket
     jmt-separator
     jmt-shebang
     jmt-shebang-body
     jmt-shebang-comment
     jmt-shebang-comment-delimiter
     jmt-square-bracket
     jmt-string-delimiter
     jmt-throws-tag-parameter
     jmt-type-declaration
     jmt-type-reference
     jmt-type-variable-declaration
     jmt-type-variable-tag-parameter
     jmt-value-tag-name
     jonprl-comment-face
     jonprl-keyword-face
     jonprl-name-face
     jonprl-operator-face
     jonprl-tactic-face
     journalctl-error-face
     journalctl-finished-face
     journalctl-host-face
     journalctl-process-face
     journalctl-starting-face
     journalctl-timestamp-face
     journalctl-warning-face
     jquery-doc-argument
     jquery-doc-header
     js2-error
     js2-external-variable
     js2-function-call
     js2-function-param
     js2-highlight-vars-face
     js2-highlight-vars-second-face
     js2-instance-member
     js2-jsdoc-html-tag-delimiter
     js2-jsdoc-html-tag-name
     js2-jsdoc-tag
     js2-jsdoc-type
     js2-jsdoc-value
     js2-object-property
     js2-object-property-access
     js2-private-function-call
     js2-private-member
     js2-warning
     js3-error-face
     js3-external-variable-face
     js3-function-param-face
     js3-instance-member-face
     js3-jsdoc-html-tag-delimiter-face
     js3-jsdoc-html-tag-name-face
     js3-jsdoc-tag-face
     js3-jsdoc-type-face
     js3-jsdoc-value-face
     js3-magic-paren-face
     js3-private-function-call-face
     js3-private-member-face
     js3-warning-face
     json-par-ancestor-face
     json-par-ancestor-out-of-window-face
     json-par-current-member-face
     jss-button-face
     jss-console-debug-message
     jss-console-error-message
     jss-console-log-message
     jss-console-warn-message
     jss-http-repl-meta-data-face
     jss-http-repl-submitted-face
     jss-script-line-marker-face
     jss-whitespace-mark-face
     jtags-final-member-face
     jtags-final-static-member-face
     jtags-inherited-final-member-face
     jtags-inherited-final-static-member-face
     jtags-inherited-member-face
     jtags-inherited-static-member-face
     jtags-member-face
     jtags-static-member-face
     jtl-highlight-line-face
     julia-macro-face
     julia-quoted-symbol-face
     julia-ts-interpolation-expression-face
     julia-ts-macro-face
     julia-ts-quoted-symbol-face
     julia-ts-string-interpolation-face
     jump-tree-visualizer-active-branch-face
     jump-tree-visualizer-current-face
     jump-tree-visualizer-default-face
     jump-tree-visualizer-register-face
     jupyter-eval-overlay
     jupyter-repl-input-prompt
     jupyter-repl-output-prompt
     jupyter-repl-traceback
     kaesar-mode-lighter-face
     kagi-bold
     kagi-code
     kagi-italic
     kana-answer-face
     kana-question-face
     kana-romaji-face
     kaocha-runner-error-face
     kaocha-runner-success-face
     kaocha-runner-warning-face
     kaolin-themes-boolean
     kele-disabled-face
     key-leap-active
     key-leap-inactive
     key-quiz-answer
     key-quiz-correct
     key-quiz-partial
     key-quiz-question
     key-quiz-wrong
     keycast-command
     keycast-key
     kite-attribute-colon-face
     kite-attribute-local-name-face
     kite-attribute-prefix-face
     kite-attribute-value-delimiter-face
     kite-attribute-value-face
     kite-boolean
     kite-cdata-section-CDATA-face
     kite-cdata-section-content-face
     kite-cdata-section-delimiter-face
     kite-char-ref-delimiter-face
     kite-char-ref-number-face
     kite-comment-content-face
     kite-comment-delimiter-face
     kite-console-prompt-face
     kite-css-computed-proprietary-unused-property
     kite-css-computed-unused-property
     kite-css-property
     kite-css-proprietary-property
     kite-css-selected-overlay
     kite-css-selector
     kite-css-value-widget-error
     kite-css-value-widget-modified
     kite-delimited-data-face
     kite-delimiter-face
     kite-element-colon-face
     kite-element-local-name-face
     kite-element-prefix-face
     kite-entity-ref-delimiter-face
     kite-entity-ref-name-face
     kite-hash-face
     kite-link-face
     kite-loading
     kite-log-debug
     kite-log-error
     kite-log-log
     kite-log-warning
     kite-markup-declaration-delimiter-face
     kite-mini-log-debug
     kite-mini-log-error
     kite-mini-log-log
     kite-mini-log-warning
     kite-modified-attribute-local-name-face
     kite-modified-attribute-value-face
     kite-modified-element-local-name-face
     kite-name-face
     kite-namespace-attribute-colon-face
     kite-namespace-attribute-prefix-face
     kite-namespace-attribute-value-delimiter-face
     kite-namespace-attribute-value-face
     kite-namespace-attribute-xmlns-face
     kite-node-highlight-face
     kite-null
     kite-number
     kite-object
     kite-processing-instruction-content-face
     kite-processing-instruction-delimiter-face
     kite-processing-instruction-target-face
     kite-prolog-keyword-face
     kite-prolog-literal-content-face
     kite-prolog-literal-delimiter-face
     kite-property-name
     kite-proto-property-name
     kite-quote
     kite-ref-face
     kite-session-closed
     kite-stack-column-number
     kite-stack-error-message
     kite-stack-error-type
     kite-stack-file-name
     kite-stack-function-name
     kite-stack-line-number
     kite-stack-pseudo-file-name
     kite-string
     kite-table-head
     kite-tag-delimiter-face
     kite-tag-slash-face
     kite-text-face
     kite-undefined
     kivy-tab-face
     klondike-heart-diamond-color
     klondike-stack-numbering
     klondike-stack-selecting
     kmacro-x-mc-cursor-face
     kmacro-x-mc-legacy-highlight-face
     kmacro-x-mc-main-cursor-face
     kpm-list-buffer-face
     kpm-list-buffer-highlight-face
     kpm-list-directory-face
     kpm-list-header-face
     kpm-list-mode-face
     kpm-list-modified-face
     kpm-list-old-path-face
     ksp-cfg-constant-face
     ksp-cfg-filter-face
     ksp-cfg-key-face
     ksp-cfg-name-face
     ksp-cfg-node-face
     ksp-cfg-number-face
     ksp-cfg-operator-face
     kubel-status-active
     kubel-status-completed
     kubel-status-crash-loop-backoff
     kubel-status-disk-pressure
     kubel-status-error
     kubel-status-evicted
     kubel-status-healthy
     kubel-status-memory-pressure
     kubel-status-network-unavailable
     kubel-status-pid-pressure
     kubel-status-ready
     kubel-status-revision-failed
     kubel-status-revision-missing
     kubel-status-running
     kubel-status-terminating
     kubel-status-true
     kubel-status-unknown
     kubernetes-context-name
     kubernetes-delete-mark
     kubernetes-dimmed
     kubernetes-json-key
     kubernetes-namespace
     kubernetes-pending-deletion
     kubernetes-progress-indicator
     kubernetes-selector
     lambdapi-proof-error-face
     lambdapi-proof-face
     landmark-font-lock-face-O
     landmark-font-lock-face-X
     langtool-correction-face
     langtool-errline
     languagetool-issue-default
     languagetool-issue-grammar
     languagetool-issue-misspelling
     languagetool-issue-style
     latex-math-preview-candidate-for-insertion-face
     latex-math-preview-key-for-insertion-face
     latex-table-wizard-background
     latex-table-wizard-highlight
     latexdiff-author-face
     latexdiff-date-face
     latexdiff-message-face
     latexdiff-ref-labels-face
     launchctl-name-face
     lazy-highlight
     ld-script-location-counter
     leaf-manager-header-line
     lean-message-boxes-content-face
     lean-server-task-face
     lean-server-task-fringe-face
     learn-ocaml-group-title-face
     learn-ocaml-header-hint-face
     ledger-font-account-directive-face
     ledger-font-account-name-face
     ledger-font-alias-definition-face
     ledger-font-alias-directive-face
     ledger-font-apply-account-face
     ledger-font-apply-directive-face
     ledger-font-apply-tag-face
     ledger-font-assert-condition-face
     ledger-font-assert-directive-face
     ledger-font-auto-xact-face
     ledger-font-bucket-account-face
     ledger-font-bucket-directive-face
     ledger-font-C-amount-face
     ledger-font-C-directive-face
     ledger-font-capture-account-face
     ledger-font-capture-directive-face
     ledger-font-capture-regex-face
     ledger-font-check-condition-face
     ledger-font-check-directive-face
     ledger-font-code-face
     ledger-font-comment-face
     ledger-font-commodity-directive-face
     ledger-font-commodity-format-face
     ledger-font-commodity-name-face
     ledger-font-condition-face
     ledger-font-D-directive-face
     ledger-font-default-directive-face
     ledger-font-define-body-face
     ledger-font-define-directive-face
     ledger-font-define-name-face
     ledger-font-directive-face
     ledger-font-end-directive-face
     ledger-font-expr-directive-face
     ledger-font-expr-expression-face
     ledger-font-fixed-commodity-face
     ledger-font-fixed-directive-face
     ledger-font-fixed-price-face
     ledger-font-format-directive-face
     ledger-font-include-directive-face
     ledger-font-include-filename-face
     ledger-font-N-directive-face
     ledger-font-N-symbol-face
     ledger-font-note-directive-face
     ledger-font-note-text-face
     ledger-font-other-face
     ledger-font-payee-cleared-face
     ledger-font-payee-directive-face
     ledger-font-payee-name-face
     ledger-font-payee-pending-face
     ledger-font-payee-regex-face
     ledger-font-payee-uncleared-face
     ledger-font-pending-face
     ledger-font-periodic-xact-face
     ledger-font-posting-account-cleared-face
     ledger-font-posting-account-face
     ledger-font-posting-account-pending-face
     ledger-font-posting-amount-cleared-face
     ledger-font-posting-amount-face
     ledger-font-posting-amount-pending-face
     ledger-font-posting-date-face
     ledger-font-price-date-face
     ledger-font-price-directive-face
     ledger-font-price-face
     ledger-font-price-symbol-face
     ledger-font-reconciler-cleared-face
     ledger-font-reconciler-pending-face
     ledger-font-reconciler-uncleared-face
     ledger-font-report-clickable-face
     ledger-font-tag-directive-face
     ledger-font-tag-name-face
     ledger-font-timeclock-directive-face
     ledger-font-uuid-directive-face
     ledger-font-uuid-face
     ledger-font-xact-cleared-face
     ledger-font-xact-highlight-face
     ledger-font-xact-pending-face
     ledger-font-year-directive-face
     ledger-font-year-face
     ledger-occur-narrowed-face
     ledger-occur-xact-face
     ledger-reconcile-last-balance-equals-target-face
     leerzeichen
     leetcode-accepted-face
     leetcode-checkmark-face
     leetcode-easy-face
     leetcode-error-face
     leetcode-hard-face
     leetcode-medium-face
     leetcode-paid-face
     lem-post-community-face
     lem-post-title-face
     lem-ui-community-face
     lem-ui-user-face
     lem-ui-widget-face
     leo-auxiliary-face
     leo-case-and-variant-marker-face
     leo-heading-face
     leo-link-face
     leo-match-face
     leo-search-and-forum-face
     letterbox-face
     line-number
     line-number-current-line
     line-number-major-tick
     line-number-minor-tick
     line-reminder-modified-sign-face
     line-reminder-saved-sign-face
     line-reminder-thumb-modified-sign-face
     line-reminder-thumb-saved-sign-face
     linemark-caution-face
     linemark-funny-face
     linemark-go-face
     linemark-stop-face
     lingr-nickname-face
     lingr-presence-event-face
     lingr-status-room-face
     lingr-status-unread-face
     lingr-timestamp-face
     link
     link-visited
     linum
     linum-relative-current-face
     lisp-extra-font-lock-backquote
     lisp-extra-font-lock-quoted
     lisp-extra-font-lock-quoted-function
     lisp-extra-font-lock-special-variable-name
     lispy-command-name-face
     lispy-cursor-face
     lispy-face-hint
     lispy-face-key-nosel
     lispy-face-key-sel
     lispy-face-opt-nosel
     lispy-face-opt-sel
     lispy-face-req-nosel
     lispy-face-req-sel
     lispy-face-rst-nosel
     lispy-face-rst-sel
     lispy-test-face
     lispyville-special-face
     listing-codesearch-filename
     listing-codesearch-line-number
     litable-result-face
     litable-substitution-face
     literate-calc-mode-identifier-face
     literate-calc-mode-result-face
     live-code-talks-button-face
     live-code-talks-comment-face
     live-code-talks-subsubtitle-face
     live-code-talks-subtitle-face
     live-code-talks-title-face
     livescript-font-lock-bold-face
     livescript-font-lock-shadow-face
     llama-cpp-chat-input-prefix-face
     llama-cpp-chat-input-suffix-face
     llama-cpp-chat-prompt-face
     llama-deleted-argument
     llama-macro
     llama-mandatory-argument
     llama-optional-argument
     llvm-ts-mode-metadata-ref-face
     llvm-ts-mode-metadata-ref-use-face
     lms-album-face
     lms-artist-face
     lms-duration-face
     lms-players-ip-face
     lms-players-isplaying-face
     lms-players-model-face
     lms-players-name-face
     lms-players-playerid-face
     lms-players-power-face
     lms-players-selected-face
     lms-playing-face
     lms-title-face
     lms-tracknum-face
     lms-year-face
     loccur-face
     log-edit-header
     log-edit-headers-separator
     log-edit-summary
     log-edit-unknown-header
     log-view-commit-body
     log-view-file
     log-view-message
     log4j-font-lock-config-face
     log4j-font-lock-debug-face
     log4j-font-lock-error-face
     log4j-font-lock-fatal-face
     log4j-font-lock-info-face
     log4j-font-lock-warn-face
     lognav-highlight-face
     logview-debug-entry
     logview-edit-filters-type-prefix
     logview-error-entry
     logview-highlight
     logview-information-entry
     logview-level-debug
     logview-level-error
     logview-level-information
     logview-level-trace
     logview-level-warning
     logview-name
     logview-pulse
     logview-section
     logview-thread
     logview-timestamp
     logview-trace-entry
     logview-unprocessed
     logview-warning-entry
     loophole-editing
     loophole-suspending
     loophole-using
     lpe:dot-apply-indicator-face
     lpe:filter-face
     lpe:filter-indicator-face
     lpe:hidden-fringe-face
     lpe:star-fringe-face
     lpe:tags-face
     lpe:tags-indicator-face
     lsp-dart-code-lens-separator
     lsp-dart-test-tree-error-face
     lsp-dart-test-tree-failed-face
     lsp-dart-test-tree-passed-face
     lsp-dart-test-tree-running-face
     lsp-dart-test-tree-skipped-face
     lsp-dart-test-tree-time-face
     lsp-dart-test-tree-waiting-face
     lsp-details-face
     lsp-dired-path-error-face
     lsp-dired-path-face
     lsp-dired-path-hint-face
     lsp-dired-path-info-face
     lsp-dired-path-warning-face
     lsp-erlang-elp-bound-modifier-face
     lsp-erlang-elp-deprecated-function-modifier-face
     lsp-erlang-elp-exported-function-modifier-face
     lsp-face-highlight-read
     lsp-face-highlight-textual
     lsp-face-highlight-write
     lsp-face-rename
     lsp-face-semhl-class
     lsp-face-semhl-comment
     lsp-face-semhl-constant
     lsp-face-semhl-default-library
     lsp-face-semhl-definition
     lsp-face-semhl-deprecated
     lsp-face-semhl-enum
     lsp-face-semhl-event
     lsp-face-semhl-function
     lsp-face-semhl-implementation
     lsp-face-semhl-interface
     lsp-face-semhl-keyword
     lsp-face-semhl-label
     lsp-face-semhl-macro
     lsp-face-semhl-member
     lsp-face-semhl-method
     lsp-face-semhl-namespace
     lsp-face-semhl-number
     lsp-face-semhl-operator
     lsp-face-semhl-parameter
     lsp-face-semhl-property
     lsp-face-semhl-regexp
     lsp-face-semhl-static
     lsp-face-semhl-string
     lsp-face-semhl-struct
     lsp-face-semhl-type
     lsp-face-semhl-type-parameter
     lsp-face-semhl-variable
     lsp-headerline-breadcrumb-deprecated-face
     lsp-headerline-breadcrumb-path-error-face
     lsp-headerline-breadcrumb-path-face
     lsp-headerline-breadcrumb-path-hint-face
     lsp-headerline-breadcrumb-path-info-face
     lsp-headerline-breadcrumb-path-warning-face
     lsp-headerline-breadcrumb-project-prefix-face
     lsp-headerline-breadcrumb-separator-face
     lsp-headerline-breadcrumb-symbols-error-face
     lsp-headerline-breadcrumb-symbols-face
     lsp-headerline-breadcrumb-symbols-hint-face
     lsp-headerline-breadcrumb-symbols-info-face
     lsp-headerline-breadcrumb-symbols-warning-face
     lsp-headerline-breadcrumb-unknown-project-prefix-face
     lsp-inlay-hint-face
     lsp-inlay-hint-parameter-face
     lsp-inlay-hint-type-face
     lsp-installation-buffer-face
     lsp-installation-finished-buffer-face
     lsp-intellij-face-code-lens-run
     lsp-intellij-face-code-lens-test
     lsp-intellij-face-code-lens-test-fail
     lsp-intellij-face-code-lens-test-pass
     lsp-intellij-face-code-lens-test-unknown
     lsp-java-progress-face
     lsp-jt-error-face
     lsp-jt-in-progress-face
     lsp-jt-success-face
     lsp-lens-face
     lsp-lens-mouse-face
     lsp-metals-face-overlay
     lsp-modeline-code-actions-face
     lsp-modeline-code-actions-preferred-face
     lsp-rename-placeholder-face
     lsp-rust-analyzer-abstract-modifier-face
     lsp-rust-analyzer-async-modifier-face
     lsp-rust-analyzer-attribute-modifier-face
     lsp-rust-analyzer-callable-modifier-face
     lsp-rust-analyzer-constant-modifier-face
     lsp-rust-analyzer-consuming-modifier-face
     lsp-rust-analyzer-control-flow-modifier-face
     lsp-rust-analyzer-crate-root-modifier-face
     lsp-rust-analyzer-declaration-modifier-face
     lsp-rust-analyzer-default-library-modifier-face
     lsp-rust-analyzer-definition-modifier-face
     lsp-rust-analyzer-deprecated-modifier-face
     lsp-rust-analyzer-documentation-modifier-face
     lsp-rust-analyzer-injected-modifier-face
     lsp-rust-analyzer-intra-doc-link-modifier-face
     lsp-rust-analyzer-library-modifier-face
     lsp-rust-analyzer-mutable-modifier-face
     lsp-rust-analyzer-public-modifier-face
     lsp-rust-analyzer-readonly-modifier-face
     lsp-rust-analyzer-reference-modifier-face
     lsp-rust-analyzer-static-modifier-face
     lsp-rust-analyzer-trait-modifier-face
     lsp-rust-analyzer-unsafe-modifier-face
     lsp-signature-face
     lsp-signature-posframe
     lsp-treemacs-file-error
     lsp-treemacs-file-hint
     lsp-treemacs-file-info
     lsp-treemacs-file-warn
     lsp-treemacs-project-root-error
     lsp-treemacs-project-root-info
     lsp-treemacs-project-root-warn
     lsp-ui-doc-background
     lsp-ui-doc-header
     lsp-ui-doc-highlight-hover
     lsp-ui-doc-url
     lsp-ui-peek-filename
     lsp-ui-peek-footer
     lsp-ui-peek-header
     lsp-ui-peek-highlight
     lsp-ui-peek-line-number
     lsp-ui-peek-list
     lsp-ui-peek-peek
     lsp-ui-peek-selection
     lsp-ui-sideline-code-action
     lsp-ui-sideline-current-symbol
     lsp-ui-sideline-global
     lsp-ui-sideline-symbol
     lsp-ui-sideline-symbol-info
     lui-button-face
     lui-deleted-face
     lui-emphasis-face
     lui-highlight-face
     lui-irc-colors-bg-0-face
     lui-irc-colors-bg-1-face
     lui-irc-colors-bg-10-face
     lui-irc-colors-bg-11-face
     lui-irc-colors-bg-12-face
     lui-irc-colors-bg-13-face
     lui-irc-colors-bg-14-face
     lui-irc-colors-bg-15-face
     lui-irc-colors-bg-2-face
     lui-irc-colors-bg-3-face
     lui-irc-colors-bg-4-face
     lui-irc-colors-bg-5-face
     lui-irc-colors-bg-6-face
     lui-irc-colors-bg-7-face
     lui-irc-colors-bg-8-face
     lui-irc-colors-bg-9-face
     lui-irc-colors-fg-0-face
     lui-irc-colors-fg-1-face
     lui-irc-colors-fg-10-face
     lui-irc-colors-fg-11-face
     lui-irc-colors-fg-12-face
     lui-irc-colors-fg-13-face
     lui-irc-colors-fg-14-face
     lui-irc-colors-fg-15-face
     lui-irc-colors-fg-2-face
     lui-irc-colors-fg-3-face
     lui-irc-colors-fg-4-face
     lui-irc-colors-fg-5-face
     lui-irc-colors-fg-6-face
     lui-irc-colors-fg-7-face
     lui-irc-colors-fg-8-face
     lui-irc-colors-fg-9-face
     lui-irc-colors-inverse-face
     lui-irc-colors-monospace-face
     lui-irc-colors-strike-through-face
     lui-strong-face
     lui-time-stamp-face
     lui-track-bar
     lusty-directory-face
     lusty-file-face
     lusty-match-face
     lusty-no-matches
     lusty-slash-face
     lusty-truncated
     lv-separator
     lyrics-face-artist
     lyrics-face-item
     lyrics-face-lyrics
     lyrics-face-song
     maces-game--guess-face
     maces-game--instruction-face
     maces-game--letters-face
     maces-game--message-face
     maces-game--points-face
     macports-describe-build-test-only-rdeps
     macports-describe-heading
     macports-describe-loading
     macports-describe-port-button-hover
     macrostep-compiler-macro-face
     macrostep-expansion-highlight-face
     macrostep-geiser-expanded-text-face
     macrostep-gensym-1
     macrostep-gensym-2
     macrostep-gensym-3
     macrostep-gensym-4
     macrostep-gensym-5
     macrostep-macro-face
     magik-argument-face
     magik-boolean-face
     magik-cb-cursor-face
     magik-cb-font-lock-gather-face
     magik-cb-font-lock-optional-face
     magik-character-face
     magik-class-face
     magik-comment-face
     magik-constant-face
     magik-doc-face
     magik-dynamic-face
     magik-global-face
     magik-global-reference-face
     magik-keyword-arguments-face
     magik-keyword-loop-face
     magik-keyword-obsolete-face
     magik-keyword-operators-face
     magik-keyword-statements-face
     magik-keyword-variable-face
     magik-label-face
     magik-method-face
     magik-number-face
     magik-pragma-face
     magik-procedure-face
     magik-session-method-definition-face
     magik-session-traceback-call-stack-face
     magik-slot-face
     magik-string-face
     magik-symbol-face
     magik-variable-face
     magik-warning-face
     magik-write-face
     magit-bisect-bad
     magit-bisect-good
     magit-bisect-skip
     magit-blame-date
     magit-blame-dimmed
     magit-blame-hash
     magit-blame-heading
     magit-blame-highlight
     magit-blame-margin
     magit-blame-name
     magit-blame-summary
     magit-branch-current
     magit-branch-local
     magit-branch-remote
     magit-branch-remote-head
     magit-branch-upstream
     magit-branch-warning
     magit-cherry-equivalent
     magit-cherry-unmatched
     magit-commit-mark-read-face
     magit-commit-mark-star-face
     magit-commit-mark-unread-face
     magit-commit-mark-urgent-face
     magit-diff-added
     magit-diff-added-highlight
     magit-diff-base
     magit-diff-base-highlight
     magit-diff-conflict-heading
     magit-diff-context
     magit-diff-context-highlight
     magit-diff-file-heading
     magit-diff-file-heading-highlight
     magit-diff-file-heading-selection
     magit-diff-hunk-heading
     magit-diff-hunk-heading-highlight
     magit-diff-hunk-heading-selection
     magit-diff-hunk-region
     magit-diff-lines-boundary
     magit-diff-lines-heading
     magit-diff-our
     magit-diff-our-highlight
     magit-diff-removed
     magit-diff-removed-highlight
     magit-diff-revision-summary
     magit-diff-revision-summary-highlight
     magit-diff-their
     magit-diff-their-highlight
     magit-diff-whitespace-warning
     magit-diffstat-added
     magit-diffstat-removed
     magit-dimmed
     magit-filename
     magit-hash
     magit-head
     magit-header-line
     magit-header-line-key
     magit-header-line-log-select
     magit-imerge-overriding-value
     magit-keyword
     magit-keyword-squash
     magit-log-author
     magit-log-date
     magit-log-graph
     magit-mode-line-process
     magit-mode-line-process-error
     magit-popup-argument
     magit-popup-disabled-argument
     magit-popup-heading
     magit-popup-key
     magit-popup-option-value
     magit-process-ng
     magit-process-ok
     magit-reflog-amend
     magit-reflog-checkout
     magit-reflog-cherry-pick
     magit-reflog-commit
     magit-reflog-merge
     magit-reflog-other
     magit-reflog-rebase
     magit-reflog-remote
     magit-reflog-reset
     magit-refname
     magit-refname-pullreq
     magit-refname-stash
     magit-refname-wip
     magit-section-child-count
     magit-section-heading
     magit-section-heading-selection
     magit-section-highlight
     magit-section-secondary-heading
     magit-sequence-done
     magit-sequence-drop
     magit-sequence-exec
     magit-sequence-head
     magit-sequence-onto
     magit-sequence-part
     magit-sequence-pick
     magit-sequence-stop
     magit-signature-bad
     magit-signature-error
     magit-signature-expired
     magit-signature-expired-key
     magit-signature-good
     magit-signature-revoked
     magit-signature-untrusted
     magit-stgit-applied
     magit-stgit-current
     magit-stgit-empty
     magit-stgit-hidden
     magit-stgit-patch
     magit-stgit-unapplied
     magit-tag
     magit-tbdiff-marker-different
     magit-tbdiff-marker-equivalent
     magit-tbdiff-marker-unmatched
     magit-topgit-current
     magit-topgit-empty
     magithub-ci-error
     magithub-ci-failure
     magithub-ci-no-status
     magithub-ci-pending
     magithub-ci-success
     magithub-ci-unknown
     magithub-deleted-thing
     magithub-edit-title
     magithub-issue-closed
     magithub-issue-number
     magithub-issue-open
     magithub-issue-title
     magithub-issue-title-edit
     magithub-issue-title-with-note
     magithub-label
     magithub-notification-reason
     magithub-repo
     magithub-user
     magrant-face-status-down
     magrant-face-status-other
     magrant-face-status-up
     make-color-highlight
     makefile-makepp-perl
     makefile-shell
     makefile-space
     makefile-targets
     makey-key-mode-args-face
     makey-key-mode-button-face
     makey-key-mode-header-face
     makey-key-mode-switch-face
     malyon-face-bold
     malyon-face-error
     malyon-face-italic
     malyon-face-plain
     malyon-face-reverse
     Man-overstrike
     Man-reverse
     Man-underline
     manage-minor-mode-face-active
     manage-minor-mode-face-changed
     manage-minor-mode-face-inactive
     manage-minor-mode-table-edit-face
     manage-minor-mode-table-hl-face
     mandoku-comment-face
     mandoku-tls-cite-face
     mandoku-tls-label-face
     mandoku-tls-ref-face
     marcopolo--cyan-face
     marcopolo--gray-face
     marcopolo--green-face
     marcopolo--orange-face
     marcopolo--red-face
     marcopolo--title
     marcopolo--yellow-face
     marcopolo-repository-description
     marcopolo-repository-misc
     marcopolo-repository-name
     marcopolo-title
     marginalia-archive
     marginalia-char
     marginalia-date
     marginalia-documentation
     marginalia-file-name
     marginalia-file-owner
     marginalia-file-priv-dir
     marginalia-file-priv-exec
     marginalia-file-priv-link
     marginalia-file-priv-no
     marginalia-file-priv-other
     marginalia-file-priv-rare
     marginalia-file-priv-read
     marginalia-file-priv-write
     marginalia-function
     marginalia-installed
     marginalia-key
     marginalia-lighter
     marginalia-list
     marginalia-mode
     marginalia-modified
     marginalia-null
     marginalia-number
     marginalia-off
     marginalia-on
     marginalia-size
     marginalia-string
     marginalia-symbol
     marginalia-true
     marginalia-type
     marginalia-value
     marginalia-version
     markdown-blockquote-face
     markdown-bold-face
     markdown-code-face
     markdown-comment-face
     markdown-footnote-marker-face
     markdown-footnote-text-face
     markdown-gfm-checkbox-face
     markdown-header-delimiter-face
     markdown-header-face
     markdown-header-face-1
     markdown-header-face-2
     markdown-header-face-3
     markdown-header-face-4
     markdown-header-face-5
     markdown-header-face-6
     markdown-header-rule-face
     markdown-highlight-face
     markdown-highlighting-face
     markdown-hr-face
     markdown-html-attr-name-face
     markdown-html-attr-value-face
     markdown-html-entity-face
     markdown-html-tag-delimiter-face
     markdown-html-tag-name-face
     markdown-inline-code-face
     markdown-italic-face
     markdown-language-info-face
     markdown-language-keyword-face
     markdown-line-break-face
     markdown-link-face
     markdown-link-title-face
     markdown-list-face
     markdown-markup-face
     markdown-math-face
     markdown-metadata-key-face
     markdown-metadata-value-face
     markdown-missing-link-face
     markdown-plain-url-face
     markdown-pre-face
     markdown-reference-face
     markdown-strike-through-face
     markdown-table-face
     markdown-url-face
     markless-bold-face
     markless-comment-face
     markless-embed-face
     markless-error-face
     markless-footnote-face
     markless-highlight-face
     markless-instruction-face
     markless-italic-face
     markless-keyword-face
     markless-list-mark-face
     markless-literal-face
     markless-markup-face
     markless-quote-face
     markless-quote-source-face
     markless-spoiler-face
     markless-strikethrough-face
     markless-underline-face
     markless-url-face
     markless-warning-face
     markup-anchor-face
     markup-attribute-face
     markup-big-face
     markup-bold-face
     markup-code-face
     markup-command-face
     markup-comment-face
     markup-complex-replacement-face
     markup-emphasis-face
     markup-error-face
     markup-gen-face
     markup-internal-reference-face
     markup-italic-face
     markup-list-face
     markup-meta-face
     markup-meta-hide-face
     markup-passthrough-face
     markup-preprocessor-face
     markup-reference-face
     markup-replacement-face
     markup-secondary-text-face
     markup-small-face
     markup-strong-face
     markup-subscript-face
     markup-superscript-face
     markup-table-cell-face
     markup-table-face
     markup-table-row-face
     markup-title-0-face
     markup-title-1-face
     markup-title-2-face
     markup-title-3-face
     markup-title-4-face
     markup-title-5-face
     markup-typewriter-face
     markup-underline-face
     markup-value-face
     markup-verbatim-face
     masm-constant
     masm-directives
     masm-instructions
     masm-labels
     masm-macro
     masm-prefix
     masm-registers
     masm-section-name
     masm-struct
     masm-subprogram
     masm-types
     masm-union
     mastodon-boost-fave-face
     mastodon-boosted-face
     mastodon-cursor-highlight-face
     mastodon-cw-face
     mastodon-display-name-face
     mastodon-handle-face
     mastodon-toot-docs-face
     mastodon-toot-docs-reply-text-face
     match
     math-preview-face
     math-preview-processing-face
     matlab-cellbreak-face
     matlab-commanddual-string-face
     matlab-cross-function-variable-face
     matlab-ignored-comment-face
     matlab-math-face
     matlab-nested-function-keyword-face
     matlab-pragma-face
     matlab-region-face
     matlab-shell-error-face
     matlab-simulink-keyword-face
     matlab-unterminated-string-face
     maude-attribute-face
     maude-attribute-value-face
     maude-element-face
     maude-end-face
     maude-file-face
     maude-label-face
     maude-module-name-face
     maude-pattern-face
     maude-start-face
     mbsync-font-lock-error-face
     mc/cursor-bar-face
     mc/cursor-face
     mc/region-face
     md4rd--greentext-face
     media-progress-dired-mpv-info-face
     media-progress-dirvish-face
     mentor-download-message
     mentor-download-name
     mentor-download-progress
     mentor-download-size
     mentor-download-speed-down
     mentor-download-speed-up
     mentor-download-state
     mentor-highlight-face
     mentor-tracker-name
     menu
     meow-beacon-cursor
     meow-beacon-fake-cursor
     meow-beacon-fake-selection
     meow-beacon-indicator
     meow-cheatsheet-command
     meow-cheatsheet-highlight
     meow-insert-cursor
     meow-insert-indicator
     meow-keypad-cannot-display
     meow-keypad-cursor
     meow-keypad-indicator
     meow-kmacro-cursor
     meow-motion-cursor
     meow-motion-indicator
     meow-normal-cursor
     meow-normal-indicator
     meow-position-highlight-number
     meow-position-highlight-number-1
     meow-position-highlight-number-2
     meow-position-highlight-number-3
     meow-position-highlight-reverse-number-1
     meow-position-highlight-reverse-number-2
     meow-position-highlight-reverse-number-3
     meow-region-cursor-1
     meow-region-cursor-2
     meow-region-cursor-3
     meow-search-highlight
     meow-search-indicator
     meow-unknown-cursor
     merlin-compilation-error-face
     merlin-compilation-warning-face
     merlin-eldoc-occurrences-face
     merlin-type-face
     message-cited-text-1
     message-cited-text-2
     message-cited-text-3
     message-cited-text-4
     message-header-cc
     message-header-name
     message-header-newsgroups
     message-header-other
     message-header-subject
     message-header-to
     message-header-xheader
     message-mml
     message-separator
     message-signature-separator
     message-view-patch-cite-1
     message-view-patch-cite-2
     message-view-patch-cite-3
     message-view-patch-cite-4
     message-view-patch-cite-5
     message-view-patch-cite-6
     message-view-patch-cite-7
     message-view-patch-commit-comment
     message-view-patch-commit-message
     message-view-patch-diff-added
     message-view-patch-diff-context
     message-view-patch-diff-equals
     message-view-patch-diff-header
     message-view-patch-diff-hunk
     message-view-patch-diff-index
     message-view-patch-diff-removed
     message-view-patch-diff-stat-bar
     message-view-patch-diff-stat-file
     message-view-patch-diff-stat-num
     message-view-patch-misc
     message-view-patch-scissors
     message-view-patch-three-dashes
     metamorph-preview-face
     metascript-builtin-face
     metascript-constant-face
     metascript-control-flow-face
     metascript-def-face
     metascript-function-name-face
     metascript-modifier-face
     metascript-number-face
     metascript-object-literal-key-face
     metascript-placeholder-face
     metascript-pretty-lambda-parameter-face
     metascript-type-name-face
     metascript-variable-name-face
     mew-face-body-cite1
     mew-face-body-cite2
     mew-face-body-cite3
     mew-face-body-cite4
     mew-face-body-cite5
     mew-face-body-comment
     mew-face-body-url
     mew-face-eof-message
     mew-face-eof-part
     mew-face-header-date
     mew-face-header-from
     mew-face-header-important
     mew-face-header-key
     mew-face-header-marginal
     mew-face-header-private
     mew-face-header-subject
     mew-face-header-to
     mew-face-header-warning
     mew-face-header-xmew
     mew-face-header-xmew-bad
     mew-face-mark-delete
     mew-face-mark-escape
     mew-face-mark-refile
     mew-face-mark-review
     mew-face-mark-unlink
     mew-face-mark-unread
     mh-folder-address
     mh-folder-allowlisted
     mh-folder-blocklisted
     mh-folder-body
     mh-folder-cur-msg-number
     mh-folder-date
     mh-folder-deleted
     mh-folder-followup
     mh-folder-msg-number
     mh-folder-refiled
     mh-folder-sent-to-me-hint
     mh-folder-sent-to-me-sender
     mh-folder-subject
     mh-folder-tick
     mh-folder-to
     mh-letter-header-field
     mh-search-folder
     mh-show-cc
     mh-show-date
     mh-show-from
     mh-show-header
     mh-show-pgg-bad
     mh-show-pgg-good
     mh-show-pgg-unknown
     mh-show-signature
     mh-show-subject
     mh-show-to
     mh-show-xface
     mh-speedbar-folder
     mh-speedbar-folder-with-unseen-messages
     mh-speedbar-selected-folder
     mh-speedbar-selected-folder-with-unseen-messages
     mhc-message-face-eof-marker
     mhc-message-face-subject
     micgoline-pl-active-blue
     micgoline-pl-active-green
     micgoline-pl-active-red
     micgoline-pl-active-yellow
     micgoline-pl-inactive-blue
     micgoline-pl-inactive-green
     micgoline-pl-inactive-red
     micgoline-pl-inactive-yellow
     milkode:highlight-line-face
     mindre-bar
     mindre-bar-inactive
     mindre-block
     mindre-bold
     mindre-border
     mindre-button
     mindre-button-hover
     mindre-button-pressed
     mindre-critical
     mindre-critical-i
     mindre-default
     mindre-default-i
     mindre-error
     mindre-faded
     mindre-faded-i
     mindre-heading-1
     mindre-highlight
     mindre-keyword
     mindre-link
     mindre-note
     mindre-paren-face
     mindre-strong
     mindre-strong-i
     mindre-subtle
     mindre-subtle-i
     mindre-type
     mindre-verbatim
     mindre-warning
     minesweeper-0
     minesweeper-1
     minesweeper-2
     minesweeper-3
     minesweeper-4
     minesweeper-5
     minesweeper-6
     minesweeper-7
     minesweeper-8
     minesweeper-blank
     minesweeper-explode
     minesweeper-marked
     minesweeper-mismarked
     minesweeper-neighbor
     mingus-album-face
     mingus-album-stale-face
     mingus-artist-face
     mingus-directory-face
     mingus-mark-face
     mingus-pausing-face
     mingus-playing-face
     mingus-playlist-face
     mingus-song-file-face
     mingus-stopped-face
     mini-echo-blob-revision
     mini-echo-blue
     mini-echo-buffer-position
     mini-echo-buffer-size
     mini-echo-char-info
     mini-echo-cyan
     mini-echo-evil-emacs-state
     mini-echo-evil-insert-state
     mini-echo-evil-motion-state
     mini-echo-evil-normal-state
     mini-echo-evil-operator-state
     mini-echo-evil-replace-state
     mini-echo-evil-visual-state
     mini-echo-gray
     mini-echo-green
     mini-echo-last-command
     mini-echo-lsp
     mini-echo-macro
     mini-echo-major-mode
     mini-echo-minibuffer-window
     mini-echo-narrow
     mini-echo-process
     mini-echo-profiler
     mini-echo-project
     mini-echo-red
     mini-echo-remote-host
     mini-echo-repeat
     mini-echo-selection-info
     mini-echo-status-global
     mini-echo-status-local
     mini-echo-violet
     mini-echo-word-count
     mini-echo-yellow
     mini-header-line-active
     mini-modeline-mode-line
     mini-modeline-mode-line-inactive
     minibar-face
     minibar-module-battery-low-face
     minibar-module-temperature-high-face
     minibar-module-temperature-very-high-face
     minibuf-isearch-comp-face
     minibuf-isearch-face
     minibuffer-complete-cycle
     minibuffer-depth-indicator
     minibuffer-prompt
     minizinc-operator-face
     mistty-fringe-face
     mistty-log-header-face
     mistty-log-message-face
     ml/black
     ml/blue
     ml/box
     ml/chapter
     ml/cyan
     ml/footnote
     ml/green
     ml/hhuge
     ml/huge
     ml/large
     ml/lbar
     ml/llarge
     ml/magenta
     ml/overline
     ml/red
     ml/script
     ml/section
     ml/small
     ml/subsection
     ml/tiny
     ml/title
     ml/type
     ml/white
     ml/xlarge
     ml/yellow
     mlg-breakpoint-face
     mm-command-output
     mm-uu-extract
     mm/master-face
     mm/mirror-face
     mmm-cleanup-submode-face
     mmm-code-submode-face
     mmm-comment-submode-face
     mmm-declaration-submode-face
     mmm-default-submode-face
     mmm-delimiter-face
     mmm-init-submode-face
     mmm-output-submode-face
     mmm-special-submode-face
     mobdebug-buffer-face
     mode-line
     mode-line-active
     mode-line-buffer-id
     mode-line-buffer-id-inactive
     mode-line-debug-disabled
     mode-line-debug-enabled
     mode-line-emphasis
     mode-line-highlight
     mode-line-inactive
     modern-fringes-arrows
     modus-themes-bold
     modus-themes-button
     modus-themes-completion-selected
     modus-themes-fixed-pitch
     modus-themes-key-binding
     modus-themes-prompt
     modus-themes-reset-soft
     modus-themes-slant
     modus-themes-ui-variable-pitch
     monkeytype-correct
     monkeytype-correction-correct
     monkeytype-correction-error
     monkeytype-default
     monkeytype-dimmed
     monkeytype-error
     monkeytype-legend-1
     monkeytype-legend-2
     monkeytype-mode-line-error
     monkeytype-mode-line-info
     monkeytype-mode-line-normal
     monkeytype-mode-line-success
     monkeytype-notice
     monkeytype-read-only
     monkeytype-results-error
     monkeytype-results-success
     monkeytype-title
     monky-branch
     monky-commit-id
     monky-diff-add
     monky-diff-del
     monky-diff-hunk-header
     monky-diff-none
     monky-diff-title
     monky-header
     monky-log-author
     monky-log-date
     monky-log-head-label-bookmarks
     monky-log-head-label-local
     monky-log-head-label-phase
     monky-log-head-label-tags
     monky-log-message
     monky-log-sha1
     monky-queue-active
     monky-queue-negative-guard
     monky-queue-patch
     monky-queue-positive-guard
     monky-section-title
     mono-complete-preview-face
     mood-line-buffer-name
     mood-line-buffer-status-modified
     mood-line-buffer-status-narrowed
     mood-line-buffer-status-read-only
     mood-line-encoding
     mood-line-frame-status-client
     mood-line-major-mode
     mood-line-status-error
     mood-line-status-info
     mood-line-status-neutral
     mood-line-status-success
     mood-line-status-warning
     mood-line-unimportant
     mouse
     mouse-drag-and-drop-region
     move-compilation-column-face
     move-compilation-error-face
     move-compilation-line-face
     move-compilation-message-face
     move-compilation-warning-face
     mozc-cand-echo-area-annotation-face
     mozc-cand-echo-area-candidate-face
     mozc-cand-echo-area-focused-face
     mozc-cand-echo-area-shortcut-face
     mozc-cand-echo-area-stats-face
     mozc-cand-overlay-description-face
     mozc-cand-overlay-even-face
     mozc-cand-overlay-focused-face
     mozc-cand-overlay-footer-face
     mozc-cand-overlay-odd-face
     mozc-cand-posframe-focused-face
     mozc-cand-posframe-footer-face
     mozc-cand-posframe-normal-face
     mozc-preedit-face
     mozc-preedit-selected-face
     mpd-first-field-face
     mpd-header-face
     mpd-second-field-face
     mpd-separator-face
     mpdel-browser-directory-face
     mpdel-playlist-current-song-face
     mpdel-tablist-album-face
     mpdel-tablist-artist-face
     mpdel-tablist-date-face
     mpdel-tablist-disk-face
     mpdel-tablist-song-name-face
     mpdel-tablist-track-face
     mpuz-solved
     mpuz-text
     mpuz-trivial
     mpuz-unsolved
     mu4e-column-faces-attachments
     mu4e-column-faces-date
     mu4e-column-faces-decryption
     mu4e-column-faces-flags
     mu4e-column-faces-maildir
     mu4e-column-faces-mailing-list
     mu4e-column-faces-message-id
     mu4e-column-faces-signature
     mu4e-column-faces-size
     mu4e-column-faces-tags
     mu4e-column-faces-thread-subject
     mu4e-column-faces-to-from
     mu4e-column-faces-user-agent
     mu4e-compose-separator-face
     mu4e-contact-face
     mu4e-context-face
     mu4e-conversation-header
     mu4e-conversation-sender-1
     mu4e-conversation-sender-2
     mu4e-conversation-sender-3
     mu4e-conversation-sender-4
     mu4e-conversation-sender-5
     mu4e-conversation-sender-6
     mu4e-conversation-sender-7
     mu4e-conversation-sender-8
     mu4e-conversation-sender-me
     mu4e-conversation-unread
     mu4e-draft-face
     mu4e-flagged-face
     mu4e-footer-face
     mu4e-forwarded-face
     mu4e-header-face
     mu4e-header-field-face
     mu4e-header-highlight-face
     mu4e-header-key-face
     mu4e-header-marks-face
     mu4e-header-title-face
     mu4e-header-value-face
     mu4e-highlight-face
     mu4e-link-face
     mu4e-modeline-face
     mu4e-ok-face
     mu4e-overview-folder
     mu4e-overview-group-folder
     mu4e-overview-unread
     mu4e-region-code
     mu4e-related-face
     mu4e-replied-face
     mu4e-special-header-value-face
     mu4e-system-face
     mu4e-title-face
     mu4e-trashed-face
     mu4e-unread-face
     mu4e-url-number-face
     mu4e-warning-face
     multi-project-selection-face
     multitran-link-face
     multitran-section-face
     muv:button-face
     mxf-view-leaf
     mxf-view-node
     mxf-view-property
     mxf-view-string
     mxf-view-value
     mxf-view-warning
     my-blue
     my-chartreuse
     my-cyan
     my-dmagenta
     my-gold
     my-green
     my-orange
     my-orangered
     my-red
     my-sgreen
     my-yellow
     nameless-face
     nasm-constant
     nasm-directives
     nasm-instructions
     nasm-labels
     nasm-local-labels
     nasm-prefix
     nasm-preprocessor
     nasm-registers
     nasm-section-name
     nasm-types
     nav-flash-face
     navi2ch-article-auto-decode-face
     navi2ch-article-citation-face
     navi2ch-article-face
     navi2ch-article-header-contents-face
     navi2ch-article-header-face
     navi2ch-article-header-fusianasan-face
     navi2ch-article-link-face
     navi2ch-article-message-separator-face
     navi2ch-article-url-face
     navi2ch-bm-cache-face
     navi2ch-bm-down-face
     navi2ch-bm-mark-face
     navi2ch-bm-new-cache-face
     navi2ch-bm-new-mark-face
     navi2ch-bm-new-unread-face
     navi2ch-bm-new-update-face
     navi2ch-bm-new-view-face
     navi2ch-bm-seen-cache-face
     navi2ch-bm-seen-mark-face
     navi2ch-bm-seen-unread-face
     navi2ch-bm-seen-update-face
     navi2ch-bm-seen-view-face
     navi2ch-bm-unread-face
     navi2ch-bm-update-face
     navi2ch-bm-updated-cache-face
     navi2ch-bm-updated-mark-face
     navi2ch-bm-updated-unread-face
     navi2ch-bm-updated-update-face
     navi2ch-bm-updated-view-face
     navi2ch-bm-view-face
     navi2ch-list-add-board-name-face
     navi2ch-list-board-name-face
     navi2ch-list-category-face
     navi2ch-list-change-board-name-face
     navi2ch-message-citation-face
     navi2ch-message-link-face
     navi2ch-message-url-face
     navi2ch-splash-screen-face
     neato-graph-bar-cpu-interrupt
     neato-graph-bar-cpu-system
     neato-graph-bar-cpu-user
     neato-graph-bar-cpu-vm
     neato-graph-bar-memory-buffer
     neato-graph-bar-memory-cache
     neato-graph-bar-memory-used
     neo-banner-face
     neo-button-face
     neo-dir-link-face
     neo-expand-btn-face
     neo-file-link-face
     neo-header-face
     neo-root-dir-face
     neo-vc-added-face
     neo-vc-conflict-face
     neo-vc-default-face
     neo-vc-edited-face
     neo-vc-ignored-face
     neo-vc-missing-face
     neo-vc-needs-merge-face
     neo-vc-needs-update-face
     neo-vc-removed-face
     neo-vc-unlocked-changes-face
     neo-vc-unregistered-face
     neo-vc-up-to-date-face
     neo-vc-user-face
     nerd-icons-blue
     nerd-icons-blue-alt
     nerd-icons-completion-dir-face
     nerd-icons-cyan
     nerd-icons-cyan-alt
     nerd-icons-dblue
     nerd-icons-dcyan
     nerd-icons-dgreen
     nerd-icons-dired-dir-face
     nerd-icons-dmaroon
     nerd-icons-dorange
     nerd-icons-dpink
     nerd-icons-dpurple
     nerd-icons-dred
     nerd-icons-dsilver
     nerd-icons-dyellow
     nerd-icons-green
     nerd-icons-ibuffer-dir-face
     nerd-icons-ibuffer-file-face
     nerd-icons-ibuffer-icon-face
     nerd-icons-ibuffer-mode-face
     nerd-icons-ibuffer-size-face
     nerd-icons-ivy-rich-archive-face
     nerd-icons-ivy-rich-bookmark-face
     nerd-icons-ivy-rich-dir-face
     nerd-icons-ivy-rich-doc-face
     nerd-icons-ivy-rich-error-face
     nerd-icons-ivy-rich-file-name-face
     nerd-icons-ivy-rich-file-owner-face
     nerd-icons-ivy-rich-file-priv-dir
     nerd-icons-ivy-rich-file-priv-exec
     nerd-icons-ivy-rich-file-priv-link
     nerd-icons-ivy-rich-file-priv-no
     nerd-icons-ivy-rich-file-priv-other
     nerd-icons-ivy-rich-file-priv-rare
     nerd-icons-ivy-rich-file-priv-read
     nerd-icons-ivy-rich-file-priv-write
     nerd-icons-ivy-rich-function-face
     nerd-icons-ivy-rich-icon-face
     nerd-icons-ivy-rich-imenu-doc-face
     nerd-icons-ivy-rich-imenu-type-face
     nerd-icons-ivy-rich-indicator-face
     nerd-icons-ivy-rich-list-face
     nerd-icons-ivy-rich-major-mode-face
     nerd-icons-ivy-rich-null-face
     nerd-icons-ivy-rich-number-face
     nerd-icons-ivy-rich-off-face
     nerd-icons-ivy-rich-on-face
     nerd-icons-ivy-rich-pacage-desc-face
     nerd-icons-ivy-rich-package-status-avaible-face
     nerd-icons-ivy-rich-package-status-held-face
     nerd-icons-ivy-rich-package-status-installed-face
     nerd-icons-ivy-rich-package-status-new-face
     nerd-icons-ivy-rich-package-status-warn-face
     nerd-icons-ivy-rich-path-face
     nerd-icons-ivy-rich-persp-face
     nerd-icons-ivy-rich-process-buffer-face
     nerd-icons-ivy-rich-process-command-face
     nerd-icons-ivy-rich-process-id-face
     nerd-icons-ivy-rich-process-status-alt-face
     nerd-icons-ivy-rich-process-status-face
     nerd-icons-ivy-rich-process-thread-face
     nerd-icons-ivy-rich-process-tty-face
     nerd-icons-ivy-rich-project-face
     nerd-icons-ivy-rich-size-face
     nerd-icons-ivy-rich-string-face
     nerd-icons-ivy-rich-symbol-face
     nerd-icons-ivy-rich-time-face
     nerd-icons-ivy-rich-true-face
     nerd-icons-ivy-rich-type-face
     nerd-icons-ivy-rich-value-face
     nerd-icons-ivy-rich-version-face
     nerd-icons-ivy-rich-warn-face
     nerd-icons-lblue
     nerd-icons-lcyan
     nerd-icons-lgreen
     nerd-icons-lmaroon
     nerd-icons-lorange
     nerd-icons-lpink
     nerd-icons-lpurple
     nerd-icons-lred
     nerd-icons-lsilver
     nerd-icons-lyellow
     nerd-icons-maroon
     nerd-icons-orange
     nerd-icons-pink
     nerd-icons-purple
     nerd-icons-purple-alt
     nerd-icons-red
     nerd-icons-red-alt
     nerd-icons-silver
     nerd-icons-yellow
     nerdtab-current-tab-face
     nerdtab-tab-face
     nerdtab-tab-mouse-face
     netease-cloud-music-artist-face
     netease-cloud-music-current-song-title-face
     netease-cloud-music-head-title-face
     netease-cloud-music-play-status-face
     netease-cloud-music-playing-song-face
     netease-cloud-music-playlist-face
     netease-cloud-music-playlists-face
     netease-cloud-music-repeat-face
     netease-cloud-music-repeat-mode-face
     netease-cloud-music-song-face
     netease-cloud-music-user-name-face
     neuron-invalid-link-face
     neuron-invalid-zettel-id-face
     neuron-link-face
     neuron-link-mouse-face
     neuron-title-overlay-face
     neuron-zettel-tag-face
     never-comment-face
     newspeak-font-lock-builtin-face
     newspeak-font-lock-comment-face
     newspeak-font-lock-constant-face
     newspeak-font-lock-function-name-face
     newspeak-font-lock-keyword-face
     newspeak-font-lock-string-face
     newspeak-font-lock-type-face
     newspeak-font-lock-variable-name-face
     newspeak-font-lock-warning-face
     newsticker-date-face
     newsticker-default-face
     newsticker-enclosure-face
     newsticker-extra-face
     newsticker-feed-face
     newsticker-immortal-item-face
     newsticker-new-item-face
     newsticker-obsolete-item-face
     newsticker-old-item-face
     newsticker-statistics-face
     newsticker-treeview-face
     newsticker-treeview-immortal-face
     newsticker-treeview-new-face
     newsticker-treeview-obsolete-face
     newsticker-treeview-old-face
     newsticker-treeview-selection-face
     next-error
     next-error-message
     nexus-widget-artifact-face
     nexus-widget-xml-tag-face
     nim-font-lock-export-face
     nim-font-lock-number-face
     nim-font-lock-pragma-face
     nim-non-overloadable-face
     nix-antiquote-face
     nix-attribute-face
     nix-builtin-face
     nix-constant-face
     nix-keyword-face
     nix-keyword-warning-face
     nix-modeline-error-face
     nix-modeline-idle-face
     nix-modeline-running-face
     nix-search-description
     nix-search-pname
     nix-search-version
     nix-store-path-face
     nix-store-path-realised-face
     nix-store-path-unrealised-face
     nlinum-current-line
     nlinum-relative-current-face
     no-emoji
     noaa-face-date
     noaa-face-short-forecast
     noaa-face-temp
     nobreak-hyphen
     nobreak-space
     norns-lua-extra-font-lock-norns-builtin
     norns-lua-extra-font-lock-norns-constant
     norns-lua-extra-font-lock-norns-special-fn
     notmuch-crypto-decryption
     notmuch-crypto-part-header
     notmuch-crypto-signature-bad
     notmuch-crypto-signature-good
     notmuch-crypto-signature-good-key
     notmuch-crypto-signature-unknown
     notmuch-hello-logo-background
     notmuch-jump-key
     notmuch-message-summary-face
     notmuch-search-count
     notmuch-search-date
     notmuch-search-flagged-face
     notmuch-search-matching-authors
     notmuch-search-non-matching-authors
     notmuch-search-subject
     notmuch-search-unread-face
     notmuch-tag-added
     notmuch-tag-deleted
     notmuch-tag-face
     notmuch-tag-flagged
     notmuch-tag-unread
     notmuch-transient-add-tag
     notmuch-transient-remove-tag
     notmuch-tree-match-author-face
     notmuch-tree-match-date-face
     notmuch-tree-match-face
     notmuch-tree-match-subject-face
     notmuch-tree-match-tag-face
     notmuch-tree-match-tree-face
     notmuch-tree-no-match-author-face
     notmuch-tree-no-match-date-face
     notmuch-tree-no-match-face
     notmuch-tree-no-match-subject-face
     notmuch-tree-no-match-tag-face
     notmuch-tree-no-match-tree-face
     notmuch-wash-cited-text
     notmuch-wash-toggle-button
     noxml-fold-folded-bold-face
     noxml-fold-folded-face
     noxml-fold-folded-italic-face
     noxml-fold-tag-face
     noxml-fold-unfolded-face
     nrepl-eval-sexp-fu-flash
     nrepl-eval-sexp-fu-flash-error
     ns-working-text-face
     nsis-font-lock-bold-function-name-face
     nsis-font-lock-bold-string-face
     nsis-font-lock-italic-function-name-face
     nsis-font-lock-italic-string-face
     nsis-font-lock-italic-type-face
     nswbuff-current-buffer-face
     nswbuff-default-face
     nswbuff-separator-face
     nswbuff-special-buffers-face
     nu-face-shortcut
     nushell-pay-attention-face
     nxml-attribute-colon
     nxml-attribute-local-name
     nxml-attribute-prefix
     nxml-attribute-value
     nxml-attribute-value-delimiter
     nxml-cdata-section-CDATA
     nxml-cdata-section-content
     nxml-cdata-section-delimiter
     nxml-char-ref-delimiter
     nxml-char-ref-number
     nxml-delimited-data
     nxml-delimiter
     nxml-element-colon
     nxml-element-local-name
     nxml-element-prefix
     nxml-entity-ref-delimiter
     nxml-entity-ref-name
     nxml-glyph
     nxml-hash
     nxml-heading
     nxml-markup-declaration-delimiter
     nxml-name
     nxml-namespace-attribute-colon
     nxml-namespace-attribute-prefix
     nxml-namespace-attribute-xmlns
     nxml-outline-active-indicator
     nxml-outline-ellipsis
     nxml-outline-indicator
     nxml-processing-instruction-content
     nxml-processing-instruction-delimiter
     nxml-processing-instruction-target
     nxml-prolog-keyword
     nxml-prolog-literal-content
     nxml-prolog-literal-delimiter
     nxml-ref
     nxml-tag-delimiter
     nxml-tag-slash
     nxml-text
     objc-font-lock-background
     objc-font-lock-bracket
     objc-font-lock-function-name
     objed-hl
     objed-mark
     objed-mode-line
     ocaml-help-face
     ocaml-link-face
     ocamldebug-event
     ocamldebug-underline
     occur-margin-face
     occurx-ellipsis-face
     octave-function-comment-block
     octo-super-chip-statements-face
     octo-xo-chip-statements-face
     octopress-highlight-line-face
     octopress-option-off
     octopress-option-on
     offlineimap-error-face
     offlineimap-msg-acct-face
     offlineimap-msg-addingflags-face
     offlineimap-msg-connecting-face
     offlineimap-msg-copyingmessage-face
     offlineimap-msg-deletingflags-face
     offlineimap-msg-deletingmessage-face
     offlineimap-msg-deletingmessages-face
     offlineimap-msg-loadmessagelist-face
     offlineimap-msg-skippingfolder-face
     offlineimap-msg-syncfolders-face
     offlineimap-msg-syncingfolders-face
     offlineimap-msg-syncingmessages-face
     olivetti-fringe
     omni-log-face
     omni-log-fading-face
     omni-log-fading-prompt-face
     omni-log-prompt-face
     omni-tags-face-default
     omni-tags-face-details
     omni-tags-face-name
     omni-tags-face-ponctuation
     omni-tags-face-separator
     omni-tags-face-symbol
     omni-tags-face-symbols
     omnibox-match
     omnibox-modeline
     omnibox-prompt
     omnibox-selection
     on-screen-fringe
     on-screen-hl-line
     on-screen-narrow-line
     on-screen-shadow
     orderless-match-face-0
     orderless-match-face-1
     orderless-match-face-2
     orderless-match-face-3
     org-agenda-calendar-event
     org-agenda-calendar-sexp
     org-agenda-clocking
     org-agenda-column-dateline
     org-agenda-current-time
     org-agenda-date
     org-agenda-date-today
     org-agenda-date-weekend
     org-agenda-date-weekend-today
     org-agenda-diary
     org-agenda-dimmed-todo-face
     org-agenda-done
     org-agenda-filter-category
     org-agenda-filter-effort
     org-agenda-filter-regexp
     org-agenda-filter-tags
     org-agenda-property-face
     org-agenda-restriction-lock
     org-agenda-structure
     org-agenda-structure-filter
     org-agenda-structure-secondary
     org-archived
     org-beamer-tag
     org-block
     org-block-begin-line
     org-block-end-line
     org-brain-button
     org-brain-child
     org-brain-edge-annotation-face-template
     org-brain-file-face-template
     org-brain-friend
     org-brain-history-list
     org-brain-local-child
     org-brain-local-parent
     org-brain-local-sibling
     org-brain-parent
     org-brain-pinned
     org-brain-selected-face-template
     org-brain-selected-list
     org-brain-sibling
     org-brain-title
     org-brain-wires
     org-change-deleted-face
     org-change-link-face
     org-checkbox
     org-checkbox-statistics-done
     org-checkbox-statistics-todo
     org-cite
     org-cite-key
     org-clock-overlay
     org-code
     org-column
     org-column-title
     org-date
     org-date-selected
     org-default
     org-dispatcher-highlight
     org-document-info
     org-document-info-keyword
     org-document-title
     org-done
     org-drawer
     org-drill-hidden-cloze-face
     org-drill-visible-cloze-face
     org-drill-visible-cloze-hint-face
     org-ellipsis
     org-eval
     org-footnote
     org-formula
     org-grep-ellipsis-face
     org-grep-match-face
     org-habit-alert-face
     org-habit-alert-future-face
     org-habit-clear-face
     org-habit-clear-future-face
     org-habit-overdue-face
     org-habit-overdue-future-face
     org-habit-ready-face
     org-habit-ready-future-face
     org-habit-stats-calendar-completed
     org-habit-stats-graph-label
     org-habit-stats-graph-name
     org-habit-stats-graph-title
     org-habit-stats-habit-name
     org-habit-stats-message-encouraging
     org-habit-stats-message-positive
     org-habit-stats-section-name
     org-habit-stats-stat-name
     org-habit-stats-stat-value
     org-headline-done
     org-headline-todo
     org-hide
     org-imminent-deadline
     org-indent
     org-inline-src-block
     org-inlinetask
     org-journal-calendar-entry-face
     org-journal-calendar-scheduled-face
     org-journal-highlight
     org-journal-tags-barchart-face
     org-journal-tags-date-header
     org-journal-tags-info-face
     org-journal-tags-on-this-day-time-header
     org-journal-tags-tag-face
     org-journal-tags-time-header
     org-latex-and-related
     org-level-1
     org-level-2
     org-level-3
     org-level-4
     org-level-5
     org-level-6
     org-level-7
     org-level-8
     org-link
     org-link-beautify-link-decorator-face
     org-link-beautify-link-description-face
     org-link-beautify-link-icon-face
     org-list-dt
     org-macro
     org-meta-line
     org-mode-line-clock
     org-mode-line-clock-overrun
     org-modern-block-name
     org-modern-date-active
     org-modern-date-inactive
     org-modern-done
     org-modern-horizontal-rule
     org-modern-internal-target
     org-modern-label
     org-modern-priority
     org-modern-radio-target
     org-modern-statistics
     org-modern-symbol
     org-modern-tag
     org-modern-time-active
     org-modern-time-inactive
     org-modern-todo
     org-noter-no-notes-exist-face
     org-noter-notes-exist-face
     org-outline-numbering-face
     org-pomodoro-mode-line
     org-pomodoro-mode-line-break
     org-pomodoro-mode-line-overtime
     org-priority
     org-property-value
     org-ql-completing-read-snippet
     org-ql-view-due-date
     org-quote
     org-recur
     org-ref-acronym-face
     org-ref-bad-cite-key-face
     org-ref-cite-&-face
     org-ref-cite-face
     org-ref-cite-global-prefix/suffix-face
     org-ref-cite-invalid-local-prefix/suffix-face
     org-ref-cite-local-prefix/suffix-face
     org-ref-glossary-face
     org-ref-label-face
     org-ref-ref-face
     org-remark-highlighter
     org-remark-highlighter-warning
     org-remark-line-highlighter
     org-reverse-datetree-calendar-date-face
     org-roam-dailies-calendar-note
     org-roam-dim
     org-roam-header-line
     org-roam-olp
     org-roam-overlay
     org-roam-preview-heading
     org-roam-preview-heading-highlight
     org-roam-preview-heading-selection
     org-roam-preview-region
     org-roam-shielded
     org-roam-title
     org-runbook-bookmark-link-highlight
     org-runbook-view-var-substitution
     org-scheduled
     org-scheduled-previously
     org-scheduled-today
     org-sexp-date
     org-side-tree-heading-face
     org-special-keyword
     org-super-agenda-header
     org-superstar-first
     org-superstar-header-bullet
     org-superstar-item
     org-superstar-leading
     org-table
     org-table-header
     org-table-sticky-header-face
     org-tag
     org-tag-group
     org-target
     org-tfl-bakerloo-face
     org-tfl-central-face
     org-tfl-circle-face
     org-tfl-district-face
     org-tfl-hammersmith-face
     org-tfl-jubliee-face
     org-tfl-metropolitan-face
     org-tfl-northern-face
     org-tfl-piccadilly-face
     org-tfl-victoria-face
     org-tfl-waterloo-face
     org-time-budgets-close-face
     org-time-budgets-done-face
     org-time-budgets-todo-face
     org-time-grid
     org-timeblock-blue
     org-timeblock-current-time-indicator
     org-timeblock-cyan
     org-timeblock-green
     org-timeblock-hours-line
     org-timeblock-list-header
     org-timeblock-magenta
     org-timeblock-mark
     org-timeblock-red
     org-timeblock-select
     org-timeblock-yellow
     org-timeline-block
     org-timeline-clocked
     org-timeline-elapsed
     org-todo
     org-tree-slide-header-overlay-face
     org-treescope-faces--markerinternal-midday
     org-treescope-faces--markerinternal-range
     org-upcoming-deadline
     org-upcoming-distant-deadline
     org-upcoming-modeline-normal-face
     org-upcoming-modeline-soon-face
     org-variable-pitch-fixed-face
     org-verbatim
     org-verse
     org-view-author-face
     org-view-quote-face
     org-view-verse-face
     org-warning
     org-wc-overlay
     orgpan-active-field
     orgpan-field
     orgpan-spaceline
     origami-fold-fringe-face
     origami-fold-header-face
     origami-fold-replacement-face
     osa-chrome-tab-active-face
     osa-chrome-tab-filter-face
     osa-chrome-tab-marked-active-face
     osa-chrome-tab-marked-face
     outline-1
     outline-2
     outline-3
     outline-4
     outline-5
     outline-6
     outline-7
     outline-8
     outline-minor-0
     outline-minor-1
     outline-minor-2
     outline-minor-3
     outline-minor-4
     outline-minor-5
     outline-minor-6
     outline-minor-7
     outline-minor-8
     outline-minor-file-local-prop-line
     outline-toc-current-section
     outline-toc-font-face
     outrespace-highlight-face
     outshine-level-1
     outshine-level-2
     outshine-level-3
     outshine-level-4
     outshine-level-5
     outshine-level-6
     outshine-level-7
     outshine-level-8
     p4-action-face
     p4-branch-face
     p4-change-face
     p4-client-face
     p4-depot-add-face
     p4-depot-branch-face
     p4-depot-delete-face
     p4-depot-edit-face
     p4-description-face
     p4-filespec-face
     p4-form-comment-face
     p4-form-keyword-face
     p4-heading-face
     p4-job-face
     p4-label-face
     p4-link-face
     p4-revision-face
     p4-user-face
     pabbrev-debug-display-label-face
     pabbrev-single-suggestion-face
     pabbrev-suggestions-face
     pabbrev-suggestions-label-face
     pacdiff-pacnew
     pacdiff-pacsave
     pacfiles--apply-all
     pacfiles--automerge
     pacfiles--delete
     pacfiles--discard
     pacfiles--discard-all
     package-description
     package-help-section-name
     package-loading-notifier-face
     package-name
     package-status-avail-obso
     package-status-available
     package-status-built-in
     package-status-dependency
     package-status-disabled
     package-status-external
     package-status-from-source
     package-status-held
     package-status-incompat
     package-status-installed
     package-status-new
     package-status-unsigned
     pact-error-face
     pact-warning-face
     page-break-lines
     pandoc-citation-key-face
     pandoc-directive-@@-face
     pandoc-directive-braces-face
     pandoc-directive-contents-face
     pandoc-directive-type-face
     pandoc-strikethrough-text-face
     pandoc-strikethrough-tilde-face
     pangu-spacing-separator-face
     paradox-archive-face
     paradox-comment-face
     paradox-commit-tag-face
     paradox-description-face
     paradox-description-face-multiline
     paradox-download-face
     paradox-highlight-face
     paradox-homepage-button-face
     paradox-mode-line-face
     paradox-name-face
     paradox-star-face
     paradox-starred-face
     paren-face-match
     paren-face-mismatch
     paren-face-no-match
     parenthesis
     parinfer-rust-dim-parens
     parrot-rotate-rotation-highlight-face
     pasp-atom-face
     pasp-construct-face
     pass-mode-directory-face
     pass-mode-entry-face
     pass-mode-header-face
     pass-mode-keybinding-face
     pdf-isearch-batch
     pdf-isearch-lazy
     pdf-isearch-match
     pdf-links-read-link
     pdf-occur-document-face
     pdf-occur-page-face
     pdf-view-pagemark-color
     pdf-view-rectangle
     pdf-view-region
     pe/directory-face
     pe/file-face
     peertube-channel-face
     peertube-date-face
     peertube-duration-face
     peertube-tags-face
     peertube-title-face
     peertube-views-face
     perject-current-face
     perject-mode-line-face
     perject-project-annotator-buffers
     perject-project-annotator-frames
     perject-project-annotator-main
     perject-project-annotator-tabs
     perject-sort-collections-current
     perject-sort-collections-other
     perject-sort-projects-current
     perject-sort-projects-other
     perject-tab-mode-line-face
     perl-heredoc
     perl-non-scalar-variable
     persp-face-lighter-buffer-not-in-persp
     persp-face-lighter-default
     persp-face-lighter-nil-persp
     persp-selected-face
     perspective-exwm-current-workspace-face
     perspective-exwm-cycle-current-face
     perspective-exwm-cycle-skip-face
     perspective-exwm-selected-pespective-face
     perspeen-selected-face
     perspeen-tab--header-line-active
     perspeen-tab--header-line-inactive
     perspeen-tab--powerline-inactive1
     pg-pbrpm-menu-input-face
     pg-pbrpm-multiple-selection-face
     phi-grep-heading-face
     phi-grep-line-number-face
     phi-grep-match-face
     phi-grep-modified-face
     phi-grep-overlay-face
     phi-replace-preview-face
     phi-search-failpart-face
     phi-search-match-face
     phi-search-selection-face
     php-$this
     php-$this-sigil
     php-arithmetic-op
     php-assignment-op
     php-builtin
     php-class
     php-class-declaration
     php-class-declaration-spec
     php-class-modifier
     php-comparison-op
     php-constant
     php-constant-assign
     php-control-structure
     php-doc-$this
     php-doc-$this-sigil
     php-doc-annotation-tag
     php-doc-class-name
     php-doc-variable-sigil
     php-errorcontrol-op
     php-function-call
     php-function-name
     php-import-declaration
     php-inc-dec-op
     php-keyword
     php-logical-op
     php-magical-constant
     php-method-call
     php-method-modifier
     php-namespace-declaration
     php-object-op
     php-operator
     php-paamayim-nekudotayim
     php-php-tag
     php-property-name
     php-static-method-call
     php-string
     php-string-op
     php-type
     php-variable-name
     php-variable-sigil
     php-visibility-modifier
     pianobar-mode-info-face
     pianobar-mode-input-face
     pianobar-mode-prompt-face
     pianobar-mode-time-face
     picpocket-dim-face
     picpocket-dir-tags-face
     picpocket-header-file
     picpocket-list-main-field
     pinboard-caption-face
     pinboard-read-face
     pinboard-unread-face
     pinot:search-item-link
     pinot:search-item-title
     pipewire-default-object
     pipewire-label
     pipewire-muted
     pipewire-volume
     pkgbuild-error-face
     plisp-abstract-class-face
     plisp-at-mark-face
     plisp-builtin-face
     plisp-comment-face
     plisp-global-constant-face
     plisp-global-variable-face
     plisp-local-function-face
     plisp-method-face
     plisp-normal-class-face
     plisp-transient-symbol-face
     plsense-direx:included-package-face
     plsense-direx:parent-package-face
     plsense-direx:regular-method-face
     plsense-direx:regular-package-face
     pocket-reader-archived
     pocket-reader-favorite-star
     pocket-reader-marked
     pocket-reader-unread
     poe-lootfilter-command-face
     poe-lootfilter-condition-face
     pomidor-break-face
     pomidor-date-face
     pomidor-overwork-face
     pomidor-skip-face
     pomidor-time-face
     pomidor-timer-face
     pomidor-work-face
     pona:face-item
     pona:face-subtitle
     pona:face-title
     pona:face-toolbar-button
     pophint:match-face
     pophint:pos-tip-face
     pophint:prompt-active-part-face
     pophint:prompt-bind-part-face
     pophint:tip-face
     poporg-edited-face
     popper-echo-area
     popper-echo-area-buried
     popper-echo-dispatch-hint
     popup-face
     popup-isearch-match
     popup-menu-face
     popup-menu-mouse-face
     popup-menu-selection-face
     popup-menu-summary-face
     popup-scroll-bar-background-face
     popup-scroll-bar-foreground-face
     popup-summary-face
     popup-tip-face
     posframe-tip-face
     powerline-active0
     powerline-active1
     powerline-active2
     powerline-evil-base-face
     powerline-evil-emacs-face
     powerline-evil-insert-face
     powerline-evil-motion-face
     powerline-evil-normal-face
     powerline-evil-operator-face
     powerline-evil-replace-face
     powerline-evil-visual-face
     powerline-inactive0
     powerline-inactive1
     powerline-inactive2
     powerthesaurus-definition-author
     powerthesaurus-definition-definition
     powerthesaurus-definition-part-of-speech
     powerthesaurus-definition-synonyms
     powerthesaurus-definition-usages
     powerthesaurus-sentence-author
     powerthesaurus-sentence-sentence
     pr-review-author-face
     pr-review-branch-face
     pr-review-button-face
     pr-review-error-state-face
     pr-review-hash-face
     pr-review-in-diff-pending-begin-face
     pr-review-in-diff-pending-end-face
     pr-review-in-diff-thread-title-face
     pr-review-info-state-face
     pr-review-label-face
     pr-review-link-face
     pr-review-listview-important-activity-face
     pr-review-listview-read-face
     pr-review-listview-status-face
     pr-review-listview-unimportant-activity-face
     pr-review-listview-unread-face
     pr-review-listview-unsubscribed-face
     pr-review-state-face
     pr-review-success-state-face
     pr-review-thread-diff-begin-face
     pr-review-thread-diff-end-face
     pr-review-thread-item-title-face
     pr-review-timestamp-face
     pr-review-title-face
     preproc-font-lock-preprocessor-background
     prescient-primary-highlight
     prescient-secondary-highlight
     prettier-inline-error
     pretty-hydra-toggle-off-face
     pretty-hydra-toggle-on-face
     preview-face
     preview-reference-face
     prism-level-0
     prism-level-0-comments
     prism-level-0-parens
     prism-level-0-strings
     prism-level-1
     prism-level-1-comments
     prism-level-1-parens
     prism-level-1-strings
     prism-level-10
     prism-level-10-comments
     prism-level-10-parens
     prism-level-10-strings
     prism-level-11
     prism-level-11-comments
     prism-level-11-parens
     prism-level-11-strings
     prism-level-12
     prism-level-12-comments
     prism-level-12-parens
     prism-level-12-strings
     prism-level-13
     prism-level-13-comments
     prism-level-13-parens
     prism-level-13-strings
     prism-level-14
     prism-level-14-comments
     prism-level-14-parens
     prism-level-14-strings
     prism-level-15
     prism-level-15-comments
     prism-level-15-parens
     prism-level-15-strings
     prism-level-2
     prism-level-2-comments
     prism-level-2-parens
     prism-level-2-strings
     prism-level-3
     prism-level-3-comments
     prism-level-3-parens
     prism-level-3-strings
     prism-level-4
     prism-level-4-comments
     prism-level-4-parens
     prism-level-4-strings
     prism-level-5
     prism-level-5-comments
     prism-level-5-parens
     prism-level-5-strings
     prism-level-6
     prism-level-6-comments
     prism-level-6-parens
     prism-level-6-strings
     prism-level-7
     prism-level-7-comments
     prism-level-7-parens
     prism-level-7-strings
     prism-level-8
     prism-level-8-comments
     prism-level-8-parens
     prism-level-8-strings
     prism-level-9
     prism-level-9-comments
     prism-level-9-parens
     prism-level-9-strings
     private-comments-face
     proced-cpu
     proced-emacs-pid
     proced-executable
     proced-interruptible-sleep-status-code
     proced-mark
     proced-marked
     proced-mem
     proced-memory-high-usage
     proced-memory-low-usage
     proced-memory-medium-usage
     proced-pgrp
     proced-pid
     proced-ppid
     proced-run-status-code
     proced-sess
     proced-session-leader-pid
     proced-sort-header
     proced-time-colon
     proced-uninterruptible-sleep-status-code
     proced-user
     prodigy-green-face
     prodigy-red-face
     prodigy-yellow-face
     project-mode-line-tag-project-tag
     projectile-rails-keyword-face
     projmake-errline
     projmake-notify-err
     projmake-notify-normal
     projmake-warnline
     prolog-builtin-face
     prolog-exception-face
     prolog-exit-face
     prolog-redo-face
     prolog-warning-face
     proof-active-area-face
     proof-boring-face
     proof-command-mouse-highlight-face
     proof-debug-message-face
     proof-declaration-name-face
     proof-eager-annotation-face
     proof-error-face
     proof-highlight-dependency-face
     proof-highlight-dependent-face
     proof-locked-face
     proof-mouse-highlight-face
     proof-omitted-proof-face
     proof-queue-face
     proof-region-mouse-highlight-face
     proof-script-highlight-error-face
     proof-script-sticky-error-face
     proof-tacticals-name-face
     proof-tactics-name-face
     proof-warning-face
     ptemplate-type-face
     pueue-environment-variable
     pueue-error
     pueue-label
     pueue-success
     pulsar-blue
     pulsar-cyan
     pulsar-generic
     pulsar-green
     pulsar-magenta
     pulsar-red
     pulsar-yellow
     pulse-highlight-face
     pulse-highlight-start-face
     puppet-escape-sequence
     puppet-regular-expression-literal
     py-builtins-face
     py-class-name-face
     py-decorators-face
     py-def-class-face
     py-def-face
     py-exception-name-face
     py-import-from-face
     py-number-face
     py-object-reference-face
     py-pseudo-keyword-face
     py-test-*mode-line-green-face*
     py-test-*mode-line-inactive-green-face*
     py-test-*mode-line-inactive-red-face*
     py-test-*mode-line-red-face*
     py-try-if-face
     py-variable-name-face
     py-XXX-tag-face
     pygn-mode-annotation-face
     pygn-mode-inline-comment-face
     pygn-mode-invalid-face
     pygn-mode-move-face
     pygn-mode-move-number-face
     pygn-mode-recursive-variation-annotation-face
     pygn-mode-recursive-variation-delimiter-face
     pygn-mode-recursive-variation-inline-comment-face
     pygn-mode-recursive-variation-move-face
     pygn-mode-recursive-variation-move-number-face
     pygn-mode-recursive-variation-rest-of-line-comment-face
     pygn-mode-rest-of-line-comment-face
     pygn-mode-result-face
     pygn-mode-tagpair-bracket-face
     pygn-mode-tagpair-key-face
     pygn-mode-tagpair-value-face
     pygn-mode-twic-section-comment-face
     pygn-mode-variation-annotation-face
     pygn-mode-variation-delimiter-face
     pygn-mode-variation-inline-comment-face
     pygn-mode-variation-move-face
     pygn-mode-variation-move-number-face
     pygn-mode-variation-rest-of-line-comment-face
     pyim-page
     pyim-page-border
     pyim-page-selection
     pyim-preview-face
     python-cell-cellbreak-face
     python-cell-highlight-face
     python-coverage-overlay-missing
     python-coverage-overlay-missing-outdated
     python-coverage-overlay-partial
     python-coverage-overlay-partial-outdated
     python-django-face-django-version
     python-django-face-header
     python-django-face-path
     python-django-face-project-root
     python-django-face-settings-module
     python-django-face-title
     python-django-face-virtualenv-path
     python-test-description
     python-test-error
     python-test-info
     python-x-modeline-error-face
     python-x-modeline-exited-face
     python-x-modeline-ready-face
     python-x-modeline-running-face
     qrencode-face
     quack-about-face
     quack-about-title-face
     quack-banner-face
     quack-pltfile-dir-face
     quack-pltfile-file-face
     quack-pltfile-prologue-face
     quack-pltish-class-defn-face
     quack-pltish-colon-keyword-face
     quack-pltish-comment-face
     quack-pltish-defn-face
     quack-pltish-keyword-face
     quack-pltish-module-defn-face
     quack-pltish-paren-face
     quack-pltish-selfeval-face
     quack-smallprint-face
     quack-threesemi-h1-face
     quack-threesemi-h2-face
     quack-threesemi-h3-face
     quack-threesemi-semi-face
     quack-threesemi-text-face
     quakec-builtin-face
     quakec-comment-face
     quakec-constant-face
     quakec-function-name-face
     quakec-keyword-face
     quakec-preprocessor-face
     quakec-progs-fname-face
     quakec-progs-output-fname-face
     quakec-progs-output-path-face
     quakec-progs-path-face
     quakec-type-face
     quakec-variable-name-face
     quasi-monochrome-error-face
     quasi-monochrome-ok-face
     quasi-monochrome-warning-face
     query-replace
     quick-peek-background-face
     quick-peek-border-face
     quick-peek-padding-face
     quickref-label-face
     quickref-note-face
     quickref-separator-face
     quiz-question-face
     quiz-question-number-face
     racer-help-heading-face
     racer-tooltip
     racket-debug-break-face
     racket-debug-breakpoint-face
     racket-debug-locals-face
     racket-debug-result-face
     racket-doc-link-face
     racket-doc-litchar-face
     racket-doc-output-face
     racket-ext-link-face
     racket-here-string-face
     racket-keyword-argument-face
     racket-logger-config-face
     racket-logger-debug-face
     racket-logger-error-face
     racket-logger-fatal-face
     racket-logger-info-face
     racket-logger-topic-face
     racket-logger-warning-face
     racket-paren-face
     racket-reader-quoted-symbol-face
     racket-reader-syntax-quoted-symbol-face
     racket-repl-error-label
     racket-repl-error-location
     racket-repl-error-message
     racket-repl-message
     racket-repl-prompt
     racket-repl-stderr
     racket-repl-stdout
     racket-repl-value
     racket-selfeval-face
     racket-xp-binding-import-face
     racket-xp-binding-import-use-face
     racket-xp-binding-lang-face
     racket-xp-binding-lang-use-face
     racket-xp-binding-local-face
     racket-xp-binding-local-use-face
     racket-xp-def-face
     racket-xp-error-face
     racket-xp-tail-position-face
     racket-xp-tail-target-face
     racket-xp-unused-face
     racket-xp-use-face
     rainbow-blocks-depth-1-face
     rainbow-blocks-depth-2-face
     rainbow-blocks-depth-3-face
     rainbow-blocks-depth-4-face
     rainbow-blocks-depth-5-face
     rainbow-blocks-depth-6-face
     rainbow-blocks-depth-7-face
     rainbow-blocks-depth-8-face
     rainbow-blocks-depth-9-face
     rainbow-blocks-unmatched-face
     rainbow-delimiters-base-error-face
     rainbow-delimiters-base-face
     rainbow-delimiters-depth-1-face
     rainbow-delimiters-depth-2-face
     rainbow-delimiters-depth-3-face
     rainbow-delimiters-depth-4-face
     rainbow-delimiters-depth-5-face
     rainbow-delimiters-depth-6-face
     rainbow-delimiters-depth-7-face
     rainbow-delimiters-depth-8-face
     rainbow-delimiters-depth-9-face
     rainbow-delimiters-mismatched-face
     rainbow-delimiters-unmatched-face
     rainbow-identifiers-identifier-1
     rainbow-identifiers-identifier-10
     rainbow-identifiers-identifier-11
     rainbow-identifiers-identifier-12
     rainbow-identifiers-identifier-13
     rainbow-identifiers-identifier-14
     rainbow-identifiers-identifier-15
     rainbow-identifiers-identifier-2
     rainbow-identifiers-identifier-3
     rainbow-identifiers-identifier-4
     rainbow-identifiers-identifier-5
     rainbow-identifiers-identifier-6
     rainbow-identifiers-identifier-7
     rainbow-identifiers-identifier-8
     rainbow-identifiers-identifier-9
     raku-comment
     raku-conditional
     raku-declare
     raku-exception
     raku-flow-control
     raku-identifier
     raku-include
     raku-label
     raku-loop
     raku-number
     raku-number-addition
     raku-operator
     raku-phaser
     raku-pragma
     raku-scope
     raku-sigil
     raku-string
     raku-twigil
     raku-type
     raku-type-constraint
     raku-type-property
     raku-var-name
     raku-var-package
     raku-version
     rats-tests-failed
     rats-tests-mixed
     rats-tests-successful
     rbenv-active-ruby-face
     rcirc-bridged-nick
     rcirc-bright-nick
     rcirc-dim-nick
     rcirc-keyword
     rcirc-monospace-text
     rcirc-my-nick
     rcirc-nick-in-message
     rcirc-nick-in-message-full-line
     rcirc-other-nick
     rcirc-prompt
     rcirc-server
     rcirc-server-prefix
     rcirc-timestamp
     rcirc-track-keyword
     rcirc-track-nick
     rcirc-url
     read-aloud-text-face
     read-multiple-choice-face
     realgud-backtrace-number
     realgud-bp-disabled-face
     realgud-bp-enabled-face
     realgud-bp-line-disabled-face
     realgud-bp-line-enabled-face
     realgud-debugger-not-running
     realgud-debugger-running
     realgud-file-name
     realgud-line-number
     realgud-overlay-arrow1
     realgud-overlay-arrow2
     realgud-overlay-arrow3
     reb-match-0
     reb-match-1
     reb-match-2
     reb-match-3
     reb-regexp-grouping-backslash
     reb-regexp-grouping-construct
     rebox-disabled-style-face
     rebox-style-chevron-face
     rebox-style-face
     rectangle-preview
     recursion-indicator-completion
     recursion-indicator-default
     recursion-indicator-prompt
     recursion-indicator-suspend
     redprl-declaration-keyword-face
     redprl-expression-keyword-face
     redprl-expression-symbol-face
     redprl-metavar-face
     redprl-number-face
     redprl-sequent-keyword-face
     redprl-sequent-symbol-face
     redprl-sort-face
     redprl-tactic-keyword-face
     redprl-tactic-symbol-face
     redshank-highlight-face
     redtt-declaration-keyword-face
     redtt-expression-keyword-face
     redtt-expression-symbol-face
     redtt-number-face
     redtt-sequent-keyword-face
     redtt-sequent-symbol-face
     redtt-tactic-keyword-face
     redtt-tactic-symbol-face
     refine-index-face
     regex-tool-matched-face
     region
     region-occurrences-highlighter-face
     repo-font-lock-staged-change-face
     repo-font-lock-unstaged-change-face
     repo-font-lock-untracked-change-face
     resize-window-background
     restclient-file-upload-face
     restclient-header-name-face
     restclient-header-value-face
     restclient-method-face
     restclient-request-hook-args-face
     restclient-request-hook-face
     restclient-request-hook-name-face
     restclient-url-face
     restclient-variable-elisp-face
     restclient-variable-multiline-face
     restclient-variable-name-face
     restclient-variable-string-face
     restclient-variable-usage-face
     reverso-definition-face
     reverso-error-face
     reverso-heading-face
     reverso-highlight-face
     reverso-history-item-face
     reverso-keyword-face
     review-mode-balloon-face
     review-mode-bold-face
     review-mode-bracket-face
     review-mode-comment-face
     review-mode-double-prime-face
     review-mode-em-dash-face
     review-mode-en-dash-face
     review-mode-figure-dash-face
     review-mode-fullwidth-hyphen-minus-face
     review-mode-header1-face
     review-mode-header2-face
     review-mode-header3-face
     review-mode-header4-face
     review-mode-header5-face
     review-mode-hide-face
     review-mode-horizontal-bar-face
     review-mode-hyphen-face
     review-mode-italic-face
     review-mode-left-quote-face
     review-mode-minus-sign-face
     review-mode-nothide-face
     review-mode-ref-face
     review-mode-reversed-quote-face
     review-mode-right-quote-face
     review-mode-title-face
     review-mode-underline-face
     review-mode-underlinebold-face
     rfc-mode-browser-ref-face
     rfc-mode-browser-status-face
     rfc-mode-browser-title-face
     rfc-mode-browser-title-obsolete-face
     rfc-mode-document-footer-face
     rfc-mode-document-header-face
     rfc-mode-document-section-title-face
     rg-column-number-face
     rg-context-face
     rg-error-face
     rg-file-tag-face
     rg-filename-face
     rg-info-face
     rg-line-number-face
     rg-literal-face
     rg-match-face
     rg-match-position-face
     rg-regexp-face
     rg-toggle-off-face
     rg-toggle-on-face
     rg-warning-face
     rii-button-apply-face
     rii-button-face
     rime-candidate-num-face
     rime-code-face
     rime-comment-face
     rime-cursor-face
     rime-default-face
     rime-highlight-candidate-face
     rime-indicator-dim-face
     rime-indicator-face
     rime-preedit-face
     ripgrep-context-face
     ripgrep-error-face
     ripgrep-hit-face
     ripgrep-match-face
     rjsx-attr
     rjsx-tag
     rjsx-tag-bracket-face
     rjsx-text
     rlk-face-average-stat
     rlk-face-bad-stat
     rlk-face-default
     rlk-face-door
     rlk-face-fireball
     rlk-face-fractalball
     rlk-face-gnome
     rlk-face-good-stat
     rlk-face-ground
     rlk-face-hero
     rlk-face-human
     rlk-face-rat
     rlk-face-shadow
     rlk-face-stairs
     rlk-face-title
     rlk-face-troll
     rlk-face-wall
     rmail-header-name
     rmail-highlight
     rmsbolt-current-line-face
     rng-error
     robot-log-builtin-keyword
     robot-log-debug-level
     robot-log-error-level
     robot-log-fail-level
     robot-log-info-level
     robot-log-keyword-arguments
     robot-log-keyword-end
     robot-log-keyword-exit-status
     robot-log-keyword-start
     robot-log-none-level
     robot-log-skip-level
     robot-log-trace-level
     robot-log-warning-level
     rom-party-chosen-word
     rom-party-game-over
     rom-party-health
     rom-party-input-prompt
     rom-party-unused-letter
     rom-party-used-letter
     ropgadget-address
     ropgadget-address-separator
     ropgadget-argument
     ropgadget-argument-separator
     ropgadget-instruction-separator
     ropgadget-mnemonic
     rpm-spec-dir-face
     rpm-spec-doc-face
     rpm-spec-ghost-face
     rpm-spec-macro-face
     rpm-spec-obsolete-tag-face
     rpm-spec-package-face
     rpm-spec-section-face
     rpm-spec-tag-face
     rpm-spec-var-face
     rst-adornment
     rst-block
     rst-comment
     rst-definition
     rst-directive
     rst-emphasis1
     rst-emphasis2
     rst-external
     rst-level-1
     rst-level-2
     rst-level-3
     rst-level-4
     rst-level-5
     rst-level-6
     rst-literal
     rst-reference
     rst-transition
     rtags-argument-face
     rtags-context
     rtags-current-line
     rtags-errline
     rtags-fixitline
     rtags-path
     rtags-skippedline
     rtags-warnline
     rubik-blue
     rubik-green
     rubik-orange
     rubik-red
     rubik-white
     rubik-yellow
     ruler-mode-column-number
     ruler-mode-comment-column
     ruler-mode-current-column
     ruler-mode-default
     ruler-mode-fill-column
     ruler-mode-fringes
     ruler-mode-goal-column
     ruler-mode-margins
     ruler-mode-pad
     ruler-mode-tab-stop
     runner-label-face
     runtests-minibuffer-error
     runtests-minibuffer-success
     rust-ampersand-face
     rust-builtin-formatting-macro
     rust-question-mark
     rust-string-interpolation
     rust-unsafe
     rustic-cargo-outdated
     rustic-cargo-outdated-upgrade
     rustic-compilation-column
     rustic-compilation-error
     rustic-compilation-info
     rustic-compilation-line
     rustic-compilation-warning
     rustic-errno-face
     rustic-message
     rustic-popup-key
     rustic-popup-section
     rustic-racer-help-heading
     rustic-racer-tooltip
     rxt-highlight-face
     salt-mode-environment-face
     salt-mode-file-source-face
     salt-mode-keyword-face
     salt-mode-match-type-face
     salt-mode-orch-keyword-face
     salt-mode-requisite-face
     salt-mode-state-function-face
     salt-mode-state-id-face
     salt-mode-state-keyword-face
     samskritam-word-face-1
     samskritam-word-face-2
     sauron-event-handled-face
     sauron-header-face
     sauron-highlight1-face
     sauron-highlight2-face
     sauron-highlight3-face
     sauron-message-face
     sauron-origin-face
     sauron-priority-face
     sauron-timestamp-face
     sayid-depth-1-face
     sayid-depth-10-face
     sayid-depth-2-face
     sayid-depth-3-face
     sayid-depth-4-face
     sayid-depth-5-face
     sayid-depth-6-face
     sayid-depth-7-face
     sayid-depth-8-face
     sayid-depth-9-face
     sayid-float-face
     sayid-int-face
     sayid-keyword-face
     sayid-string-face
     sayid-symbol-face
     sbt:error
     sbt:info
     sbt:warning
     scala-font-lock:abstract-face
     scala-font-lock:final-face
     scala-font-lock:implicit-face
     scala-font-lock:lazy-face
     scala-font-lock:override-face
     scala-font-lock:private-face
     scala-font-lock:protected-face
     scala-font-lock:sealed-face
     scala-font-lock:var-face
     scala-font-lock:var-keyword-face
     scopeline-face
     scroll-bar
     scrollkeeper-guideline-highlight
     scrollkeeper-guideline-thinline
     scrollkeeper-guideline-underline
     sculpture-themes-dark-elfeed-star-face
     sculpture-themes-dark-elfeed-title-1
     sculpture-themes-dark-elfeed-title-2
     sculpture-themes-dark-elfeed-title-3
     sculpture-themes-dark-elfeed-title-4
     sculpture-themes-dark-elfeed-title-5
     sculpture-themes-dark-elfeed-title-6
     sculpture-themes-dark-elfeed-title-7
     sculpture-themes-dark-elfeed-title-8
     sculpture-themes-dark-head-outline-1
     sculpture-themes-dark-head-outline-2
     sculpture-themes-dark-head-outline-3
     sculpture-themes-dark-head-outline-4
     sculpture-themes-dark-head-outline-5
     sculpture-themes-dark-head-outline-6
     sculpture-themes-dark-head-outline-7
     sculpture-themes-dark-head-outline-8
     sculpture-themes-dark-modeline-line
     sculpture-themes-dark-modeline-line-i
     sculpture-themes-dark-modeline-mode
     sculpture-themes-dark-modeline-percent
     sculpture-themes-dark-modeline-percent-i
     sculpture-themes-dark-modeline-workspace
     sculpture-themes-dark-variable-pitch-italic
     sculpture-themes-light-elfeed-star-face
     sculpture-themes-light-elfeed-title-1
     sculpture-themes-light-elfeed-title-2
     sculpture-themes-light-elfeed-title-3
     sculpture-themes-light-elfeed-title-4
     sculpture-themes-light-elfeed-title-5
     sculpture-themes-light-elfeed-title-6
     sculpture-themes-light-elfeed-title-7
     sculpture-themes-light-elfeed-title-8
     sculpture-themes-light-head-outline-1
     sculpture-themes-light-head-outline-2
     sculpture-themes-light-head-outline-3
     sculpture-themes-light-head-outline-4
     sculpture-themes-light-head-outline-5
     sculpture-themes-light-head-outline-6
     sculpture-themes-light-head-outline-7
     sculpture-themes-light-head-outline-8
     sculpture-themes-light-modeline-mode
     sculpture-themes-light-modeline-percent
     sculpture-themes-light-modeline-workspace
     sculpture-themes-light-variable-pitch-italic
     sculpture-themes-pastel-elfeed-star-face
     sculpture-themes-pastel-elfeed-title-1
     sculpture-themes-pastel-elfeed-title-2
     sculpture-themes-pastel-elfeed-title-3
     sculpture-themes-pastel-elfeed-title-4
     sculpture-themes-pastel-elfeed-title-5
     sculpture-themes-pastel-elfeed-title-6
     sculpture-themes-pastel-elfeed-title-7
     sculpture-themes-pastel-elfeed-title-8
     sculpture-themes-pastel-head-outline-1
     sculpture-themes-pastel-head-outline-2
     sculpture-themes-pastel-head-outline-3
     sculpture-themes-pastel-head-outline-4
     sculpture-themes-pastel-head-outline-5
     sculpture-themes-pastel-head-outline-6
     sculpture-themes-pastel-head-outline-7
     sculpture-themes-pastel-head-outline-8
     sculpture-themes-pastel-modeline-line
     sculpture-themes-pastel-modeline-mode
     sculpture-themes-pastel-modeline-percent
     sculpture-themes-pastel-modeline-workspace
     sculpture-themes-pastel-variable-pitch-italic
     sdlang-mode-attribute-face
     sdlang-mode-boolean-face
     sdlang-mode-data-face
     sdlang-mode-date-face
     sdlang-mode-error-face
     sdlang-mode-namespace-face
     sdlang-mode-number-face
     sdlang-mode-punctuation-face
     sdlang-mode-string-face
     sdlang-mode-tag-face
     searchq-file-face
     searchq-highlight-face
     searchq-linum-face
     secondary-selection
     sekka-guide-face
     selectrum-completion-annotation
     selectrum-completion-docsig
     selectrum-current-candidate
     selectrum-group-separator
     selectrum-group-title
     selectrum-mouse-highlight
     selectrum-quick-keys-highlight
     selectrum-quick-keys-match
     semantic-complete-inline-face
     semantic-decoration-on-fileless-includes
     semantic-decoration-on-includes
     semantic-decoration-on-private-members-face
     semantic-decoration-on-protected-members-face
     semantic-decoration-on-unknown-includes
     semantic-decoration-on-unparsed-includes
     semantic-highlight-edits-face
     semantic-highlight-func-current-tag-face
     semantic-idle-symbol-highlight
     semantic-tag-boundary-face
     semantic-unmatched-syntax-face
     senator-momentary-highlight-face
     separator-line
     sequed-base-a
     sequed-base-c
     sequed-base-g
     sequed-base-t
     seriestracker-finished-series
     seriestracker-season
     seriestracker-series
     seriestracker-watched
     sesman-browser-button-face
     sesman-browser-highligh-face
     sesman-buffer-face
     sesman-directory-face
     sesman-project-face
     sfz-header-face
     sfz-number-face
     sfz-opcode-face
     sfz-string-face
     sfz-unrecognized-opcode-face
     sgml-namespace
     sh-escaped-newline
     sh-heredoc
     sh-quoted-exec
     shadow
     shampoo-method-name
     shampoo-selected-list-item
     shampoo-smalltalk-version
     shell-highlight-undef-alias-face
     shell-highlight-undef-defined-face
     shell-highlight-undef-undefined-face
     shelldoc-short-help-emphasis-face
     shelldoc-short-help-face
     shm-current-face
     shm-evaporate-face
     shm-quarantine-face
     shortdoc-heading
     shortdoc-section
     show-paren-match
     show-paren-match-expression
     show-paren-mismatch
     show-tabs-space
     show-tabs-tab
     showcss/breadcrumb-id-and-class-face
     showcss/breadcrumb-seperator-face
     showcss/breadcrumb-tag-face
     showcss/header-face
     showcss/header-filepath-face
     showcss/region-face
     showcss/source-region-face
     showtip-face
     shr-abbreviation
     shr-code
     shr-h1
     shr-h2
     shr-h3
     shr-h4
     shr-h5
     shr-h6
     shr-link
     shr-mark
     shr-selected-link
     shr-strike-through
     shr-sup
     shr-text
     shrface-code
     shrface-description-list-term-face
     shrface-figure
     shrface-h1-face
     shrface-h2-face
     shrface-h3-face
     shrface-h4-face
     shrface-h5-face
     shrface-h6-face
     shrface-highlight
     shrface-href-face
     shrface-href-file-face
     shrface-href-ftp-face
     shrface-href-http-face
     shrface-href-https-face
     shrface-href-mailto-face
     shrface-href-other-face
     shrface-item-bullet-face
     shrface-item-number-face
     shrface-links-mouse-face
     shrface-links-title-face
     shrface-links-url-face
     shrface-verbatim
     side-hustle
     side-notes
     sideline-backend
     sideline-blame
     sideline-default
     sideline-lsp-code-action
     sieve-action-commands
     sieve-control-commands
     sieve-tagged-arguments
     sieve-test-commands
     sift-hit-face
     sift-match-face
     simple-modeline-space
     simple-modeline-status-error
     simple-modeline-status-info
     simple-modeline-status-modified
     simple-modeline-status-success
     simple-modeline-status-warning
     simple-modeline-unimportant
     simple-mpc-current-track-face
     simple-mpc-main-headers
     simple-mpc-main-name
     simple-rtm-list
     simple-rtm-note-title
     simple-rtm-smart-list
     simple-rtm-task
     simple-rtm-task-duedate
     simple-rtm-task-duedate-due
     simple-rtm-task-location
     simple-rtm-task-priority-1
     simple-rtm-task-priority-2
     simple-rtm-task-priority-3
     simple-rtm-task-tag
     simple-rtm-task-time-estimate
     simple-rtm-task-url
     sis-inline-face
     skerrick-result-overlay-face
     skewer-error-face
     skewer-repl-log-face
     skype--face-my-message
     skype--face-my-time-field
     skype--face-optional-field
     skype--face-other-message
     skype--face-other-time-field
     skype--face-user-field
     slack-all-thread-buffer-thread-header-face
     slack-attachment-field-title
     slack-attachment-footer
     slack-attachment-header
     slack-attachment-pad
     slack-button-block-element-face
     slack-button-danger-block-element-face
     slack-button-primary-block-element-face
     slack-channel-button-face
     slack-date-picker-block-element-face
     slack-dialog-cancel-button-face
     slack-dialog-element-error-face
     slack-dialog-element-hint-face
     slack-dialog-element-label-face
     slack-dialog-element-placeholder-face
     slack-dialog-select-element-input-face
     slack-dialog-submit-button-face
     slack-dialog-title-face
     slack-message-action-danger-face
     slack-message-action-face
     slack-message-action-primary-face
     slack-message-attachment-preview-header-face
     slack-message-deleted-face
     slack-message-mention-face
     slack-message-mention-keyword-face
     slack-message-mention-me-face
     slack-message-output-header
     slack-message-output-reaction
     slack-message-output-text
     slack-modeline-channel-has-unreads-face
     slack-modeline-has-unreads-face
     slack-modeline-thread-has-unreads-face
     slack-mrkdwn-blockquote-face
     slack-mrkdwn-bold-face
     slack-mrkdwn-code-block-face
     slack-mrkdwn-code-face
     slack-mrkdwn-italic-face
     slack-mrkdwn-list-face
     slack-mrkdwn-strike-face
     slack-new-message-marker-face
     slack-overflow-block-element-face
     slack-preview-face
     slack-profile-image-face
     slack-room-info-section-label-face
     slack-room-info-section-title-face
     slack-room-info-title-face
     slack-room-info-title-room-name-face
     slack-room-unread-face
     slack-search-result-message-header-face
     slack-search-result-message-username-face
     slack-select-block-element-face
     slack-user-active-face
     slack-user-dnd-face
     slack-user-profile-header-face
     slack-user-profile-property-name-face
     sldb-catch-tag-face
     sldb-condition-face
     sldb-detailed-frame-line-face
     sldb-frame-label-face
     sldb-frame-line-face
     sldb-local-name-face
     sldb-local-value-face
     sldb-non-restartable-frame-line-face
     sldb-reference-face
     sldb-restart-face
     sldb-restart-number-face
     sldb-restart-type-face
     sldb-restartable-frame-line-face
     sldb-section-face
     sldb-topline-face
     slime-apropos-label
     slime-apropos-symbol
     slime-early-deprecation-warning-face
     slime-error-face
     slime-final-deprecation-warning-face
     slime-highlight-edits-face
     slime-highlight-face
     slime-inspector-action-face
     slime-inspector-label-face
     slime-inspector-topline-face
     slime-inspector-type-face
     slime-inspector-value-face
     slime-late-deprecation-warning-face
     slime-note-face
     slime-reader-conditional-face
     slime-repl-input-face
     slime-repl-inputed-output-face
     slime-repl-output-face
     slime-repl-output-mouseover-face
     slime-repl-prompt-face
     slime-repl-result-face
     slime-style-warning-face
     slime-warning-face
     slstats-caption
     slurm-script-directives
     sly-action-face
     sly-apropos-label
     sly-apropos-symbol
     sly-asdf-flymake-base-error
     sly-asdf-flymake-base-note
     sly-asdf-flymake-base-warning
     sly-db-catch-tag-face
     sly-db-condition-face
     sly-db-frame-label-face
     sly-db-frame-line-face
     sly-db-local-name-face
     sly-db-non-restartable-frame-line-face
     sly-db-restart-face
     sly-db-restart-number-face
     sly-db-restartable-frame-line-face
     sly-db-section-face
     sly-db-topline-face
     sly-error-face
     sly-mode-line
     sly-mrepl-note-face
     sly-mrepl-output-face
     sly-mrepl-prompt-face
     sly-note-face
     sly-overlay-result-overlay-face
     sly-part-button-face
     sly-quicklisp-indicator-face
     sly-reader-conditional-face
     sly-stickers-armed-face
     sly-stickers-empty-face
     sly-stickers-exited-non-locally-face
     sly-stickers-placed-face
     sly-stickers-recordings-face
     sly-style-warning-face
     sly-warning-face
     smblog-date-face
     smblog-file-face
     smblog-fun-face
     smblog-hilight-msg-face
     smblog-hl-1-face
     smblog-hl-2-face
     smblog-hl-3-face
     smblog-hl-4-face
     smblog-metadata-face
     smblog-pid-face
     smblog-reqs-error-face
     smblog-reqs-op-face
     smblog-reqs-success-face
     smerge-base
     smerge-lower
     smerge-markers
     smerge-refined-added
     smerge-refined-changed
     smerge-refined-removed
     smerge-upper
     smilefjes-face
     sml-modeline-end-face
     sml-modeline-vis-face
     sml-yacc-bnf-face
     sml/charging
     sml/client
     sml/col-number
     sml/discharging
     sml/filename
     sml/folder
     sml/git
     sml/global
     sml/line-number
     sml/minor-modes
     sml/modes
     sml/modified
     sml/mule-info
     sml/name-filling
     sml/not-modified
     sml/numbers-separator
     sml/outside-modified
     sml/position-percentage
     sml/prefix
     sml/process
     sml/projectile
     sml/read-only
     sml/remote
     sml/sudo
     sml/time
     sml/vc
     sml/vc-edited
     sniem-edit-content-face
     sniem-motion-hint-face
     snitch--log-filter-active-face
     snitch--log-filter-face
     snow-flake
     so-long-mode-line-active
     so-long-mode-line-inactive
     soccer-face-draw
     soccer-face-fixtures
     soccer-face-local-time
     soccer-face-loss
     soccer-face-scorecard-header
     soccer-face-time-to-kickoff
     soccer-face-win
     socyl-hit-face
     socyl-match-face
     solaire-default-face
     solaire-fringe-face
     solaire-header-line-face
     solaire-hl-line-face
     solaire-line-number-face
     solaire-mode-line-active-face
     solaire-mode-line-face
     solaire-mode-line-inactive-face
     solaire-org-hide-face
     solaire-region-face
     sonic-pi-error-marker
     sp-pair-overlay-face
     sp-show-pair-enclosing
     sp-show-pair-match-content-face
     sp-show-pair-match-face
     sp-show-pair-mismatch-face
     sp-wrap-overlay-closing-pair
     sp-wrap-overlay-face
     sp-wrap-overlay-opening-pair
     sp-wrap-tag-overlay-face
     spacebar-active
     spacebar-inactive
     spacebar-persp
     spaceline-all-the-icons-info-face
     spaceline-all-the-icons-sunrise-face
     spaceline-all-the-icons-sunset-face
     spaceline-evil-emacs
     spaceline-evil-insert
     spaceline-evil-motion
     spaceline-evil-normal
     spaceline-evil-replace
     spaceline-evil-visual
     spaceline-flycheck-error
     spaceline-flycheck-info
     spaceline-flycheck-warning
     spaceline-highlight-face
     spaceline-modified
     spaceline-python-venv
     spaceline-read-only
     spaceline-unmodified
     spam
     speech-tagger-loading-text
     speed-type-correct
     speed-type-default
     speed-type-mistake
     speedbar-button-face
     speedbar-directory-face
     speedbar-file-face
     speedbar-highlight-face
     speedbar-selected-face
     speedbar-separator-face
     speedbar-tag-face
     spell-fu-incorrect-face
     sphinx-code-block-face
     spice-analysis-face
     spice-instance-name-face
     spice-layla-function-name-face
     spice-model-name-face
     spice-title-face
     spiff-added
     spiff-changed-face
     spiff-file-header-face
     spiff-indicator-changed
     spray-accent-face
     spray-base-face
     srecode-field-face
     srecode-separator-face
     ssh-tunnels-name
     standoff-xml-glyph
     standoff-xml-ref
     starhugger-inline-suggestion-face
     stem-reading-delight-face
     stem-reading-highlight-face
     stgit-applied-patch-face
     stgit-branch-name-face
     stgit-committed-patch-face
     stgit-description-face
     stgit-file-permission-face
     stgit-ignored-file-face
     stgit-index-work-tree-title-face
     stgit-modified-file-face
     stgit-top-patch-face
     stgit-unapplied-patch-face
     stgit-unknown-file-face
     stgit-unmerged-file-face
     sticky-shell-shorten-header-ellipsis
     string-edit-prompt
     stripe-highlight
     stripe-hl-line
     stripes
     strokes-char
     subed-ass-text-face
     subed-id-face
     subed-srt-text-face
     subed-time-face
     subed-time-separator-face
     subed-vtt-text-face
     subed-word-data-face
     subscript
     success
     sudo-edit-header-face
     sudoku-autovalue-face
     sudoku-face
     sudoku-orig-value-face
     sudoku-value-face
     sudoku-value-pencil-1-face
     sudoku-value-pencil-2-face
     suggest-heading
     suggestion-box-face
     sunshine-forecast-date-face
     sunshine-forecast-day-divider-face
     sunshine-forecast-headline-face
     superscript
     svg-lib-button-active-face
     svg-lib-button-hover-face
     svg-lib-button-press-face
     svg-tag-default-face
     swap-regions-selection
     sweeprolog-arity
     sweeprolog-around-syntax-error
     sweeprolog-atom
     sweeprolog-autoload
     sweeprolog-body
     sweeprolog-breakpoint
     sweeprolog-built-in
     sweeprolog-chars
     sweeprolog-chr-type
     sweeprolog-class
     sweeprolog-clause
     sweeprolog-codes
     sweeprolog-comment
     sweeprolog-constraint
     sweeprolog-control
     sweeprolog-dcg-string
     sweeprolog-debug-prefix
     sweeprolog-debug-topic
     sweeprolog-declaration-option
     sweeprolog-delimiter
     sweeprolog-deprecated
     sweeprolog-dict-function
     sweeprolog-dict-key
     sweeprolog-dict-return-op
     sweeprolog-dict-sep
     sweeprolog-dict-tag
     sweeprolog-directive
     sweeprolog-dynamic
     sweeprolog-eldoc-argument-highlight
     sweeprolog-error
     sweeprolog-error-prefix
     sweeprolog-expanded
     sweeprolog-ext-quant
     sweeprolog-extern
     sweeprolog-file
     sweeprolog-file-no-depend
     sweeprolog-flag-name
     sweeprolog-float
     sweeprolog-foreign
     sweeprolog-fullstop
     sweeprolog-func-dot
     sweeprolog-function
     sweeprolog-functor
     sweeprolog-global
     sweeprolog-goal
     sweeprolog-grammar-rule
     sweeprolog-head-built-in
     sweeprolog-head-constraint
     sweeprolog-head-def-iso
     sweeprolog-head-def-swi
     sweeprolog-head-dynamic
     sweeprolog-head-exported
     sweeprolog-head-extern
     sweeprolog-head-hook
     sweeprolog-head-imported
     sweeprolog-head-iso
     sweeprolog-head-local
     sweeprolog-head-meta
     sweeprolog-head-multifile
     sweeprolog-head-public
     sweeprolog-head-test
     sweeprolog-head-undefined
     sweeprolog-head-unreferenced
     sweeprolog-hole
     sweeprolog-hook
     sweeprolog-html-attribute
     sweeprolog-html-call
     sweeprolog-identifier
     sweeprolog-imported
     sweeprolog-info-prefix
     sweeprolog-instantiation-error
     sweeprolog-int
     sweeprolog-keyword
     sweeprolog-local
     sweeprolog-macro
     sweeprolog-meta
     sweeprolog-meta-spec
     sweeprolog-method
     sweeprolog-module
     sweeprolog-multifile
     sweeprolog-neck
     sweeprolog-nil
     sweeprolog-no-file
     sweeprolog-no-flag-name
     sweeprolog-no-function
     sweeprolog-no-option-name
     sweeprolog-not-callable
     sweeprolog-op-type
     sweeprolog-option-name
     sweeprolog-pragma
     sweeprolog-predicate-indicator
     sweeprolog-qq-close
     sweeprolog-qq-content
     sweeprolog-qq-open
     sweeprolog-qq-sep
     sweeprolog-qq-type
     sweeprolog-query-replace-term-current
     sweeprolog-query-replace-term-match
     sweeprolog-query-replace-term-prompt-new
     sweeprolog-query-replace-term-prompt-old
     sweeprolog-rational
     sweeprolog-recursion
     sweeprolog-singleton
     sweeprolog-string
     sweeprolog-string-comment
     sweeprolog-structured-comment
     sweeprolog-syntax-error
     sweeprolog-term
     sweeprolog-term-search-current
     sweeprolog-term-search-match
     sweeprolog-thread-local
     sweeprolog-type-error
     sweeprolog-undefined
     sweeprolog-undefined-import
     sweeprolog-unused-import
     sweeprolog-variable
     sweeprolog-variable-at-point
     sweeprolog-warning-prefix
     swift-helpful-section-title
     swift-mode:build-config-keyword-face
     swift-mode:builtin-constant-face
     swift-mode:builtin-enum-case-face
     swift-mode:builtin-function-face
     swift-mode:builtin-function-trailing-closure-face
     swift-mode:builtin-method-face
     swift-mode:builtin-method-trailing-closure-face
     swift-mode:builtin-precedence-group-face
     swift-mode:builtin-property-face
     swift-mode:builtin-type-face
     swift-mode:constant-keyword-face
     swift-mode:function-call-face
     swift-mode:function-name-face
     swift-mode:keyword-face
     swift-mode:negation-char-face
     swift-mode:preprocessor-keyword-face
     swift-mode:property-access-face
     swiper-background-match-face-1
     swiper-background-match-face-2
     swiper-background-match-face-3
     swiper-background-match-face-4
     swiper-line-face
     swiper-match-face-1
     swiper-match-face-2
     swiper-match-face-3
     swiper-match-face-4
     switch-window-background
     switch-window-label
     swoop-face-header-format-line
     swoop-face-line-buffer-name
     swoop-face-line-number
     swoop-face-target-line
     swoop-face-target-words
     sx-custom-button
     sx-inbox-item-type
     sx-inbox-item-type-unread
     sx-question-list-answers
     sx-question-list-answers-accepted
     sx-question-list-bounty
     sx-question-list-date
     sx-question-list-favorite
     sx-question-list-parent
     sx-question-list-read-question
     sx-question-list-score
     sx-question-list-score-upvoted
     sx-question-list-unread-question
     sx-question-mode-accepted
     sx-question-mode-closed
     sx-question-mode-closed-reason
     sx-question-mode-content-face
     sx-question-mode-date
     sx-question-mode-header
     sx-question-mode-kbd-tag
     sx-question-mode-score
     sx-question-mode-score-downvoted
     sx-question-mode-score-upvoted
     sx-question-mode-sub-sup-tag
     sx-question-mode-title
     sx-question-mode-title-comments
     sx-tag
     sx-user-accept-rate
     sx-user-name
     sx-user-reputation
     symbol-navigation-hydra-ahs-plugin-beginning-of-defun-face-dim
     symbol-navigation-hydra-ahs-plugin-display-face-dim
     symbol-navigation-hydra-ahs-plugin-whole-buffer-face-dim
     symbol-navigation-hydra-disabled-head-face
     symbol-overlay-default-face
     symbol-overlay-face-1
     symbol-overlay-face-2
     symbol-overlay-face-3
     symbol-overlay-face-4
     symbol-overlay-face-5
     symbol-overlay-face-6
     symbol-overlay-face-7
     symbol-overlay-face-8
     symex--current-node-face
     symon-lingr-nickname-face
     symon-lingr-room-header-face
     symon-lingr-time-face
     symon-lingr-user-id-face
     syncthing-bold
     syncthing-count-discovery
     syncthing-count-listeners
     syncthing-count-local-bytes
     syncthing-count-local-files
     syncthing-count-local-folders
     syncthing-italic
     syncthing-my-id
     syncthing-progress-0
     syncthing-progress-100
     syncthing-progress-25
     syncthing-progress-50
     syncthing-progress-75
     syncthing-prop
     syncthing-rate-download
     syncthing-rate-upload
     syncthing-title
     syncthing-uptime
     synquid-de-bruijn-face
     syslog-debug
     syslog-error
     syslog-file
     syslog-hide
     syslog-hour
     syslog-info
     syslog-ip
     syslog-su
     syslog-warn
     ta-highlight
     tab-bar
     tab-bar-echo-area-tab
     tab-bar-echo-area-tab-group-current
     tab-bar-echo-area-tab-group-inactive
     tab-bar-echo-area-tab-inactive
     tab-bar-echo-area-tab-ungrouped
     tab-bar-groups-tab-1
     tab-bar-groups-tab-2
     tab-bar-groups-tab-3
     tab-bar-groups-tab-4
     tab-bar-groups-tab-5
     tab-bar-groups-tab-6
     tab-bar-groups-tab-7
     tab-bar-groups-tab-8
     tab-bar-groups-tab-group-current
     tab-bar-groups-tab-group-inactive
     tab-bar-tab
     tab-bar-tab-group-current
     tab-bar-tab-group-inactive
     tab-bar-tab-inactive
     tab-bar-tab-ungrouped
     tab-group:group
     tab-group:match
     tab-group:move-target
     tab-group:scroll-button
     tab-group:scroll-button:disabled
     tab-group:scroll-button:hover
     tab-group:tab
     tab-group:tab-separator
     tab-group:tab:active
     tab-group:tab:hover
     tab-group:tabbar
     tab-line
     tab-line-close-highlight
     tab-line-highlight
     tab-line-tab
     tab-line-tab-current
     tab-line-tab-group
     tab-line-tab-inactive
     tab-line-tab-inactive-alternate
     tab-line-tab-modified
     tab-line-tab-special
     tabbar-button
     tabbar-button-highlight
     tabbar-default
     tabbar-highlight
     tabbar-key-binding
     tabbar-modified
     tabbar-selected
     tabbar-selected-modified
     tabbar-separator
     tabbar-unselected
     tabbar-unselected-modified
     tabgo-face
     table-cell
     tabnine-overlay-face
     tabula-rasa-cursor
     tabula-rasa-default
     tabula-rasa-region
     tabulated-list-fake-header
     tango-plus-deemphasized
     tango-plus-quotation
     taskpaper-done-item
     taskpaper-emphasis
     taskpaper-fast-select-key
     taskpaper-link
     taskpaper-markup
     taskpaper-missing-link
     taskpaper-note
     taskpaper-project-mark
     taskpaper-project-name
     taskpaper-query-error
     taskpaper-query-secondary-text
     taskpaper-strong
     taskpaper-tag
     taskpaper-task
     taskpaper-task-done-mark
     taskpaper-task-undone-mark
     tcl-escaped-newline
     te/master-face
     te/mirror-face
     telega-blue
     telega-box-button
     telega-box-button-active
     telega-button-highlight
     telega-chat-input-attachment
     telega-chat-prompt
     telega-delim-face
     telega-describe-item-title
     telega-describe-section-title
     telega-describe-subsection-title
     telega-enckey-00
     telega-enckey-01
     telega-enckey-10
     telega-enckey-11
     telega-entity-type-blockquote
     telega-entity-type-bold
     telega-entity-type-botcommand
     telega-entity-type-cashtag
     telega-entity-type-code
     telega-entity-type-hashtag
     telega-entity-type-italic
     telega-entity-type-mention
     telega-entity-type-pre
     telega-entity-type-spoiler
     telega-entity-type-strikethrough
     telega-entity-type-texturl
     telega-entity-type-underline
     telega-filter-active
     telega-filter-button-active
     telega-filter-button-inactive
     telega-highlight-text-face
     telega-link
     telega-mention-count
     telega-msg-deleted
     telega-msg-heading
     telega-msg-inline-forward
     telega-msg-inline-reply
     telega-msg-self-title
     telega-msg-sponsored
     telega-msg-user-title
     telega-muted-count
     telega-root-heading
     telega-secret-title
     telega-shadow
     telega-topic-button
     telega-tracking
     telega-unmuted-count
     telega-unread-unmuted-modeline
     telega-user-non-online-status
     telega-user-online-status
     telega-username
     telega-webpage-chat-link
     telega-webpage-fixed
     telega-webpage-header
     telega-webpage-preformatted
     telega-webpage-sitename
     telega-webpage-strike-through
     telega-webpage-subheader
     telega-webpage-title
     telephone-line-accent-active
     telephone-line-accent-inactive
     telephone-line-error
     telephone-line-evil
     telephone-line-evil-emacs
     telephone-line-evil-god
     telephone-line-evil-insert
     telephone-line-evil-motion
     telephone-line-evil-normal
     telephone-line-evil-operator
     telephone-line-evil-replace
     telephone-line-evil-visual
     telephone-line-projectile
     telephone-line-unimportant
     telephone-line-warning
     tempel-default
     tempel-field
     tempel-form
     term
     term+input-face
     term+input-readonly-face
     term-bold
     term-color-black
     term-color-blue
     term-color-bright-black
     term-color-bright-blue
     term-color-bright-cyan
     term-color-bright-green
     term-color-bright-magenta
     term-color-bright-red
     term-color-bright-white
     term-color-bright-yellow
     term-color-cyan
     term-color-green
     term-color-magenta
     term-color-red
     term-color-white
     term-color-yellow
     term-color16-black
     term-color16-blue
     term-color16-cyan
     term-color16-dark-white
     term-color16-dark-yellow
     term-color16-gray
     term-color16-green
     term-color16-lgith-cyan
     term-color16-light-blue
     term-color16-light-green
     term-color16-light-magenta
     term-color16-light-red
     term-color16-magenta
     term-color16-red
     term-color16-white
     term-color16-yellow
     term-faint
     term-fast-blink
     term-frame
     term-italic
     term-overline
     term-slow-blink
     term-strike
     term-underline
     terraform-builtin-face
     terraform-resource-name-face
     terraform-resource-type-face
     terraform-variable-name-face
     test-case-assertion
     test-case-failure
     test-case-fringe
     test-case-mode-line-failure
     test-case-mode-line-success
     test-case-mode-line-success-modified
     test-case-mode-line-undetermined
     test-case-result-column
     test-case-result-file
     test-case-result-line
     test-case-result-message
     testcover-1value
     testcover-mark-line-1value
     testcover-mark-line-nohits
     testcover-nohits
     TeX-error-description-error
     TeX-error-description-help
     TeX-error-description-tex-said
     TeX-error-description-warning
     TeX-fold-folded-face
     TeX-fold-unfolded-face
     tex-math
     tex-math-face
     tex-smart-umlauts-marks
     tex-verbatim
     texinfo-heading
     textile-acronym-face
     textile-alignments-face
     textile-blockquote-face
     textile-citation-face
     textile-class-face
     textile-code-face
     textile-deleted-face
     textile-emph-face
     textile-footnote-face
     textile-footnotemark-face
     textile-h1-face
     textile-h2-face
     textile-h3-face
     textile-h4-face
     textile-h5-face
     textile-h6-face
     textile-image-face
     textile-inline-code-face
     textile-inserted-face
     textile-lang-face
     textile-link-face
     textile-ol-bullet-face
     textile-pre-face
     textile-span-face
     textile-strong-face
     textile-style-face
     textile-subscript-face
     textile-superscript-face
     textile-table-face
     textile-ul-bullet-face
     textile-url-face
     textsec-suspicious
     thread-dump-current-thread
     threes-face-0
     threes-face-1
     threes-face-2
     threes-face-3
     threes-face-max
     thrift-doxygen-key-face
     thrift-ordinal-face
     thumb-through-blockquote-face
     thumb-through-bold-face
     thumb-through-comment-face
     thumb-through-header-face
     thumb-through-header-face-1
     thumb-through-header-face-2
     thumb-through-header-face-3
     thumb-through-header-face-4
     thumb-through-header-face-5
     thumb-through-header-face-6
     thumb-through-inline-code-face
     thumb-through-italic-face
     thumb-through-link-face
     thumb-through-link-title-face
     thumb-through-list-face
     thumb-through-math-face
     thumb-through-pre-face
     thumb-through-reference-face
     thumb-through-url-face
     tickscript-boolean
     tickscript-chaining-method
     tickscript-duration
     tickscript-node
     tickscript-number
     tickscript-operator
     tickscript-property
     tickscript-udf
     tickscript-udf-param
     tickscript-variable
     tide-choice-face
     tide-file
     tide-hl-identifier-face
     tide-imenu-type-face
     tide-line-number
     tide-match
     timonier-k8s-mode-key-face
     timonier-k8s-mode-namespace-face
     timonier-k8s-mode-namespace-status-face
     timonier-k8s-mode-node-face
     timonier-k8s-mode-pod-face
     timonier-k8s-mode-pod-status-face
     timonier-k8s-mode-service-face
     timonier-k8s-mode-title-face
     timu-caribbean-black-face
     timu-caribbean-blue-face
     timu-caribbean-bold-face
     timu-caribbean-bold-face-italic
     timu-caribbean-cyan-face
     timu-caribbean-darkblue-face
     timu-caribbean-darkcyan-face
     timu-caribbean-darkred-face
     timu-caribbean-default-face
     timu-caribbean-green-face
     timu-caribbean-grey-face
     timu-caribbean-italic-face
     timu-caribbean-magenta-face
     timu-caribbean-orange-face
     timu-caribbean-purple-face
     timu-caribbean-red-face
     timu-caribbean-strike-through-face
     timu-caribbean-teal-face
     timu-caribbean-underline-face
     timu-caribbean-white-face
     timu-caribbean-yellow-face
     timu-line-active-face
     timu-line-bg-active-face
     timu-line-bg-inactive-face
     timu-line-fancy-face
     timu-line-inactive-face
     timu-line-modified-face
     timu-line-read-only-face
     timu-line-special-face
     timu-line-status-face
     timu-macos-black-face
     timu-macos-blue-face
     timu-macos-bold-face
     timu-macos-bold-face-italic
     timu-macos-cyan-face
     timu-macos-darkblue-face
     timu-macos-darkcyan-face
     timu-macos-darkred-face
     timu-macos-default-face
     timu-macos-green-face
     timu-macos-grey-face
     timu-macos-italic-face
     timu-macos-magenta-face
     timu-macos-orange-face
     timu-macos-purple-face
     timu-macos-red-face
     timu-macos-strike-through-face
     timu-macos-teal-face
     timu-macos-underline-face
     timu-macos-white-face
     timu-macos-yellow-face
     timu-rouge-bold-face
     timu-rouge-bold-face-italic
     timu-rouge-default-face
     timu-rouge-italic-face
     timu-rouge-strike-through-face
     timu-rouge-underline-face
     timu-spacegrey-bold-face
     timu-spacegrey-bold-face-italic
     timu-spacegrey-default-face
     timu-spacegrey-italic-face
     timu-spacegrey-strike-through-face
     timu-spacegrey-underline-face
     tiny-menu-heading-face
     tlc-font-lock-output-code
     tldr-code-block
     tldr-command-argument
     tldr-command-itself
     tldr-description
     tldr-introduction
     tldr-title
     tmm-inactive
     tmsu-added-face
     tmsu-dired-overlay-face
     tmsu-removed-face
     todo-archived-only
     todo-button
     todo-category-string
     todo-comment
     todo-date
     todo-diary-expired
     todo-done
     todo-done-sep
     todo-key-prompt
     todo-mark
     todo-nondiary
     todo-prefix-string
     todo-search
     todo-sorted-column
     todo-time
     todo-top-priority
     todotxt-a-priority-face
     todotxt-b-priority-face
     todotxt-c-priority-face
     todotxt-complete-face
     todotxt-date-face
     todotxt-done-face
     todotxt-priority-a-face
     todotxt-priority-b-face
     todotxt-priority-c-face
     tokei-num-code-face
     tokei-num-comments-face
     tomatinho-current-ok-face
     tomatinho-current-pause-face
     tomatinho-ok-face
     tomatinho-pause-face
     tomatinho-reset-face
     tomatinho-time-face
     tool-bar
     tooltip
     trailing-whitespace
     transient-active-infix
     transient-amaranth
     transient-argument
     transient-blue
     transient-delimiter
     transient-disabled-suffix
     transient-enabled-suffix
     transient-heading
     transient-higher-level
     transient-inactive-argument
     transient-inactive-value
     transient-inapt-suffix
     transient-key
     transient-key-exit
     transient-key-noop
     transient-key-return
     transient-key-stay
     transient-mismatched-key
     transient-nonstandard-key
     transient-pink
     transient-posframe
     transient-posframe-border
     transient-purple
     transient-red
     transient-separator
     transient-teal
     transient-unreachable
     transient-unreachable-key
     transient-value
     translate-paragraph-highlight-face
     transpose-mark-region-set-face
     trashed-deleted
     trashed-directory
     trashed-mark
     trashed-marked
     trashed-restored
     trashed-symlink
     travis--cyan-face
     travis--gray-face
     travis--green-face
     travis--orange-face
     travis--red-face
     travis--title
     travis--yellow-face
     tree-sitter-ess-r-assignment-face
     tree-sitter-ess-r-boolean-face
     tree-sitter-ess-r-comment-face
     tree-sitter-ess-r-conditional-face
     tree-sitter-ess-r-doc-face
     tree-sitter-ess-r-dollar-face
     tree-sitter-ess-r-error-face
     tree-sitter-ess-r-float-face
     tree-sitter-ess-r-function-face
     tree-sitter-ess-r-keyword.function-face
     tree-sitter-ess-r-matrix-face
     tree-sitter-ess-r-method-face
     tree-sitter-ess-r-modifier-face
     tree-sitter-ess-r-namespace-face
     tree-sitter-ess-r-number-face
     tree-sitter-ess-r-operator-face
     tree-sitter-ess-r-operatorcomp-face
     tree-sitter-ess-r-operatorpipe-face
     tree-sitter-ess-r-operatorunary-face
     tree-sitter-ess-r-opspecial-face
     tree-sitter-ess-r-parameter-face
     tree-sitter-ess-r-punctuation.bracket-face
     tree-sitter-ess-r-repeat-face
     tree-sitter-ess-r-slot-face
     tree-sitter-ess-r-string-face
     tree-sitter-ess-r-varname-face
     tree-sitter-hl-face:attribute
     tree-sitter-hl-face:comment
     tree-sitter-hl-face:constant
     tree-sitter-hl-face:constant.builtin
     tree-sitter-hl-face:constructor
     tree-sitter-hl-face:doc
     tree-sitter-hl-face:embedded
     tree-sitter-hl-face:escape
     tree-sitter-hl-face:function
     tree-sitter-hl-face:function.builtin
     tree-sitter-hl-face:function.call
     tree-sitter-hl-face:function.macro
     tree-sitter-hl-face:function.special
     tree-sitter-hl-face:keyword
     tree-sitter-hl-face:label
     tree-sitter-hl-face:method
     tree-sitter-hl-face:method.call
     tree-sitter-hl-face:number
     tree-sitter-hl-face:operator
     tree-sitter-hl-face:property
     tree-sitter-hl-face:property.definition
     tree-sitter-hl-face:punctuation
     tree-sitter-hl-face:punctuation.bracket
     tree-sitter-hl-face:punctuation.delimiter
     tree-sitter-hl-face:punctuation.special
     tree-sitter-hl-face:string
     tree-sitter-hl-face:string.special
     tree-sitter-hl-face:tag
     tree-sitter-hl-face:type
     tree-sitter-hl-face:type.argument
     tree-sitter-hl-face:type.builtin
     tree-sitter-hl-face:type.parameter
     tree-sitter-hl-face:type.super
     tree-sitter-hl-face:variable
     tree-sitter-hl-face:variable.builtin
     tree-sitter-hl-face:variable.parameter
     tree-sitter-hl-face:variable.special
     tree-sitter-query-match
     treebundel--gitlog-heading
     treemacs-all-the-icons-file-face
     treemacs-all-the-icons-root-face
     treemacs-async-loading-face
     treemacs-diagnostic-error-face
     treemacs-diagnostic-warning-face
     treemacs-directory-collapsed-face
     treemacs-directory-face
     treemacs-file-face
     treemacs-fringe-indicator-face
     treemacs-git-added-face
     treemacs-git-commit-diff-face
     treemacs-git-conflict-face
     treemacs-git-ignored-face
     treemacs-git-modified-face
     treemacs-git-renamed-face
     treemacs-git-unmodified-face
     treemacs-git-untracked-face
     treemacs-header-button-face
     treemacs-help-column-face
     treemacs-help-title-face
     treemacs-hl-line-face
     treemacs-marked-file-face
     treemacs-nerd-icons-file-face
     treemacs-nerd-icons-root-face
     treemacs-on-failure-pulse-face
     treemacs-on-success-pulse-face
     treemacs-peek-mode-indicator-face
     treemacs-root-face
     treemacs-root-remote-disconnected-face
     treemacs-root-remote-face
     treemacs-root-remote-unreadable-face
     treemacs-root-unreadable-face
     treemacs-tags-face
     treemacs-term-node-face
     treemacs-window-background-face
     treesit-explorer-anonymous-node
     treesit-explorer-field-name
     trr-correct-face
     trr-graph-face
     trr-miss-face
     trr-self-face
     trr-text-face
     tss-eldoc-function-name-face
     tss-eldoc-type-face
     tty-menu-disabled-face
     tty-menu-enabled-face
     tty-menu-selected-face
     tuareg-font-double-semicolon-face
     tuareg-font-lock-attribute-face
     tuareg-font-lock-constructor-face
     tuareg-font-lock-doc-markup-face
     tuareg-font-lock-doc-verbatim-face
     tuareg-font-lock-error-face
     tuareg-font-lock-extension-node-face
     tuareg-font-lock-governing-face
     tuareg-font-lock-infix-extension-node-face
     tuareg-font-lock-interactive-directive-face
     tuareg-font-lock-interactive-error-face
     tuareg-font-lock-interactive-output-face
     tuareg-font-lock-label-face
     tuareg-font-lock-line-number-face
     tuareg-font-lock-module-face
     tuareg-font-lock-multistage-face
     tuareg-font-lock-operator-face
     tuareg-opam-error-face
     tuareg-opam-pkg-variable-name-face
     tubestatus-good-service-face
     tubestatus-line-closed-face
     tubestatus-major-delay-face
     tubestatus-minor-delay-face
     tubestatus-special-service-face
     turing-machine-current-face
     turing-machine-tape-face
     tutorial-warning-face
     twittering-timeline-footer-face
     twittering-timeline-header-face
     twittering-uri-face
     twittering-username-face
     typescript-access-modifier-face
     typescript-jsdoc-tag
     typescript-jsdoc-type
     typescript-jsdoc-value
     typescript-primitive-face
     typescript-this-face
     typescript-ts-jsx-attribute-face
     typescript-ts-jsx-tag-face
     typit-correct-char
     typit-current-word
     typit-normal-text
     typit-statistic
     typit-title
     typit-value
     typit-wrong-char
     tzc-face-date-string
     tzc-face-offset-string
     tzc-face-time-string
     tzc-face-time-zone-label
     uci-mode-depth-face
     uci-mode-finished-face
     uci-mode-multipv-1-face
     uci-mode-option-name-face
     uci-mode-pv-face
     uci-mode-score-face
     uiua-dyadic-function
     uiua-dyadic-modifier
     uiua-monadic-function
     uiua-monadic-modifier
     uiua-noadic-or-constant
     uiua-number
     underline
     undo-hl-delete
     undo-hl-insert
     undo-tree-visualizer-active-branch-face
     undo-tree-visualizer-current-face
     undo-tree-visualizer-default-face
     undo-tree-visualizer-register-face
     undo-tree-visualizer-unmodified-face
     unicode-tokens-fraktur-font-face
     unicode-tokens-highlight-face
     unicode-tokens-sans-font-face
     unicode-tokens-script-font-face
     unicode-tokens-serif-font-face
     unicode-tokens-symbol-font-face
     unicode-whitespace-subdued-empty
     unicode-whitespace-subdued-hspace
     unicode-whitespace-subdued-indentation
     unicode-whitespace-subdued-line
     unicode-whitespace-subdued-newline
     unicode-whitespace-subdued-space
     unicode-whitespace-subdued-space-after-tab
     unicode-whitespace-subdued-space-before-tab
     unicode-whitespace-subdued-tab
     unicode-whitespace-subdued-trailing
     untappd-main-element-face
     untappd-rating-icon-face
     uptimes-current-uptime-face
     uptimes-header-face
     uptimes-headings-face
     uptimes-other-uptime-face
     utop-error
     utop-frozen
     utop-prompt
     utop-stderr
     utop-stdout
     variable-pitch
     variable-pitch-text
     vc-conflict-state
     vc-dir-directory
     vc-dir-file
     vc-dir-header
     vc-dir-header-value
     vc-dir-mark-indicator
     vc-dir-status-edited
     vc-dir-status-ignored
     vc-dir-status-up-to-date
     vc-dir-status-warning
     vc-edited-state
     vc-git-log-edit-summary-max-warning
     vc-git-log-edit-summary-target-warning
     vc-ignored-state
     vc-locally-added-state
     vc-locked-state
     vc-missing-state
     vc-needs-update-state
     vc-removed-state
     vc-state-base
     vc-up-to-date-state
     vcomplete-highlight
     vcursor
     vdiff-addition-face
     vdiff-change-face
     vdiff-closed-fold-face
     vdiff-open-fold-face
     vdiff-refine-added
     vdiff-refine-changed
     vdiff-subtraction-face
     vdiff-subtraction-fringe-face
     vdiff-target-face
     vera-font-lock-function
     vera-font-lock-interface
     vera-font-lock-number
     verb-code-tag
     verb-header
     verb-http-keyword
     verb-json-key
     verb-log-error
     verb-log-info
     verb-log-warning
     veri-kompass-inst-marked-face
     verify-url/invalid-url-face
     verilog-ext-compile-bin-face
     verilog-ext-compile-msg-code-face
     verilog-ext-font-lock-brackets-content-face
     verilog-ext-font-lock-brackets-face
     verilog-ext-font-lock-curly-braces-face
     verilog-ext-font-lock-direction-face
     verilog-ext-font-lock-dot-name-face
     verilog-ext-font-lock-grouping-keywords-face
     verilog-ext-font-lock-instance-face
     verilog-ext-font-lock-modport-face
     verilog-ext-font-lock-module-face
     verilog-ext-font-lock-operator-face
     verilog-ext-font-lock-parenthesis-face
     verilog-ext-font-lock-port-connection-face
     verilog-ext-font-lock-preprocessor-face
     verilog-ext-font-lock-punctuation-face
     verilog-ext-font-lock-time-event-face
     verilog-ext-font-lock-time-unit-face
     verilog-ext-font-lock-translate-off-face
     verilog-ext-font-lock-typedef-face
     verilog-ext-font-lock-uvm-classes-face
     verilog-ext-font-lock-width-num-face
     verilog-ext-font-lock-width-type-face
     verilog-ext-font-lock-xilinx-attributes-face
     verilog-ext-imenu-class-item-face
     verilog-ext-xref-match-face
     verilog-font-lock-ams-face
     verilog-font-lock-grouping-keywords-face
     verilog-font-lock-p1800-face
     verilog-font-lock-translate-off-face
     verilog-ts-font-lock-attribute-face
     verilog-ts-font-lock-brackets-content-face
     verilog-ts-font-lock-brackets-face
     verilog-ts-font-lock-curly-braces-face
     verilog-ts-font-lock-direction-face
     verilog-ts-font-lock-dot-name-face
     verilog-ts-font-lock-error-face
     verilog-ts-font-lock-grouping-keywords-face
     verilog-ts-font-lock-instance-face
     verilog-ts-font-lock-modport-face
     verilog-ts-font-lock-module-face
     verilog-ts-font-lock-operator-face
     verilog-ts-font-lock-parenthesis-face
     verilog-ts-font-lock-port-connection-face
     verilog-ts-font-lock-preprocessor-face
     verilog-ts-font-lock-punctuation-face
     verilog-ts-font-lock-time-event-face
     verilog-ts-font-lock-time-unit-face
     verilog-ts-font-lock-translate-off-face
     verilog-ts-font-lock-width-num-face
     verilog-ts-font-lock-width-type-face
     versuri-lyrics-text
     versuri-lyrics-title
     vertical-border
     vertico-current
     vertico-group-separator
     vertico-group-title
     vertico-indexed
     vertico-mouse
     vertico-multiline
     vertico-quick1
     vertico-quick2
     vhdl-ext-compile-bin-face
     vhdl-ext-compile-msg-code-face
     vhdl-ext-font-lock-brackets-content-face
     vhdl-ext-font-lock-brackets-face
     vhdl-ext-font-lock-curly-braces-face
     vhdl-ext-font-lock-entity-face
     vhdl-ext-font-lock-instance-face
     vhdl-ext-font-lock-instance-lib-face
     vhdl-ext-font-lock-operator-face
     vhdl-ext-font-lock-parenthesis-face
     vhdl-ext-font-lock-port-connection-face
     vhdl-ext-font-lock-punctuation-face
     vhdl-ext-font-lock-then-face
     vhdl-ext-font-lock-translate-off-face
     vhdl-ext-xref-match-face
     vhdl-font-lock-attribute-face
     vhdl-font-lock-directive-face
     vhdl-font-lock-enumvalue-face
     vhdl-font-lock-function-face
     vhdl-font-lock-generic-/constant-face
     vhdl-font-lock-prompt-face
     vhdl-font-lock-reserved-words-face
     vhdl-font-lock-translate-off-face
     vhdl-font-lock-type-face
     vhdl-font-lock-variable-face
     vhdl-speedbar-architecture-face
     vhdl-speedbar-architecture-selected-face
     vhdl-speedbar-configuration-face
     vhdl-speedbar-configuration-selected-face
     vhdl-speedbar-entity-face
     vhdl-speedbar-entity-selected-face
     vhdl-speedbar-instantiation-face
     vhdl-speedbar-instantiation-selected-face
     vhdl-speedbar-library-face
     vhdl-speedbar-package-face
     vhdl-speedbar-package-selected-face
     vhdl-speedbar-subprogram-face
     vhdl-ts-font-lock-brackets-content-face
     vhdl-ts-font-lock-entity-face
     vhdl-ts-font-lock-error-face
     vhdl-ts-font-lock-instance-face
     vhdl-ts-font-lock-instance-lib-face
     vhdl-ts-font-lock-operator-face
     vhdl-ts-font-lock-parenthesis-face
     vhdl-ts-font-lock-port-connection-face
     vhdl-ts-font-lock-punctuation-face
     vhdl-ts-font-lock-then-face
     vhdl-ts-font-lock-translate-off-face
     vhl/default-face
     vi-tilde-fringe-face
     viking-blink
     vim-empty-lines-face
     vimish-fold-fringe
     vimish-fold-mouse-face
     vimish-fold-overlay
     vimrc-command
     vimrc-function-builtin
     vimrc-number
     vimrc-option
     vimscript-ts-mode-embedded-face
     vimscript-ts-mode-heredoc-face
     vimscript-ts-mode-keycode-face
     vimscript-ts-mode-regexp-face
     vimscript-ts-mode-register-face
     vimscript-ts-mode-scope-face
     viper-minibuffer-emacs
     viper-minibuffer-insert
     viper-minibuffer-vi
     viper-replace-overlay
     viper-search
     visible-mark-active
     visible-mark-face1
     visible-mark-face2
     visible-mark-forward-face1
     visible-mark-forward-face2
     visual-ascii-mode-printable-face
     visual-ascii-mode-unprintable-face
     vline
     vline-visual
     volume-bar
     vr/group-0
     vr/group-1
     vr/group-2
     vr/match-0
     vr/match-1
     vr/match-separator-face
     vtable
     vterm-color-black
     vterm-color-blue
     vterm-color-bright-black
     vterm-color-bright-blue
     vterm-color-bright-cyan
     vterm-color-bright-green
     vterm-color-bright-magenta
     vterm-color-bright-red
     vterm-color-bright-white
     vterm-color-bright-yellow
     vterm-color-cyan
     vterm-color-green
     vterm-color-inverse-video
     vterm-color-magenta
     vterm-color-red
     vterm-color-underline
     vterm-color-white
     vterm-color-yellow
     vundo-branch-stem
     vundo-default
     vundo-diff-highlight
     vundo-highlight
     vundo-last-saved
     vundo-node
     vundo-saved
     vundo-stem
     w3m-anchor
     w3m-arrived-anchor
     w3m-bold
     w3m-current-anchor
     w3m-error
     w3m-form
     w3m-form-button
     w3m-form-button-mouse
     w3m-form-button-pressed
     w3m-form-inactive
     w3m-haddock-heading-face
     w3m-header-line-background
     w3m-header-line-content
     w3m-header-line-title
     w3m-history-current-url
     w3m-image
     w3m-image-anchor
     w3m-insert
     w3m-italic
     w3m-lnum
     w3m-lnum-match
     w3m-lnum-minibuffer-prompt
     w3m-session-select
     w3m-session-selected
     w3m-strike-through
     w3m-tab-background
     w3m-tab-mouse
     w3m-tab-selected
     w3m-tab-selected-background
     w3m-tab-selected-retrieving
     w3m-tab-unselected
     w3m-tab-unselected-retrieving
     w3m-tab-unselected-unseen
     w3m-underline
     w3m-unsafe-url-warning
     warning
     wavedrom-font-lock-brackets-face
     wavedrom-font-lock-punctuation-face
     wc-goal-face
     weather-metno-date
     weather-metno-date-range
     weather-metno-entry
     weather-metno-footer
     weather-metno-header
     web-mode-annotation-face
     web-mode-annotation-html-face
     web-mode-annotation-tag-face
     web-mode-annotation-type-face
     web-mode-annotation-value-face
     web-mode-block-attr-name-face
     web-mode-block-attr-value-face
     web-mode-block-comment-face
     web-mode-block-control-face
     web-mode-block-delimiter-face
     web-mode-block-face
     web-mode-block-string-face
     web-mode-bold-face
     web-mode-builtin-face
     web-mode-comment-face
     web-mode-comment-keyword-face
     web-mode-constant-face
     web-mode-css-at-rule-face
     web-mode-css-color-face
     web-mode-css-comment-face
     web-mode-css-function-face
     web-mode-css-priority-face
     web-mode-css-property-name-face
     web-mode-css-pseudo-class-face
     web-mode-css-selector-class-face
     web-mode-css-selector-face
     web-mode-css-selector-tag-face
     web-mode-css-string-face
     web-mode-css-variable-face
     web-mode-current-column-highlight-face
     web-mode-current-element-highlight-face
     web-mode-doctype-face
     web-mode-error-face
     web-mode-filter-face
     web-mode-folded-face
     web-mode-function-call-face
     web-mode-function-name-face
     web-mode-html-attr-custom-face
     web-mode-html-attr-engine-face
     web-mode-html-attr-equal-face
     web-mode-html-attr-name-face
     web-mode-html-attr-value-face
     web-mode-html-entity-face
     web-mode-html-tag-bracket-face
     web-mode-html-tag-custom-face
     web-mode-html-tag-face
     web-mode-html-tag-namespaced-face
     web-mode-html-tag-unclosed-face
     web-mode-inlay-face
     web-mode-interpolate-color1-face
     web-mode-interpolate-color2-face
     web-mode-interpolate-color3-face
     web-mode-interpolate-color4-face
     web-mode-italic-face
     web-mode-javascript-comment-face
     web-mode-javascript-string-face
     web-mode-json-comment-face
     web-mode-json-context-face
     web-mode-json-key-face
     web-mode-json-string-face
     web-mode-jsx-depth-1-face
     web-mode-jsx-depth-2-face
     web-mode-jsx-depth-3-face
     web-mode-jsx-depth-4-face
     web-mode-jsx-depth-5-face
     web-mode-keyword-face
     web-mode-param-name-face
     web-mode-part-comment-face
     web-mode-part-face
     web-mode-part-string-face
     web-mode-preprocessor-face
     web-mode-script-face
     web-mode-sql-keyword-face
     web-mode-string-face
     web-mode-style-face
     web-mode-symbol-face
     web-mode-type-face
     web-mode-underline-face
     web-mode-variable-name-face
     web-mode-warning-face
     web-mode-whitespace-face
     weechat-corrector-corrected-face
     weechat-error-face
     weechat-highlight-face
     weechat-nick-self-face
     weechat-prompt-face
     weechat-read-marker
     weechat-time-face
     wfnames-dir
     wfnames-files
     wfnames-modified
     wfnames-modified-exists
     wfnames-prefix
     wfnames-symlink
     wg-brace-face
     wg-command-face
     wg-current-workgroup-face
     wg-divider-face
     wg-filename-face
     wg-frame-face
     wg-message-face
     wg-mode-line-face
     wg-other-workgroup-face
     wg-previous-workgroup-face
     wgrep-delete-face
     wgrep-done-face
     wgrep-face
     wgrep-file-face
     wgrep-reject-face
     which-func
     which-key-command-description-face
     which-key-docstring-face
     which-key-group-description-face
     which-key-highlighted-command-face
     which-key-key-face
     which-key-local-map-description-face
     which-key-note-face
     which-key-posframe
     which-key-posframe-border
     which-key-separator-face
     which-key-special-key-face
     whitespace-big-indent
     whitespace-empty
     whitespace-hspace
     whitespace-indentation
     whitespace-line
     whitespace-missing-newline-at-eof
     whitespace-newline
     whitespace-space
     whitespace-space-after-tab
     whitespace-space-before-tab
     whitespace-tab
     whitespace-trailing
     why-this-annotate-heat-map-cold
     why-this-annotate-heat-map-warm
     why-this-annotate-underline
     why-this-face
     widget-button
     widget-button-pressed
     widget-documentation
     widget-field
     widget-inactive
     widget-single-line-field
     wiki-nav-link-face
     wiki-nav-mouse-face
     wikinfo-search-title
     window-divider
     window-divider-first-pixel
     window-divider-last-pixel
     window-number-face
     window-numbering-face
     winum-face
     wl-highlight-action-argument-face
     wl-highlight-demo-face
     wl-highlight-folder-closed-face
     wl-highlight-folder-few-face
     wl-highlight-folder-killed-face
     wl-highlight-folder-many-face
     wl-highlight-folder-opened-face
     wl-highlight-folder-path-face
     wl-highlight-folder-unknown-face
     wl-highlight-folder-unread-face
     wl-highlight-folder-zero-face
     wl-highlight-header-separator-face
     wl-highlight-logo-face
     wl-highlight-message-citation-header
     wl-highlight-message-cited-text-1
     wl-highlight-message-cited-text-10
     wl-highlight-message-cited-text-2
     wl-highlight-message-cited-text-3
     wl-highlight-message-cited-text-4
     wl-highlight-message-cited-text-5
     wl-highlight-message-cited-text-6
     wl-highlight-message-cited-text-7
     wl-highlight-message-cited-text-8
     wl-highlight-message-cited-text-9
     wl-highlight-message-header-contents
     wl-highlight-message-headers
     wl-highlight-message-important-header-contents
     wl-highlight-message-important-header-contents2
     wl-highlight-message-signature
     wl-highlight-message-unimportant-header-contents
     wl-highlight-summary-answered-face
     wl-highlight-summary-copied-face
     wl-highlight-summary-deleted-face
     wl-highlight-summary-displaying-face
     wl-highlight-summary-disposed-face
     wl-highlight-summary-flagged-face
     wl-highlight-summary-forwarded-face
     wl-highlight-summary-high-read-face
     wl-highlight-summary-high-unread-face
     wl-highlight-summary-killed-face
     wl-highlight-summary-low-read-face
     wl-highlight-summary-low-unread-face
     wl-highlight-summary-new-face
     wl-highlight-summary-normal-face
     wl-highlight-summary-prefetch-face
     wl-highlight-summary-refiled-face
     wl-highlight-summary-resend-face
     wl-highlight-summary-spam-face
     wl-highlight-summary-target-face
     wl-highlight-summary-temp-face
     wl-highlight-summary-thread-top-face
     wl-highlight-summary-unread-face
     wl-highlight-thread-indent-face
     wl-message-header-narrowing-face
     wl-summary-persistent-mark-face
     wn-modeline-face
     wolfram-pod-title
     wolfram-query
     woman-addition
     woman-bold
     woman-italic
     woman-unknown
     wordel-almost
     wordel-box
     wordel-correct
     wordel-current-box
     wordel-default
     wordel-error
     wordel-guessed
     wordel-spacer
     wordsmith-default-face
     wordsmith-noun-face
     wordsmith-verb-face
     world-clock-label
     writegood-duplicates-face
     writegood-passive-voice-face
     writegood-weasels-face
     wwg-green-face
     wwg-red-face
     wwg-yellow-face
     x509-asn1-hexl-header
     x509-asn1-hexl-value
     x509-asn1-sequence-face
     x509-browse-url-face
     x509-constant-face
     x509-hex-string-face
     x509-keyword-face
     x509-near-warning-face
     x509-oid-face
     x509-oid-link-face
     x509-short-name-face
     x509-string-face
     x509-warning-face
     xbm-life
     xref-file-header
     xref-line-number
     xref-match
     xwiki-bold-face
     xwiki-code-face
     xwiki-definition-list-face
     xwiki-header-face
     xwiki-header-face-1
     xwiki-header-face-2
     xwiki-header-face-3
     xwiki-header-face-4
     xwiki-header-face-5
     xwiki-header-face-6
     xwiki-horizontal-line-face
     xwiki-inline-code-face
     xwiki-italic-face
     xwiki-link-face
     xwiki-list-face
     xwiki-macro-face
     xwiki-markup-face
     xwiki-newline-face
     xwiki-parameter-face
     xwiki-quotation-face
     xwiki-strike-through-face
     xwiki-subscript-face
     xwiki-superscript-face
     xwiki-table-marker-face
     xwiki-underline-face
     yafolding-ellipsis-face
     yahtzee-face
     yahtzee-face-fixed
     yahtzee-face-selected
     yahtzee-face-user-arrow
     yalinum-bar-face
     yalinum-face
     yalinum-track-face
     yaml-pro-fold-replacement-face
     yaml-tab-face
     yard-directive-face
     yard-name-face
     yard-option-face
     yard-tag-face
     yard-types-face
     yarn-mode-dependency-face
     yarn-mode-keywords-face
     yarn-mode-package-face
     yas--field-debug-face
     yas-field-highlight-face
     yascroll:thumb-fringe
     yascroll:thumb-text-area
     YaTeX-font-lock-bold-face
     YaTeX-font-lock-crossref-face
     YaTeX-font-lock-declaration-face
     YaTeX-font-lock-delimiter-face
     YaTeX-font-lock-formula-face
     YaTeX-font-lock-include-face
     YaTeX-font-lock-italic-face
     YaTeX-font-lock-label-face
     YaTeX-font-lock-math-sub-face
     YaTeX-font-lock-math-sup-face
     YaTeX-on-the-fly-activated-face
     yeetube-face-channel
     yeetube-face-date
     yeetube-face-duration
     yeetube-face-header-query
     yeetube-face-title
     yeetube-face-view-count
     yesql-ghosts-defn-face
     ytdious-channel-name-face
     ytdious-video-length-face
     ytdious-video-published-face
     ytdious-video-view-face
     ytel-channel-name-face
     ytel-video-length-face
     ytel-video-published-face
     ytel-video-view-face
     zen-catch-vertical-bar-face
     zen-error-face
     zen-int-range-face
     zen-label-face
     zen-multiline-string-face
     zen-slice-range-face
     zencoding-preview-input
     zencoding-preview-output
     zenscript-bracket-prefix-face
     zenscript-preprocessor-face
     zephir-class-declaration-face
     zephir-class-declaration-spec-face
     zephir-class-modifier-face
     zephir-comparison-operator-face
     zephir-constant-assign-face
     zephir-constant-face
     zephir-function-call-face
     zephir-function-name-face
     zephir-import-declaration-face
     zephir-keyword-face
     zephir-logical-operator-face
     zephir-magical-constant-face
     zephir-method-call-face
     zephir-method-modifier-face
     zephir-namespace-declaration-face
     zephir-object-operator-face
     zephir-operator-face
     zephir-property-name-face
     zephir-this-face
     zephir-type-<>-face
     zephir-type-face
     zephir-variable-name-face
     zerodark-buffer-position-face
     zerodark-error-face
     zerodark-modified-face
     zerodark-not-modified-face
     zerodark-ok-face
     zerodark-ro-face
     zerodark-vc-face
     zerodark-warning-face
     zig-multiline-string-face
     zim-wiki-font-tag
     zk-desktop-button
     zlc-selected-completion-face
     zone-tmux-clock-solid-face
     zpresent-base
     zpresent-body
     zpresent-h1
     zpresent-title-slide-title
     zpresent-whole-screen-face
     ztreep-arrow-face
     ztreep-diff-header-face
     ztreep-diff-header-small-face
     ztreep-diff-model-add-face
     ztreep-diff-model-diff-face
     ztreep-diff-model-ignored-face
     ztreep-diff-model-normal-face
     ztreep-expand-sign-face
     ztreep-header-face
     ztreep-leaf-face
     ztreep-node-count-children-face
     ztreep-node-face)
  "A list of most faces defined as faces.

The first element is `default'.")

(defconst most-faces-as-variables
  '( gnus-face-0
     gnus-face-1
     gnus-face-2
     gnus-face-3
     gnus-face-4
     goto-address-url-face
     grep-context-face
     grep-error-face
     grep-hit-face
     grep-match-face
     ibuffer-deletion-face
     ibuffer-filter-group-name-face
     ibuffer-marked-face
     ibuffer-title-face)
  "A list of most faces defined as variables.")

(provide 'most-faces)

;;; most-faces.el ends here
