/* do not edit automatically generated by mc from PushBackInput.  */
/* PushBackInput.def provides a method for pushing back and consuming input.

Copyright (C) 2001-2025 Free Software Foundation, Inc.
Contributed by Gaius Mulley <gaius.mulley@southwales.ac.uk>.

This file is part of GNU Modula-2.

GNU Modula-2 is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

GNU Modula-2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

Under Section 7 of GPL version 3, you are granted additional
permissions described in the GCC Runtime Library Exception, version
3.1, as published by the Free Software Foundation.

You should have received a copy of the GNU General Public License and
a copy of the GCC Runtime Library Exception along with this program;
see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see
<http://www.gnu.org/licenses/>.  */


#if !defined (_PushBackInput_H)
#   define _PushBackInput_H

#define INCLUDE_MEMORY
#include "config.h"
#include "system.h"
#   ifdef __cplusplus
extern "C" {
#   endif
#include <stdbool.h>
#   if !defined (PROC_D)
#      define PROC_D
       typedef void (*PROC_t) (void);
       typedef struct { PROC_t proc; } PROC;
#   endif

#   include "GFIO.h"
#   include "GDynamicStrings.h"

#   if defined (_PushBackInput_C)
#      define EXTERN
#   else
#      define EXTERN extern
#   endif


/*
   Open - opens a file for reading.
*/

EXTERN FIO_File PushBackInput_Open (const char *a_, unsigned int _a_high);

/*
   GetCh - gets a character from either the push back stack or
           from file, f.
*/

EXTERN char PushBackInput_GetCh (FIO_File f);

/*
   PutCh - pushes a character onto the push back stack, it also
           returns the character which has been pushed.
*/

EXTERN char PushBackInput_PutCh (char ch);

/*
   PutString - pushes a string onto the push back stack.
*/

EXTERN void PushBackInput_PutString (const char *a_, unsigned int _a_high);

/*
   PutStr - pushes a dynamic string onto the push back stack.
            The string, s, is not deallocated.
*/

EXTERN void PushBackInput_PutStr (DynamicStrings_String s);

/*
   Error - emits an error message with the appropriate file, line combination.
*/

EXTERN void PushBackInput_Error (const char *a_, unsigned int _a_high);

/*
   WarnError - emits an error message with the appropriate file, line combination.
               It does not terminate but when the program finishes an exit status of
               1 will be issued.
*/

EXTERN void PushBackInput_WarnError (const char *a_, unsigned int _a_high);

/*
   WarnString - emits an error message with the appropriate file, line combination.
                It does not terminate but when the program finishes an exit status of
                1 will be issued.
*/

EXTERN void PushBackInput_WarnString (DynamicStrings_String s);

/*
   Close - closes the opened file.
*/

EXTERN void PushBackInput_Close (FIO_File f);

/*
   GetExitStatus - returns the exit status which will be 1 if any warnings were issued.
*/

EXTERN unsigned int PushBackInput_GetExitStatus (void);

/*
   SetDebug - sets the debug flag on or off.
*/

EXTERN void PushBackInput_SetDebug (bool d);

/*
   GetColumnPosition - returns the column position of the current character.
*/

EXTERN unsigned int PushBackInput_GetColumnPosition (void);

/*
   GetCurrentLine - returns the current line number.
*/

EXTERN unsigned int PushBackInput_GetCurrentLine (void);
#   ifdef __cplusplus
}
#   endif

#   undef EXTERN
#endif
