------------------------------------------------------------------------------
--                                                                          --
--                         GNAT RUN-TIME COMPONENTS                         --
--                                                                          --
--                       S Y S T E M . E X P _ L L U                        --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--          Copyright (C) 1992-2024, Free Software Foundation, Inc.         --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 3,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.                                     --
--                                                                          --
-- As a special exception under Section 7 of GPL version 3, you are granted --
-- additional permissions described in the GCC Runtime Library Exception,   --
-- version 3.1, as published by the Free Software Foundation.               --
--                                                                          --
-- You should have received a copy of the GNU General Public License and    --
-- a copy of the GCC Runtime Library Exception along with this program;     --
-- see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see    --
-- <http://www.gnu.org/licenses/>.                                          --
--                                                                          --
-- GNAT was originally developed  by the GNAT team at  New York University. --
-- Extensive contributions were provided by Ada Core Technologies Inc.      --
--                                                                          --
------------------------------------------------------------------------------

--  This function performs exponentiation of unsigned types (with binary
--  modulus values exceeding that of Unsigned_Types.Unsigned). The result
--  is always full width, the caller must do a masking operation if the
--  modulus is less than 2 ** (Long_Long_Unsigned'Size).

--  Note: preconditions in this unit are meant for analysis only, not for
--  run-time checking, so that the expected exceptions are raised. This is
--  enforced by setting the corresponding assertion policy to Ignore.
--  Postconditions and contract cases should not be executed at run-time as
--  well, in order not to slow down the execution of these functions.

pragma Assertion_Policy (Pre            => Ignore,
                         Post           => Ignore,
                         Contract_Cases => Ignore,
                         Ghost          => Ignore);

with System.Exponu;
with System.Unsigned_Types;

package System.Exp_LLU
  with SPARK_Mode
is

   subtype Long_Long_Unsigned is Unsigned_Types.Long_Long_Unsigned;

   function Exp_Long_Long_Unsigned is new Exponu (Long_Long_Unsigned);
   pragma Pure_Function (Exp_Long_Long_Unsigned);
   --  Return the power of ``Left`` by ``Right`` where ``Left`` is a
   --  Long_Long_Unsigned.
   --
   --  This function is implemented using the standard logarithmic approach:
   --  ``Right`` gets shifted right testing successive low order bits, and
   --  ``Left`` is raised to the next power of 2.
   --
   --  In case of overflow, Constraint_Error is raised.

end System.Exp_LLU;
