/* { dg-do compile } */
/* { dg-options "-mavx512bw -mavx512vbmi -O2" } */
/* { dg-final { scan-assembler-times {(?n)vmov[a-z0-9]*[ \t]*%ymm[0-9]} 12} } */
/* { dg-final { scan-assembler-not "pxor" } } */


typedef float v16sf __attribute__((vector_size(64)));
typedef double v8df __attribute__ ((vector_size (64)));
typedef long long v8di __attribute__((vector_size(64)));
typedef int v16si __attribute__((vector_size(64)));
typedef short v32hi __attribute__ ((vector_size (64)));
typedef char v64qi __attribute__ ((vector_size (64)));

v8df
foo_v8df (v8df x)
{
  return __builtin_shuffle (x, (v8df) { 0, 0, 0, 0, 0, 0, 0, 0 },
			    (v8di) { 0, 1, 2, 3, 15, 14, 10, 11 });
}

v8df
foo_v8df_l (v8df x)
{
  return __builtin_shuffle ((v8df) { 0, 0, 0, 0, 0, 0, 0, 0 }, x,
			    (v8di) { 8, 9, 10, 11, 0, 1, 2, 3 });
}

v8di
foo_v8di (v8di x)
{
  return __builtin_shuffle (x, (v8di) { 0, 0, 0, 0, 0, 0, 0, 0 },
			    (v8di) { 0, 1, 2, 3, 8, 9, 10, 11 });
}

v8di
foo_v8di_l (v8di x)
{
  return __builtin_shuffle ((v8di) { 0, 0, 0, 0, 0, 0, 0, 0 }, x,
			    (v8di) { 8, 9, 10, 11, 7, 6, 5, 4 });
}

v16sf
foo_v16sf (v16sf x)
{
  return __builtin_shuffle (x, (v16sf)  { 0, 0, 0, 0, 0, 0, 0, 0,
					   0, 0, 0, 0, 0, 0, 0, 0 },
			       (v16si) { 0, 1, 2, 3, 4, 5, 6, 7,
					 16, 17, 18, 19, 20, 21, 22, 23 });
}

v16sf
foo_v16sf_l (v16sf x)
{
  return __builtin_shuffle ((v16sf)  { 0, 0, 0, 0, 0, 0, 0, 0,
				       0, 0, 0, 0, 0, 0, 0, 0 }, x,
			    (v16si) { 16, 17, 18, 19, 20, 21, 22, 23,
				      0, 15, 2, 13, 4, 11, 6, 9 });
}

v16si
foo_v16si (v16si x)
{
    return __builtin_shuffle (x, (v16si)  { 0, 0, 0, 0, 0, 0, 0, 0,
					   0, 0, 0, 0, 0, 0, 0, 0 },
			       (v16si) { 0, 1, 2, 3, 4, 5, 6, 7,
					 31, 30, 29, 28, 20, 21, 22, 23 });
}

v16si
foo_v16si_l (v16si x)
{
    return __builtin_shuffle ((v16si)  { 0, 0, 0, 0, 0, 0, 0, 0,
					 0, 0, 0, 0, 0, 0, 0, 0 }, x,
			      (v16si) { 16, 17, 18, 19, 20, 21, 22, 23,
					15, 0, 13, 2, 11, 4, 9, 6 });
}

v32hi
foo_v32hi (v32hi x)
{
  return __builtin_shuffle (x, (v32hi) { 0, 0, 0, 0, 0, 0, 0, 0,
					 0, 0, 0, 0, 0, 0, 0, 0,
					 0, 0, 0, 0, 0, 0, 0, 0,
					 0, 0, 0, 0, 0, 0, 0, 0 },
			       (v32hi) { 0, 1, 2, 3, 4, 5, 6, 7,
					 8, 9, 10, 11, 12, 13, 14, 15,
					 63, 33, 61, 35, 59, 37, 57, 39,
					 55, 41, 53, 43, 51, 45, 49, 47 });
}

v32hi
foo_v32hi_l (v32hi x)
{
  return __builtin_shuffle ((v32hi) { 0, 0, 0, 0, 0, 0, 0, 0,
				       0, 0, 0, 0, 0, 0, 0, 0,
				       0, 0, 0, 0, 0, 0, 0, 0,
				       0, 0, 0, 0, 0, 0, 0, 0 }, x,
			       (v32hi) { 32, 33, 34, 35, 36, 37, 38, 39,
					 40, 41, 42, 43, 44, 45, 46, 47,
					 31, 0, 29, 2, 27, 4, 25, 6,
					 23, 8, 21, 10, 19, 12, 17, 14 });
}

v64qi
foo_v64qi (v64qi x)
{
  return __builtin_shuffle (x, (v64qi) { 0, 0, 0, 0, 0, 0, 0, 0,
					 0, 0, 0, 0, 0, 0, 0, 0,
					 0, 0, 0, 0, 0, 0, 0, 0,
					 0, 0, 0, 0, 0, 0, 0, 0,
					 0, 0, 0, 0, 0, 0, 0, 0,
					 0, 0, 0, 0, 0, 0, 0, 0,
					 0, 0, 0, 0, 0, 0, 0, 0,
					 0, 0, 0, 0, 0, 0, 0, 0 },
			       (v64qi) {0, 1, 2, 3, 4, 5, 6, 7,
					  8, 9, 10, 11, 12, 13, 14, 15,
					  16, 17, 18, 19, 20, 21, 22, 23,
					  24, 25, 26, 27, 28, 29, 30, 31,
					  64, 127, 66, 125, 68, 123, 70, 121,
					  72, 119, 74, 117, 76, 115, 78, 113,
					  80, 111, 82, 109, 84, 107, 86, 105,
					  88, 103, 90, 101, 92, 99, 94, 97 });
}

v64qi
foo_v64qi_l (v64qi x)
{
  return __builtin_shuffle ((v64qi) { 0, 0, 0, 0, 0, 0, 0, 0,
				      0, 0, 0, 0, 0, 0, 0, 0,
				      0, 0, 0, 0, 0, 0, 0, 0,
				      0, 0, 0, 0, 0, 0, 0, 0,
				      0, 0, 0, 0, 0, 0, 0, 0,
				      0, 0, 0, 0, 0, 0, 0, 0,
				      0, 0, 0, 0, 0, 0, 0, 0,
				      0, 0, 0, 0, 0, 0, 0, 0 }, x,
			    (v64qi) { 64, 65, 66, 67, 68, 69, 70, 71,
				      72, 73, 74, 75, 76, 77, 78, 79,
				      80, 81, 82, 83, 84, 85, 86, 87,
				      88, 89, 90, 91, 92, 93, 94, 95,
				      0, 63, 2, 61, 4, 59, 6, 57,
				      8, 55, 10, 53, 12, 51, 14, 49,
				      16, 47, 18, 45, 20, 43, 22, 41,
				      24, 39, 26, 37, 28, 35, 30, 33 });
}
