;; Scheduling description for z196 (cpu 2817).
;;   Copyright (C) 2010-2023 Free Software Foundation, Inc.
;;   Contributed by Christian Borntraeger (Christian.Borntraeger@de.ibm.com)
;;                  Andreas Krebbel (Andreas.Krebbel@de.ibm.com)

;; This file is part of GCC.

;; GCC is free software; you can redistribute it and/or modify it under
;; the terms of the GNU General Public License as published by the Free
;; Software Foundation; either version 3, or (at your option) any later
;; version.

;; GCC is distributed in the hope that it will be useful, but WITHOUT ANY
;; WARRANTY; without even the implied warranty of MERCHANTABILITY or
;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;; for more details.

;; You should have received a copy of the GNU General Public License
;; along with GCC; see the file COPYING3.  If not see
;; <http://www.gnu.org/licenses/>.

(define_automaton "z196_ipu")

;; Fetch + Decoder
(define_cpu_unit "z196_g1" "z196_ipu")
(define_cpu_unit "z196_g2" "z196_ipu")
(define_cpu_unit "z196_g3" "z196_ipu")
(define_cpu_unit "z196_cr1" "z196_ipu")
(define_cpu_unit "z196_cr2" "z196_ipu")
(define_cpu_unit "z196_cr3" "z196_ipu")

(final_presence_set "z196_g2" "z196_g1")
(final_presence_set "z196_g3" "z196_g2")
(final_presence_set "z196_cr2" "z196_cr1")
(final_presence_set "z196_cr3" "z196_cr2")
(exclusion_set "z196_g1" "z196_cr1")

;; Instructions can be groupable, end a group, or be alone in a group.
(define_reservation "z196_simple" "( z196_g1 | z196_g2 | z196_g3 )")
(define_reservation "z196_ends" "( z196_g3 | ( z196_g2 + z196_g3 ) | ( z196_g1 + z196_g2 + z196_g3 ) )")

;; Try to keep cracked and alone insns together in a clump.  This will also
;; improve the clumping of "normal" insns.  We also allow crackes insns
;; to go as a last instruction together with normal ones.
(define_reservation "z196_crack"  "( z196_cr1 | z196_cr2 | z196_cr3 | z196_g3)")
(define_reservation "z196_alone"  "( z196_cr1 | z196_cr2 | z196_cr3 )")

;; Most simple instruction a fast enough to be handled by OOO even with
;; latency == 0.  This reduces life ranges and spilling. We want to increase
;; life range for longer running ops, though, thats why we do not use
;; -fno-schedule-insns.
(define_insn_reservation "z196_simple_LSU" 0
  (and (eq_attr "cpu" "z196")
       (and (eq_attr "type" "load,store,lr")
            (eq_attr "z196prop" "none")))
  "z196_simple")

(define_insn_reservation "z196_simple_FXU" 0
  (and (eq_attr "cpu" "z196")
       (and (eq_attr "type" "integer,la,larl,other")
            (and (eq_attr "z196prop" "none")
                 (eq_attr "op_type" "RR"))))
  "z196_simple")

(define_insn_reservation "z196_simple_DUAL" 0
  (and (eq_attr "cpu" "z196")
       (and (eq_attr "type" "integer,la,larl,other")
            (and (eq_attr "z196prop" "none")
                 (eq_attr "op_type" "!RR"))))
  "z196_simple")

(define_insn_reservation "z196_cracked" 0
  (and (eq_attr "cpu" "z196")
       (and (eq_attr "type" "integer,la,larl,load,lr,store,other")
            (eq_attr "z196prop" "z196_cracked")))
  "z196_crack")

(define_insn_reservation "z196_alone" 0
  (and (eq_attr "cpu" "z196")
       (and (eq_attr "type" "integer,la,larl,load,lr,store,other")
            (eq_attr "z196prop" "z196_alone")))
  "z196_alone")

(define_insn_reservation "z196_ends" 0
  (and (eq_attr "cpu" "z196")
       (and (eq_attr "type" "integer,la,larl,load,lr,store,other")
            (eq_attr "z196prop" "z196_ends")))
  "z196_ends")

(define_insn_reservation "z196_branch" 0
  (and (eq_attr "cpu" "z196")
       (eq_attr "type" "branch"))
  "z196_ends")

(define_insn_reservation "z196_call" 0
  (and (eq_attr "cpu" "z196")
       (eq_attr "type" "jsr"))
  "z196_ends")

(define_insn_reservation "z196_mul_hi" 10
  (and (eq_attr "cpu" "z196")
       (eq_attr "type" "imulhi"))
  "z196_simple")

(define_insn_reservation "z196_mul_si" 12
  (and (eq_attr "cpu" "z196")
       (eq_attr "type" "imulsi"))
  "z196_simple")

(define_insn_reservation "z196_mul_di" 14
  (and (eq_attr "cpu" "z196")
       (eq_attr "type" "imuldi"))
  "z196_simple")

(define_insn_reservation "z196_div" 73
  (and (eq_attr "cpu" "z196")
       (eq_attr "type" "idiv"))
  "z196_alone")

(define_insn_reservation "z196_sem" 0
  (and (eq_attr "cpu" "z196")
       (eq_attr "type" "sem"))
  "z196_crack")

(define_insn_reservation "z196_cs" 0
  (and (eq_attr "cpu" "z196")
       (eq_attr "type" "cs"))
  "z196_crack")

(define_insn_reservation "z196_vs" 0
  (and (eq_attr "cpu" "z196")
       (eq_attr "type" "vs"))
  "z196_alone")

(define_insn_reservation "z196_lm_stm" 0
  (and (eq_attr "cpu" "z196")
       (eq_attr "type" "stm,lm"))
  "z196_crack")


;;
;; Binary Floating Point
;;

(define_insn_reservation "z196_fsimptf" 18
  (and (eq_attr "cpu" "z196")
       (eq_attr "type" "fsimptf,fhex"))
  "z196_alone")

(define_insn_reservation "z196_fmultf" 47
  (and (eq_attr "cpu" "z196")
       (eq_attr "type" "fmultf"))
  "z196_alone")

(define_insn_reservation "z196_fsimpdf" 7
  (and (eq_attr "cpu" "z196")
       (eq_attr "type" "fsimpdf,fmuldf,fhex"))
  "z196_simple")

(define_insn_reservation "z196_fmadddf" 7
  (and (eq_attr "cpu" "z196")
       (eq_attr "type" "fmadddf"))
  "z196_alone")

(define_insn_reservation "z196_fsimpsf" 7
  (and (eq_attr "cpu" "z196")
       (eq_attr "type" "fsimpsf,fmulsf,fhex"))
  "z196_simple")

(define_insn_reservation "z196_fmaddsf" 7
  (and (eq_attr "cpu" "z196")
       (eq_attr "type" "fmaddsf"))
  "z196_alone")

(define_insn_reservation "z196_fdivtf" 108
  (and (eq_attr "cpu" "z196")
       (eq_attr "type" "fdivtf,fsqrttf"))
  "z196_alone")

(define_insn_reservation "z196_fdivdf" 36
  (and (eq_attr "cpu" "z196")
       (eq_attr "type" "fdivdf,fsqrtdf"))
  "z196_simple")

(define_insn_reservation "z196_fdivsf" 29
  (and (eq_attr "cpu" "z196")
       (eq_attr "type" "fdivsf,fsqrtsf"))
  "z196_simple")


;; Loads and stores are cheap as well.
(define_insn_reservation "z196_floaddf" 0
  (and (eq_attr "cpu" "z196")
       (eq_attr "type" "floaddf"))
  "z196_simple")

(define_insn_reservation "z196_floadsf" 0
  (and (eq_attr "cpu" "z196")
       (eq_attr "type" "floadsf"))
  "z196_simple")

(define_insn_reservation "z196_fstoredf" 0
  (and (eq_attr "cpu" "z196")
       (eq_attr "type" "fstoredf"))
  "z196_simple")

(define_insn_reservation "z196_fstoresf" 0
  (and (eq_attr "cpu" "z196")
       (eq_attr "type" "fstoresf"))
  "z196_simple")


(define_insn_reservation "z196_ftrunctf" 9
  (and (eq_attr "cpu" "z196")
       (eq_attr "type" "ftrunctf"))
  "z196_simple")

(define_insn_reservation "z196_ftruncdf" 7
  (and (eq_attr "cpu" "z196")
       (eq_attr "type" "ftruncdf"))
  "z196_simple")


(define_insn_reservation "z196_ftoi" 7
  (and (eq_attr "cpu" "z196")
       (eq_attr "type" "ftoi"))
  "z196_crack")

(define_insn_reservation "z196_itof" 7
  (and (eq_attr "cpu" "z196")
       (eq_attr "type" "itoftf,itofdf,itofsf"))
  "z196_crack")

;;
;; Decimal Floating Point
;;

;; DDTR
(define_insn_reservation "z196_fdivdd" 33
  (and (eq_attr "cpu" "z196")
       (eq_attr "type" "fdivdd"))
  "z196_simple")

;; DXTR
(define_insn_reservation "z196_fdivtd" 35
  (and (eq_attr "cpu" "z196")
       (eq_attr "type" "fdivtd"))
  "z196_alone")

;; LEDTR
(define_insn_reservation "z196_ftruncsd" 34
  (and (eq_attr "cpu" "z196")
       (eq_attr "type" "ftruncsd"))
  "z196_simple")

;; LDXTR
(define_insn_reservation "z196_ftruncdd" 36
  (and (eq_attr "cpu" "z196")
       (eq_attr "type" "ftruncdd"))
  "z196_simple")

;; These are normal fp loads/stores - which are cheap.
(define_insn_reservation "z196_floadsddd" 0
  (and (eq_attr "cpu" "z196")
       (eq_attr "type" "floadsd,floaddd,fstoredd,fstoresd"))
  "z196_simple")

;; MDTR
(define_insn_reservation "z196_fmuldd" 23
  (and (eq_attr "cpu" "z196")
       (eq_attr "type" "fmuldd"))
  "z196_simple")

;; MXTR
(define_insn_reservation "z196_fmultd" 25
  (and (eq_attr "cpu" "z196")
       (eq_attr "type" "fmultd"))
  "z196_alone")

;; multiple different isns like add, sub etc.
;; Just use the same defaults as z10.
(define_insn_reservation "z196_fsimpsd" 17
  (and (eq_attr "cpu" "z196")
       (eq_attr "type" "fsimpsd"))
  "z196_simple")
(define_insn_reservation "z196_fsimpdd" 17
  (and (eq_attr "cpu" "z196")
       (eq_attr "type" "fsimpdd"))
  "z196_simple")
(define_insn_reservation "z196_fsimptd" 18
  (and (eq_attr "cpu" "z196")
       (eq_attr "type" "fsimptd"))
  "z196_alone")

;; CDGTR
(define_insn_reservation "z196_itofdd" 45
  (and (eq_attr "cpu" "z196")
       (eq_attr "type" "itofdd"))
  "z196_crack")

;; CXGTR
(define_insn_reservation "z196_itoftd" 33
  (and (eq_attr "cpu" "z196")
       (eq_attr "type" "itoftd"))
  "z196_crack")

;; CGXTR, CGDTR
(define_insn_reservation "z196_ftoidfp" 33
  (and (eq_attr "cpu" "z196")
       (eq_attr "type" "ftoidfp"))
  "z196_crack")



