/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "WebKitDOMHTMLMarqueeElement.h"

#include "DOMObjectCache.h"
#include "ExceptionCode.h"
#include "HTMLNames.h"
#include "JSMainThreadExecState.h"
#include "WebKitDOMHTMLMarqueeElementPrivate.h"
#include "WebKitDOMNodePrivate.h"
#include "WebKitDOMPrivate.h"
#include "gobject/ConvertToUTF8String.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

namespace WebKit {

WebKitDOMHTMLMarqueeElement* kit(WebCore::HTMLMarqueeElement* obj)
{
    return WEBKIT_DOM_HTML_MARQUEE_ELEMENT(kit(static_cast<WebCore::Node*>(obj)));
}

WebCore::HTMLMarqueeElement* core(WebKitDOMHTMLMarqueeElement* request)
{
    return request ? static_cast<WebCore::HTMLMarqueeElement*>(WEBKIT_DOM_OBJECT(request)->coreObject) : 0;
}

WebKitDOMHTMLMarqueeElement* wrapHTMLMarqueeElement(WebCore::HTMLMarqueeElement* coreObject)
{
    ASSERT(coreObject);
    return WEBKIT_DOM_HTML_MARQUEE_ELEMENT(g_object_new(WEBKIT_TYPE_DOM_HTML_MARQUEE_ELEMENT, "core-object", coreObject, NULL));
}

} // namespace WebKit

G_DEFINE_TYPE(WebKitDOMHTMLMarqueeElement, webkit_dom_html_marquee_element, WEBKIT_TYPE_DOM_HTML_ELEMENT)

enum {
    PROP_0,
    PROP_BEHAVIOR,
    PROP_BG_COLOR,
    PROP_DIRECTION,
    PROP_HEIGHT,
    PROP_HSPACE,
    PROP_LOOP,
    PROP_SCROLL_AMOUNT,
    PROP_SCROLL_DELAY,
    PROP_TRUE_SPEED,
    PROP_VSPACE,
    PROP_WIDTH,
};

static void webkit_dom_html_marquee_element_set_property(GObject* object, guint propertyId, const GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMHTMLMarqueeElement* self = WEBKIT_DOM_HTML_MARQUEE_ELEMENT(object);
    WebCore::HTMLMarqueeElement* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_BEHAVIOR: {
        coreSelf->setAttribute(WebCore::HTMLNames::behaviorAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_BG_COLOR: {
        coreSelf->setAttribute(WebCore::HTMLNames::bgcolorAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_DIRECTION: {
        coreSelf->setAttribute(WebCore::HTMLNames::directionAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_HEIGHT: {
        coreSelf->setAttribute(WebCore::HTMLNames::heightAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_HSPACE: {
        coreSelf->setUnsignedIntegralAttribute(WebCore::HTMLNames::hspaceAttr, (g_value_get_ulong(value)));
        break;
    }
    case PROP_LOOP: {
        WebCore::ExceptionCode ec = 0;
        coreSelf->setLoop((g_value_get_long(value)), ec);
        break;
    }
    case PROP_SCROLL_AMOUNT: {
        WebCore::ExceptionCode ec = 0;
        coreSelf->setScrollAmount((g_value_get_long(value)), ec);
        break;
    }
    case PROP_SCROLL_DELAY: {
        WebCore::ExceptionCode ec = 0;
        coreSelf->setScrollDelay((g_value_get_long(value)), ec);
        break;
    }
    case PROP_TRUE_SPEED: {
        coreSelf->setBooleanAttribute(WebCore::HTMLNames::truespeedAttr, (g_value_get_boolean(value)));
        break;
    }
    case PROP_VSPACE: {
        coreSelf->setUnsignedIntegralAttribute(WebCore::HTMLNames::vspaceAttr, (g_value_get_ulong(value)));
        break;
    }
    case PROP_WIDTH: {
        coreSelf->setAttribute(WebCore::HTMLNames::widthAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_html_marquee_element_get_property(GObject* object, guint propertyId, GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMHTMLMarqueeElement* self = WEBKIT_DOM_HTML_MARQUEE_ELEMENT(object);
    WebCore::HTMLMarqueeElement* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_BEHAVIOR: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::behaviorAttr)));
        break;
    }
    case PROP_BG_COLOR: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::bgcolorAttr)));
        break;
    }
    case PROP_DIRECTION: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::directionAttr)));
        break;
    }
    case PROP_HEIGHT: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::heightAttr)));
        break;
    }
    case PROP_HSPACE: {
        g_value_set_ulong(value, coreSelf->getUnsignedIntegralAttribute(WebCore::HTMLNames::hspaceAttr));
        break;
    }
    case PROP_LOOP: {
        g_value_set_long(value, coreSelf->loop());
        break;
    }
    case PROP_SCROLL_AMOUNT: {
        g_value_set_long(value, coreSelf->scrollAmount());
        break;
    }
    case PROP_SCROLL_DELAY: {
        g_value_set_long(value, coreSelf->scrollDelay());
        break;
    }
    case PROP_TRUE_SPEED: {
        g_value_set_boolean(value, coreSelf->fastHasAttribute(WebCore::HTMLNames::truespeedAttr));
        break;
    }
    case PROP_VSPACE: {
        g_value_set_ulong(value, coreSelf->getUnsignedIntegralAttribute(WebCore::HTMLNames::vspaceAttr));
        break;
    }
    case PROP_WIDTH: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::widthAttr)));
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_html_marquee_element_class_init(WebKitDOMHTMLMarqueeElementClass* requestClass)
{
    GObjectClass* gobjectClass = G_OBJECT_CLASS(requestClass);
    gobjectClass->set_property = webkit_dom_html_marquee_element_set_property;
    gobjectClass->get_property = webkit_dom_html_marquee_element_get_property;

    g_object_class_install_property(gobjectClass,
                                    PROP_BEHAVIOR,
                                    g_param_spec_string("behavior", /* name */
                                                           "html_marquee_element_behavior", /* short description */
                                                           "read-write  gchar* HTMLMarqueeElement.behavior", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_BG_COLOR,
                                    g_param_spec_string("bg-color", /* name */
                                                           "html_marquee_element_bg-color", /* short description */
                                                           "read-write  gchar* HTMLMarqueeElement.bg-color", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_DIRECTION,
                                    g_param_spec_string("direction", /* name */
                                                           "html_marquee_element_direction", /* short description */
                                                           "read-write  gchar* HTMLMarqueeElement.direction", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_HEIGHT,
                                    g_param_spec_string("height", /* name */
                                                           "html_marquee_element_height", /* short description */
                                                           "read-write  gchar* HTMLMarqueeElement.height", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_HSPACE,
                                    g_param_spec_ulong("hspace", /* name */
                                                           "html_marquee_element_hspace", /* short description */
                                                           "read-write  gulong HTMLMarqueeElement.hspace", /* longer - could do with some extra doc stuff here */
                                                           0, /* min */
G_MAXULONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_LOOP,
                                    g_param_spec_long("loop", /* name */
                                                           "html_marquee_element_loop", /* short description */
                                                           "read-write  glong HTMLMarqueeElement.loop", /* longer - could do with some extra doc stuff here */
                                                           G_MINLONG, /* min */
G_MAXLONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_SCROLL_AMOUNT,
                                    g_param_spec_long("scroll-amount", /* name */
                                                           "html_marquee_element_scroll-amount", /* short description */
                                                           "read-write  glong HTMLMarqueeElement.scroll-amount", /* longer - could do with some extra doc stuff here */
                                                           G_MINLONG, /* min */
G_MAXLONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_SCROLL_DELAY,
                                    g_param_spec_long("scroll-delay", /* name */
                                                           "html_marquee_element_scroll-delay", /* short description */
                                                           "read-write  glong HTMLMarqueeElement.scroll-delay", /* longer - could do with some extra doc stuff here */
                                                           G_MINLONG, /* min */
G_MAXLONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_TRUE_SPEED,
                                    g_param_spec_boolean("true-speed", /* name */
                                                           "html_marquee_element_true-speed", /* short description */
                                                           "read-write  gboolean HTMLMarqueeElement.true-speed", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_VSPACE,
                                    g_param_spec_ulong("vspace", /* name */
                                                           "html_marquee_element_vspace", /* short description */
                                                           "read-write  gulong HTMLMarqueeElement.vspace", /* longer - could do with some extra doc stuff here */
                                                           0, /* min */
G_MAXULONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_WIDTH,
                                    g_param_spec_string("width", /* name */
                                                           "html_marquee_element_width", /* short description */
                                                           "read-write  gchar* HTMLMarqueeElement.width", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
}

static void webkit_dom_html_marquee_element_init(WebKitDOMHTMLMarqueeElement* request)
{
}

void
webkit_dom_html_marquee_element_start(WebKitDOMHTMLMarqueeElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_MARQUEE_ELEMENT(self));
    WebCore::HTMLMarqueeElement* item = WebKit::core(self);
    item->start();
}

void
webkit_dom_html_marquee_element_stop(WebKitDOMHTMLMarqueeElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_MARQUEE_ELEMENT(self));
    WebCore::HTMLMarqueeElement* item = WebKit::core(self);
    item->stop();
}

gchar*
webkit_dom_html_marquee_element_get_behavior(WebKitDOMHTMLMarqueeElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_MARQUEE_ELEMENT(self), 0);
    WebCore::HTMLMarqueeElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::behaviorAttr));
    return result;
}

void
webkit_dom_html_marquee_element_set_behavior(WebKitDOMHTMLMarqueeElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_MARQUEE_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLMarqueeElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::behaviorAttr, convertedValue);
}

gchar*
webkit_dom_html_marquee_element_get_bg_color(WebKitDOMHTMLMarqueeElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_MARQUEE_ELEMENT(self), 0);
    WebCore::HTMLMarqueeElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::bgcolorAttr));
    return result;
}

void
webkit_dom_html_marquee_element_set_bg_color(WebKitDOMHTMLMarqueeElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_MARQUEE_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLMarqueeElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::bgcolorAttr, convertedValue);
}

gchar*
webkit_dom_html_marquee_element_get_direction(WebKitDOMHTMLMarqueeElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_MARQUEE_ELEMENT(self), 0);
    WebCore::HTMLMarqueeElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::directionAttr));
    return result;
}

void
webkit_dom_html_marquee_element_set_direction(WebKitDOMHTMLMarqueeElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_MARQUEE_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLMarqueeElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::directionAttr, convertedValue);
}

gchar*
webkit_dom_html_marquee_element_get_height(WebKitDOMHTMLMarqueeElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_MARQUEE_ELEMENT(self), 0);
    WebCore::HTMLMarqueeElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::heightAttr));
    return result;
}

void
webkit_dom_html_marquee_element_set_height(WebKitDOMHTMLMarqueeElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_MARQUEE_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLMarqueeElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::heightAttr, convertedValue);
}

gulong
webkit_dom_html_marquee_element_get_hspace(WebKitDOMHTMLMarqueeElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_MARQUEE_ELEMENT(self), 0);
    WebCore::HTMLMarqueeElement* item = WebKit::core(self);
    gulong result = item->getUnsignedIntegralAttribute(WebCore::HTMLNames::hspaceAttr);
    return result;
}

void
webkit_dom_html_marquee_element_set_hspace(WebKitDOMHTMLMarqueeElement* self, gulong value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_MARQUEE_ELEMENT(self));
    WebCore::HTMLMarqueeElement* item = WebKit::core(self);
    item->setUnsignedIntegralAttribute(WebCore::HTMLNames::hspaceAttr, value);
}

glong
webkit_dom_html_marquee_element_get_loop(WebKitDOMHTMLMarqueeElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_MARQUEE_ELEMENT(self), 0);
    WebCore::HTMLMarqueeElement* item = WebKit::core(self);
    glong result = item->loop();
    return result;
}

void
webkit_dom_html_marquee_element_set_loop(WebKitDOMHTMLMarqueeElement* self, glong value, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_MARQUEE_ELEMENT(self));
    g_return_if_fail(!error || !*error);
    WebCore::HTMLMarqueeElement* item = WebKit::core(self);
    WebCore::ExceptionCode ec = 0;
    item->setLoop(value, ec);
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
}

glong
webkit_dom_html_marquee_element_get_scroll_amount(WebKitDOMHTMLMarqueeElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_MARQUEE_ELEMENT(self), 0);
    WebCore::HTMLMarqueeElement* item = WebKit::core(self);
    glong result = item->scrollAmount();
    return result;
}

void
webkit_dom_html_marquee_element_set_scroll_amount(WebKitDOMHTMLMarqueeElement* self, glong value, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_MARQUEE_ELEMENT(self));
    g_return_if_fail(!error || !*error);
    WebCore::HTMLMarqueeElement* item = WebKit::core(self);
    WebCore::ExceptionCode ec = 0;
    item->setScrollAmount(value, ec);
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
}

glong
webkit_dom_html_marquee_element_get_scroll_delay(WebKitDOMHTMLMarqueeElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_MARQUEE_ELEMENT(self), 0);
    WebCore::HTMLMarqueeElement* item = WebKit::core(self);
    glong result = item->scrollDelay();
    return result;
}

void
webkit_dom_html_marquee_element_set_scroll_delay(WebKitDOMHTMLMarqueeElement* self, glong value, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_MARQUEE_ELEMENT(self));
    g_return_if_fail(!error || !*error);
    WebCore::HTMLMarqueeElement* item = WebKit::core(self);
    WebCore::ExceptionCode ec = 0;
    item->setScrollDelay(value, ec);
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
}

gboolean
webkit_dom_html_marquee_element_get_true_speed(WebKitDOMHTMLMarqueeElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_MARQUEE_ELEMENT(self), FALSE);
    WebCore::HTMLMarqueeElement* item = WebKit::core(self);
    gboolean result = item->fastHasAttribute(WebCore::HTMLNames::truespeedAttr);
    return result;
}

void
webkit_dom_html_marquee_element_set_true_speed(WebKitDOMHTMLMarqueeElement* self, gboolean value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_MARQUEE_ELEMENT(self));
    WebCore::HTMLMarqueeElement* item = WebKit::core(self);
    item->setBooleanAttribute(WebCore::HTMLNames::truespeedAttr, value);
}

gulong
webkit_dom_html_marquee_element_get_vspace(WebKitDOMHTMLMarqueeElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_MARQUEE_ELEMENT(self), 0);
    WebCore::HTMLMarqueeElement* item = WebKit::core(self);
    gulong result = item->getUnsignedIntegralAttribute(WebCore::HTMLNames::vspaceAttr);
    return result;
}

void
webkit_dom_html_marquee_element_set_vspace(WebKitDOMHTMLMarqueeElement* self, gulong value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_MARQUEE_ELEMENT(self));
    WebCore::HTMLMarqueeElement* item = WebKit::core(self);
    item->setUnsignedIntegralAttribute(WebCore::HTMLNames::vspaceAttr, value);
}

gchar*
webkit_dom_html_marquee_element_get_width(WebKitDOMHTMLMarqueeElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_MARQUEE_ELEMENT(self), 0);
    WebCore::HTMLMarqueeElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::widthAttr));
    return result;
}

void
webkit_dom_html_marquee_element_set_width(WebKitDOMHTMLMarqueeElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_MARQUEE_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLMarqueeElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::widthAttr, convertedValue);
}

