/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "WebKitDOMHTMLMapElement.h"

#include "DOMObjectCache.h"
#include "ExceptionCode.h"
#include "HTMLNames.h"
#include "JSMainThreadExecState.h"
#include "WebKitDOMHTMLCollectionPrivate.h"
#include "WebKitDOMHTMLMapElementPrivate.h"
#include "WebKitDOMNodePrivate.h"
#include "WebKitDOMPrivate.h"
#include "gobject/ConvertToUTF8String.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

namespace WebKit {

WebKitDOMHTMLMapElement* kit(WebCore::HTMLMapElement* obj)
{
    return WEBKIT_DOM_HTML_MAP_ELEMENT(kit(static_cast<WebCore::Node*>(obj)));
}

WebCore::HTMLMapElement* core(WebKitDOMHTMLMapElement* request)
{
    return request ? static_cast<WebCore::HTMLMapElement*>(WEBKIT_DOM_OBJECT(request)->coreObject) : 0;
}

WebKitDOMHTMLMapElement* wrapHTMLMapElement(WebCore::HTMLMapElement* coreObject)
{
    ASSERT(coreObject);
    return WEBKIT_DOM_HTML_MAP_ELEMENT(g_object_new(WEBKIT_TYPE_DOM_HTML_MAP_ELEMENT, "core-object", coreObject, NULL));
}

} // namespace WebKit

G_DEFINE_TYPE(WebKitDOMHTMLMapElement, webkit_dom_html_map_element, WEBKIT_TYPE_DOM_HTML_ELEMENT)

enum {
    PROP_0,
    PROP_AREAS,
    PROP_NAME,
};

static void webkit_dom_html_map_element_set_property(GObject* object, guint propertyId, const GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMHTMLMapElement* self = WEBKIT_DOM_HTML_MAP_ELEMENT(object);
    WebCore::HTMLMapElement* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_NAME: {
        coreSelf->setAttribute(WebCore::HTMLNames::nameAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_html_map_element_get_property(GObject* object, guint propertyId, GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMHTMLMapElement* self = WEBKIT_DOM_HTML_MAP_ELEMENT(object);
    WebCore::HTMLMapElement* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_AREAS: {
        RefPtr<WebCore::HTMLCollection> ptr = coreSelf->areas();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_NAME: {
        g_value_take_string(value, convertToUTF8String(coreSelf->getNameAttribute()));
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_html_map_element_class_init(WebKitDOMHTMLMapElementClass* requestClass)
{
    GObjectClass* gobjectClass = G_OBJECT_CLASS(requestClass);
    gobjectClass->set_property = webkit_dom_html_map_element_set_property;
    gobjectClass->get_property = webkit_dom_html_map_element_get_property;

    g_object_class_install_property(gobjectClass,
                                    PROP_AREAS,
                                    g_param_spec_object("areas", /* name */
                                                           "html_map_element_areas", /* short description */
                                                           "read-only  WebKitDOMHTMLCollection* HTMLMapElement.areas", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_HTML_COLLECTION, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_NAME,
                                    g_param_spec_string("name", /* name */
                                                           "html_map_element_name", /* short description */
                                                           "read-write  gchar* HTMLMapElement.name", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
}

static void webkit_dom_html_map_element_init(WebKitDOMHTMLMapElement* request)
{
}

WebKitDOMHTMLCollection*
webkit_dom_html_map_element_get_areas(WebKitDOMHTMLMapElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_MAP_ELEMENT(self), 0);
    WebCore::HTMLMapElement* item = WebKit::core(self);
    RefPtr<WebCore::HTMLCollection> gobjectResult = WTF::getPtr(item->areas());
    return WebKit::kit(gobjectResult.get());
}

gchar*
webkit_dom_html_map_element_get_name(WebKitDOMHTMLMapElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_MAP_ELEMENT(self), 0);
    WebCore::HTMLMapElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->getNameAttribute());
    return result;
}

void
webkit_dom_html_map_element_set_name(WebKitDOMHTMLMapElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_MAP_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLMapElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::nameAttr, convertedValue);
}

