/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "WebKitDOMHTMLBodyElement.h"

#include "DOMObjectCache.h"
#include "ExceptionCode.h"
#include "HTMLNames.h"
#include "JSMainThreadExecState.h"
#include "WebKitDOMHTMLBodyElementPrivate.h"
#include "WebKitDOMNodePrivate.h"
#include "WebKitDOMPrivate.h"
#include "gobject/ConvertToUTF8String.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

namespace WebKit {

WebKitDOMHTMLBodyElement* kit(WebCore::HTMLBodyElement* obj)
{
    return WEBKIT_DOM_HTML_BODY_ELEMENT(kit(static_cast<WebCore::Node*>(obj)));
}

WebCore::HTMLBodyElement* core(WebKitDOMHTMLBodyElement* request)
{
    return request ? static_cast<WebCore::HTMLBodyElement*>(WEBKIT_DOM_OBJECT(request)->coreObject) : 0;
}

WebKitDOMHTMLBodyElement* wrapHTMLBodyElement(WebCore::HTMLBodyElement* coreObject)
{
    ASSERT(coreObject);
    return WEBKIT_DOM_HTML_BODY_ELEMENT(g_object_new(WEBKIT_TYPE_DOM_HTML_BODY_ELEMENT, "core-object", coreObject, NULL));
}

} // namespace WebKit

G_DEFINE_TYPE(WebKitDOMHTMLBodyElement, webkit_dom_html_body_element, WEBKIT_TYPE_DOM_HTML_ELEMENT)

enum {
    PROP_0,
    PROP_A_LINK,
    PROP_BACKGROUND,
    PROP_BG_COLOR,
    PROP_LINK,
    PROP_TEXT,
    PROP_V_LINK,
};

static void webkit_dom_html_body_element_set_property(GObject* object, guint propertyId, const GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMHTMLBodyElement* self = WEBKIT_DOM_HTML_BODY_ELEMENT(object);
    WebCore::HTMLBodyElement* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_A_LINK: {
        coreSelf->setAttribute(WebCore::HTMLNames::alinkAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_BACKGROUND: {
        coreSelf->setAttribute(WebCore::HTMLNames::backgroundAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_BG_COLOR: {
        coreSelf->setAttribute(WebCore::HTMLNames::bgcolorAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_LINK: {
        coreSelf->setAttribute(WebCore::HTMLNames::linkAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_TEXT: {
        coreSelf->setAttribute(WebCore::HTMLNames::textAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_V_LINK: {
        coreSelf->setAttribute(WebCore::HTMLNames::vlinkAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_html_body_element_get_property(GObject* object, guint propertyId, GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMHTMLBodyElement* self = WEBKIT_DOM_HTML_BODY_ELEMENT(object);
    WebCore::HTMLBodyElement* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_A_LINK: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::alinkAttr)));
        break;
    }
    case PROP_BACKGROUND: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::backgroundAttr)));
        break;
    }
    case PROP_BG_COLOR: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::bgcolorAttr)));
        break;
    }
    case PROP_LINK: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::linkAttr)));
        break;
    }
    case PROP_TEXT: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::textAttr)));
        break;
    }
    case PROP_V_LINK: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::vlinkAttr)));
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_html_body_element_class_init(WebKitDOMHTMLBodyElementClass* requestClass)
{
    GObjectClass* gobjectClass = G_OBJECT_CLASS(requestClass);
    gobjectClass->set_property = webkit_dom_html_body_element_set_property;
    gobjectClass->get_property = webkit_dom_html_body_element_get_property;

    g_object_class_install_property(gobjectClass,
                                    PROP_A_LINK,
                                    g_param_spec_string("a-link", /* name */
                                                           "html_body_element_a-link", /* short description */
                                                           "read-write  gchar* HTMLBodyElement.a-link", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_BACKGROUND,
                                    g_param_spec_string("background", /* name */
                                                           "html_body_element_background", /* short description */
                                                           "read-write  gchar* HTMLBodyElement.background", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_BG_COLOR,
                                    g_param_spec_string("bg-color", /* name */
                                                           "html_body_element_bg-color", /* short description */
                                                           "read-write  gchar* HTMLBodyElement.bg-color", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_LINK,
                                    g_param_spec_string("link", /* name */
                                                           "html_body_element_link", /* short description */
                                                           "read-write  gchar* HTMLBodyElement.link", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_TEXT,
                                    g_param_spec_string("text", /* name */
                                                           "html_body_element_text", /* short description */
                                                           "read-write  gchar* HTMLBodyElement.text", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_V_LINK,
                                    g_param_spec_string("v-link", /* name */
                                                           "html_body_element_v-link", /* short description */
                                                           "read-write  gchar* HTMLBodyElement.v-link", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
}

static void webkit_dom_html_body_element_init(WebKitDOMHTMLBodyElement* request)
{
}

gchar*
webkit_dom_html_body_element_get_a_link(WebKitDOMHTMLBodyElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_BODY_ELEMENT(self), 0);
    WebCore::HTMLBodyElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::alinkAttr));
    return result;
}

void
webkit_dom_html_body_element_set_a_link(WebKitDOMHTMLBodyElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_BODY_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLBodyElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::alinkAttr, convertedValue);
}

gchar*
webkit_dom_html_body_element_get_background(WebKitDOMHTMLBodyElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_BODY_ELEMENT(self), 0);
    WebCore::HTMLBodyElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::backgroundAttr));
    return result;
}

void
webkit_dom_html_body_element_set_background(WebKitDOMHTMLBodyElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_BODY_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLBodyElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::backgroundAttr, convertedValue);
}

gchar*
webkit_dom_html_body_element_get_bg_color(WebKitDOMHTMLBodyElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_BODY_ELEMENT(self), 0);
    WebCore::HTMLBodyElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::bgcolorAttr));
    return result;
}

void
webkit_dom_html_body_element_set_bg_color(WebKitDOMHTMLBodyElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_BODY_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLBodyElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::bgcolorAttr, convertedValue);
}

gchar*
webkit_dom_html_body_element_get_link(WebKitDOMHTMLBodyElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_BODY_ELEMENT(self), 0);
    WebCore::HTMLBodyElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::linkAttr));
    return result;
}

void
webkit_dom_html_body_element_set_link(WebKitDOMHTMLBodyElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_BODY_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLBodyElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::linkAttr, convertedValue);
}

gchar*
webkit_dom_html_body_element_get_text(WebKitDOMHTMLBodyElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_BODY_ELEMENT(self), 0);
    WebCore::HTMLBodyElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::textAttr));
    return result;
}

void
webkit_dom_html_body_element_set_text(WebKitDOMHTMLBodyElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_BODY_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLBodyElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::textAttr, convertedValue);
}

gchar*
webkit_dom_html_body_element_get_v_link(WebKitDOMHTMLBodyElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_BODY_ELEMENT(self), 0);
    WebCore::HTMLBodyElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::vlinkAttr));
    return result;
}

void
webkit_dom_html_body_element_set_v_link(WebKitDOMHTMLBodyElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_BODY_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLBodyElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::vlinkAttr, convertedValue);
}

