/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "WebKitDOMDOMMimeTypeArray.h"

#include "DOMObjectCache.h"
#include "ExceptionCode.h"
#include "JSMainThreadExecState.h"
#include "WebKitDOMDOMMimeTypeArrayPrivate.h"
#include "WebKitDOMDOMMimeTypePrivate.h"
#include "WebKitDOMPrivate.h"
#include "gobject/ConvertToUTF8String.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

#define WEBKIT_DOM_DOM_MIME_TYPE_ARRAY_GET_PRIVATE(obj) G_TYPE_INSTANCE_GET_PRIVATE(obj, WEBKIT_TYPE_DOM_DOM_MIME_TYPE_ARRAY, WebKitDOMDOMMimeTypeArrayPrivate)

typedef struct _WebKitDOMDOMMimeTypeArrayPrivate {
    RefPtr<WebCore::DOMMimeTypeArray> coreObject;
} WebKitDOMDOMMimeTypeArrayPrivate;

namespace WebKit {

WebKitDOMDOMMimeTypeArray* kit(WebCore::DOMMimeTypeArray* obj)
{
    if (!obj)
        return 0;

    if (gpointer ret = DOMObjectCache::get(obj))
        return WEBKIT_DOM_DOM_MIME_TYPE_ARRAY(ret);

    return wrapDOMMimeTypeArray(obj);
}

WebCore::DOMMimeTypeArray* core(WebKitDOMDOMMimeTypeArray* request)
{
    return request ? static_cast<WebCore::DOMMimeTypeArray*>(WEBKIT_DOM_OBJECT(request)->coreObject) : 0;
}

WebKitDOMDOMMimeTypeArray* wrapDOMMimeTypeArray(WebCore::DOMMimeTypeArray* coreObject)
{
    ASSERT(coreObject);
    return WEBKIT_DOM_DOM_MIME_TYPE_ARRAY(g_object_new(WEBKIT_TYPE_DOM_DOM_MIME_TYPE_ARRAY, "core-object", coreObject, NULL));
}

} // namespace WebKit

G_DEFINE_TYPE(WebKitDOMDOMMimeTypeArray, webkit_dom_dom_mime_type_array, WEBKIT_TYPE_DOM_OBJECT)

enum {
    PROP_0,
    PROP_LENGTH,
};

static void webkit_dom_dom_mime_type_array_finalize(GObject* object)
{
    WebKitDOMDOMMimeTypeArrayPrivate* priv = WEBKIT_DOM_DOM_MIME_TYPE_ARRAY_GET_PRIVATE(object);

    WebKit::DOMObjectCache::forget(priv->coreObject.get());

    priv->~WebKitDOMDOMMimeTypeArrayPrivate();
    G_OBJECT_CLASS(webkit_dom_dom_mime_type_array_parent_class)->finalize(object);
}

static void webkit_dom_dom_mime_type_array_get_property(GObject* object, guint propertyId, GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMDOMMimeTypeArray* self = WEBKIT_DOM_DOM_MIME_TYPE_ARRAY(object);
    WebCore::DOMMimeTypeArray* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_LENGTH: {
        g_value_set_ulong(value, coreSelf->length());
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static GObject* webkit_dom_dom_mime_type_array_constructor(GType type, guint constructPropertiesCount, GObjectConstructParam* constructProperties)
{
    GObject* object = G_OBJECT_CLASS(webkit_dom_dom_mime_type_array_parent_class)->constructor(type, constructPropertiesCount, constructProperties);

    WebKitDOMDOMMimeTypeArrayPrivate* priv = WEBKIT_DOM_DOM_MIME_TYPE_ARRAY_GET_PRIVATE(object);
    priv->coreObject = static_cast<WebCore::DOMMimeTypeArray*>(WEBKIT_DOM_OBJECT(object)->coreObject);
    WebKit::DOMObjectCache::put(priv->coreObject.get(), object);

    return object;
}

static void webkit_dom_dom_mime_type_array_class_init(WebKitDOMDOMMimeTypeArrayClass* requestClass)
{
    GObjectClass* gobjectClass = G_OBJECT_CLASS(requestClass);
    g_type_class_add_private(gobjectClass, sizeof(WebKitDOMDOMMimeTypeArrayPrivate));
    gobjectClass->constructor = webkit_dom_dom_mime_type_array_constructor;
    gobjectClass->finalize = webkit_dom_dom_mime_type_array_finalize;
    gobjectClass->get_property = webkit_dom_dom_mime_type_array_get_property;

    g_object_class_install_property(gobjectClass,
                                    PROP_LENGTH,
                                    g_param_spec_ulong("length", /* name */
                                                           "dom_mime_type_array_length", /* short description */
                                                           "read-only  gulong DOMMimeTypeArray.length", /* longer - could do with some extra doc stuff here */
                                                           0, /* min */
G_MAXULONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
}

static void webkit_dom_dom_mime_type_array_init(WebKitDOMDOMMimeTypeArray* request)
{
    WebKitDOMDOMMimeTypeArrayPrivate* priv = WEBKIT_DOM_DOM_MIME_TYPE_ARRAY_GET_PRIVATE(request);
    new (priv) WebKitDOMDOMMimeTypeArrayPrivate();
}

WebKitDOMDOMMimeType*
webkit_dom_dom_mime_type_array_item(WebKitDOMDOMMimeTypeArray* self, gulong index)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOM_MIME_TYPE_ARRAY(self), 0);
    WebCore::DOMMimeTypeArray* item = WebKit::core(self);
    RefPtr<WebCore::DOMMimeType> gobjectResult = WTF::getPtr(item->item(index));
    return WebKit::kit(gobjectResult.get());
}

WebKitDOMDOMMimeType*
webkit_dom_dom_mime_type_array_named_item(WebKitDOMDOMMimeTypeArray* self, const gchar* name)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOM_MIME_TYPE_ARRAY(self), 0);
    g_return_val_if_fail(name, 0);
    WebCore::DOMMimeTypeArray* item = WebKit::core(self);
    WTF::String convertedName = WTF::String::fromUTF8(name);
    RefPtr<WebCore::DOMMimeType> gobjectResult = WTF::getPtr(item->namedItem(convertedName));
    return WebKit::kit(gobjectResult.get());
}

gulong
webkit_dom_dom_mime_type_array_get_length(WebKitDOMDOMMimeTypeArray* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOM_MIME_TYPE_ARRAY(self), 0);
    WebCore::DOMMimeTypeArray* item = WebKit::core(self);
    gulong result = item->length();
    return result;
}

